/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL plugin
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_WGL_BACKEND_H__
#define __PGM_WGL_BACKEND_H__

#include <windows.h>
#include "pgmbackend.h"

G_BEGIN_DECLS

#define PGM_TYPE_WGL_BACKEND (pgm_wgl_backend_get_type ())
#define PGM_WGL_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_WGL_BACKEND, PgmWglBackend))
#define PGM_WGL_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_WGL_BACKEND, PgmWglBackendClass))
#define PGM_IS_WGL_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_WGL_BACKEND))
#define PGM_IS_WGL_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_WGL_BACKEND))
#define PGM_WGL_BACKEND_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_WGL_BACKEND, PgmWglBackendClass))

typedef struct _PgmWglBackend            PgmWglBackend;
typedef struct _PgmWglBackendClass       PgmWglBackendClass;
typedef struct _PgmWglBackendSource      PgmWglBackendSource;
typedef struct _PgmWglBackendProcAddress PgmWglBackendProcAddress;

typedef enum {
  PGM_WGL_FEAT_SWAP_CONTROL = (1 << 0)
} PgmWglBackendFeature;

typedef enum {
  PGM_VBLANK_NONE,
  PGM_VBLANK_SWAP_CONTROL
} PgmWglBackendVBlank;

struct _PgmWglBackend {
  PgmBackend parent;

  /* Window management */
  WNDCLASS              wc;
  HWND                  hwnd;
  HGLRC                 hrc;
  HDC                   hdc;
  PIXELFORMATDESCRIPTOR pfd;
  guint                 pf;

  /* WGL extensions */
  const gchar *extensions;

  /* Message source id */
  guint message_id;

  /* WGL features */
  guint feature_mask;

  /* WGL function pointers */
  PgmWglBackendProcAddress *wgl;

  /* Display lists to rasterize Windows fonts (for debugging purpose) */
  guint text_lists;

  /* Screen informations */
  gint resolution_width;
  gint resolution_height;
  gint size_mm_width;
  gint size_mm_height;

  /* Backed up window position/size */
  RECT windowed;

  /* Current cursor */
  HICON cursor;

  /* Vertical blanking mode */
  PgmWglBackendVBlank vblank_mode;

  /* States */
  gboolean created;
  gboolean never_shown;
  gboolean hidden;
  gboolean fullscreen;
  gboolean decorated;
  gboolean intel_chipset;
};

struct _PgmWglBackendClass {
  PgmBackendClass parent_class;
};

/* Message source */
struct _PgmWglBackendSource {
  GSource source;
  GPollFD poll_fd;
};

/* WGL function pointers definitions */
typedef gboolean (WINAPI *PgmWglSwapIntervalFunc) (gint interval);

/* WGL function pointers used for extensions loading */
struct _PgmWglBackendProcAddress {
  PgmWglSwapIntervalFunc swap_interval;
};

GType       pgm_wgl_backend_get_type (void) G_GNUC_CONST;

PgmBackend *pgm_wgl_backend_new      (PgmContext *context);
void        pgm_wgl_backend_register (GTypeModule *module);

G_END_DECLS

#endif /* __PGM_WGL_BACKEND_H__ */
