/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.filter;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XSeekable;
import com.sun.star.io.XStream;
import com.sun.star.lang.IllegalArgumentException;

public class ByteArrayXStream
implements XInputStream,
XOutputStream,
XSeekable,
XStream {
    private int initialSize = 100240;
    private int size = this.initialSize;
    private int position = 0;
    private int readPosition = 0;
    private boolean closed = false;
    private byte[] buffer = new byte[this.size];

    public void closeOutput() throws NotConnectedException, BufferSizeExceededException, IOException {
        if (this.buffer.length > this.position) {
            byte[] newBuffer = new byte[this.position];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
            this.buffer = newBuffer;
        }
        this.closed = true;
    }

    public void flush() throws NotConnectedException, BufferSizeExceededException, IOException {
    }

    public void writeBytes(byte[] values) throws NotConnectedException, BufferSizeExceededException, IOException {
        if (values.length > this.size - this.position) {
            byte[] newBuffer = null;
            while (values.length > this.size - this.position) {
                this.size *= 2;
            }
            newBuffer = new byte[this.size];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
            this.buffer = newBuffer;
        }
        System.arraycopy(values, 0, this.buffer, this.position, values.length);
        this.position += values.length;
    }

    private void _check() throws NotConnectedException, IOException {
        if (this.closed) {
            throw new IOException("input closed");
        }
    }

    public int available() throws NotConnectedException, IOException {
        this._check();
        return this.position - this.readPosition;
    }

    public void closeInput() throws NotConnectedException, IOException {
        this.closed = true;
    }

    public int readBytes(byte[][] values, int param) throws NotConnectedException, BufferSizeExceededException, IOException {
        this._check();
        try {
            int remain = this.position - this.readPosition;
            if (param > remain) {
                param = remain;
            }
            if (values[0] == null) {
                values[0] = new byte[param];
            }
            System.arraycopy(this.buffer, this.readPosition, values[0], 0, param);
            this.readPosition += param;
            return param;
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            ae.printStackTrace();
            throw new BufferSizeExceededException("buffer overflow");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("error accessing buffer");
        }
    }

    public int readSomeBytes(byte[][] values, int param) throws NotConnectedException, BufferSizeExceededException, IOException {
        return this.readBytes(values, param);
    }

    public void skipBytes(int param) throws NotConnectedException, BufferSizeExceededException, IOException {
        this._check();
        if (param > this.position - this.readPosition) {
            throw new BufferSizeExceededException("buffer overflow");
        }
        this.readPosition += param;
    }

    public long getLength() throws IOException {
        if (this.buffer != null) {
            return this.position;
        }
        throw new IOException("no bytes");
    }

    public long getPosition() throws IOException {
        if (this.buffer != null) {
            return this.readPosition;
        }
        throw new IOException("no bytes");
    }

    public void seek(long param) throws IllegalArgumentException, IOException {
        if (this.buffer != null) {
            if (param < 0L || param > (long)this.position) {
                throw new IllegalArgumentException("invalid seek position");
            }
        } else {
            throw new IOException("no bytes");
        }
        this.readPosition = (int)param;
    }

    public XInputStream getInputStream() {
        return this;
    }

    public XOutputStream getOutputStream() {
        return this;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }
}

