/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.i18n;

import writer2latex.latex.i18n.UnicodeCharacter;
import writer2latex.latex.i18n.UnicodeRow;

class UnicodeTable {
    protected UnicodeRow[] table = new UnicodeRow[256];
    private UnicodeTable parent;

    public UnicodeTable(UnicodeTable parent) {
        this.parent = parent;
        if (parent != null) {
            int i = 0;
            while (i < 256) {
                this.table[i] = parent.table[i];
                ++i;
            }
        }
    }

    private void createEntry(int nRow, int nCol) {
        if (this.table[nRow] == null) {
            this.table[nRow] = new UnicodeRow();
        } else if (this.parent != null && this.table[nRow] == this.parent.table[nRow]) {
            this.table[nRow] = (UnicodeRow)this.parent.table[nRow].clone();
        }
        if (this.table[nRow].entries[nCol] == null) {
            this.table[nRow].entries[nCol] = new UnicodeCharacter();
        }
    }

    protected void addCharType(char c, int nType) {
        int nRow = c / 256;
        int nCol = c % 256;
        this.createEntry(nRow, nCol);
        this.table[nRow].entries[nCol].nType = nType;
    }

    protected void addCharType(char c, String sType) {
        int nRow = c / 256;
        int nCol = c % 256;
        this.createEntry(nRow, nCol);
        this.table[nRow].entries[nCol].nType = "combining".equals(sType) ? 1 : ("ignore".equals(sType) ? 2 : 0);
    }

    protected void addMathChar(char c, String sLaTeX) {
        int nRow = c / 256;
        int nCol = c % 256;
        this.createEntry(nRow, nCol);
        this.table[nRow].entries[nCol].sMath = sLaTeX;
    }

    protected void addTextChar(char c, String sLaTeX, int nFontencs, boolean bDashes) {
        int nRow = c / 256;
        int nCol = c % 256;
        this.createEntry(nRow, nCol);
        this.table[nRow].entries[nCol].sText = sLaTeX;
        this.table[nRow].entries[nCol].nFontencs = nFontencs;
        this.table[nRow].entries[nCol].bDashes = bDashes;
    }

    private UnicodeCharacter getEntry(char c) {
        int nRow = c / 256;
        int nCol = c % 256;
        if (this.table[nRow] == null) {
            return null;
        }
        return this.table[nRow].entries[nCol];
    }

    public int getCharType(char c) {
        UnicodeCharacter entry = this.getEntry(c);
        if (entry == null) {
            return 3;
        }
        return entry.nType;
    }

    public boolean hasMathChar(char c) {
        UnicodeCharacter entry = this.getEntry(c);
        if (entry == null) {
            return false;
        }
        return entry.sMath != null;
    }

    public String getMathChar(char c) {
        UnicodeCharacter entry = this.getEntry(c);
        if (entry == null) {
            return null;
        }
        return entry.sMath;
    }

    public boolean hasTextChar(char c) {
        UnicodeCharacter entry = this.getEntry(c);
        if (entry == null) {
            return false;
        }
        return entry.sText != null;
    }

    public String getTextChar(char c) {
        UnicodeCharacter entry = this.getEntry(c);
        if (entry == null) {
            return null;
        }
        return entry.sText;
    }

    public int getFontencs(char c) {
        UnicodeCharacter entry = this.getEntry(c);
        if (entry == null) {
            return 0;
        }
        return entry.nFontencs;
    }

    public boolean isDashes(char c) {
        UnicodeCharacter entry = this.getEntry(c);
        if (entry == null) {
            return false;
        }
        return entry.bDashes;
    }

    public int getCharCount() {
        int nCount = 0;
        int nRow = 0;
        while (nRow < 256) {
            if (this.table[nRow] != null) {
                int nCol = 0;
                while (nCol < 256) {
                    UnicodeCharacter entry = this.table[nRow].entries[nCol];
                    if (entry != null) {
                        ++nCount;
                    }
                    ++nCol;
                }
            }
            ++nRow;
        }
        return nCount;
    }
}

