/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import writer2latex.office.ControlReader;
import writer2latex.office.FormReader;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xmerge.BinaryGraphicsDocument;
import writer2latex.xmerge.EmbeddedObject;
import writer2latex.xmerge.EmbeddedXMLObject;

public class DrawConverter
extends ConverterHelper {
    public static final int INLINE = 0;
    public static final int FLOATING = 1;
    public static final int ABSOLUTE = 2;
    public static final int CENTERED = 3;
    private FormReader form = null;
    private String sScale;
    private boolean bConvertToPx;
    private boolean bKeepImageSize;
    private Vector frames = new Vector();
    private boolean bCollectFrames = false;

    public DrawConverter(OfficeReader ofr, Config config, Converter converter) {
        super(ofr, config, converter);
        Iterator formsIterator = ofr.getForms().getFormsIterator();
        if (formsIterator.hasNext() && config.getXhtmlSplitLevel() == 0) {
            this.form = (FormReader)formsIterator.next();
        }
        this.bCollectFrames = ofr.isSpreadsheet();
        this.sScale = config.getXhtmlScaling();
        this.bConvertToPx = config.xhtmlConvertToPx();
        this.bKeepImageSize = config.keepImageSize();
    }

    public void convertDrawContent(Element onode) {
        if (!onode.hasChildNodes()) {
            return;
        }
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        int i = 0;
        while (i < nLen) {
            String sNodeName;
            Node child = nList.item(i);
            if (child.getNodeType() == 1 && (sNodeName = child.getNodeName()).equals("draw:page")) {
                this.handleDrawPage((Element)child, this.converter.nextOutFile());
            }
            ++i;
        }
    }

    private void handleDrawPage(Element onode, Element hnode) {
        Element div = this.converter.createElement("div");
        hnode.appendChild(div);
        StyleInfo info = new StyleInfo();
        this.getPageSc().applyStyle(onode.getAttribute("draw:master-page-name"), info);
        info.props.addValue("top", "0");
        info.props.addValue("left", "0");
        info.props.addValue("position", "absolute");
        this.applyStyle(info, div);
        if (!onode.hasChildNodes()) {
            return;
        }
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nList.item(i);
            if (child.getNodeType() == 1) {
                this.handleDrawElement((Element)child, div, div, 2);
            }
            ++i;
        }
    }

    public Element createForm() {
        if (this.form == null) {
            return null;
        }
        Element htmlForm = this.converter.createElement("form");
        htmlForm.setAttribute("name", this.form.getAttribute("form:name"));
        htmlForm.setAttribute("action", this.form.getAttribute("xlink:href"));
        String sMethod = this.form.getAttribute("form:method");
        htmlForm.setAttribute("method", sMethod != null ? sMethod : "get");
        return htmlForm;
    }

    public Element getRealDrawElement(Element onode) {
        if ("draw:a".equals(onode.getTagName())) {
            Node child = onode.getFirstChild();
            while (child != null) {
                if (OfficeReader.isDrawElement(child)) {
                    return (Element)child;
                }
                child = child.getNextSibling();
            }
            return null;
        }
        return onode;
    }

    public Element getDrawAnchor(Element onode) {
        Element parent = (Element)onode.getParentNode();
        if ("draw:frame".equals(parent.getTagName())) {
            parent = (Element)parent.getParentNode();
        }
        if ("draw:a".equals(parent.getTagName())) {
            return parent;
        }
        return null;
    }

    private Element getFrame(Element onode) {
        if (this.ofr.isOpenDocument()) {
            return (Element)onode.getParentNode();
        }
        return onode;
    }

    public void flushFrames(Element hnode) {
        this.bCollectFrames = false;
        int nCount = this.frames.size();
        int i = 0;
        while (i < nCount) {
            this.handleDrawElement((Element)this.frames.get(i), hnode, null, 3);
            ++i;
        }
        this.frames.clear();
        this.bCollectFrames = true;
    }

    public void handleDrawElement(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        if (this.bCollectFrames) {
            this.frames.add(onode);
            return;
        }
        String sName = onode.getNodeName();
        if (sName.equals("draw:object")) {
            this.handleDrawObject(onode, hnodeBlock, hnodeInline, nMode);
        } else if (sName.equals("draw:object-ole")) {
            this.handleDrawObject(onode, hnodeBlock, hnodeInline, nMode);
        } else if (sName.equals("draw:image")) {
            this.handleDrawImage(onode, hnodeBlock, hnodeInline, nMode);
        } else if (sName.equals("draw:text-box")) {
            this.handleDrawTextBox(onode, hnodeBlock, hnodeInline, nMode);
        } else if (sName.equals("draw:a")) {
            Element elm = this.getRealDrawElement(onode);
            if (elm != null) {
                this.handleDrawElement(elm, hnodeBlock, hnodeInline, nMode);
            }
        } else if (sName.equals("draw:frame")) {
            this.handleDrawElement(Misc.getFirstChildElement(onode), hnodeBlock, hnodeInline, nMode);
        } else if (sName.equals("draw:g")) {
            this.handleDrawGroup(onode, hnodeBlock, hnodeInline, nMode);
        } else if (sName.equals("draw:control")) {
            this.handleDrawControl(onode, hnodeBlock, hnodeInline, nMode);
        }
    }

    private void handleDrawObject(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        Element hnode;
        if (hnodeInline != null) {
            hnode = hnodeInline;
        } else {
            Element div = this.converter.createElement("div");
            hnodeBlock.appendChild(div);
            hnode = div;
        }
        String sHref = Misc.getAttribute(onode, "xlink:href");
        if (sHref != null) {
            if (this.ofr.isInPackage(sHref)) {
                EmbeddedObject object;
                if (sHref.startsWith("#")) {
                    sHref = sHref.substring(1);
                }
                if (sHref.startsWith("./")) {
                    sHref = sHref.substring(2);
                }
                if ("application/vnd.sun.xml.math".equals((object = this.converter.getEmbeddedObject(sHref)).getType()) || "application/vnd.oasis.opendocument.formula".equals(object.getType())) {
                    EmbeddedXMLObject xmlObject = (EmbeddedXMLObject)object;
                    try {
                        hnode.appendChild(this.converter.createTextNode(" "));
                        this.getMathCv().convert(xmlObject.getContentDOM().getDocumentElement(), hnode);
                        hnode.appendChild(this.converter.createTextNode(" "));
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    Element replacementImage;
                    boolean bIgnore = true;
                    if (this.ofr.isOpenDocument() && (replacementImage = Misc.getChildByTagName(this.getFrame(onode), "draw:image")) != null) {
                        this.handleDrawImage(replacementImage, hnodeBlock, hnodeInline, nMode);
                        bIgnore = false;
                    }
                    if (bIgnore) {
                        hnode.appendChild(this.converter.createTextNode("[Warning: object ignored]"));
                    }
                }
            } else {
                hnode.appendChild(this.converter.createTextNode("[Warning: Linked object ignored]"));
            }
        } else {
            Element formula = Misc.getChildByTagName(onode, "math:math");
            if (formula != null) {
                hnode.appendChild(this.converter.createTextNode(" "));
                this.getMathCv().convert(formula, hnode);
                hnode.appendChild(this.converter.createTextNode(" "));
            } else {
                Element replacementImage;
                boolean bIgnore = true;
                if (this.ofr.isOpenDocument() && (replacementImage = Misc.getChildByTagName(this.getFrame(onode), "draw:image")) != null) {
                    this.handleDrawImage(replacementImage, hnodeBlock, hnodeInline, nMode);
                    bIgnore = false;
                }
                if (bIgnore) {
                    hnode.appendChild(this.converter.createTextNode("[Warning: object ignored]"));
                }
            }
        }
    }

    private void handleDrawImage(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        String sFileName = null;
        String sHref = Misc.getAttribute(onode, "xlink:href");
        if (sHref != null && sHref.length() > 0 && !this.ofr.isInPackage(sHref)) {
            sFileName = sHref;
            if (this.ofr.isOpenDocument() && this.ofr.isPackageFormat() && sFileName.startsWith("../")) {
                sFileName = sFileName.substring(3);
            }
            String sExt = sHref.substring(sHref.lastIndexOf(".")).toLowerCase();
        } else {
            BinaryGraphicsDocument bgd = this.converter.getImageLoader().getImage(onode);
            if (bgd != null) {
                this.converter.addDocument(bgd);
                sFileName = bgd.getFileName();
            }
        }
        if (sFileName == null) {
            return;
        }
        Element image = this.converter.createElement("img");
        String sName = Misc.getAttribute(this.getFrame(onode), "draw:name");
        this.converter.addTarget(image, sName + "%7Cgraphics");
        image.setAttribute("src", sFileName);
        Element frame = this.getFrame(onode);
        Element desc = Misc.getChildByTagName(frame, "svg:desc");
        String sAltText = desc != null ? Misc.getPCDATA(desc) : (sName != null ? sName : sFileName);
        image.setAttribute("alt", sAltText);
        StyleInfo info = new StyleInfo();
        String sStyleName = Misc.getAttribute(frame, "draw:style-name");
        this.getFrameSc().applyStyle(sStyleName, info);
        if (!this.bKeepImageSize) {
            this.applySize(frame, info.props, false);
        }
        this.applyPlacement(frame, hnodeBlock, hnodeInline, nMode, image, info);
        this.applyStyle(info, image);
        this.addLink(onode, image);
    }

    private void handleDrawTextBox(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        Element textbox = this.converter.createElement("div");
        if (hnodeBlock == null) {
            return;
        }
        hnodeBlock.appendChild(textbox);
        String sName = Misc.getAttribute(this.getFrame(onode), "draw:name");
        this.converter.addTarget(textbox, sName + "%7Cframe");
        Element frame = this.getFrame(onode);
        StyleInfo info = new StyleInfo();
        String sStyleName = Misc.getAttribute(frame, "draw:style-name");
        if (sStyleName != null) {
            this.getFrameSc().applyStyle(sStyleName, info);
        }
        if ((sStyleName = Misc.getAttribute(frame, "presentation:style-name")) != null) {
            if ("outline".equals(Misc.getAttribute(frame, "presentation:class"))) {
                this.getPresentationSc().enterOutline(sStyleName);
            }
            this.getPresentationSc().applyStyle(sStyleName, info);
        }
        if ((sStyleName = Misc.getAttribute(frame, "draw:text-style-name")) != null) {
            // empty if block
        }
        switch (nMode) {
            case 0: {
                break;
            }
            case 2: {
                this.applySize(frame, info.props, false);
                this.applyPosition(frame, info.props);
                break;
            }
            case 3: {
                info.props.addValue("maring-top", "2px");
                info.props.addValue("maring-bottom", "2px");
                info.props.addValue("margin-left", "auto");
                info.props.addValue("margin-right", "auto");
                this.applySize(frame, info.props, true);
                break;
            }
            case 1: {
                String sX;
                this.applySize(frame, info.props, true);
                StyleWithProperties style = this.ofr.getFrameStyle(sStyleName);
                if (style == null) break;
                String sPos = style.getProperty("style:horizontal-pos");
                String sWrap = style.getProperty("style:wrap");
                if (this.isLeft(sPos) && this.mayWrapRight(sWrap)) {
                    info.props.addValue("float", "left");
                    break;
                }
                if (this.isRight(sPos) && this.mayWrapLeft(sWrap)) {
                    info.props.addValue("float", "right");
                    break;
                }
                if (!this.isFromLeft(sPos)) break;
                if (this.mayWrapRight(sWrap)) {
                    info.props.addValue("float", "left");
                }
                if ((sX = frame.getAttribute("svg:x")) == null || sX.length() <= 0) break;
                info.props.addValue("margin-left", this.scale(sX));
            }
        }
        this.applyStyle(info, textbox);
        this.getTextCv().traverseBlockText(onode, textbox);
        this.getPresentationSc().exitOutline();
    }

    private void handleDrawGroup(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        Node child = onode.getFirstChild();
        while (child != null) {
            if (OfficeReader.isDrawElement(child)) {
                this.handleDrawElement((Element)child, hnodeBlock, hnodeInline, nMode);
            }
            child = child.getNextSibling();
        }
    }

    private void handleDrawControl(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        ControlReader control;
        if (this.form == null) {
            return;
        }
        ControlReader controlReader = control = this.ofr.isOpenDocument() ? this.ofr.getForms().getControl(Misc.getAttribute(onode, "draw:control")) : this.ofr.getForms().getControl(Misc.getAttribute(onode, "form:id"));
        if (control == null || control.getOwnerForm() != this.form) {
            return;
        }
        Element hcontrol = null;
        String sType = control.getControlType();
        if ("form:text".equals(sType)) {
            hcontrol = this.createInputText(control, false);
        } else if ("form:password".equals(sType)) {
            hcontrol = this.createInputText(control, true);
        } else if ("form:file".equals(sType)) {
            hcontrol = this.createInputFile(control);
        } else if ("form:image".equals(sType)) {
            hcontrol = this.createInput(control, "image");
        } else if ("form:hidden".equals(sType)) {
            hcontrol = this.createInput(control, "hidden");
        } else if ("form:checkbox".equals(sType)) {
            hcontrol = this.createInputCheck(control, false);
        } else if ("form:radio".equals(sType)) {
            hcontrol = this.createInputCheck(control, true);
        } else if ("form:button".equals(sType)) {
            hcontrol = this.createInputButton(control);
        } else if ("form:fixed-text".equals(sType)) {
            hcontrol = this.createLabel(control);
        } else if ("form:textarea".equals(sType)) {
            hcontrol = this.createTextarea(control);
        } else if ("form:listbox".equals(sType)) {
            hcontrol = this.createSelect(control);
        }
        if (hcontrol != null) {
            Element frame = onode;
            StyleInfo info = new StyleInfo();
            this.getFrameSc().applyStyle(frame.getAttribute("draw:style-name"), info);
            this.applySize(frame, info.props, false);
            this.applyPlacement(frame, hnodeBlock, hnodeInline, nMode, hcontrol, info);
            this.applyStyle(info, hcontrol);
        }
    }

    private Element createInput(ControlReader control, String sType) {
        Element input = this.converter.createElement("input");
        input.setAttribute("type", sType);
        return input;
    }

    private Element createInputFile(ControlReader control) {
        Element input = this.converter.createElement("input");
        input.setAttribute("type", "file");
        this.setCommonAttributes(control, input);
        this.setDisabled(control, input);
        this.setReadonly(control, input);
        this.setValue(control, input);
        return input;
    }

    private Element createInputText(ControlReader control, boolean bPassword) {
        Element input = this.converter.createElement("input");
        input.setAttribute("type", bPassword ? "password" : "text");
        this.setCommonAttributes(control, input);
        this.setName(control, input, true);
        this.setValue(control, input);
        this.setMaxLength(control, input);
        this.setDisabled(control, input);
        this.setReadonly(control, input);
        return input;
    }

    private Element createInputCheck(ControlReader control, boolean bRadio) {
        Element input = this.converter.createElement("input");
        input.setAttribute("type", bRadio ? "radio" : "checkbox");
        this.setCommonAttributes(control, input);
        this.setName(control, input, true);
        this.setValue(control, input);
        this.setChecked(control, input);
        this.setDisabled(control, input);
        this.setReadonly(control, input);
        Element label = this.converter.createElement("label");
        this.setFor(control, label);
        label.appendChild(input);
        label.appendChild(this.converter.createTextNode(control.getTypeAttribute("form:label")));
        return label;
    }

    private Element createInputButton(ControlReader control) {
        Element input = this.converter.createElement("input");
        String sButtonType = control.getTypeAttribute("form:button-type");
        if ("submit".equals(sButtonType)) {
            input.setAttribute("type", "submit");
        } else if ("reset".equals(sButtonType)) {
            input.setAttribute("type", "reset");
        } else {
            input.setAttribute("type", "button");
        }
        this.setCommonAttributes(control, input);
        this.setName(control, input, true);
        input.setAttribute("value", control.getTypeAttribute("form:label"));
        this.setDisabled(control, input);
        return input;
    }

    private Element createLabel(ControlReader control) {
        Element label = this.converter.createElement("label");
        this.setCommonAttributes(control, label);
        this.setFor(control, label);
        label.setAttribute("value", control.getTypeAttribute("form:label"));
        label.appendChild(this.converter.createTextNode(control.getTypeAttribute("form:label")));
        return label;
    }

    private Element createTextarea(ControlReader control) {
        Element textarea = this.converter.createElement("textarea");
        this.setCommonAttributes(control, textarea);
        this.setName(control, textarea, true);
        this.setDisabled(control, textarea);
        this.setReadonly(control, textarea);
        textarea.setAttribute("rows", "10");
        textarea.setAttribute("cols", "5");
        String s = control.getTypeAttribute("form:value");
        if (s != null) {
            textarea.appendChild(this.converter.createTextNode(s));
        }
        return textarea;
    }

    private Element createSelect(ControlReader control) {
        Element select = this.converter.createElement("select");
        this.setCommonAttributes(control, select);
        this.setName(control, select, false);
        this.setSize(control, select);
        this.setMultiple(control, select);
        this.setDisabled(control, select);
        int nCount = control.getItemCount();
        int i = 0;
        while (i < nCount) {
            String sLabel = control.getItemAttribute(i, "form:label");
            boolean bSelected = "true".equals(control.getItemAttribute(i, "form:selected"));
            Element option = this.converter.createElement("option");
            select.appendChild(option);
            if (bSelected) {
                option.setAttribute("selected", "selected");
            }
            option.appendChild(this.converter.createTextNode(sLabel));
            ++i;
        }
        return select;
    }

    private void setCommonAttributes(ControlReader control, Element hnode) {
        this.setId(control, hnode);
        this.setTitle(control, hnode);
        this.setTabIndex(control, hnode);
    }

    private void setId(ControlReader control, Element hnode) {
        String s = control.getId();
        if (s != null) {
            hnode.setAttribute("id", s);
        }
    }

    private void setName(ControlReader control, Element hnode, boolean bRequired) {
        String s = control.getAttribute("form:name");
        if (s != null) {
            hnode.setAttribute("name", s);
        } else if (bRequired) {
            hnode.setAttribute("name", "unknown");
        }
    }

    private void setValue(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:value");
        if (s != null) {
            hnode.setAttribute("value", s);
        }
    }

    private void setTitle(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:title");
        if (s != null) {
            hnode.setAttribute("title", s);
        }
    }

    private void setTabIndex(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:tab-index");
        if (s != null) {
            hnode.setAttribute("tabindex", s);
        }
    }

    private void setMaxLength(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:max-length");
        if (s != null) {
            hnode.setAttribute("maxlength", s);
        }
    }

    private void setSize(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:size");
        if (s != null) {
            hnode.setAttribute("size", s);
        }
    }

    private void setChecked(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:selected");
        if ("true".equals(s)) {
            hnode.setAttribute("checked", "checked");
        }
    }

    private void setMultiple(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:multiple");
        if ("true".equals(s)) {
            hnode.setAttribute("multiple", "multiple");
        }
    }

    private void setDisabled(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:disabled");
        if ("true".equals(s)) {
            hnode.setAttribute("disabled", "disabled");
        }
    }

    private void setReadonly(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:readonly");
        if ("true".equals(s)) {
            hnode.setAttribute("readonly", "readonly");
        }
    }

    private void setFor(ControlReader control, Element hnode) {
        hnode.setAttribute("for", control.getId());
    }

    private void addLink(Element onode, Element hnode) {
        String sHref;
        Element oanchor = this.getDrawAnchor(onode);
        if (oanchor != null && (sHref = oanchor.getAttribute("xlink:href")) != null && sHref.length() > 0) {
            Element hanchor = this.converter.createLink(oanchor);
            hnode.getParentNode().replaceChild(hanchor, hnode);
            hanchor.appendChild(hnode);
        }
    }

    private void applySize(Element node, CSVList props, boolean bOnlyWidth) {
        String sWidth = Misc.getAttribute(node, "svg:width");
        if (sWidth != null) {
            props.addValue("width", this.scale(sWidth));
        }
        if (bOnlyWidth) {
            return;
        }
        String sHeight = Misc.getAttribute(node, "svg:height");
        if (sHeight != null) {
            props.addValue("height", this.scale(sHeight));
        }
    }

    private void applyPosition(Element node, CSVList props) {
        String sY;
        props.addValue("position", "absolute");
        String sX = node.getAttribute("svg:x");
        if (sX != null && sX.length() > 0) {
            props.addValue("left", this.scale(sX));
        }
        if ((sY = node.getAttribute("svg:y")) != null && sY.length() > 0) {
            props.addValue("top", this.scale(sY));
        }
    }

    private void applyPlacement(Element onode, Element hnodeBlock, Element hnodeInline, int nMode, Element object, StyleInfo info) {
        switch (nMode) {
            case 0: {
                hnodeInline.appendChild(object);
                break;
            }
            case 2: {
                this.applyPosition(onode, info.props);
                if (hnodeInline != null) {
                    hnodeInline.appendChild(object);
                    break;
                }
                Element div = this.converter.createElement("div");
                hnodeBlock.appendChild(div);
                div.appendChild(object);
                break;
            }
            case 3: {
                Element centerdiv = this.converter.createElement("div");
                centerdiv.setAttribute("style", "margin:2px 0px 2px 0px");
                hnodeBlock.appendChild(centerdiv);
                centerdiv.appendChild(object);
                break;
            }
            case 1: {
                Element div;
                boolean bWrap = false;
                String sAlign = "center";
                String sX = null;
                String sStyleName = Misc.getAttribute(onode, "draw:style-name");
                StyleWithProperties style = this.ofr.getFrameStyle(sStyleName);
                if (style != null) {
                    String sPos = style.getProperty("style:horizontal-pos");
                    String sWrap = style.getProperty("style:wrap");
                    if (this.isLeft(sPos)) {
                        bWrap = this.mayWrapRight(sWrap);
                        sAlign = "left";
                    } else if (this.isRight(sPos)) {
                        bWrap = this.mayWrapLeft(sWrap);
                        sAlign = "right";
                    } else if (this.isFromLeft(sPos)) {
                        bWrap = this.mayWrapRight(sWrap);
                        sAlign = "left";
                        sX = onode.getAttribute("svg:x");
                    }
                }
                if (bWrap) {
                    info.props.addValue("float", sAlign);
                    if (sX != null && sX.length() > 0) {
                        info.props.addValue("margin-left", sX);
                    }
                    if (hnodeInline != null) {
                        hnodeInline.appendChild(object);
                        break;
                    }
                    div = this.converter.createElement("div");
                    hnodeBlock.appendChild(div);
                    div.appendChild(object);
                    break;
                }
                div = this.converter.createElement("div");
                hnodeBlock.appendChild(div);
                div.appendChild(object);
                CSVList props = new CSVList(";");
                props.addValue("text-align", sAlign);
                if (sX != null && sX.length() > 0) {
                    props.addValue("margin-left", sX);
                }
                div.setAttribute("style", props.toString());
            }
        }
    }

    private boolean isLeft(String sHPos) {
        return "left".equals(sHPos) || "inside".equals(sHPos);
    }

    private boolean isCenter(String sHPos) {
        return "center".equals(sHPos);
    }

    private boolean isRight(String sHPos) {
        return "right".equals(sHPos) || "outside".equals(sHPos);
    }

    private boolean isFromLeft(String sHPos) {
        return "from-left".equals(sHPos) || "from-inside".equals(sHPos);
    }

    private boolean mayWrapLeft(String sWrap) {
        return "left".equals(sWrap) || "parallel".equals(sWrap) || "dynamic".equals(sWrap) || "run-through".equals(sWrap);
    }

    private boolean mayWrapRight(String sWrap) {
        return "right".equals(sWrap) || "parallel".equals(sWrap) || "dynamic".equals(sWrap) || "run-through".equals(sWrap);
    }

    private String scale(String s) {
        if (this.bConvertToPx) {
            return Misc.length2px(Misc.multiply(this.sScale, Misc.truncateLength(s)));
        }
        return Misc.multiply(this.sScale, Misc.truncateLength(s));
    }

    static {
        INLINE = 0;
        FLOATING = 1;
        ABSOLUTE = 2;
        CENTERED = 3;
    }
}

