/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.xhtml.CellStyleConverter;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.FrameStyleConverter;
import writer2latex.xhtml.ListStyleConverter;
import writer2latex.xhtml.PageStyleConverter;
import writer2latex.xhtml.ParStyleConverter;
import writer2latex.xhtml.PresentationStyleConverter;
import writer2latex.xhtml.RowStyleConverter;
import writer2latex.xhtml.SectionStyleConverter;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.TableStyleConverter;
import writer2latex.xhtml.TextStyleConverter;

class StyleConverter
extends ConverterHelper {
    private TextStyleConverter textSc;
    private ParStyleConverter parSc;
    private ListStyleConverter listSc;
    private SectionStyleConverter sectionSc;
    private TableStyleConverter tableSc;
    private RowStyleConverter rowSc;
    private CellStyleConverter cellSc;
    private FrameStyleConverter frameSc;
    private PresentationStyleConverter presentationSc;
    private PageStyleConverter pageSc;

    public StyleConverter(OfficeReader ofr, Config config, Converter converter, int nType) {
        super(ofr, config, converter);
        this.textSc = new TextStyleConverter(ofr, config, converter, nType);
        this.parSc = new ParStyleConverter(ofr, config, converter, nType);
        this.listSc = new ListStyleConverter(ofr, config, converter, nType);
        this.sectionSc = new SectionStyleConverter(ofr, config, converter, nType);
        this.tableSc = new TableStyleConverter(ofr, config, converter, nType);
        this.rowSc = new RowStyleConverter(ofr, config, converter, nType);
        this.cellSc = new CellStyleConverter(ofr, config, converter, nType);
        this.frameSc = new FrameStyleConverter(ofr, config, converter, nType);
        this.presentationSc = new PresentationStyleConverter(ofr, config, converter, nType);
        this.pageSc = new PageStyleConverter(ofr, config, converter, nType);
    }

    protected TextStyleConverter getTextSc() {
        return this.textSc;
    }

    protected ParStyleConverter getParSc() {
        return this.parSc;
    }

    protected ListStyleConverter getListSc() {
        return this.listSc;
    }

    protected SectionStyleConverter getSectionSc() {
        return this.sectionSc;
    }

    protected TableStyleConverter getTableSc() {
        return this.tableSc;
    }

    protected RowStyleConverter getRowSc() {
        return this.rowSc;
    }

    protected CellStyleConverter getCellSc() {
        return this.cellSc;
    }

    protected FrameStyleConverter getFrameSc() {
        return this.frameSc;
    }

    protected PresentationStyleConverter getPresentationSc() {
        return this.presentationSc;
    }

    protected PageStyleConverter getPageSc() {
        return this.pageSc;
    }

    private StyleWithProperties getDefaultStyle() {
        if (this.ofr.isSpreadsheet()) {
            return this.ofr.getDefaultCellStyle();
        }
        if (this.ofr.isPresentation()) {
            return this.ofr.getDefaultFrameStyle();
        }
        return this.ofr.getDefaultParStyle();
    }

    public void applyDefaultLanguage(Element node) {
        StyleWithProperties style = this.getDefaultStyle();
        if (style != null) {
            StyleInfo info = new StyleInfo();
            TextStyleConverter.applyLang(style, info);
            this.applyStyle(info, node);
        }
    }

    public Node exportStyles(Document htmlDOM) {
        StyleWithProperties defaultStyle;
        String sIndent = "      ";
        StringBuffer buf = new StringBuffer();
        if (this.config.xhtmlCustomStylesheet().length() == 0 && (this.config.xhtmlFormatting() == 4 || this.config.xhtmlFormatting() == 7) && (defaultStyle = this.getDefaultStyle()) != null) {
            CSVList props = new CSVList(";");
            this.getTextSc().cssTextCommon(defaultStyle, props, true);
            buf.append(sIndent).append("body {").append(props.toString()).append("}\n");
        }
        buf.append(this.getTextSc().getStyleDeclarations(sIndent));
        buf.append(this.getParSc().getStyleDeclarations(sIndent));
        buf.append(this.getListSc().getStyleDeclarations(sIndent));
        buf.append(this.getSectionSc().getStyleDeclarations(sIndent));
        buf.append(this.getCellSc().getStyleDeclarations(sIndent));
        buf.append(this.getTableSc().getStyleDeclarations(sIndent));
        buf.append(this.getRowSc().getStyleDeclarations(sIndent));
        buf.append(this.getFrameSc().getStyleDeclarations(sIndent));
        buf.append(this.getPresentationSc().getStyleDeclarations(sIndent));
        buf.append(this.getPageSc().getStyleDeclarations(sIndent));
        if (buf.length() > 0) {
            Element htmlStyle = htmlDOM.createElement("style");
            htmlStyle.setAttribute("media", "all");
            htmlStyle.setAttribute("type", "text/css");
            htmlStyle.appendChild(htmlDOM.createTextNode("\n"));
            htmlStyle.appendChild(htmlDOM.createTextNode(buf.toString()));
            htmlStyle.appendChild(htmlDOM.createTextNode("    "));
            return htmlStyle;
        }
        return null;
    }
}

