/* **********************************************************
 * Copyright 2005 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * smac_compat.h --
 *
 *      This file defines an abstraction layer to handling
 *      differences among the Linux kernel and avoiding
 *      symbol match issues.
 */

#ifndef _SMAC_COMPAT_H_
#define _SMAC_COMPAT_H_

#include "vm_basic_types.h"

#if defined(__x86_64__) 
#define SMACINT
#else
#define SMACINT __attribute__((cdecl, regparm(3)))
#endif

void   SMACINT SMACL_Memcpy(void *d, void *s, size_t l);
int    SMACINT SMACL_Memcmp(void *p1, void *p2, size_t l);
void   SMACINT SMACL_Memset(void *p1, int val, size_t l);
void*  SMACINT SMACL_Alloc(size_t s);
void   SMACINT SMACL_Free(void *p);

unsigned long SMACINT SMACL_GetUptime(void);

void   SMACINT SMACL_InitSpinlock(void **s);
void   SMACINT SMACL_AcquireSpinlock(void **s, unsigned long *flags);
void   SMACINT SMACL_ReleaseSpinlock(void  **s, unsigned long *flags);


struct sk_buff* SMACINT SMACL_DupPacket(struct sk_buff *skb);
void*  SMACINT SMACL_PacketData(struct sk_buff *skb);
unsigned int SMACINT SMACL_PacketLength(struct sk_buff *skb);
int    SMACINT SMACL_IsSkbNonlinear(struct sk_buff* skb);
int    SMACINT SMACL_IsSkbHostBound(struct sk_buff* skb);
#ifdef DBG
void   SMACINT SMACL_Print(const char * m, ...);
void   SMACINT SMACL_PrintSkb(struct sk_buff *skb, char *type);
int    SMACINT SMACL_Snprintf(char *str, size_t size, const char *format, ...);
#endif /* DBG */

#endif /* _SMAC_COMPAT_H */

