/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * $Id$
 * **********************************************************/

/*
 * cpuid.h --
 *
 *    wrap CPUID instruction
 */

#ifndef CPUID_H
#define CPUID_H

#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

typedef enum {
   CPUID_OEM_AMD,
   CPUID_OEM_CYRIX,
   CPUID_OEM_INTEL,
   CPUID_OEM_OTHER
} CPUOem;

EXTERN void CPUID_Init(void);
EXTERN CPUOem CPUID_GetOEM(void);
EXTERN uint32 CPUID_GetFeatures(void);
EXTERN uint32 CPUID_GetVersion(void);
EXTERN Bool CPUID_SyscallSupported(void);
EXTERN Bool CPUID_LongModeSupported(void);
#endif

