/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Date;
import nz.net.catalyst.Log;
import nz.net.catalyst.Main;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.Transmission;

public class Search
extends Main {
    private static final Search instance = new Search();
    private static final String PORT_PROPERTY = "LuceneServerPort";
    private static final String HOST_PROPERTY = "LuceneServerHost";
    private static final String APPLICATION_PROPERTY = "Application";
    private static int port;
    private static String host;
    private static String application;

    public static void main(String[] args) {
        Log.debug("In Search.main");
        instance.init(args);
    }

    public static void Start(String[] args) throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            sb.append(' ');
            sb.append(args[i]);
            ++i;
        }
        Log.debug("Starting");
        port = Integer.getInteger(PORT_PROPERTY, 22222);
        host = System.getProperty(HOST_PROPERTY, "localhost");
        application = System.getProperty(APPLICATION_PROPERTY, "test");
        Socket socket = new Socket(host, port);
        PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"), 0x100000), false);
        Date start = new Date();
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        Search.searchDocs(out, in, sb.toString());
        socket.close();
        Date end = new Date();
        System.out.print(end.getTime() - start.getTime());
        Log.debug(" total milliseconds");
    }

    public static void searchDocs(PrintWriter out, BufferedReader in, String query) throws Exception {
        long beforeTransmission = System.currentTimeMillis();
        Transmission command = new Transmission(ECommand.QUERY);
        command.add(APPLICATION_PROPERTY, application);
        command.add("Default-Field", "Text");
        command.add("Body", "Query");
        command.setBody(query);
        long beforeSending = System.currentTimeMillis();
        command.write(out);
        long beforeReceiving = System.currentTimeMillis();
        Transmission response = Transmission.create(in);
        long finished = System.currentTimeMillis();
        if (response == null) {
            System.err.println("Input closed while we were waiting for a response!");
        } else {
            response.write(new PrintWriter(System.out));
        }
        System.err.println("Creating transmission: " + (beforeSending - beforeTransmission) + " ms");
        System.err.println("Sending command: " + (beforeReceiving - beforeSending) + " ms");
        System.err.println("Response time: " + (finished - beforeReceiving) + " ms");
    }
}

