#!/bin/bash

# This runs PhpDocumentor to build the documentation for the
# Axyl API. The resulting docs are in the form of an HTML set
# of pages in a self-consitent website. These will be put into
# the 'api' directory, where this script lives.
THIS=`basename $0`

# Firstly, Axyl has to be installed, and its config file should
# be accessible at /etc/axyl/axyl.conf so that this script can
# find the library to document.

# Obviously PhpDocumentor also has to be installed. This can be
# downloaded from http://sourceforge.net/projects/phpdocu/
# Having grabbed a copy and unpacked it, adjust the path
# below to point at the directory it is in, and then re-run
# this script.
PHPDOC_DIR=/var/www/phpdoc

# Where is the Axyl 'api' directory at? We default it to
# just below this directory we are running this script.
# Change if required.
HERE=`pwd`
API_DIR=${HERE}/api

# Other parameters you might need to change..
DOC_NAME="Axyl"
DOC_TITLE="Axyl Library API"
DOC_IGNORE="*CFG,*JS,*GIF,*JPG,*PNG,*CSS,*SH,*HTML,*XML,*html-tidy-logic.php"
DOC_SOURCECODE=on
DOC_JAVADESC=off
#DOC_OUTPUT="HTML:Smarty:HandS"
#DOC_OUTPUT="HTML:frames:DOM/phpdoc.de"
DOC_OUTPUT="HTML:frames:DOM/earthli"

# Phpdoc sanity check..
if [ ! -x ${PHPDOC_DIR}/phpdoc ]; then
  echo "Error: ${PHPDOC_DIR}/phpdoc not found or not executable"
  exit 1
fi

# Which library are we documenting. Either we are in a source
# distribution (the first preference), or we are executing this
# inside an installed Axyl.
AXYL_HOME=
if [ -f ${HERE}/../debian/axyl.copyright ] ; then
  AXYL_HOME="${HERE}/.."
  VER=`head -n 1 ${AXYL_HOME}/debian/changelog | cut -f2 -d\( | cut -f1 -d')' | cut -f1 -d-`
  DOC_NAME="${DOC_NAME} ${VER}"
  DOC_TITLE="${DOC_TITLE} ${VER}"
  echo "building API documentation for source Axyl Version $VER"
else
  if [ -f /etc/axyl/axyl.conf ] ; then
    . /etc/axyl/axyl.conf
    if [ -f /etc/axyl/axyl.version ] ; then
      AXVER=`cat /etc/axyl/axyl.version`
      echo "building API documentation for installed Axyl Version $VER"
      DOC_NAME="${DOC_NAME} ${VER}"
      DOC_TITLE="${DOC_TITLE} ${VER}"
    else
      echo "building Axyl API documentation"
    fi
  fi
fi

# Axyl sanity check - is the library present..?
if [ ! -f ${AXYL_HOME}/lib/default-application.xml ] ; then
  echo "Error: Axyl library not present - unable to document it!"
  if [ "$AXYL_HOME" = "" ] ; then
    echo "AXYL_HOME was set to nullstring"
  else
    echo "AXYL_HOME was set to: $AXYL_HOME"
    exit 1
  fi
fi

# Some info for user..
echo "Phpdoc directory is set to $PHPDOC_DIR"
echo "API documentation will be put in $API_DIR"
echo "Axyl is installed in $AXYL_HOME"

# Clear old documentation out..
echo "clearing existing documentation from ${API_DIR}.."
cd $API_DIR
find . -type f ! -name "Root" ! -name "Repository" ! -name "Entries*" -exec rm -f {} \;

echo "building documentation from ${AXYL_HOME}/lib.."
cd ${PHPDOC_DIR}
./phpdoc \
 -t  ${API_DIR} \
 -d  ${AXYL_HOME}/lib \
 -dn ${DOC_NAME} \
 -i  ${DOC_IGNORE} \
 -o  ${DOC_OUTPUT} \
 -s  ${DOC_SOURCECODE} \
 -j  ${DOC_JAVADESC} \
 -ti ${DOC_TITLE}
 
 echo "Done."
