// created by: Andre Dietisheim (dietisheim@sphere.ch)
// created: 2001-12-20
// modified by: Andre Dietisheim (dietisheim@sphere.ch)
// modified: 2004-02-21
// version: 2.5.3

function Xlayer( sParent, xlayerParent, x, y, offsetX, offsetY, w, h,  iClipTop, iClipRight, iClipBottom, iClipLeft, iZindex, bVisibility, sBgcolor, fading, events, sText, bBold, sAlign, iTopTextBorder, iRightTextBorder, iBottomTextBorder, iLeftTextBorder, sFgcolor, sHref, sIcon, iIconWidth, iIconHeight, iconBorder, sFontface, iFontsize, src, sSpacer )
{
	if ( !Xlayer.prototype.instances )
		Xlayer.prototype.instances = new Array();
	Xlayer.prototype.instances[ Xlayer.prototype.instances.length ] = this; // Store this Instance In static array

	this.index = Xlayer.prototype.instances.length - 1;
	this.sParent = sParent;
	this.parent = null;
	this.xlayerParent = xlayerParent;
	this.lyr = null;
	this.id = this.id || "Xlayer" + this.index;
	this.x = x || 0;
	this.y = y || 0;
	this.offsetX = offsetX ||	0;
	this.offsetY = offsetY ||	0;
	this.w = w ||	0;
	this.h = h || 0;
	this.iClipTop = iClipTop || 0;
	this.iClipRight = iClipRight || w;
	this.iClipBottom = iClipBottom || h;
	this.iClipLeft = iClipLeft || 0;
	this.iZindex = iZindex || 0;
	this.bVisibility = bVisibility;
	this.sBgcolor = sBgcolor || "black";
	this.iOpacity = 0;
	this.sSpacer = sSpacer;

	// caption ---
	this.sText = sText || null;
	this.bBold = bBold || false;
	this.sAlign = sAlign || "center";
	this.iTopTextBorder = iTopTextBorder;
	this.iRightTextBorder = iRightTextBorder;
	this.iBottomTextBorder = iBottomTextBorder;
	this.iLeftTextBorder = iLeftTextBorder;
	this.sFgcolor = sFgcolor || "white";
	this.sHref = ( is.nn4up && !sHref )? "#" : sHref; // nn4 always need a href to process clicks
	this.sFontface = sFontface || "Helvetica";
	this.iFontsize = iFontsize || 2;
	this.sIcon = sIcon ||	null;
	this.iIconWidth = iIconWidth || 0;
	this.iIconHeight = iIconHeight || 0;
	this.iconBorder = iconBorder || 0;

	// iframe ----
	this.iframe = null;
	this.scrollbars = null;
	this.src = src ||	null;
	this.events = events || null; // array: event, func, event, func, ...
	this.fading =	fading || null; // array: start, stop, steps, delay

	if ( is.op6up && !is.op7up ) // opera can't create dynamically
		this.writeDiv();
}

Xlayer.prototype.MOUSEOVER = "onmouseover";
Xlayer.prototype.MOUSEOUT = "onmouseout";
Xlayer.prototype.CLICK = "onclick";


Xlayer.prototype.create = function() 
{
	this.parent = XlayerParent.prototype.getLayer( this.sParent ); // parent = another layer or document.body
	this.parentCoordsOnly = XlayerParent.prototype.getLayer( this.xlayerParent.sId );
	if ( is.nn4up )
	{
		if ( this.w == "100%" )
			this.lyr = new Layer( this.parent.innerWidth, this.parent );
		else
			this.lyr = new Layer( this.w, this.parent );
	}
	else if ( is.iewin5up || is.iemac5up || is.gk || is.sf || is.kq3up || is.op7up )
	{
		this.lyr = document.createElement( "DIV" ); // create layer
		this.lyr.style.position = "absolute";
		this.lyr.style.overflow = "hidden";
		this.lyr.id = this.id;
		this.parent.appendChild( this.lyr ); // insert into DOM
	}
	else if ( is.op6up && !is.op7up )
	{ // already created on instanciation (no dynamic creation possible)
		this.lyr = document.getElementById( this.id );
	}
	
	this.setVisibility( this.bVisibility );
	this.setSize( this.w, this.h );
	this.setEvents( this.events );
	if ( !( is.op6up && !is.op7up ) ) 
		this.setBody( this.getCaption( this.sText, this.bBold, this.sIcon, this.iIconWidth, this.iIconHeight, this.iconBorder ) );
	this.setBgColor( this.sBgcolor );
	this.setFgColor( this.sFgcolor );
	this.setPos( this.x, this.y, this.offsetX, this.offsetY );
	this.setZindex( this.iZindex );
	this.fade( this.fading );
}

Xlayer.prototype.writeDiv = function()
{
	document.writeln( '<div id="' + this.id + '" style="position:absolute;">' + this.getCaption( this.sText, this.bBold, this.sIcon, this.iIconWidth, this.iIconHeight, this.iconBorder ) + '</div>' );
}

Xlayer.prototype.kill = function()
{
	if ( is.nn4up )
	{
		for ( i = 0; i < document.layers.length ; i++ ) // scan trough layers-array in NN-DOM
		{
			this.setVisibility( false );
			if ( document.layers[ i ].id == this.lyr.id )	
			{
				index = i;
				//document.layers.splice(i, 1)
				//delete document.layers[i]
				document.layers[ i ] = null;
				break;
			}
		}
	}
	else if ( is.iewin5up || is.iemac5up || is.gk || is.sf || is.kq3up || is.op7up )
	{
		var lyr;
		lyr = document.getElementById( this.lyr.id );
		document.body.removeChild( lyr );
	}
	this.iOpacity = 0;
}

Xlayer.prototype.setFgColor = function( color )
{
	if ( this.sText )
	{
		this.sFgcolor = color;

		if ( is.nn4up )
			this.setBody( this.getCaption( this.sText, this.bBold, this.sIcon, this.iIconWidth, this.iIconHeight, this.iconBorder ) );
		else if ( is.iewin5up || is.iemac5up || is.gk || is.sf  || is.kq3up || is.op6up )
		{
			if ( this.sText )
			{
				document.getElementById( this.id+"d" ).style.color = color;
				//this.setCaption( this.sText, this.bBold, this.sIcon, this.iIconWidth, this.iIconHeight, this.iconBorder );
			}
		}
	}

}

Xlayer.prototype.setBgColor = function( color )
{
	this.sBgcolor = color;

	if ( is.nn4up )
		this.lyr.document.bgColor = color;
	else if ( is.iewin5up || is.iemac5up || is.gk || is.sf || is.kq3up || is.op6up )
		this.lyr.style.backgroundColor = color;
}

Xlayer.prototype.setSize = function( w, h )
{
	var iOldWidth = this.w; // store old values
	var iOldHeight = this.h;

	this.w = w; // store new values
	this.h = h;

	if ( is.nn4up )
	{
		if ( w == "100%" )
			this.lyr.resizeTo( window.innerWidth, h );
		else 
			this.lyr.resizeTo( w, h );
	}
	else if ( is.iewin5up || is.iemac5up || is.gk || is.sf || is.kq3up || is.op7up )
	{
		if ( w == "100%" )
		{
			this.lyr.style.width = "100%";
			this.lyr.style.height = h + 'px';
		}
		else
		{
			this.lyr.style.width = w + 'px';
			this.lyr.style.height = h + 'px';
		}

		this.setClipping( this.iClipTop, ( this.iClipRight + w - iOldWidth ),  ( this.iClipBottom + h - iOldHeight ), this.iClipLeft );

		if ( is.iewin5up && this.iframe ) // recreate iframe on resize
			this.setIframe( this.src );
	}
	else if ( is.op6up && !is.op7up )
	{
		if ( w == "100%" )
		{
			this.lyr.style.pixelWidth = "100%";
			this.lyr.style.pixelHeight = h;
		}
		else
		{
			this.lyr.style.pixelWidth = w;
			this.lyr.style.pixelHeight = h;
		}
	}
}

Xlayer.prototype.setPos = function( x, y, offsetX, offsetY )
{
	var parent;
	if ( this.parentCoordsOnly )
		parent = this.parentCoordsOnly;
	else
		parent = this.parent;
		
	// calc x, y ---
	if ( x == "centered" )
		x = XlayerParent.prototype.getX( parent ) + ( XlayerParent.getW( parent ) / 2 ) - this.w / 2;
	else if ( x == "left" )
		x = this.xlayerParent.getX( parent );
	else if ( x == "right" )
		x = XlayerParent.prototype.getX( parent ) + XlayerParent.prototype.getW( parent ) - this.w;

	if ( y == "centered" )
		y = XlayerParent.prototype.getY( parent ) + ( XlayerParent.prototype.getH( parent ) / 2 ) - this.h / 2;
	else if ( y == "top" )
		y = XlayerParent.prototype.getY( parent );
	else if ( y == "bottom" )
		y = XlayerParent.prototype.getY( parent ) + XlayerParent.prototype.getH( parent ) - this.h;

	if ( offsetX )
		x += offsetX;
	if ( offsetY )
		y += offsetY;

	this.x = x;
	this.y = y;

	// set position ---
	if ( is.nn4up )
	{
		this.lyr.moveTo( this.x, this.y );
	}
	else if ( is.iewin5up || is.iemac5up || is.gk || is.sf || is.kq3up || is.op6up )
	{
		this.lyr.style.top = this.y + "px";
		this.lyr.style.left = this.x + "px";
	}
}

Xlayer.prototype.setVisibility = function( bVisibility ) 
{
	this.bVisibility = bVisibility;
	if ( this.lyr ) 
	{
		if ( is.nn4up ) 
		{
			this.lyr.visibility = ( bVisibility )? "show" : "hide";
		}
		else if ( is.iewin5up || is.iemac5up || is.gk || is.sf || is.kq3up || is.op6up ) 
		{
			this.lyr.style.visibility = ( bVisibility )? "visible" : "hidden";
		}
	}
}

Xlayer.prototype.isVisible = function() 
{
	return this.bVisibility;
}

Xlayer.prototype.setFontsize = function( iFontsize )
{
	this.iFontsize = iFontsize;
}

Xlayer.prototype.setFontface = function( sFontface )
{
	this.sFontface = sFontface;
}

Xlayer.prototype.setClipping = function( top, right, bottom, left )
{
	if ( is.iewin5up || is.iemac5up || is.gk || is.sf || is.kq3up || is.op7up )
	{
		this.lyr.style.clip = "rect(" + top + "px " + right + "px " + bottom + "px " + left + "px)";
	}
	else if ( is.nn4up )
	{
		this.lyr.clip.top = top;
		this.lyr.clip.right = right;
		this.lyr.clip.bottom = bottom;
		this.lyr.clip.left = left;
	}
	this.iClipTop = top;
	this.iClipRight = right;
	this.iClipBottom = bottom;
	this.iClipLeft = left;
}

Xlayer.prototype.setZindex = function( iZindex )
{
	this.iZindex = iZindex;

	if ( is.iewin5up || is.iemac5up || is.gk || is.sf || is.kq3up || is.op6up )
	{
		this.lyr.style.zIndex = iZindex;
	}
	else if ( is.nn4up )
	{
		this.lyr.zIndex = iZindex;
	}
}

Xlayer.prototype.setEvents = function( events )
{
	if( events )
	{
		for ( i = 0; i < events.length; )
		{
			var e = events[ i++ ];
			var func = events[ i++ ];

			if ( is.gk || is.sf || is.kq3up || is.op7up ) this.lyr.addEventListener( e.substring( 2, e.length ), this.onEvent( e, func, this.lyr ), false );
			else if ( is.iewin5up || is.iemac5up || is.op6up ) this.lyr[ e.toLowerCase() ] = this.onEvent( e, func, this.lyr );//new Function( func );
			else if ( is.nn4up )
			{
				this.lyr.captureEvents( Event[ e.toUpperCase().substring( 2 ) ] );
				this.lyr[ e.toLowerCase() ] = new Function( func );
			}
		}
	}
}

Xlayer.prototype.onEvent = function( event, func, xlayer )
{
	return function( e )
	{
		var e = arguments[ 0 ];
		if ( event == Xlayer.prototype.MOUSEOVER || event == Xlayer.prototype.MOUSEOUT )
		{
			if ( !e ) var e = window.event; //ie

			if ( e.target && e.relatedTarget )
			{
				var target = e.target;
				var relatedTarget = e.relatedTarget;
			}
			else if ( e.fromElement && e.toElement )
			{
				var target = e.toElement;
				var relatedTarget = e.fromElement;
			}
			if ( Xlayer.prototype.isChildNode( relatedTarget, xlayer ) && Xlayer.prototype.isChildNode( target, xlayer ) )
				return false; // ignore events of inner html-entities 
		}
		return eval( func );
	};
}

Xlayer.prototype.isChildNode = function( node, parentNode )
{
	if ( node == parentNode )
	{
		return true;
	}
	else if ( node && node.parentNode )
		return Xlayer.prototype.isChildNode( node.parentNode, parentNode );
	else
		return false;
}

Xlayer.prototype.setBody = function( sHtml )
{
	if ( is.iewin5up || is.iemac || is.op7up || is.kq3up )
		this.lyr.innerHTML = sHtml;
	else if ( is.gk || is.sf )
	{
		while ( this.lyr.hasChildNodes() )
				this.lyr.removeChild( this.lyr.firstChild );
		var range = this.lyr.ownerDocument.createRange();
		range.selectNodeContents( this.lyr );
		range.deleteContents();
		var contextualFrag = range.createContextualFragment( sHtml );
		this.lyr.appendChild( contextualFrag );
	}
	else if( is.nn4up )
	{
		this.lyr.document.open()
		this.lyr.document.write( sHtml );
		this.lyr.document.close();
	}
	else if ( is.op6up && !is.op7up )
		this.sBody = sHtml;
}

Xlayer.prototype.scroll = function( orientation, step )
{
	this.orientation = orientation;
	this.step = step;

	// scrolling possible (clipping present)
	if ( ( this.iClipRight < this.w ) || ( this.iClipTop != 0 ) || ( this.iClipLeft > 0 ) || ( this.iClipBottom < this.h ) ) 
	{ // scrolling possible
		if ( orientation == "horiz" )
		{
			if ( this.iClipLeft + step > 0 && this.iClipRight  + step < this.w ) 
			{	// border reached?
				this.setPos(this.x - step, this.y);
				this.setClipping(this.iClipTop, this.iClipRight + step, this.iClipBottom, this.iClipLeft + step);
			}
		}
		else if ( orientation == "vert" )
		{
			if ( this.iClipTop + step > 0 && this.iClipBottom + step < this.h ) 
			{	// border reached?
				this.setPos( this.x, this.y - step );
				this.setClipping( this.iClipTop + step, this.iClipRight, this.iClipBottom + step, this.iClipLeft );
			}
		}
	}
}

Xlayer.prototype.setOpacity = function( iOpac )
{
	if ( is.iewin5up || is.iemac5up )
		this.lyr.style.filter = "alpha(opacity=" + iOpac + ")";

	else if ( is.gk )
	{
		this.lyr.style.MozOpacity = iOpac / 100;//opac + "%";
	}
/*	not tested yet
	else if ( is.kq3up )
	{
		this.lyr.style.KhtmlOpacity = iOpac / 100;
	}
*/}

Xlayer.prototype.fade = function( fading )
{
	if ( fading )
	{
		start =	fading[ 0 ]; // opacity start value
		stop =	fading[ 1 ]; // stop
		steps =	fading[ 2 ]; // number of steps
		delay =	fading[ 3 ]; // delay in ms

		this.iOpacity = this.iOpacity + parseInt( ( stop - start ) / steps );
		this.setOpacity( this.iOpacity );

		if ( this.iOpacity < stop )
			setTimeout( "Xlayer.prototype.instances[" + this.index + "].fade( Xlayer.prototype.instances[" + this.index + "].fading )", delay);

		this.fading = fading;
		return true;
	}
}

Xlayer.prototype.setIframe = function( src, scrollbars )
{
	this.src =	src;

	if ( scrollbars != null )
	{
		this.scrollbars = ( scrollbars )? "yes"	: "no";
	}
	else if ( this.scrollbars == null )
	{
		this.scrollbars = "yes";			// default for scrollbars: 'yes'
	}

	if ( is.nn4up )
	{
		this.lyr.src = src;
	}
	else if ( is.iewin5 )
	{ // ugly workaround: ie5 basically cannot create dynamically : frame, iframe

		this.lyr.innerHTML = "<iframe width='100%' height='100%' frameborder='0' scrolling='" + this.scrollbars + "' id='" + this.id + "_iframe" + "'></iframe>";
		this.lyr.contentWindow = new Object();
		this.lyr.contentWindow.location = new Object();
		this.iframe = document.getElementById(this.id + "_iframe");		// store iframe
		this.lyr.contentWindow.location.iframe = this.iframe;
		this.lyr.contentWindow.location.iframe.id = "";
		this.lyr.contentWindow.location.iframe.src = src
	}
	else if ( is.iewin55up || is.iemac5up || is.gk || is.sf || is.kq3up || is.op7up )
	{
		var iframe;
		iframe = document.createElement( "IFRAME" );			// create iframe
		iframe.src = src;
		iframe.name = this.id + "_iframe";
		iframe.scrolling = this.scrollbars;
		iframe.frameBorder = "0px";
		iframe.style.visibility = "inherit";

		if ( is.iewin55up )
		{
			iframe.style.width = this.w + "px";
			iframe.style.height = this.h + "px";
		}
		else if ( is.iemac5up || is.gk || is.sf || is.kq3up || is.op7up )
		{
			iframe.style.width = "inherit";
			iframe.style.height = "inherit";
		}

		while ( this.lyr.hasChildNodes() )
		{	// remove existing layer child-nodes
			this.lyr.removeChild( this.lyr.lastChild );
		}
		this.lyr.appendChild( iframe ) // insert iframe into layer

		this.iframe = iframe;
	}
}

Xlayer.prototype.getCaption = function( sText, bBold, sIcon, iIconWidth, iIconHeight, iIconBorder )
{
	this.sText = sText;
	this.sIcon = sIcon;
	this.iIconWidth = iIconWidth;
	this.iIconHeight = iIconHeight;

	var tab_head = '<table style="' + ( ( is.iewin5up )? 'cursor: hand;' : 'cursor: pointer;" ' ) + 'width="' + this.w + '" height="' + this.h + '" border="0" cellpadding="0" cellspacing="0">';
	var tab_foot = '</table>';

	if ( sText || sIcon )
	{
		// content ---
		var img = "", desc = "", html ="", tab_body = "", sTextCell = "";
		if ( sIcon )
			img = '<img src="' + sIcon + '" width="' + iIconWidth + '" height="' + iIconHeight + '">';
		if ( sText )
		{				
			if ( is.nn4up )
				sTextCell = '<font id="' + this.id + 'd" color="' + this.sFgcolor + '" size="' + ( parseInt( "0" + ( this.iFontsize / 5 ), 10 ) ) + '" face="' + this.sFontface + '">' + ( ( bBold )? '<b>' : '' ) + sText + ( ( bBold )? '</b>' : '' ) + '</font>';
			else if ( is.iewin5up || is.gk || is.sf || is.kq3up || is.iemac5up || is.op6up )
				sTextCell = '<span id="' + this.id + 'd" style="' + 'color:' + this.sFgcolor + ';' + 'font-size:' + this.iFontsize + 'px;' + 'font-family:' + this.sFontface + ';' + ( ( bBold )? ' font-weight:bold;' : '' ) + 'height:' + this.iFontsize + 'px">' + sText + '</span>';
		}
		if ( this.sHref && is.nn4up ) // nn4 always needs a <a href...
			sTextCell = "<a href='" + this.sHref + "' style='text-decoration: none;'>" + sTextCell + "</a>";

		// text cell -----
		var iTextCellWidth = this.w - iIconWidth - iIconBorder;
		var iTextCellHeight = this.h - this.iTopTextBorder - this.iBottomTextBorder;
		desc += '<table width="' + iTextCellWidth + '" height="' + this.h + '" cellpadding="0" cellspacing="0" border="0">';
		// top text border
		if ( this.iTopTextBorder > 0 )
			desc += '<tr style="line-height: ' +  this.iTopTextBorder + 'px"><td colspan="3" height="' + this.iTopTextBorder + '"><img src="' + this.sSpacer + '" width="1" height="' + this.iTopTextBorder + '" border="0"></td></tr>';
		desc += '<tr style="line-height: ' +  this.iFontsize + 'px">';
		// left border
		if ( this.iLeftTextBorder > 0 )
			desc += '<td><img src="' + this.sSpacer + '" width="' + this.iLeftTextBorder + '" height="1" border="0"></td>';
		// text cell
		desc += '<td valign="middle" align="' + this.sAlign + '">' + sTextCell + '</td>';
		// right border
		if ( this.iRightTextBorder > 0 )
			desc += '<td><img src="' + this.sSpacer + '" width="' + this.iRightTextBorder + '" height="1" border="0"></td>';
		desc += '</tr>';
		// bottom text border
		if ( this.iBottomTextBorder > 0 )
			desc += '<tr style="line-height: ' + this.iBottomTextBorder + 'px"><td colspan="3" height="' + this.iBottomTextBorder + '"><img src="' + this.sSpacer + '" width="1" height="' + this.iBottomTextBorder + '" border="0"></td></tr>';
		// right border
		desc += '</table>';
		// text & icons ---
		if ( sIcon && sText )
		{
			tab_body =
				'<tr>' +
					'<td nowrap ';
			if ( is.iemac5 )
			{
				tab_body += 'style="position: absolute; top: 0px; height: ' + this.iFontsize + 'px; width: ' + ( this.w - iIconWidth - iIconBorder ) + 'px; vertical-align: middle;" ';
			}
			tab_body +=
						'width="' + ( this.w - iIconWidth  - iIconBorder ) + '" height="' + this.h + '" align="' + this.sAlign + '" valign="middle">' +
						desc +
					'</td>' +
					'<td ';
			if ( is.iemac5 )
			{
				tab_body += 'style="position: absolute; top: ' + ( ( this.h - iIconHeight ) / 2 ) + 'px; left: ' + ( this.w - iIconWidth - iIconBorder ) + 'px; bottom: ' + iIconHeight + 'px; right:' + ( iIconWidth + iIconBorder ) + 'px;height: ' + iIconHeight + 'px; width: ' + ( iIconWidth + iIconBorder ) + 'px" ';
			}
			tab_body +=
					'width="' + ( iIconWidth + iIconBorder ) + '" height="' + this.h + '" align="center" valign="middle" >' +
						img +
					'</td>' +
				'</tr>';
		}

		// text only ---
		else if ( sText && !sIcon )
		{
			tab_body = '<tr><td ';
			if ( is.iemac5 )
			{
				tab_body += 'style="position: absolute; top: 0; left: 0" ';
			}
			tab_body +=
				'width="' + this.w + '" height="' + this.h + '" align="' + this.sAlign + '" valign="middle">' + desc + '</td></tr>';
		}
		// icon only ---
		else if ( sIcon && !sText )
		{
			tab_body = '<tr><td nowrap ';
			if ( is.iemac5 )
			{
				tab_body += 'style="position: absolute; top: 0; left: 0" ';
			}
			tab_body += 'width="' + this.w + '" height="' + this.h + '" align="' + this.sAlign + '" valign="middle">' + sIcon + '</td></tr>';
		}
		var html = tab_head + tab_body + tab_foot;

		return html;
	}
}
