/*
    Additions to NetworkManager, network-manager-applet and modemmanager
    for supporting Ericsson modules like F3507g.

    Author: Per Hallsmark <per@hallsmark.se>
            Bjorn Runaker <bjorn.runaker@ericsson.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <unistd.h>
#include "nm-gsm-modem-mbm.h"
#include "nm-device-private.h"
#include "nm-device-interface.h"
#include "NetworkManagerSystem.h"
#include "nm-setting-connection.h"
#include "nm-setting-gsm.h"
#include "nm-modem-types.h"
#include "nm-utils.h"

G_DEFINE_TYPE (NMGsmModemMbm, nm_gsm_modem_mbm, NM_TYPE_GSM_MODEM)

#define NM_GSM_MODEM_MBM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NM_TYPE_GSM_MODEM_MBM, NMGsmModemMbmPrivate))

typedef struct {
	char *netdev_iface;
	NMIP4Config  *pending_ip4_config;
} NMGsmModemMbmPrivate;

#define MBM_SECRETS_TRIES "gsm-secrets-tries"

static NMActStageReturn
   (*old_real_act_stage1_prepare) (NMDevice *device, NMDeviceStateReason *reason) = NULL;

static char *
get_network_device (NMDevice *device)
{
	char *result = NULL;
	GError *error = NULL;
	GValue value = { 0, };

	if (!dbus_g_proxy_call (nm_modem_device_get_proxy (NM_MODEM_DEVICE (device), "org.freedesktop.DBus.Properties"),
					    "Get", &error,
					    G_TYPE_STRING, MM_DBUS_INTERFACE_MODEM_GSM_MBM,
					    G_TYPE_STRING, "NetworkDevice",
					    G_TYPE_INVALID,
					    G_TYPE_VALUE, &value,
					    G_TYPE_INVALID)) {
		nm_warning ("Could not get MBM device's network interface: %s", error->message);
		g_error_free (error);
	} else {
		if (G_VALUE_HOLDS_STRING (&value))
			result = g_value_dup_string (&value);
		else
			nm_warning ("Could not get MBM device's network interface: wrong type '%s'",
					  G_VALUE_TYPE_NAME (&value));

		g_value_unset (&value);
	}

	return result;
}

NMDevice *
nm_gsm_modem_mbm_new (const char *path,
				  const char *data_device,
				  const char *driver)
{
	NMDevice *device;

	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (data_device != NULL, NULL);
	g_return_val_if_fail (driver != NULL, NULL);

	device = (NMDevice *) g_object_new (NM_TYPE_GSM_MODEM_MBM,
								 NM_DEVICE_INTERFACE_UDI, path,
								 NM_DEVICE_INTERFACE_IFACE, data_device,
								 NM_DEVICE_INTERFACE_DRIVER, driver,
								 NM_DEVICE_INTERFACE_MANAGED, TRUE,
                                                                 NM_MODEM_DEVICE_PATH, path,
								 NULL);

	if (device) {
		NMGsmModemMbmPrivate *priv;

		priv = NM_GSM_MODEM_MBM_GET_PRIVATE (device);
		priv->netdev_iface = get_network_device (device);
		if (!priv->netdev_iface) {
			g_object_unref (device);
			device = NULL;
		}
	}

	return device;
}

/*****************************************************************************/
static NMSetting *
get_setting (NMGsmModemMbm *modem, GType setting_type)
{
	NMActRequest *req;
	NMSetting *setting = NULL;

	req = nm_device_get_act_request (NM_DEVICE (modem));
	if (req) {
		NMConnection *connection;

		connection = nm_act_request_get_connection (req);
		if (connection)
			setting = nm_connection_get_setting (connection, setting_type);
	}

	return setting;
}

#if 0
static void
mbm_auth_done (DBusGProxy *proxy, DBusGProxyCall *call_id, gpointer user_data)
{
	GError *error = NULL;

	if (dbus_g_proxy_end_call (proxy, call_id, &error, G_TYPE_INVALID)) {


	} else {
/* return value not needed		nm_warning ("Setting username
 * and password failed: %s", error->message);*/
		g_error_free (error);
	}
}
#endif

static NMActStageReturn
real_act_stage1_prepare (NMDevice *device, NMDeviceStateReason *reason)
{
	NMActRequest *req;
	NMConnection *connection;
	const char *setting_name;
	GPtrArray *hints = NULL;
	const char *hint1 = NULL, *hint2 = NULL;
	guint32 tries;
	NMSettingGsm *s_gsm;
	GError *error;

	g_debug("real_act_stage1_prepare");

	req = nm_device_get_act_request (device);
	g_assert (req);
	connection = nm_act_request_get_connection (req);
	g_assert (connection);

	setting_name = nm_connection_need_secrets (connection, &hints);
	g_debug("setting_name = %s", setting_name?setting_name:"");

	if (hints) {
		if (hints->len > 0)
			hint1 = g_ptr_array_index (hints, 0);
		if (hints->len > 1)
			hint2 = g_ptr_array_index (hints, 1);
		g_debug("hints->len = %d", hints->len);
	}

	nm_device_state_changed (device, NM_DEVICE_STATE_NEED_AUTH, NM_DEVICE_STATE_REASON_NONE);

	g_debug("before nm_act_request_request_connection_secrets");

	s_gsm = NM_SETTING_GSM (get_setting (NM_GSM_MODEM_MBM (device), NM_TYPE_SETTING_GSM));

	if (s_gsm->username && *s_gsm->username && (!s_gsm->password || !s_gsm->password)) {
	tries = GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (connection), MBM_SECRETS_TRIES));
	nm_act_request_request_connection_secrets (req,
			NM_SETTING_GSM_SETTING_NAME,
		tries ? TRUE : FALSE,
		SECRETS_CALLER_GSM,
		NM_SETTING_GSM_PASSWORD,
		NULL);

	g_object_set_data (G_OBJECT (connection), MBM_SECRETS_TRIES, GUINT_TO_POINTER (++tries));

	sleep (1);

	s_gsm = NM_SETTING_GSM (get_setting (NM_GSM_MODEM_MBM (device), NM_TYPE_SETTING_GSM));

	g_debug("s_gsm->username = %s,  s_gsm->password = %s, s_gsm->pin = %s, bE=%d",  s_gsm->username,  s_gsm->password, s_gsm->pin, s_gsm->lock);
	} else
		g_debug("no update of password dialog");
	dbus_g_proxy_call_with_timeout (nm_modem_device_get_proxy (NM_MODEM_DEVICE (device), MM_DBUS_INTERFACE_MODEM_GSM_NETWORK),
				 "SetUserPass", 10000,
				 &error,
				 G_TYPE_STRING, s_gsm->username ? s_gsm->username : "",
				 G_TYPE_STRING, s_gsm->password ? s_gsm->password : "",
				 G_TYPE_STRING, s_gsm->pin ? s_gsm->pin : "",
				 G_TYPE_UINT, s_gsm->lock,
				 G_TYPE_INVALID);
	if (hints)
		g_ptr_array_free (hints, TRUE);


	g_debug("MBM version of  real_act_stage1_prepare");

	if (old_real_act_stage1_prepare)
		return (*old_real_act_stage1_prepare)(device, reason);
	else
		return NM_ACT_STAGE_RETURN_SUCCESS;
}

static NMActStageReturn
real_act_stage2_config (NMDevice *device, NMDeviceStateReason *reason)
{
	NMGsmModemMbmPrivate *priv = NM_GSM_MODEM_MBM_GET_PRIVATE (device);
	NMActRequest *req;
	NMConnection *connection;
	guint32 tries = 0;

	/* set tries to 0 when we pass this */
	 
	req = nm_device_get_act_request (device);
	g_assert (req);
	connection = nm_act_request_get_connection (req);
	g_assert (connection);

	g_object_set_data (G_OBJECT (connection), MBM_SECRETS_TRIES, GUINT_TO_POINTER (tries));


	nm_device_set_ip_iface (device, priv->netdev_iface);
	g_warning("%s %s: setting ip_iface to %s\n", __FILE__, __FUNCTION__, priv->netdev_iface);

//	nm_device_activate_schedule_stage3_ip_config_start (device);


	g_debug("real_act_stage2_config done");
	return NM_ACT_STAGE_RETURN_SUCCESS;
}


#if 0
static NMActStageReturn
real_act_stage4_get_ip4_config (NMDevice *device,
                                NMIP4Config **config,
                                NMDeviceStateReason *reason)
{
	NMGsmModemMbmPrivate *priv = NM_GSM_MODEM_MBM_GET_PRIVATE (device);

	*config = priv->pending_ip4_config;
        priv->pending_ip4_config = NULL;

        return NM_ACT_STAGE_RETURN_SUCCESS;
}
#endif

static void
real_deactivate (NMDevice *device)
{
	NMGsmModemMbmPrivate *priv = NM_GSM_MODEM_MBM_GET_PRIVATE (device);

	if (priv->pending_ip4_config) {
                g_object_unref (priv->pending_ip4_config);
                priv->pending_ip4_config = NULL;
        }

	if (priv->netdev_iface) {
		nm_system_device_flush_ip4_routes_with_iface (priv->netdev_iface);
		nm_system_device_flush_ip4_addresses_with_iface (priv->netdev_iface);
		nm_system_device_set_up_down_with_iface (priv->netdev_iface, FALSE, NULL);
	}
	nm_device_set_ip_iface (device, NULL);

	if (NM_DEVICE_CLASS (nm_gsm_modem_mbm_parent_class)->deactivate)
		NM_DEVICE_CLASS (nm_gsm_modem_mbm_parent_class)->deactivate (device);
}

static gboolean
real_hw_is_up (NMDevice *device)
{
	NMGsmModemMbmPrivate *priv = NM_GSM_MODEM_MBM_GET_PRIVATE (device);

	if (priv->netdev_iface)
		return nm_system_device_is_up_with_iface (priv->netdev_iface);

	return TRUE;
}

static gboolean
real_hw_bring_up (NMDevice *device, gboolean *no_firmware)
{
	NMGsmModemMbmPrivate *priv = NM_GSM_MODEM_MBM_GET_PRIVATE (device);

	if (priv->netdev_iface)
		return nm_system_device_set_up_down_with_iface (priv->netdev_iface, TRUE, no_firmware);

	return TRUE;
}

static void
real_connect (NMModemDevice *modem, const char *number)
{
	nm_device_activate_schedule_stage2_device_config (NM_DEVICE (modem));
}

/*****************************************************************************/

static void
nm_gsm_modem_mbm_init (NMGsmModemMbm *self)
{
}

static void
finalize (GObject *object)
{
	NMGsmModemMbmPrivate *priv = NM_GSM_MODEM_MBM_GET_PRIVATE (object);

	g_free (priv->netdev_iface);

	G_OBJECT_CLASS (nm_gsm_modem_mbm_parent_class)->finalize (object);
}

static void
nm_gsm_modem_mbm_class_init (NMGsmModemMbmClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	NMDeviceClass *device_class = NM_DEVICE_CLASS (klass);
	NMModemDeviceClass *modem_class = NM_MODEM_DEVICE_CLASS (klass);

	g_type_class_add_private (object_class, sizeof (NMGsmModemMbmPrivate));

	object_class->finalize = finalize;

	old_real_act_stage1_prepare = device_class->act_stage1_prepare;
	device_class->act_stage1_prepare = real_act_stage1_prepare;
	
	device_class->act_stage2_config = real_act_stage2_config;
#if 0
	device_class->act_stage4_get_ip4_config = real_act_stage4_get_ip4_config;
#endif
	device_class->deactivate = real_deactivate;
	device_class->hw_is_up = real_hw_is_up;
	device_class->hw_bring_up = real_hw_bring_up;

	modem_class->connect = real_connect;
}
