/* -*- Mode: C; tab-width: 5; indent-tabs-mode: t; c-basic-offset: 5 -*- */

#ifndef NM_GSM_MODEM_H
#define NM_GSM_MODEM_H

#include <nm-modem-device.h>

G_BEGIN_DECLS

#define NM_TYPE_GSM_MODEM            (nm_gsm_modem_get_type ())
#define NM_GSM_MODEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_TYPE_GSM_MODEM, NMGsmModem))
#define NM_GSM_MODEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  NM_TYPE_GSM_MODEM, NMGsmModemClass))
#define NM_IS_GSM_MODEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_TYPE_GSM_MODEM))
#define NM_IS_GSM_MODEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  NM_TYPE_GSM_MODEM))
#define NM_GSM_MODEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  NM_TYPE_GSM_MODEM, NMGsmModemClass))

typedef struct {
	NMModemDevice parent;
} NMGsmModem;

typedef struct {
	NMModemDeviceClass parent;

	/* Signals */
	void (*signal_quality) (NMGsmModem *modem, guint32 quality);
} NMGsmModemClass;

GType nm_gsm_modem_get_type (void);

NMDevice *nm_gsm_modem_new (const char *path,
					   const char *data_device,
					   const char *driver);

G_END_DECLS

#endif /* NM_GSM_MODEM_H */
