/*
 * Copyright (c) 2007 Jeremy English <jhe@jeremyenglish.org>
 * 
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 * 
 * Created: 07-May-2007 
 */

#include <stdint.h> 
#include <string.h>
#include "screenhack.h"
#include "analogtv.h"
#include "asm6502.h"

/* We want to paint on a 32 by 32 grid of pixels. We will needed to
   divided the screen up into chuncks */
enum {
  SCREEN_W = ANALOGTV_VIS_LEN,
  SCREEN_H = ANALOGTV_VISLINES,
  NUM_PROGS = 9
};

struct state {
  Display *dpy;
  Window window;
  
  Bit8 pixels[32][32];

  machine_6502 *machine;

  analogtv *tv;
  analogtv_input *inp;
  analogtv_reception reception;
  int pixw; /* pixel width */
  int pixh;/* pixel height */
  int topb;/* top boarder */
  int field_ntsc[4];/* used for clearing the screen*/ 
  int dt;/* how long to wait before changing the demo*/
  unsigned int pc;/* program counter */
  struct timeval start_time; 
};

static void
plot6502(Bit8 x, Bit8 y, Bit8 color, void *closure)
{
  struct state *st = (struct state *) closure;
  st->pixels[x][y] = color;
}

static void 
start_rand_bin_prog(machine_6502 *machine, struct state *st){
  int r = random() % NUM_PROGS;

  Bit8 noise[] =
    {0xa0, 0xff, 0xa2, 0x00, 0xa5, 0xfe, 0x9d, 0x00, 0x02, 0x29, 
     0x07, 0x9d, 0x00, 0x03, 0x29, 0x03, 0x9d, 0x00, 0x04, 0x29, 
     0x01, 0x9d, 0x00, 0x05, 0xe8, 0x88, 0xd0, 0xe8, 0x60, 0x00};

  Bit8 random[22] =
    {0xa5, 0xfe, 0x85, 0x00, 0xa5, 0xfe, 0x29, 0x03, 0x18, 0x69,
     0x02, 0x85, 0x01, 0xa5, 0xfe, 0xa0, 0x00, 0x91, 0x00, 0x4c,
     0x00, 0x06};

  Bit8 atari[629] =
    {0xa9, 0x5c, 0x85, 0x00, 0xa9, 0x06, 0x85, 0x01, 0xa9, 0x00,
     0x85, 0x02, 0xa9, 0x02, 0x85, 0x03, 0xa5, 0x03, 0xc9, 0x06,
     0xd0, 0x01, 0x60, 0xa2, 0x00, 0xa1, 0x00, 0xc9, 0xff, 0xd0,
     0x1a, 0xe8, 0xa1, 0x00, 0xa8, 0xe8, 0xa1, 0x00, 0xa2, 0x00,
     0x81, 0x02, 0x20, 0x51, 0x06, 0x88, 0xd0, 0xf6, 0x20, 0x46,
     0x06, 0x20, 0x46, 0x06, 0x4c, 0x10, 0x06, 0xa2, 0x00, 0x81,
     0x02, 0x20, 0x51, 0x06, 0x20, 0x46, 0x06, 0x4c, 0x10, 0x06,
     0xe6, 0x00, 0xa5, 0x00, 0xc9, 0x00, 0xd0, 0x02, 0xe6, 0x01,
     0x60, 0xe6, 0x02, 0xa6, 0x02, 0xe0, 0x00, 0xd0, 0x02, 0xe6,
     0x03, 0x60, 0xff, 0x2b, 0x01, 0x0f, 0x0f, 0x0f, 0x0c, 0x0f,
     0x0f, 0x0f, 0xff, 0x18, 0x01, 0x0c, 0x0f, 0x0c, 0x00, 0x0c,
     0x0f, 0x0c, 0xff, 0x18, 0x01, 0x00, 0x0f, 0x0c, 0x00, 0x0c,
     0x0f, 0x0c, 0xff, 0x18, 0x01, 0x0c, 0x0f, 0x0c, 0x00, 0x0c,
     0x0f, 0x0c, 0xff, 0x18, 0x01, 0x00, 0x0f, 0x0c, 0x00, 0x0c,
     0x0f, 0x0c, 0xff, 0x18, 0x01, 0x0c, 0x0f, 0x00, 0x00, 0x0c,
     0x0f, 0x0c, 0xff, 0x18, 0x01, 0x00, 0x0f, 0x0c, 0x00, 0x0c,
     0x0f, 0x0c, 0xff, 0x18, 0x01, 0x00, 0x0f, 0x0c, 0x00, 0x0c,
     0x0f, 0x00, 0xff, 0x18, 0x01, 0x00, 0x0f, 0x0c, 0x00, 0x0c,
     0x0f, 0x00, 0xff, 0x17, 0x01, 0x0f, 0x00, 0x0f, 0x0c, 0x00,
     0x0c, 0x0f, 0x00, 0x0f, 0xff, 0x16, 0x01, 0x0c, 0x00, 0x01,
     0x0c, 0x00, 0x0c, 0x0f, 0x00, 0x0c, 0xff, 0x15, 0x01, 0x0f,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x0c, 0x01, 0x00, 0x00, 0xff,
     0x15, 0x01, 0x0c, 0x00, 0x0c, 0x01, 0x0c, 0x00, 0x0c, 0x01,
     0x0c, 0x00, 0x0c, 0xff, 0x13, 0x01, 0x0f, 0x00, 0x00, 0x0f,
     0x01, 0x0c, 0x00, 0x0c, 0x01, 0x0f, 0x00, 0x00, 0x0f, 0xff,
     0x11, 0x01, 0x0f, 0x00, 0x00, 0x00, 0x01, 0x01, 0x0c, 0x00,
     0x0c, 0x01, 0x01, 0x00, 0x00, 0x00, 0xff, 0x10, 0x01, 0x0f,
     0x00, 0x00, 0x00, 0x0f, 0x01, 0x01, 0x00, 0x00, 0x0c, 0x01,
     0x01, 0x0f, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x0d, 0x01, 0x0c,
     0x00, 0x00, 0x00, 0x0c, 0x01, 0x01, 0x01, 0x0c, 0x00, 0x0c,
     0x01, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0xff, 0x0a,
     0x01, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x01, 0x01, 0x01,
     0x01, 0x00, 0x00, 0x0c, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x0c, 0xff, 0x08, 0x01, 0x00, 0x00, 0x00,
     0x00, 0x0c, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x0c,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x00,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
     0x00, 0x0c, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0c,
     0x00, 0x0c, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x0c,
     0x00, 0x00, 0xff, 0x12, 0x01, 0x0f, 0xff, 0x35, 0x01, 0x00,
     0x0f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x01, 0x0c,
     0x0c, 0x01, 0x01, 0x01, 0x0c, 0x00, 0x00, 0x00, 0x01, 0x01,
     0x00, 0x0f, 0x0f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x0c, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x0f, 0x01, 0x01,
     0x0f, 0x00, 0x00, 0x0f, 0x01, 0x01, 0x00, 0x0f, 0x01, 0x0c,
     0x0c, 0x01, 0x00, 0x0f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x00, 0x0f, 0x00, 0x0f, 0x01, 0x01, 0x00, 0x0f,
     0x01, 0x01, 0x0f, 0x0c, 0x0c, 0x0c, 0x01, 0x01, 0x00, 0x01,
     0x01, 0x0f, 0x00, 0x01, 0x00, 0x0f, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x0c, 0x0f, 0x01, 0x01,
     0x0c, 0x0f, 0x01, 0x01, 0x00, 0x0f, 0x0f, 0x00, 0x01, 0x01,
     0x00, 0x0f, 0x0f, 0x00, 0x0f, 0x01, 0x00, 0x0f, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x0c, 0x00, 0x0c, 0x00, 0x00,
     0x01, 0x01, 0x00, 0x0f, 0x01, 0x01, 0x00, 0x0c, 0x0c, 0x00,
     0x0f, 0x01, 0x00, 0x0f, 0x00, 0x0f, 0x01, 0x01, 0x00, 0x0f,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x0c, 0x0f,
     0x0f, 0x00, 0x0f, 0x01, 0x0c, 0x0f, 0x01, 0x0c, 0x0c, 0x0f,
     0x0f, 0x0c, 0x0c, 0x01, 0x00, 0x01, 0x0f, 0x0c, 0x01, 0x01,
     0x00, 0x0f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x00,
     0x01, 0x01, 0x01, 0x0c, 0x0c, 0x01, 0x00, 0x0f, 0x01, 0x00,
     0x0f, 0x01, 0x01, 0x0f, 0x00, 0x01, 0x00, 0x0f, 0x01, 0x00,
     0x0f, 0x01, 0x00, 0x0f, 0xff, 0x10, 0x01, 0x0f, 0xff, 0x05,
     0x01, 0x0f, 0x01, 0x01, 0x01, 0x0f, 0xff, 0x26, 0x01};
  
  Bit8 c64[1076] =
    {0xa9, 0x34, 0x85, 0x00, 0xa9, 0x06, 0x85, 0x01, 0xa9, 0x00,
     0x85, 0x02, 0xa9, 0x02, 0x85, 0x03, 0xa2, 0x00, 0xa1, 0x00,
     0x81, 0x02, 0xe6, 0x00, 0xa5, 0x00, 0xc9, 0x00, 0xd0, 0x02,
     0xe6, 0x01, 0xe6, 0x02, 0xa5, 0x02, 0xc9, 0x00, 0xd0, 0x08,
     0xa5, 0x03, 0xc9, 0x05, 0xf0, 0x05, 0xe6, 0x03, 0x4c, 0x12,
     0x06, 0x60, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
     0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02,
     0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
     0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02,
     0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
     0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01,
     0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06,
     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
     0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x01, 0x01, 0x01, 0x01, 0x01, 0x01};
  
  Bit8 demoscene[2109] =
    {0xa2, 0x00, 0xbd, 0x1c, 0x0e, 0xc9, 0xff, 0xf0, 0x0a, 0x9d,
     0xe0, 0x04, 0x9d, 0xe0, 0x05, 0xe8, 0x4c, 0x02, 0x06, 0x20,
     0xbd, 0x06, 0xa9, 0x00, 0x85, 0x10, 0x85, 0x11, 0x20, 0xd0,
     0x06, 0x20, 0x4e, 0x06, 0x20, 0x28, 0x06, 0x4c, 0x1c, 0x06,
     0xa2, 0x00, 0xbd, 0x21, 0x05, 0x9d, 0x20, 0x05, 0xbd, 0x41,
     0x05, 0x9d, 0x40, 0x05, 0xbd, 0x61, 0x05, 0x9d, 0x60, 0x05,
     0xbd, 0x81, 0x05, 0x9d, 0x80, 0x05, 0xbd, 0xa1, 0x05, 0x9d,
     0xa0, 0x05, 0xe8, 0xe0, 0x1f, 0xd0, 0xdd, 0x60, 0xa5, 0x10,
     0xc9, 0x00, 0xd0, 0x0d, 0xe6, 0x11, 0xa6, 0x11, 0xbd, 0xf0,
     0x09, 0xaa, 0xbd, 0xd4, 0x09, 0x85, 0x10, 0xc6, 0x10, 0xa6,
     0x11, 0xbd, 0xf0, 0x09, 0xc9, 0xff, 0xd0, 0x07, 0xa9, 0x00,
     0x85, 0x10, 0x85, 0x11, 0x60, 0x0a, 0xaa, 0xbd, 0x64, 0x0a,
     0x85, 0x02, 0xe8, 0xbd, 0x64, 0x0a, 0x85, 0x03, 0xa9, 0x9c,
     0x18, 0x65, 0x02, 0x85, 0x00, 0xa9, 0x0a, 0x65, 0x03, 0x85,
     0x01, 0xa6, 0x10, 0xa1, 0x00, 0x8d, 0x3f, 0x05, 0x8a, 0x18,
     0x69, 0x06, 0xaa, 0xa1, 0x00, 0x8d, 0x5f, 0x05, 0x8a, 0x18,
     0x69, 0x06, 0xaa, 0xa1, 0x00, 0x8d, 0x7f, 0x05, 0x8a, 0x18,
     0x69, 0x06, 0xaa, 0xa1, 0x00, 0x8d, 0x9f, 0x05, 0x8a, 0x18,
     0x69, 0x06, 0xaa, 0xa1, 0x00, 0x8d, 0xbf, 0x05, 0x60, 0xa9,
     0xf3, 0x85, 0x20, 0xa9, 0x06, 0x85, 0x21, 0xa9, 0x00, 0x85,
     0x22, 0xa9, 0x02, 0x85, 0x23, 0xa2, 0x00, 0x60, 0xa1, 0x20,
     0xc9, 0xff, 0xf0, 0x1c, 0x81, 0x22, 0xe6, 0x20, 0xa5, 0x20,
     0xc9, 0x00, 0xd0, 0x02, 0xe6, 0x21, 0xe6, 0x22, 0xa5, 0x22,
     0xc9, 0x00, 0xd0, 0x08, 0xa5, 0x23, 0xc9, 0x05, 0xf0, 0x02,
     0xe6, 0x23, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x0b, 0x0b, 0x0c, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
     0x0b, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x0c, 0x0c, 0x0f, 0x0f,
     0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x0b, 0x0c, 0x0c, 0x0f, 0x0c, 0x0f,
     0x0f, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x00, 0x0b, 0x0b, 0x0c,
     0x0f, 0x0f, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x0c, 0x0b, 0x0f, 0x0c,
     0x0f, 0x0f, 0x0c, 0x0c, 0x0b, 0x00, 0x0b, 0x0c, 0x0c, 0x0c,
     0x0f, 0x0f, 0x01, 0x0f, 0x0c, 0x0b, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x0c,
     0x0c, 0x0c, 0x0f, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
     0x0c, 0x0f, 0x0c, 0x0f, 0x0f, 0x0f, 0x0f, 0x0b, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00,
     0x00, 0x0b, 0x0c, 0x0c, 0x0f, 0x0f, 0x0f, 0x0f, 0x0c, 0x0f,
     0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x01, 0x0f, 0x0f, 0x0c,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x0b, 0x0b, 0x0b, 0x0c, 0x0f, 0x0f, 0x01, 0x0f,
     0x0f, 0x0c, 0x0f, 0x0f, 0x0f, 0x01, 0x0f, 0x0f, 0x0f, 0x0f,
     0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x0b, 0x0b, 0x0c, 0x0f,
     0x01, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x01,
     0x0f, 0x0f, 0x0f, 0x0f, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x0b, 0x0c, 0x0b,
     0x0c, 0x0c, 0x01, 0x01, 0x0f, 0x01, 0x0f, 0x01, 0x0f, 0x01,
     0x0f, 0x0f, 0x01, 0x0f, 0x0f, 0x01, 0x0b, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x0b, 0x0c,
     0x0c, 0x0b, 0x0c, 0x0f, 0x01, 0x01, 0x01, 0x0f, 0x0f, 0x01,
     0x0f, 0x0f, 0x01, 0x0f, 0x0f, 0x0f, 0x0f, 0x01, 0x0c, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b,
     0x0c, 0x0c, 0x0c, 0x0b, 0x0c, 0x0c, 0x0f, 0x01, 0x01, 0x01,
     0x0f, 0x0f, 0x01, 0x0f, 0x01, 0x0f, 0x01, 0x0f, 0x0f, 0x01,
     0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b,
     0x0b, 0x0c, 0x0c, 0x0c, 0x0f, 0x0c, 0x0c, 0x0f, 0x0f, 0x01,
     0x01, 0x01, 0x01, 0x0f, 0x0f, 0x0f, 0x01, 0x0f, 0x01, 0x0f,
     0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x0b, 0x0c, 0x0c, 0x0c, 0x0f, 0x0c, 0x0f, 0x0c, 0x0f,
     0x0f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x0f, 0x01, 0x0f,
     0x0f, 0x0f, 0x0f, 0x01, 0x0f, 0x0b, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x0b, 0x0b, 0x0b, 0x0c, 0x0c, 0x0f, 0x0c, 0x0f, 0x0f,
     0x0c, 0x0f, 0x0f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x0f,
     0x0f, 0x01, 0x0f, 0x0f, 0x0f, 0x01, 0x0c, 0x0b, 0x0b, 0x00,
     0x00, 0x00, 0x00, 0x0b, 0x0b, 0x0c, 0x0f, 0x0c, 0x0f, 0x0f,
     0x0f, 0x0f, 0x0f, 0x0c, 0x0f, 0x01, 0x01, 0x01, 0x01, 0x01,
     0x0f, 0x0f, 0x0f, 0x01, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0b,
     0x0b, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0c, 0x0c, 0x0c, 0x0f,
     0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x01, 0x01,
     0x01, 0x0f, 0x0b, 0x0f, 0x0f, 0x0f, 0x01, 0x0f, 0x0f, 0x0f,
     0x0f, 0x0b, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0c, 0x0c,
     0x0f, 0x0c, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
     0x0f, 0x0f, 0x0c, 0x0b, 0x0f, 0x0f, 0x01, 0x0f, 0x0f, 0x0f,
     0x0f, 0x0f, 0x0f, 0x0c, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x0b,
     0x0b, 0x0c, 0x0c, 0x0f, 0x0c, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
     0x0f, 0x0c, 0x0c, 0x0b, 0x0c, 0x0c, 0x0f, 0x0f, 0x01, 0x0c,
     0x0c, 0x0f, 0x0f, 0x0f, 0x0f, 0x0c, 0x0b, 0x00, 0x00, 0x00,
     0x00, 0x0b, 0x0b, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x0f, 0x0f,
     0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x01, 0x0f,
     0x0c, 0x0b, 0x0f, 0x0c, 0x0f, 0x0c, 0x0f, 0x0c, 0x0b, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x0b, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f,
     0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
     0x0c, 0x0b, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x0c, 0x0f, 0x0c,
     0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x0c, 0x0c,
     0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
     0x0c, 0x0b, 0x0b, 0x0c, 0x0c, 0x0c, 0x0f, 0x0c, 0x0f, 0x0f,
     0x0f, 0x0c, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b,
     0x0b, 0x0b, 0x0c, 0x0c, 0x0f, 0x0c, 0x0f, 0x0f, 0x0f, 0x0c,
     0x0c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0b, 0x0b, 0x0c, 0x0c, 0x0f,
     0x0c, 0x0c, 0x0f, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x0b, 0x0b, 0x0c, 0x0b, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
     0x0c, 0x0b, 0x0b, 0x0b, 0x0b, 0x0c, 0x0b, 0x0b, 0x0c, 0x0c,
     0x0f, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0b, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x0b, 0x0c, 0x0c,
     0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0b, 0x0b, 0x0b, 0x0b, 0x0c,
     0x0c, 0x0f, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xff,
     0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x02, 0x05,
     0x05, 0x05, 0x06, 0x06, 0x05, 0x05, 0x06, 0x05, 0x05, 0x04,
     0x05, 0x06, 0x06, 0x06, 0x06, 0x05, 0x02, 0x03, 0x00, 0x0e,
     0x0d, 0x0b, 0x18, 0x1b, 0x03, 0x04, 0x0f, 0x13, 0x07, 0x1b,
     0x0c, 0x00, 0x0a, 0x04, 0x12, 0x1b, 0x08, 0x13, 0x1b, 0x0f,
     0x0e, 0x12, 0x12, 0x08, 0x01, 0x0b, 0x04, 0x1a, 0x1a, 0x1a,
     0x13, 0x07, 0x08, 0x12, 0x1b, 0x08, 0x12, 0x1b, 0x13, 0x07,
     0x04, 0x1b, 0x05, 0x08, 0x11, 0x12, 0x13, 0x1b, 0x03, 0x04,
     0x0c, 0x0e, 0x1b, 0x0c, 0x00, 0x03, 0x04, 0x1b, 0x08, 0x0d,
     0x1b, 0x13, 0x07, 0x08, 0x12, 0x1b, 0x04, 0x0d, 0x15, 0x1a,
     0x1a, 0x1a, 0x1a, 0x1b, 0x07, 0x0e, 0x0f, 0x04, 0x1b, 0x18,
     0x0e, 0x14, 0x1b, 0x0b, 0x08, 0x0a, 0x04, 0x1b, 0x08, 0x13,
     0x1a, 0x1a, 0x1a, 0x1b, 0x1b, 0x16, 0x16, 0x16, 0x1a, 0x03,
     0x04, 0x0f, 0x13, 0x07, 0x1a, 0x0e, 0x11, 0x06, 0x1b, 0x1b,
     0x1b, 0x1b, 0x1b, 0xff, 0x00, 0x00, 0x20, 0x00, 0x40, 0x00,
     0x60, 0x00, 0x80, 0x00, 0xa0, 0x00, 0xc0, 0x00, 0xe0, 0x00,
     0x00, 0x01, 0x20, 0x01, 0x40, 0x01, 0x60, 0x01, 0x80, 0x01,
     0xa0, 0x01, 0xc0, 0x01, 0xe0, 0x01, 0x00, 0x02, 0x20, 0x02,
     0x40, 0x02, 0x60, 0x02, 0x80, 0x02, 0xa0, 0x02, 0xc0, 0x02,
     0xe0, 0x02, 0x00, 0x03, 0x20, 0x03, 0x40, 0x03, 0x60, 0x03,
     0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
     0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
     0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
     0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
     0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
     0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
     0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
     0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
     0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01,
     0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
     0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
     0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
     0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
     0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00,
     0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00,
     0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
     0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
     0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
     0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01,
     0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
     0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
     0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
     0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
     0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00,
     0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x01, 0x00,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
     0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
     0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x09, 0x0b, 0x09,
     0x08, 0x09, 0x08, 0x0a, 0x08, 0x0a, 0x07, 0x0a, 0x07, 0x01,
     0x07, 0x01, 0x01, 0x07, 0x01, 0x07, 0x0a, 0x07, 0x0a, 0x08,
     0x0a, 0x08, 0x09, 0x08, 0x09, 0x0b, 0x09, 0x0b, 0xff};

  Bit8 breakout[219] =
    {0xa9, 0xfe, 0x85, 0x02, 0xa9, 0xee, 0x85, 0x03, 0xa9, 0x00,
     0x85, 0x00, 0xa9, 0x02, 0x85, 0x01, 0xa2, 0x20, 0xa9, 0x02,
     0x9d, 0xff, 0x01, 0x9d, 0xdf, 0x05, 0xa0, 0x00, 0x91, 0x00,
     0xa0, 0x1f, 0x91, 0x00, 0xe0, 0x01, 0xf0, 0x15, 0xa9, 0x03,
     0xa0, 0x17, 0x91, 0x00, 0xa9, 0x04, 0xc8, 0x91, 0x00, 0xa9,
     0x05, 0xc8, 0x91, 0x00, 0xa9, 0x06, 0xc8, 0x91, 0x00, 0x18,
     0xa5, 0x00, 0x69, 0x20, 0x85, 0x00, 0xa5, 0x01, 0x69, 0x00,
     0x85, 0x01, 0xca, 0xd0, 0xc7, 0xa6, 0x02, 0xa4, 0x03, 0xa9,
     0x44, 0x85, 0x00, 0xa9, 0x02, 0x85, 0x01, 0x8a, 0x48, 0xa9,
     0x01, 0xa2, 0x00, 0x81, 0x00, 0x68, 0xaa, 0xca, 0xf0, 0x46,
     0x88, 0xd0, 0xfa, 0x8a, 0x48, 0x20, 0xd5, 0x06, 0xa5, 0x03,
     0x29, 0x01, 0xd0, 0x0d, 0x18, 0xa5, 0x00, 0x69, 0x20, 0x85,
     0x00, 0x90, 0x11, 0xe6, 0x01, 0xd0, 0x0d, 0x38, 0xa5, 0x00,
     0xe9, 0x20, 0x85, 0x00, 0xa5, 0x01, 0xe9, 0x00, 0x85, 0x01,
     0xa2, 0x00, 0xa1, 0x00, 0xd0, 0x07, 0xa4, 0x03, 0x68, 0xaa,
     0x4c, 0x57, 0x06, 0xc9, 0x02, 0xf0, 0x04, 0xa9, 0x00, 0x81,
     0x00, 0xa9, 0x01, 0x45, 0x03, 0x85, 0x03, 0x4c, 0x6c, 0x06,
     0x20, 0xd5, 0x06, 0xa5, 0x02, 0x29, 0x01, 0xd0, 0x04, 0xe6,
     0x00, 0xd0, 0x02, 0xc6, 0x00, 0xa2, 0x00, 0xa1, 0x00, 0xd0,
     0x05, 0xa6, 0x02, 0x4c, 0x57, 0x06, 0xc9, 0x02, 0xf0, 0x04,
     0xa9, 0x00, 0x81, 0x00, 0xa9, 0x01, 0x45, 0x02, 0x85, 0x02,
     0x4c, 0xad, 0x06, 0xa9, 0x00, 0xaa, 0x81, 0x00, 0x60};

  Bit8 sierpinsky[145] =
    {0xa2, 0x00, 0xa0, 0x00, 0xa5, 0xfe, 0x29, 0x03, 0xc9, 0x03,
     0xd0, 0x03, 0x4c, 0x04, 0x06, 0x48, 0x0a, 0x0a, 0x0a, 0x85,
     0xf3, 0x68, 0x29, 0x01, 0x0a, 0x0a, 0x0a, 0x0a, 0x85, 0xf4,
     0x8a, 0x4a, 0x65, 0xf3, 0xaa, 0x98, 0x4a, 0x65, 0xf4, 0xa8,
     0x20, 0x2e, 0x06, 0x4c, 0x04, 0x06, 0x48, 0x8a, 0x48, 0x98,
     0x48, 0x48, 0x48, 0x86, 0xf2, 0xa4, 0xf2, 0xa9, 0x00, 0x85,
     0xf0, 0xa9, 0x02, 0x85, 0xf1, 0xa9, 0x00, 0x68, 0x29, 0x07,
     0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x18, 0x65, 0xf0, 0x85, 0xf0,
     0x90, 0x02, 0xe6, 0xf1, 0x18, 0x68, 0x29, 0x18, 0x4a, 0x4a,
     0x4a, 0x65, 0xf1, 0x85, 0xf1, 0x18, 0x98, 0x65, 0xf0, 0x65,
     0xf1, 0xa9, 0x01, 0x20, 0x72, 0x06, 0x91, 0xf0, 0x68, 0xa8,
     0x68, 0xaa, 0x68, 0x60, 0xb1, 0xf0, 0xc9, 0x00, 0xd0, 0x03,
     0xa9, 0x0b, 0x60, 0xc9, 0x0b, 0xd0, 0x03, 0xa9, 0x0c, 0x60,
     0xc9, 0x0c, 0xd0, 0x03, 0xa9, 0x0f, 0x60, 0xc9, 0x0f, 0xd0,
     0x03, 0xa9, 0x01, 0x60, 0x60};

Bit8 spacer[583] =
  {0x20, 0x62, 0x06, 0x20, 0x90, 0x06, 0x20, 0xe6, 0x06, 0x20,
   0x52, 0x06, 0x4c, 0x03, 0x06, 0xa5, 0x82, 0xa8, 0xb9, 0x07,
   0x07, 0x85, 0x00, 0xc8, 0xb9, 0x07, 0x07, 0x85, 0x01, 0xa2,
   0x2a, 0xa1, 0x00, 0xc9, 0x00, 0xf0, 0x02, 0xc9, 0x05, 0xa9,
   0x05, 0x81, 0x00, 0xa5, 0x60, 0xc5, 0x61, 0xf0, 0x19, 0xa5,
   0x61, 0x0a, 0xa8, 0xb9, 0x07, 0x07, 0x85, 0x00, 0xc8, 0xb9,
   0x07, 0x07, 0x85, 0x01, 0xa9, 0x00, 0xa2, 0x2a, 0x81, 0x00,
   0xa5, 0x60, 0x85, 0x61, 0x60, 0xa5, 0xfe, 0x81, 0x00, 0x4c,
   0x4b, 0x06, 0xa5, 0xff, 0xc9, 0x77, 0xd0, 0x03, 0xc6, 0x60,
   0x60, 0xc9, 0x78, 0xd0, 0x02, 0xe6, 0x60, 0x60, 0xa2, 0x00,
   0xbd, 0x47, 0x07, 0x9d, 0x00, 0x05, 0xe8, 0xe0, 0x00, 0xd0,
   0xf5, 0xa9, 0x0a, 0x85, 0x60, 0x85, 0x61, 0xa2, 0x00, 0xa9,
   0x0c, 0x9d, 0x00, 0x02, 0x9d, 0x00, 0x04, 0xca, 0xe0, 0x00,
   0xd0, 0xf5, 0xa9, 0x10, 0x85, 0x80, 0xa2, 0x0f, 0x95, 0x81,
   0xca, 0x10, 0xfb, 0x60, 0xa9, 0x00, 0x85, 0x78, 0xa9, 0x20,
   0x85, 0x79, 0xa9, 0xc0, 0x85, 0x7a, 0xa9, 0xe0, 0x85, 0x7b,
   0xa2, 0x0f, 0xb5, 0x81, 0x95, 0x82, 0xa8, 0xb9, 0x07, 0x07,
   0x85, 0x00, 0xc8, 0xb9, 0x07, 0x07, 0x85, 0x01, 0xa9, 0x0c,
   0xa4, 0x78, 0x91, 0x00, 0xc8, 0x91, 0x00, 0xa4, 0x7b, 0x91,
   0x00, 0xc8, 0x91, 0x00, 0xa4, 0x79, 0xa9, 0x00, 0x91, 0x00,
   0xc8, 0x91, 0x00, 0xa4, 0x7a, 0x91, 0x00, 0xc8, 0x91, 0x00,
   0xe6, 0x78, 0xe6, 0x79, 0xe6, 0x7a, 0xe6, 0x7b, 0xe6, 0x78,
   0xe6, 0x79, 0xe6, 0x7a, 0xe6, 0x7b, 0xca, 0x10, 0xbd, 0x60,
   0xa5, 0x80, 0xc5, 0x81, 0xf0, 0x09, 0xa5, 0x80, 0x18, 0xe5,
   0x81, 0x10, 0x0f, 0x30, 0x08, 0xa5, 0xfe, 0x29, 0x0f, 0x0a,
   0x85, 0x80, 0x60, 0xc6, 0x81, 0xc6, 0x81, 0x60, 0xe6, 0x81,
   0xe6, 0x81, 0x60, 0x00, 0x02, 0x20, 0x02, 0x40, 0x02, 0x60,
   0x02, 0x80, 0x02, 0xa0, 0x02, 0xc0, 0x02, 0xe0, 0x02, 0x00,
   0x03, 0x20, 0x03, 0x40, 0x03, 0x60, 0x03, 0x80, 0x03, 0xa0,
   0x03, 0xc0, 0x03, 0xe0, 0x03, 0x00, 0x04, 0x20, 0x04, 0x40,
   0x04, 0x60, 0x04, 0x80, 0x04, 0xa0, 0x04, 0xc0, 0x04, 0xe0,
   0x04, 0x00, 0x05, 0x20, 0x05, 0x40, 0x05, 0x60, 0x05, 0x80,
   0x05, 0xa0, 0x05, 0xc0, 0x05, 0xe0, 0x05, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x00, 0x00,
   0x06, 0x01, 0x01, 0x06, 0x00, 0x00, 0x01, 0x01, 0x01, 0x06,
   0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x01, 0x01, 0x06, 0x00,
   0x00, 0x06, 0x01, 0x06, 0x00, 0x06, 0x00, 0x01, 0x00, 0x06,
   0x01, 0x06, 0x01, 0x06, 0x00, 0x01, 0x00, 0x01, 0x00, 0x06,
   0x00, 0x06, 0x01, 0x06, 0x00, 0x06, 0x00, 0x01, 0x00, 0x06,
   0x01, 0x06, 0x00, 0x00, 0x06, 0x01, 0x01, 0x06, 0x06, 0x01,
   0x01, 0x01, 0x00, 0x06, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01,
   0x06, 0x00, 0x06, 0x06, 0x01, 0x01, 0x01, 0x00, 0x06, 0x01,
   0x00, 0x06, 0x01, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01,
   0x06, 0x01, 0x01, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01, 0x01,
   0x06, 0x01, 0x06, 0x06, 0x06, 0x06, 0x01, 0x06, 0x06, 0x06,
   0x06, 0x01, 0x01, 0x01, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01,
   0x01, 0x01, 0x0e, 0x01, 0x01, 0x0e, 0x06, 0x06, 0x01, 0x01,
   0x06, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01, 0x01,
   0x01, 0x01, 0x06, 0x01, 0x01, 0x06, 0x01, 0x06, 0x06, 0x06,
   0x01, 0x01, 0x01, 0x06, 0x0e, 0x01, 0x01, 0x06, 0x0e, 0x06,
   0x01, 0x01, 0x0e, 0x01, 0x0e, 0x06, 0x01, 0x01, 0x01, 0x06,
   0x0e, 0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x06, 0x01, 0x06,
   0x0e, 0x0e, 0x0e, 0x06, 0x0e, 0x0e, 0x06, 0x0e, 0x0e, 0x06,
   0x0e, 0x0e, 0x06, 0x0e, 0x0e, 0x06, 0x0e, 0x0e, 0x06, 0x0e,
   0x0e, 0x06, 0x0e, 0x0e, 0x06, 0x0e, 0x0e, 0x06, 0x0e, 0x0e,
   0x06, 0x0e, 0x0e};

 Bit8 pong[398] =
  {0x20, 0x27, 0x06, 0x20, 0x18, 0x06, 0x20, 0x29, 0x07, 0x20,
   0x5c, 0x06, 0x20, 0xf6, 0x06, 0xa5, 0x10, 0xc9, 0x1f, 0xd0,
   0xf4, 0x4c, 0x15, 0x06, 0xa9, 0x0b, 0x85, 0x10, 0xa9, 0x05,
   0x85, 0x11, 0xa9, 0xff, 0x85, 0x12, 0x85, 0x13, 0x60, 0xa9,
   0x00, 0x85, 0x00, 0xa9, 0x02, 0x85, 0x01, 0xa2, 0x00, 0xa0,
   0x1f, 0x98, 0xaa, 0xa9, 0x0e, 0x9d, 0x00, 0x02, 0x9d, 0x20,
   0x02, 0xa2, 0x00, 0x81, 0x00, 0xe8, 0x81, 0x00, 0xa2, 0x1e,
   0x81, 0x00, 0xe8, 0x81, 0x00, 0xa5, 0x00, 0xc9, 0xe0, 0xd0,
   0x02, 0xe6, 0x01, 0x18, 0x69, 0x20, 0x85, 0x00, 0x88, 0xd0,
   0xd8, 0x60, 0xa5, 0x10, 0x85, 0x15, 0xa5, 0x11, 0x85, 0x16,
   0xa5, 0x10, 0x18, 0x65, 0x12, 0x85, 0x10, 0x20, 0xdf, 0x06,
   0xc9, 0x00, 0xf0, 0x15, 0xa5, 0x12, 0xc9, 0x01, 0xd0, 0x09,
   0xa9, 0xff, 0x85, 0x12, 0xc6, 0x10, 0x4c, 0x87, 0x06, 0xa9,
   0x01, 0x85, 0x12, 0xe6, 0x10, 0xa5, 0x11, 0x18, 0x65, 0x13,
   0x85, 0x11, 0x20, 0xdf, 0x06, 0xc9, 0x00, 0xf0, 0x15, 0xa5,
   0x13, 0xc9, 0x01, 0xd0, 0x09, 0xa9, 0xff, 0x85, 0x13, 0xc6,
   0x11, 0x4c, 0xaa, 0x06, 0xa9, 0x01, 0x85, 0x13, 0xe6, 0x11,
   0xa5, 0x10, 0x29, 0x1f, 0x0a, 0xaa, 0xbd, 0x4e, 0x07, 0x85,
   0x00, 0xe8, 0xbd, 0x4e, 0x07, 0x85, 0x01, 0xa5, 0x11, 0x29,
   0x1f, 0xaa, 0xa9, 0x0d, 0x81, 0x00, 0xa5, 0x15, 0x29, 0x1f,
   0x0a, 0xaa, 0xbd, 0x4e, 0x07, 0x85, 0x00, 0xe8, 0xbd, 0x4e,
   0x07, 0x85, 0x01, 0xa5, 0x16, 0x29, 0x1f, 0xaa, 0xa9, 0x00,
   0x81, 0x00, 0x60, 0xa5, 0x10, 0x0a, 0xaa, 0xbd, 0x4e, 0x07,
   0x85, 0x00, 0xe8, 0xbd, 0x4e, 0x07, 0x85, 0x01, 0xa5, 0x11,
   0x29, 0x1f, 0xaa, 0xa1, 0x00, 0x60, 0xa5, 0xff, 0xc9, 0x61,
   0xd0, 0x08, 0xa5, 0x20, 0xc9, 0x00, 0xf0, 0x0e, 0xc6, 0x20,
   0xc9, 0x64, 0xd0, 0x08, 0xa5, 0x20, 0xc9, 0x19, 0xf0, 0x02,
   0xe6, 0x20, 0xa6, 0x20, 0xa9, 0x00, 0x9d, 0xe0, 0x05, 0xe8,
   0xa0, 0x1e, 0xa9, 0x0f, 0x9d, 0xe0, 0x05, 0xe8, 0x88, 0xd0,
   0xf7, 0xa9, 0x00, 0x9d, 0xe0, 0x05, 0x60, 0xa9, 0x00, 0x85,
   0x05, 0xa9, 0x02, 0x85, 0x06, 0xe6, 0x06, 0xa5, 0xfe, 0x29,
   0x0f, 0x18, 0x69, 0x05, 0xaa, 0xa5, 0x06, 0x0a, 0xa8, 0xa9,
   0x0c, 0x81, 0x05, 0xe8, 0x88, 0xd0, 0xfa, 0xa5, 0x06, 0xc9,
   0x05, 0xd0, 0xe4, 0x60, 0x00, 0x02, 0x20, 0x02, 0x40, 0x02,
   0x60, 0x02, 0x80, 0x02, 0xa0, 0x02, 0xc0, 0x02, 0xe0, 0x02,
   0x00, 0x03, 0x20, 0x03, 0x40, 0x03, 0x60, 0x03, 0x80, 0x03,
   0xa0, 0x03, 0xc0, 0x03, 0xe0, 0x03, 0x00, 0x04, 0x20, 0x04,
   0x40, 0x04, 0x60, 0x04, 0x80, 0x04, 0xa0, 0x04, 0xc0, 0x04,
   0xe0, 0x04, 0x00, 0x05, 0x20, 0x05, 0x40, 0x05, 0x60, 0x05,
   0x80, 0x05, 0xa0, 0x05, 0xc0, 0x05, 0xe0, 0x05};

  switch(r){
  case 0: 
    start_eval_binary(machine,noise,30,plot6502,st);
    break;
  case 1:
    start_eval_binary(machine,atari,629,plot6502,st);
    break;
  case 2:
    start_eval_binary(machine,c64,1076,plot6502,st);
    break;
  case 3:
    start_eval_binary(machine,random,22,plot6502,st);
    break;
  case 4:
    start_eval_binary(machine,demoscene,2109,plot6502,st);
    break;
  case 5:
    start_eval_binary(machine,breakout,219,plot6502,st);
    break;
  case 6:
    start_eval_binary(machine,sierpinsky,145,plot6502,st);
    break;
  case 7:
    start_eval_binary(machine,spacer,583,plot6502,st);
    break;
  case 8:
   start_eval_binary(machine,pong,398,plot6502,st);
   break;
  } 
}

/*
 * get_time ()
 *
 * returns the total time elapsed since the beginning of the demo
 */
static double get_time(struct state *st) {
  struct timeval t;
  float f;
#if GETTIMEOFDAY_TWO_ARGS
  gettimeofday(&t, NULL);
#else
  gettimeofday(&t);
#endif
  t.tv_sec -= st->start_time.tv_sec;
  f = ((double)t.tv_sec) + t.tv_usec*1e-6;
  return f;
}

/*
 * init_time ()
 *
 * initialises the timing structures
 */
static void init_time(struct state *st) {
#if GETTIMEOFDAY_TWO_ARGS
  gettimeofday(&st->start_time, NULL);
#else
  gettimeofday(&st->start_time);
#endif
}

static void *
m6502_init (Display *dpy, Window window)
{
  struct state *st = (struct state *) calloc (1, sizeof(*st));
  unsigned int x, y;
  char *s = get_string_resource (dpy, "file", "File");
  int n = get_integer_resource(dpy, "displaytime", "Displaytime");
  int dh;
  st->pc = 0;
  st->dt = n;
  st->dpy = dpy;
  st->window = window;
  st->tv=analogtv_allocate(st->dpy, st->window);
  analogtv_set_defaults(st->tv, "");
  
  st->machine = build6502();
  st->inp=analogtv_input_allocate();
  analogtv_setup_sync(st->inp, 1, 0);
  
  st->reception.input = st->inp;
  st->reception.level = 2.0;
  st->reception.ofs=0;
  
  st->reception.multipath=0.0;
  st->pixw = SCREEN_W / 32;
  st->pixh = SCREEN_H / 32;
  dh = SCREEN_H % 32;
  st->topb = dh / 2;

  init_time(st);
  
  if (strlen(s) > 0)
    start_eval_file(st->machine,s, plot6502, st);
  else
    start_rand_bin_prog(st->machine,st);

  analogtv_lcp_to_ntsc(ANALOGTV_BLACK_LEVEL, 0.0, 0.0, st->field_ntsc);

  analogtv_draw_solid(st->inp,
                      ANALOGTV_VIS_START, ANALOGTV_VIS_END,
                      ANALOGTV_TOP, ANALOGTV_BOT,
                      st->field_ntsc);

  for(x = 0; x < 32; x++)
    for(y = 0; y < 32; y++)
      st->pixels[x][y] = 0;

  return st;
}

static void
paint_pixel(struct state *st, int x, int y, int idx)
{
  double clr_tbl[16][3] = {
    {  0,   0,   0},
    {255, 255, 255},
    {136,   0,   0},
    {170, 255, 238},
    {204,  68, 204},
    {  0, 204,  85},
    {  0,   0, 170},
    {238, 238, 119},
    {221, 136,  85},
    {102,  68,   0},
    {255, 119, 119},
    { 51,  51,  51},
    {119, 119, 119},
    {170, 255, 102},
    {  0, 136, 255},
    {187, 187, 187}
  };
  int ntsc[4], i;
  int rawy,rawi,rawq;
  /* RGB conversion taken from analogtv draw xpm */
  rawy=( 5*clr_tbl[idx][0] + 11*clr_tbl[idx][1] + 2*clr_tbl[idx][2]) / 64;
  rawi=(10*clr_tbl[idx][0] -  4*clr_tbl[idx][1] - 5*clr_tbl[idx][2]) / 64;
  rawq=( 3*clr_tbl[idx][0] -  8*clr_tbl[idx][1] + 5*clr_tbl[idx][2]) / 64;

  ntsc[0]=rawy+rawq;
  ntsc[1]=rawy-rawi;
  ntsc[2]=rawy-rawq;
  ntsc[3]=rawy+rawi;

  for (i=0; i<4; i++) {
    if (ntsc[i]>ANALOGTV_WHITE_LEVEL) ntsc[i]=ANALOGTV_WHITE_LEVEL;
    if (ntsc[i]<ANALOGTV_BLACK_LEVEL) ntsc[i]=ANALOGTV_BLACK_LEVEL;
  }

      
  x *= st->pixw;
  y *= st->pixh;
  y += st->topb;
  analogtv_draw_solid(st->inp,
		      ANALOGTV_VIS_START + x, ANALOGTV_VIS_START + x + st->pixw,
		      ANALOGTV_TOP + y, ANALOGTV_TOP + y + st->pixh, ntsc);			      
}

static unsigned long
m6502_draw (Display *dpy, Window window, void *closure)
{
  struct state *st = (struct state *) closure;
  unsigned int x = 0, y = 0;
  double te;

  next_eval(st->machine,500);

  for (x = 0; x < 32; x++)
    for (y = 0; y < 32; y++)
      paint_pixel(st,x,y,st->pixels[x][y]);
  
  analogtv_init_signal(st->tv, 0.04);
  analogtv_reception_update(&st->reception);
  analogtv_add_signal(st->tv, &st->reception);
  analogtv_draw(st->tv);
  te = get_time(st);
  
  if (te > st->dt){ /* do something more interesting here XXX */
    for(x = 0; x < 32; x++)
      for(y = 0; y < 32; y++)
	st->pixels[x][y] = 0;
    init_time(st);
    start_rand_bin_prog(st->machine,st);
  }

  return 10000;
}




static const char *m6502_defaults [] = {
  ".background:      black",
  ".foreground:      white",
  "*file:",
  "*displaytime:     20",
  ANALOGTV_DEFAULTS
  "*TVContrast:      150",
  0
};

static XrmOptionDescRec m6502_options [] = {
  { "-file",           ".file",     XrmoptionSepArg, 0 },
  { "-displaytime",    ".displaytime", XrmoptionSepArg, 0},
  ANALOGTV_OPTIONS
  { 0, 0, 0, 0 }
};

static void
m6502_reshape (Display *dpy, Window window, void *closure, 
                 unsigned int w, unsigned int h)
{
  struct state *st = (struct state *) closure;
  analogtv_reconfigure (st->tv);
}

static Bool
m6502_event (Display *dpy, Window window, void *closure, XEvent *event)
{
  return False;
}

static void
m6502_free (Display *dpy, Window window, void *closure)
{
  struct state *st = (struct state *) closure;
  analogtv_release(st->tv);
  free (st);
}

XSCREENSAVER_MODULE ("m6502", m6502)
