/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include <libgnomeui/libgnomeui.h>

#include "maximus-app.h"

static gboolean on_sess_save (GnomeClient        *client,
                              gint                arg1, 
                              GnomeSaveStyle      arg2,
                              gboolean            arg3,
                              GnomeInteractStyle  arg4,
                              gboolean            arg5);

gint
main (gint argc, gchar *argv[])
{
  MaximusApp *app;
  GnomeClient *client;
  gchar *exec[] = {"maximus"};

  g_thread_init (NULL);
  g_set_application_name ("Maximus");
  
  gtk_init (&argc, &argv);

  gnome_program_init ("maximus", "0.3", LIBGNOMEUI_MODULE, argc, argv,
                      GNOME_PARAM_NONE);

  client = gnome_master_client ();
  gnome_client_set_restart_command (client, 1, exec);
  gnome_client_set_restart_style (client, GNOME_RESTART_IMMEDIATELY);

  g_signal_connect (client, "save-yourself", G_CALLBACK (on_sess_save), NULL);

  app = maximus_app_get_default ();

  gtk_main ();

  return EXIT_SUCCESS;
}

static gboolean on_sess_save (GnomeClient        *client,
                              gint                arg1, 
                              GnomeSaveStyle      arg2,
                              gboolean            arg3,
                              GnomeInteractStyle  arg4,
                              gboolean            arg5)
{
  return TRUE;
}
