/***************************************************************************
 *Copyright (C) 2008 Inventec Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 **************************************************************************/
#ifndef EVENT_INCLUDED
#define EVENT_INCLUDED

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/module.h>

#include <linux/moduleparam.h> //接收參數
#include <linux/types.h> //裝置編號型別定義
#include <linux/kdev_t.h> //裝置編號處理函數，如MKDEV, MAJOR , MINOR
#include <linux/fs.h> //註冊裝置編號函數
#include <linux/cdev.h> //註冊字元裝置
#include <asm/io.h> //inb, outb
#include <linux/jiffies.h>


#include <linux/slab.h>
#include <linux/consolemap.h>
#include <linux/kbd_kern.h>
#include <linux/kbd_diacr.h>
#include <linux/vt_kern.h>
#include <linux/blkdev.h>




#define fnESC   1
#define fnTilde   41
#define fnF1    59
#define fnF2    60
#define fnF3    61
#define fnF5    63
#define fnF6    64
#define fnF8    66
#define fnF9    67
#define fnF10    68
#define fn1    2
#define fn2    3
#define fnA    30
#define fnS    31

extern unsigned long j1;

int event_open(struct inode *node, struct file *filp);
int event_release(struct inode *node, struct file *filp);
ssize_t event_read (struct file *filp, char __user *buff, size_t count, loff_t *fpos);
ssize_t event_write (struct file *filp, const char __user *buff, size_t count, loff_t *fpos);
void osd_set_key_status(void);
int osd_get_key_status(void);
#endif
