/***************************************************************************
 *Copyright (C) 2008 Inventec Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 **************************************************************************/
#ifndef INIT_INCLUDED
#include "init.h"
#endif

MODULE_DESCRIPTION("Toshiba OSD Driver");
MODULE_AUTHOR("Thomas Wu(thomas.wu@inventec.com)");
MODULE_LICENSE("GPL");
MODULE_VERSION("1.03.19");
module_param(event_major, int, S_IRUGO);

static int osdd_init_module(void)
{
	
	int result;
	result=alloc_chrdev_region(&event_num, event_minor, 1, "event");
	event_major=MAJOR(event_num);
	if (result<0){
		printk(KERN_WARNING "Can't get Event number\n");
		return result;
	}

	result=alloc_chrdev_region(&key_num, event_minor, 1, "key");
	key_major=MAJOR(key_num);
	if (result<0){
		printk(KERN_WARNING "Can't get key number\n");
		return result;
	}

	result=alloc_chrdev_region(&fan_num, fan_minor, 1, "fan");
	fan_major=MAJOR(fan_num);
	if (result<0){
		printk(KERN_WARNING "Can't get Fan number\n");
		return result;
	}

	result=alloc_chrdev_region(&wireless_num, fan_minor, 1, "wireless");
	wireless_major=MAJOR(wireless_num);
	if (result<0){
		printk(KERN_WARNING "Can't get Wireless number\n");
		return result;
	}

	result=alloc_chrdev_region(&mute_num, mute_minor, 1, "mute");
	mute_major=MAJOR(mute_num);
	if (result<0){
		printk(KERN_WARNING "Can't get Mute number\n");
		return result;
	}

	result=alloc_chrdev_region(&hibernate_num, hibernate_minor, 1, "hibernate");
	hibernate_major=MAJOR(hibernate_num);
	if (result<0){
		printk(KERN_WARNING "Can't get Hibernate number\n");
		return result;
	}

	result=alloc_chrdev_region(&threeg_num, threeg_minor, 1, "threeg");
	threeg_major=MAJOR(threeg_num);
	if (result<0){
		printk(KERN_WARNING "Can't get 3G number\n");
		return result;
	}

	event_dev=cdev_alloc();
	event_dev->ops=&event_fops;
	cdev_add(event_dev, event_num, 1);

	key_dev=cdev_alloc();
	key_dev->ops=&key_fops;
	cdev_add(key_dev, key_num, 1);

	fan_dev=cdev_alloc();
	fan_dev->ops=&fan_fops;
	cdev_add(fan_dev, fan_num, 1);

	wireless_dev=cdev_alloc();
	wireless_dev->ops=&wireless_fops;
	cdev_add(wireless_dev, wireless_num, 1);

	mute_dev=cdev_alloc();
	mute_dev->ops=&mute_fops;
	cdev_add(mute_dev, mute_num, 1);

	hibernate_dev=cdev_alloc();
	hibernate_dev->ops=&hibernate_fops;
	cdev_add(hibernate_dev, hibernate_num, 1);

	threeg_dev=cdev_alloc();
	threeg_dev->ops=&threeg_fops;
	cdev_add(threeg_dev, threeg_num, 1);
	return 0;
}

static void osdd_exit_module(void)
{
	unregister_chrdev_region(event_num, 1);
	unregister_chrdev_region(key_num, 1);
	unregister_chrdev_region(fan_num, 1);
	unregister_chrdev_region(wireless_num, 1);
	unregister_chrdev_region(mute_num, 1);
	unregister_chrdev_region(hibernate_num, 1);
	unregister_chrdev_region(threeg_num, 1);
	cdev_del(event_dev);
	cdev_del(key_dev);
	cdev_del(fan_dev);
	cdev_del(wireless_dev);
	cdev_del(mute_dev);
	cdev_del(hibernate_dev);
	cdev_del(threeg_dev);
}

module_init(osdd_init_module);
module_exit(osdd_exit_module);
