/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */


#ifndef __CLUTTER_FOCUS_GROUP_H__
#define __CLUTTER_FOCUS_GROUP_H__

#include <clutter/clutter-actor.h>

G_BEGIN_DECLS

#define CLUTTER_TYPE_FOCUS_GROUP                  (clutter_focus_group_get_type ())
#define CLUTTER_FOCUS_GROUP(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLUTTER_TYPE_FOCUS_GROUP, ClutterFocusGroup))
#define CLUTTER_IS_FOCUS_GROUP(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLUTTER_TYPE_FOCUS_GROUP))
#define CLUTTER_FOCUS_GROUP_GET_IFACE(obj)        (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLUTTER_TYPE_FOCUS_GROUP, ClutterFocusGroupIface))

typedef struct _ClutterFocusGroup        ClutterFocusGroup;
typedef struct _ClutterFocusGroupIface   ClutterFocusGroupIface;

struct _ClutterFocusGroupIface
{
  /*< private >*/
  GTypeInterface g_iface;

  /*< public >*/
  gboolean (* direction_event) (ClutterFocusGroup     *focus_group,
                                ClutterFocusDirection  direction);
  gboolean (* key_event)       (ClutterFocusGroup     *focus_group,
                                const gchar           *string);
  gboolean (* action_event)    (ClutterFocusGroup     *focus_group);

  /* signals */
};

enum _ClutterFocusDirection
{
  CLUTTER_DIRECTION_NEXT,     /* Tab */
  CLUTTER_DIRECTION_PREV,     /* Shift+tab */
  CLUTTER_DIRECTION_UP,      /* <Arrows> */ 
  CLUTTER_DIRECTION_RIGHT,
  CLUTTER_DIRECTION_DOWN,
  CLUTTER_DIRECTION_LEFT,    /* </Arrows> */
  CLUTTER_DIRECTION_PAGE_UP,
  CLUTTER_DIRECTION_PAGE_DOWN
};

GType    clutter_focus_group_get_type        (void) G_GNUC_CONST;

gboolean clutter_focus_group_direction_event (ClutterFocusGroup     *group,
                                              ClutterFocusDirection  dir);

gboolean clutter_focus_group_key_event       (ClutterFocusGroup     *group,
                                              const gchar           *string);

gboolean clutter_focus_group_action_event    (ClutterFocusGroup     *group);


G_END_DECLS

#endif /* __CLUTTER_FOCUS_GROUP_H__ */
