/* Generated from posixunix.scm by the Chicken compiler
   2006-10-12 08:27
   Version 2.5rc1 - linux-unix-gnu-x86 - [ libffi dload ptables applyhook ]
   command line: posixunix.scm -output-file uposixunix.c -quiet -no-trace -optimize-level 2 -include-path . -no-lambda-info -unsafe -feature unsafe -explicit-use
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#ifdef ECOS
#include <cyg/posix/signal.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else 
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
#ifndef ECOS
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
struct C_fake_group {
  int gr_gid;
  int gr_mem[ 1 ];
  char *gr_name;
  char *gr_passwd;
};
static C_TLS struct C_fake_group *C_group;
#endif
static C_TLS int C_pipefds[ 2 ];
#endif
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)   	(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name),	C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#ifndef ECOS
#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#ifdef HAVE_GRP_H
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#endif
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#define C_islink            ((C_statbuf.st_mode & S_IFMT) == S_IFLNK)
#define C_isreg             ((C_statbuf.st_mode & S_IFMT) == S_IFREG)

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_exec_args() {
  char **a = C_exec_args;
  while((*a) != NULL) C_free(*(a++));
}

static void C_fcall C_free_exec_env() {
  char **a = C_exec_env;
  while((*a) != NULL) C_free(*(a++));
}

#define C_set_exec_arg(i, a, len)      C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)      C_set_arg_string(C_exec_env, i, a, len)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigprocmask(d)    C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)    FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd) FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd) FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_timeval.tv_sec = C_unfix(t), C_timeval.tv_usec = 0, C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__CYGWIN__) || defined(__SVR4)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

time_t timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#endif

#if !defined(C_GNU_ENV) || defined(__CYGWIN__) || defined(__uClinux__)
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
# define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = mktime(&C_tm)) != -1)
# define C_timegm(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = timegm(&C_tm)) != -1)
#else
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), asctime(&C_tm) )
# define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), (C_temporary_flonum = mktime(&C_tm)) != -1)
# define C_timegm(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), (C_temporary_flonum = timegm(&C_tm)) != -1)
#endif

#ifndef ECOS
static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))
#endif

static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[361];


/* from k4715 in set-root-directory! in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub925(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub925(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from select */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub776(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub776(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_return:
#undef return

return C_r;}

/* from sleep in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub746(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub746(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub743(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub743(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub741(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub741(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub682(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub682(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k3849 */
static C_word C_fcall stub675(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub675(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub670(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub670(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k3841 */
static C_word C_fcall stub663(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub663(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from f_3826 in k3820 in process-fork in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub651(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub651(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub646(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub646(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub609(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub609(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);
              else return(C_hostbuf);
C_return:
#undef return

return C_r;}

/* from ttyname */
static C_word C_fcall stub602(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub602(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from set-alarm! in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub588(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub588(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from ex0 */
static C_word C_fcall stub582(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub582(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub577(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub577(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__)
time_t clock = (time_t)0;struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
return(z);
C_return:
#undef return

return C_r;}

/* from asctime */
static C_word C_fcall stub562(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub562(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from ctime */
static C_word C_fcall stub553(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub553(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k3383 */
static C_word C_fcall stub526(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub526(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k3325 */
static C_word C_fcall stub501(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub501(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from get */
static C_word C_fcall stub479(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub479(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k2807 in k2803 in file-link in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub377(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub377(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from current-effective-group-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub339(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub339(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from current-effective-user-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub337(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub337(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from current-group-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub335(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub335(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from current-user-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub333(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub333(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from k2529 in initialize-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub311(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub311(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from _ensure-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub285(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub285(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_return:
#undef return

return C_r;}

/* from _get-groups */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub281(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub281(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_return:
#undef return

return C_r;}

/* from group-member */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub270(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub270(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_return:
#undef return

return C_r;}

/* from fd_test in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub62(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub62(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from fd_set in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub56(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub56(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from fd_zero in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall stub51(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub51(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from strerror */
static C_word C_fcall stub7(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub7(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

/* from make-nonblocking in k1094 in k1091 in k1088 in k1085 in k1082 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub1(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_return:
#undef return

return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1084)
static void C_ccall f_1084(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1087)
static void C_ccall f_1087(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1090)
static void C_ccall f_1090(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1093)
static void C_ccall f_1093(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1096)
static void C_ccall f_1096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2218)
static void C_ccall f_2218(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4741)
static void C_ccall f_4741(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2267)
static void C_ccall f_2267(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2776)
static void C_ccall f_2776(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4721)
static void C_ccall f_4721(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4717)
static void C_ccall f_4717(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4492)
static void C_ccall f_4492(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4492)
static void C_ccall f_4492r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4646)
static void C_fcall f_4646(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4652)
static void C_ccall f_4652(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4641)
static void C_fcall f_4641(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4636)
static void C_fcall f_4636(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4494)
static void C_fcall f_4494(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4623)
static void C_ccall f_4623(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4631)
static void C_ccall f_4631(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4498)
static void C_fcall f_4498(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4611)
static void C_ccall f_4611(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4508)
static void C_ccall f_4508(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4510)
static void C_fcall f_4510(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4529)
static void C_ccall f_4529(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4597)
static void C_ccall f_4597(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4604)
static void C_ccall f_4604(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4591)
static void C_ccall f_4591(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4544)
static void C_ccall f_4544(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4578)
static void C_ccall f_4578(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4564)
static void C_ccall f_4564(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4576)
static void C_ccall f_4576(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4572)
static void C_ccall f_4572(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4556)
static void C_ccall f_4556(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4554)
static void C_ccall f_4554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4615)
static void C_ccall f_4615(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4184)
static void C_ccall f_4184(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4184)
static void C_ccall f_4184r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4447)
static void C_fcall f_4447(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4442)
static void C_fcall f_4442(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4186)
static void C_fcall f_4186(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4198)
static void C_ccall f_4198(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4210)
static void C_ccall f_4210(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4391)
static void C_ccall f_4391(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4395)
static void C_ccall f_4395(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4398)
static void C_ccall f_4398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4438)
static void C_ccall f_4438(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4401)
static void C_ccall f_4401(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4429)
static void C_ccall f_4429(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4404)
static void C_ccall f_4404(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4413)
static void C_ccall f_4413(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4214)
static void C_ccall f_4214(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4217)
static void C_ccall f_4217(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4220)
static void C_ccall f_4220(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4233)
static void C_ccall f_4233(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4378)
static void C_ccall f_4378(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4382)
static void C_ccall f_4382(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4362)
static void C_ccall f_4362(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4346)
static void C_ccall f_4346(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4350)
static void C_ccall f_4350(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4277)
static void C_ccall f_4277(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4333)
static void C_ccall f_4333(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4337)
static void C_ccall f_4337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4283)
static void C_ccall f_4283(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4292)
static void C_fcall f_4292(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4324)
static void C_ccall f_4324(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4308)
static void C_ccall f_4308(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4281)
static void C_ccall f_4281(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4235)
static void C_fcall f_4235(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4249)
static void C_fcall f_4249(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4265)
static void C_ccall f_4265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4268)
static void C_ccall f_4268(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4245)
static void C_ccall f_4245(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4204)
static void C_ccall f_4204(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4192)
static void C_ccall f_4192(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4164)
static void C_fcall f_4164(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4176)
static void C_ccall f_4176(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4170)
static void C_ccall f_4170(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4118)
static void C_ccall f_4118(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4118)
static void C_ccall f_4118r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4125)
static void C_ccall f_4125(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4140)
static void C_ccall f_4140(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4097)
static void C_ccall f_4097(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4097)
static void C_ccall f_4097r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4094)
static void C_ccall f_4094(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4091)
static void C_ccall f_4091(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4088)
static void C_ccall f_4088(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4018)
static void C_ccall f_4018(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4018)
static void C_ccall f_4018r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3854)
static void C_ccall f_3854(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3854)
static void C_ccall f_3854r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3973)
static void C_fcall f_3973(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3968)
static void C_fcall f_3968(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3856)
static void C_fcall f_3856(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3860)
static void C_ccall f_3860(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3868)
static void C_fcall f_3868(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3911)
static C_word C_fcall f_3911(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_3881)
static void C_fcall f_3881(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3906)
static void C_ccall f_3906(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3884)
static void C_ccall f_3884(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3846)
static C_word C_fcall f_3846(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_3838)
static C_word C_fcall f_3838(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_3800)
static void C_ccall f_3800(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3800)
static void C_ccall f_3800r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3822)
static void C_ccall f_3822(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3826)
static void C_ccall f_3826(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3694)
static void C_ccall f_3694(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3694)
static void C_ccall f_3694r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3700)
static void C_fcall f_3700(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3721)
static void C_ccall f_3721(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3792)
static void C_ccall f_3792(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3725)
static void C_ccall f_3725(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3732)
static void C_ccall f_3732(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3734)
static void C_fcall f_3734(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3751)
static void C_ccall f_3751(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3761)
static void C_ccall f_3761(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3765)
static void C_ccall f_3765(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3715)
static void C_ccall f_3715(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3682)
static void C_ccall f_3682(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3686)
static void C_ccall f_3686(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3689)
static void C_ccall f_3689(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3655)
static void C_ccall f_3655(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3659)
static void C_ccall f_3659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3634)
static void C_ccall f_3634(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3638)
static void C_ccall f_3638(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3581)
static void C_ccall f_3581(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3581)
static void C_ccall f_3581r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3588)
static void C_ccall f_3588(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3578)
static void C_ccall f_3578(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3559)
static void C_ccall f_3559(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3559)
static void C_ccall f_3559r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3563)
static void C_ccall f_3563(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3551)
static void C_ccall f_3551(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3523)
static void C_ccall f_3523(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3530)
static void C_ccall f_3530(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3495)
static void C_ccall f_3495(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3502)
static void C_ccall f_3502(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3467)
static void C_ccall f_3467(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3474)
static void C_ccall f_3474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3477)
static void C_ccall f_3477(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3480)
static void C_ccall f_3480(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3450)
static void C_ccall f_3450(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3454)
static void C_ccall f_3454(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3457)
static void C_ccall f_3457(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3439)
static void C_ccall f_3439(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3433)
static void C_ccall f_3433(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3427)
static void C_ccall f_3427(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3421)
static void C_ccall f_3421(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3389)
static void C_ccall f_3389(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3389)
static void C_ccall f_3389r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3331)
static void C_ccall f_3331(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_3331)
static void C_ccall f_3331r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_3335)
static void C_ccall f_3335(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3341)
static void C_ccall f_3341(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3360)
static void C_ccall f_3360(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3347)
static void C_ccall f_3347(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3248)
static void C_ccall f_3248(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3254)
static void C_fcall f_3254(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3258)
static void C_ccall f_3258(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3266)
static void C_fcall f_3266(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3292)
static void C_ccall f_3292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3296)
static void C_ccall f_3296(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3284)
static void C_ccall f_3284(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3236)
static void C_ccall f_3236(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3241)
static void C_ccall f_3241(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3225)
static void C_ccall f_3225(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3230)
static void C_ccall f_3230(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3234)
static void C_ccall f_3234(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3202)
static void C_ccall f_3202(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3223)
static void C_ccall f_3223(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3206)
static void C_ccall f_3206(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3165)
static void C_ccall f_3165(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3165)
static void C_ccall f_3165r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3169)
static void C_fcall f_3169(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3187)
static void C_ccall f_3187(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3183)
static void C_ccall f_3183(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3140)
static void C_ccall f_3140(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3118)
static void C_ccall f_3118(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3118)
static void C_ccall f_3118r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3122)
static void C_ccall f_3122(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3103)
static void C_ccall f_3103(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3103)
static void C_ccall f_3103r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3107)
static void C_ccall f_3107(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3088)
static void C_ccall f_3088(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3088)
static void C_ccall f_3088r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3092)
static void C_ccall f_3092(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3070)
static void C_fcall f_3070(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3008)
static void C_fcall f_3008(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3027)
static void C_fcall f_3027(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2972)
static void C_ccall f_2972(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2997)
static void C_ccall f_2997(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2993)
static void C_ccall f_2993(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2986)
static void C_ccall f_2986(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2951)
static void C_ccall f_2951(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2951)
static void C_ccall f_2951r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2955)
static void C_fcall f_2955(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2958)
static void C_ccall f_2958(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2909)
static void C_ccall f_2909(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2945)
static void C_ccall f_2945(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2928)
static void C_ccall f_2928(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2898)
static void C_ccall f_2898(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2898)
static void C_ccall f_2898r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2907)
static void C_ccall f_2907(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2887)
static void C_ccall f_2887(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2887)
static void C_ccall f_2887r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2896)
static void C_ccall f_2896(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2872)
static void C_fcall f_2872(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2885)
static void C_ccall f_2885(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2835)
static void C_fcall f_2835(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2843)
static void C_ccall f_2843(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2816)
static void C_ccall f_2816(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2805)
static void C_ccall f_2805(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2809)
static void C_ccall f_2809(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2777)
static void C_ccall f_2777(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2798)
static void C_ccall f_2798(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2782)
static void C_ccall f_2782(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2785)
static void C_ccall f_2785(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2745)
static void C_ccall f_2745(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2772)
static void C_ccall f_2772(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2760)
static void C_ccall f_2760(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2768)
static void C_ccall f_2768(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2764)
static void C_ccall f_2764(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2730)
static void C_ccall f_2730(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2740)
static void C_ccall f_2740(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2715)
static void C_ccall f_2715(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2725)
static void C_ccall f_2725(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2719)
static void C_ccall f_2719(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2700)
static void C_ccall f_2700(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2710)
static void C_ccall f_2710(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2704)
static void C_ccall f_2704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2694)
static void C_ccall f_2694(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2688)
static void C_ccall f_2688(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2682)
static void C_ccall f_2682(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2661)
static void C_fcall f_2661(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2680)
static void C_ccall f_2680(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2676)
static void C_ccall f_2676(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2668)
static void C_ccall f_2668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2646)
static void C_ccall f_2646(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2656)
static void C_ccall f_2656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2631)
static void C_ccall f_2631(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2641)
static void C_ccall f_2641(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2628)
static void C_ccall f_2628(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2625)
static void C_ccall f_2625(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2622)
static void C_ccall f_2622(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2619)
static void C_ccall f_2619(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2598)
static void C_ccall f_2598(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2617)
static void C_ccall f_2617(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2613)
static void C_ccall f_2613(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2577)
static void C_ccall f_2577(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2596)
static void C_ccall f_2596(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2592)
static void C_ccall f_2592(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2535)
static void C_ccall f_2535(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2531)
static void C_ccall f_2531(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2545)
static void C_ccall f_2545(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2472)
static void C_ccall f_2472(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2476)
static void C_ccall f_2476(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2481)
static void C_fcall f_2481(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2497)
static void C_ccall f_2497(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2409)
static void C_ccall f_2409(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2467)
static void C_ccall f_2467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2413)
static void C_ccall f_2413(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2416)
static void C_ccall f_2416(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2448)
static void C_ccall f_2448(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2419)
static void C_ccall f_2419(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2424)
static void C_fcall f_2424(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2438)
static void C_ccall f_2438(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2406)
static C_word C_fcall f_2406(C_word t0);
C_noret_decl(f_2352)
static void C_ccall f_2352(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2401)
static void C_ccall f_2401(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2356)
static void C_fcall f_2356(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2366)
static void C_ccall f_2366(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2370)
static void C_ccall f_2370(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2376)
static void C_fcall f_2376(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2380)
static void C_ccall f_2380(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2390)
static void C_ccall f_2390(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2374)
static void C_ccall f_2374(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2307)
static void C_ccall f_2307(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2344)
static void C_ccall f_2344(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2311)
static void C_fcall f_2311(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2321)
static void C_ccall f_2321(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2325)
static void C_ccall f_2325(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2329)
static void C_ccall f_2329(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2333)
static void C_ccall f_2333(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2337)
static void C_ccall f_2337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2269)
static void C_ccall f_2269(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2302)
static void C_ccall f_2302(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2273)
static void C_ccall f_2273(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2280)
static void C_ccall f_2280(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2284)
static void C_ccall f_2284(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2288)
static void C_ccall f_2288(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2292)
static void C_ccall f_2292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2296)
static void C_ccall f_2296(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2248)
static void C_ccall f_2248(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2263)
static void C_ccall f_2263(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2252)
static void C_ccall f_2252(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2230)
static void C_ccall f_2230(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2240)
static void C_ccall f_2240(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2220)
static void C_ccall f_2220(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2177)
static void C_ccall f_2177(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2181)
static void C_ccall f_2181(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2157)
static void C_ccall f_2157(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2157)
static void C_ccall f_2157r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2161)
static void C_ccall f_2161(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2167)
static void C_ccall f_2167(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2167)
static void C_ccall f_2167r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2171)
static void C_ccall f_2171(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2137)
static void C_ccall f_2137(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2137)
static void C_ccall f_2137r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2141)
static void C_ccall f_2141(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2147)
static void C_ccall f_2147(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2147)
static void C_ccall f_2147r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2151)
static void C_ccall f_2151(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2113)
static void C_ccall f_2113(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2113)
static void C_ccall f_2113r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2117)
static void C_ccall f_2117(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2128)
static void C_ccall f_2128(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2128)
static void C_ccall f_2128r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2132)
static void C_ccall f_2132(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2122)
static void C_ccall f_2122(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2089)
static void C_ccall f_2089(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2089)
static void C_ccall f_2089r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2093)
static void C_ccall f_2093(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2104)
static void C_ccall f_2104(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2104)
static void C_ccall f_2104r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2108)
static void C_ccall f_2108(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2098)
static void C_ccall f_2098(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2076)
static void C_ccall f_2076(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2080)
static void C_ccall f_2080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2043)
static void C_ccall f_2043(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2043)
static void C_ccall f_2043r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2071)
static void C_ccall f_2071(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2061)
static void C_ccall f_2061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2054)
static void C_ccall f_2054(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2010)
static void C_ccall f_2010(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2010)
static void C_ccall f_2010r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2038)
static void C_ccall f_2038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2028)
static void C_ccall f_2028(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2021)
static void C_ccall f_2021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1995)
static void C_fcall f_1995(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2008)
static void C_ccall f_2008(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1989)
static void C_fcall f_1989(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1977)
static C_word C_fcall f_1977(C_word t0);
C_noret_decl(f_1937)
static void C_ccall f_1937(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1937)
static void C_ccall f_1937r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1941)
static void C_fcall f_1941(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1950)
static void C_ccall f_1950(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1917)
static void C_ccall f_1917(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1935)
static void C_ccall f_1935(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1921)
static void C_ccall f_1921(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1766)
static void C_ccall f_1766(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1766)
static void C_ccall f_1766r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1868)
static void C_fcall f_1868(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1876)
static void C_ccall f_1876(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1863)
static void C_fcall f_1863(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1768)
static void C_fcall f_1768(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1772)
static void C_ccall f_1772(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1775)
static void C_ccall f_1775(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1778)
static void C_ccall f_1778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1862)
static void C_ccall f_1862(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1782)
static void C_ccall f_1782(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1796)
static void C_fcall f_1796(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1806)
static void C_ccall f_1806(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1818)
static void C_fcall f_1818(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1828)
static void C_ccall f_1828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1745)
static void C_ccall f_1745(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1764)
static void C_ccall f_1764(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1760)
static void C_ccall f_1760(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1724)
static void C_ccall f_1724(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1743)
static void C_ccall f_1743(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1739)
static void C_ccall f_1739(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1703)
static void C_ccall f_1703(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1722)
static void C_ccall f_1722(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1718)
static void C_ccall f_1718(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1651)
static void C_ccall f_1651(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1651)
static void C_ccall f_1651r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1658)
static void C_ccall f_1658(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1670)
static void C_ccall f_1670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1664)
static void C_ccall f_1664(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1614)
static void C_ccall f_1614(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1630)
static void C_ccall f_1630(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1618)
static void C_ccall f_1618(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1621)
static void C_ccall f_1621(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1608)
static void C_ccall f_1608(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1612)
static void C_ccall f_1612(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1602)
static void C_ccall f_1602(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1606)
static void C_ccall f_1606(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1596)
static void C_ccall f_1596(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1600)
static void C_ccall f_1600(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1590)
static void C_ccall f_1590(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1594)
static void C_ccall f_1594(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1584)
static void C_ccall f_1584(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1588)
static void C_ccall f_1588(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1578)
static void C_ccall f_1578(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1582)
static void C_ccall f_1582(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1572)
static void C_ccall f_1572(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1576)
static void C_ccall f_1576(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1566)
static void C_ccall f_1566(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1570)
static void C_ccall f_1570(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1537)
static void C_ccall f_1537(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1537)
static void C_ccall f_1537r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1548)
static void C_fcall f_1548(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1541)
static void C_ccall f_1541(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1500)
static void C_fcall f_1500(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1532)
static void C_ccall f_1532(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1525)
static void C_ccall f_1525(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1504)
static void C_ccall f_1504(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1323)
static void C_ccall f_1323(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1323)
static void C_ccall f_1323r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1484)
static void C_ccall f_1484(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1339)
static void C_ccall f_1339(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1464)
static void C_ccall f_1464(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1345)
static void C_ccall f_1345(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1348)
static void C_fcall f_1348(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1430)
static void C_ccall f_1430(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1428)
static void C_ccall f_1428(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1387)
static void C_fcall f_1387(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1405)
static void C_ccall f_1405(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1403)
static void C_ccall f_1403(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1391)
static void C_fcall f_1391(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1321)
static C_word C_fcall f_1321(C_word t0,C_word t1);
C_noret_decl(f_1319)
static C_word C_fcall f_1319(C_word t0,C_word t1);
C_noret_decl(f_1317)
static C_word C_fcall f_1317(C_word t0);
C_noret_decl(f_1288)
static void C_ccall f_1288(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1292)
static void C_ccall f_1292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1298)
static void C_ccall f_1298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1305)
static void C_ccall f_1305(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1255)
static void C_ccall f_1255(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1255)
static void C_ccall f_1255r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1259)
static void C_ccall f_1259(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1265)
static void C_ccall f_1265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1219)
static void C_ccall f_1219(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1219)
static void C_ccall f_1219r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1223)
static void C_ccall f_1223(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1226)
static void C_ccall f_1226(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1229)
static void C_ccall f_1229(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1207)
static void C_ccall f_1207(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1178)
static void C_ccall f_1178(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1178)
static void C_ccall f_1178r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1199)
static void C_ccall f_1199(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1186)
static void C_ccall f_1186(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1189)
static void C_ccall f_1189(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1123)
static void C_fcall f_1123(C_word t0) C_noret;
C_noret_decl(f_1129)
static void C_ccall f_1129(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1138)
static void C_ccall f_1138(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1106)
static void C_fcall f_1106(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_1110)
static void C_ccall f_1110(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1121)
static void C_ccall f_1121(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1117)
static void C_ccall f_1117(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1098)
static C_word C_fcall f_1098(C_word t0);

C_noret_decl(trf_4646)
static void C_fcall trf_4646(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4646(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4646(t0,t1);}

C_noret_decl(trf_4641)
static void C_fcall trf_4641(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4641(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4641(t0,t1,t2);}

C_noret_decl(trf_4636)
static void C_fcall trf_4636(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4636(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4636(t0,t1,t2,t3);}

C_noret_decl(trf_4494)
static void C_fcall trf_4494(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4494(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4494(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4498)
static void C_fcall trf_4498(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4498(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4498(t0,t1);}

C_noret_decl(trf_4510)
static void C_fcall trf_4510(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4510(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4510(t0,t1,t2,t3);}

C_noret_decl(trf_4447)
static void C_fcall trf_4447(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4447(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4447(t0,t1);}

C_noret_decl(trf_4442)
static void C_fcall trf_4442(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4442(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4442(t0,t1,t2);}

C_noret_decl(trf_4186)
static void C_fcall trf_4186(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4186(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4186(t0,t1,t2,t3);}

C_noret_decl(trf_4292)
static void C_fcall trf_4292(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4292(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4292(t0,t1);}

C_noret_decl(trf_4235)
static void C_fcall trf_4235(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4235(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4235(t0,t1);}

C_noret_decl(trf_4249)
static void C_fcall trf_4249(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4249(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4249(t0,t1);}

C_noret_decl(trf_4164)
static void C_fcall trf_4164(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4164(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4164(t0,t1,t2);}

C_noret_decl(trf_3973)
static void C_fcall trf_3973(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3973(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3973(t0,t1);}

C_noret_decl(trf_3968)
static void C_fcall trf_3968(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3968(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3968(t0,t1,t2);}

C_noret_decl(trf_3856)
static void C_fcall trf_3856(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3856(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3856(t0,t1,t2,t3);}

C_noret_decl(trf_3868)
static void C_fcall trf_3868(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3868(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3868(t0,t1,t2,t3);}

C_noret_decl(trf_3881)
static void C_fcall trf_3881(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3881(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3881(t0,t1);}

C_noret_decl(trf_3700)
static void C_fcall trf_3700(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3700(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3700(t0,t1,t2);}

C_noret_decl(trf_3734)
static void C_fcall trf_3734(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3734(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3734(t0,t1,t2);}

C_noret_decl(trf_3254)
static void C_fcall trf_3254(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3254(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3254(t0,t1,t2);}

C_noret_decl(trf_3266)
static void C_fcall trf_3266(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3266(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3266(t0,t1,t2);}

C_noret_decl(trf_3169)
static void C_fcall trf_3169(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3169(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3169(t0,t1);}

C_noret_decl(trf_3070)
static void C_fcall trf_3070(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3070(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3070(t0,t1,t2,t3);}

C_noret_decl(trf_3008)
static void C_fcall trf_3008(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3008(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3008(t0,t1,t2);}

C_noret_decl(trf_3027)
static void C_fcall trf_3027(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3027(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3027(t0,t1);}

C_noret_decl(trf_2955)
static void C_fcall trf_2955(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2955(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2955(t0,t1);}

C_noret_decl(trf_2872)
static void C_fcall trf_2872(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2872(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2872(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2835)
static void C_fcall trf_2835(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2835(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2835(t0,t1,t2);}

C_noret_decl(trf_2661)
static void C_fcall trf_2661(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2661(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2661(t0,t1,t2);}

C_noret_decl(trf_2481)
static void C_fcall trf_2481(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2481(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2481(t0,t1,t2,t3);}

C_noret_decl(trf_2424)
static void C_fcall trf_2424(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2424(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2424(t0,t1,t2);}

C_noret_decl(trf_2356)
static void C_fcall trf_2356(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2356(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2356(t0,t1);}

C_noret_decl(trf_2376)
static void C_fcall trf_2376(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2376(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2376(t0,t1,t2);}

C_noret_decl(trf_2311)
static void C_fcall trf_2311(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2311(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2311(t0,t1);}

C_noret_decl(trf_1995)
static void C_fcall trf_1995(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1995(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_1995(t0,t1,t2,t3,t4);}

C_noret_decl(trf_1989)
static void C_fcall trf_1989(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1989(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1989(t0,t1);}

C_noret_decl(trf_1941)
static void C_fcall trf_1941(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1941(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1941(t0,t1);}

C_noret_decl(trf_1868)
static void C_fcall trf_1868(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1868(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1868(t0,t1);}

C_noret_decl(trf_1863)
static void C_fcall trf_1863(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1863(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1863(t0,t1,t2);}

C_noret_decl(trf_1768)
static void C_fcall trf_1768(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1768(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1768(t0,t1,t2,t3);}

C_noret_decl(trf_1796)
static void C_fcall trf_1796(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1796(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1796(t0,t1);}

C_noret_decl(trf_1818)
static void C_fcall trf_1818(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1818(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1818(t0,t1);}

C_noret_decl(trf_1548)
static void C_fcall trf_1548(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1548(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1548(t0,t1);}

C_noret_decl(trf_1500)
static void C_fcall trf_1500(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1500(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1500(t0,t1,t2,t3);}

C_noret_decl(trf_1348)
static void C_fcall trf_1348(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1348(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1348(t0,t1);}

C_noret_decl(trf_1387)
static void C_fcall trf_1387(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1387(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1387(t0,t1);}

C_noret_decl(trf_1391)
static void C_fcall trf_1391(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1391(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1391(t0,t1);}

C_noret_decl(trf_1123)
static void C_fcall trf_1123(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1123(void *dummy){
C_word t0=C_pick(0);
C_adjust_stack(-1);
f_1123(t0);}

C_noret_decl(trf_1106)
static void C_fcall trf_1106(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1106(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_1106(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr7rv)
static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(2580)){
C_save(t1);
C_rereclaim2(2580*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,361);
lf[1]=C_static_string(C_heaptop,27,"too many optional arguments");
lf[3]=C_h_intern(&lf[3],13,"string-append");
lf[5]=C_h_intern(&lf[5],15,"\003syssignal-hook");
lf[6]=C_static_string(C_heaptop,3," - ");
lf[7]=C_h_intern(&lf[7],17,"\003syspeek-c-string");
lf[8]=C_h_intern(&lf[8],16,"\003sysupdate-errno");
lf[10]=C_h_intern(&lf[10],18,"\003syscurrent-thread");
lf[11]=C_h_intern(&lf[11],12,"\003sysschedule");
lf[12]=C_h_intern(&lf[12],8,"pipe/buf");
lf[13]=C_h_intern(&lf[13],11,"open/rdonly");
lf[14]=C_h_intern(&lf[14],11,"open/wronly");
lf[15]=C_h_intern(&lf[15],9,"open/rdwr");
lf[16]=C_h_intern(&lf[16],9,"open/read");
lf[17]=C_h_intern(&lf[17],10,"open/write");
lf[18]=C_h_intern(&lf[18],10,"open/creat");
lf[19]=C_h_intern(&lf[19],11,"open/append");
lf[20]=C_h_intern(&lf[20],9,"open/excl");
lf[21]=C_h_intern(&lf[21],11,"open/noctty");
lf[22]=C_h_intern(&lf[22],13,"open/nonblock");
lf[23]=C_h_intern(&lf[23],10,"open/trunc");
lf[24]=C_h_intern(&lf[24],9,"open/sync");
lf[25]=C_h_intern(&lf[25],10,"open/fsync");
lf[26]=C_h_intern(&lf[26],11,"open/binary");
lf[27]=C_h_intern(&lf[27],9,"open/text");
lf[28]=C_h_intern(&lf[28],10,"perm/irusr");
lf[29]=C_h_intern(&lf[29],10,"perm/iwusr");
lf[30]=C_h_intern(&lf[30],10,"perm/ixusr");
lf[31]=C_h_intern(&lf[31],10,"perm/irgrp");
lf[32]=C_h_intern(&lf[32],10,"perm/iwgrp");
lf[33]=C_h_intern(&lf[33],10,"perm/ixgrp");
lf[34]=C_h_intern(&lf[34],10,"perm/iroth");
lf[35]=C_h_intern(&lf[35],10,"perm/iwoth");
lf[36]=C_h_intern(&lf[36],10,"perm/ixoth");
lf[37]=C_h_intern(&lf[37],10,"perm/irwxu");
lf[38]=C_h_intern(&lf[38],10,"perm/irwxg");
lf[39]=C_h_intern(&lf[39],10,"perm/irwxo");
lf[40]=C_h_intern(&lf[40],10,"perm/isvtx");
lf[41]=C_h_intern(&lf[41],10,"perm/isuid");
lf[42]=C_h_intern(&lf[42],10,"perm/isgid");
lf[43]=C_h_intern(&lf[43],9,"file-open");
lf[44]=C_h_intern(&lf[44],11,"\000file-error");
lf[45]=C_static_string(C_heaptop,17,"can not open file");
lf[46]=C_h_intern(&lf[46],17,"\003sysmake-c-string");
lf[47]=C_h_intern(&lf[47],20,"\003sysexpand-home-path");
lf[48]=C_h_intern(&lf[48],10,"file-close");
lf[49]=C_static_string(C_heaptop,18,"can not close file");
lf[50]=C_h_intern(&lf[50],11,"make-string");
lf[51]=C_h_intern(&lf[51],9,"file-read");
lf[52]=C_static_string(C_heaptop,22,"can not read from file");
lf[53]=C_h_intern(&lf[53],11,"\000type-error");
lf[54]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[55]=C_h_intern(&lf[55],10,"file-write");
lf[56]=C_static_string(C_heaptop,21,"can not write to file");
lf[57]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[58]=C_h_intern(&lf[58],12,"file-mkstemp");
lf[59]=C_h_intern(&lf[59],13,"\003syssubstring");
lf[60]=C_static_string(C_heaptop,29,"can not create temporary file");
lf[61]=C_h_intern(&lf[61],11,"file-select");
lf[62]=C_static_string(C_heaptop,6,"failed");
lf[63]=C_h_intern(&lf[63],12,"\003sysfor-each");
lf[64]=C_h_intern(&lf[64],8,"seek/set");
lf[65]=C_h_intern(&lf[65],8,"seek/end");
lf[66]=C_h_intern(&lf[66],8,"seek/cur");
lf[68]=C_static_string(C_heaptop,19,"can not access file");
lf[69]=C_static_string(C_heaptop,42,"bad argument type - not a fixnum or string");
lf[70]=C_h_intern(&lf[70],9,"file-stat");
lf[71]=C_h_intern(&lf[71],9,"file-size");
lf[72]=C_h_intern(&lf[72],22,"file-modification-time");
lf[73]=C_h_intern(&lf[73],16,"file-access-time");
lf[74]=C_h_intern(&lf[74],16,"file-change-time");
lf[75]=C_h_intern(&lf[75],10,"file-owner");
lf[76]=C_h_intern(&lf[76],16,"file-permissions");
lf[77]=C_h_intern(&lf[77],13,"regular-file\077");
lf[78]=C_h_intern(&lf[78],14,"symbolic-link\077");
lf[79]=C_h_intern(&lf[79],13,"file-position");
lf[80]=C_static_string(C_heaptop,38,"can not retrieve file position of port");
lf[81]=C_h_intern(&lf[81],6,"stream");
lf[82]=C_static_string(C_heaptop,12,"invalid file");
lf[83]=C_h_intern(&lf[83],5,"port\077");
lf[84]=C_h_intern(&lf[84],18,"set-file-position!");
lf[85]=C_static_string(C_heaptop,25,"can not set file position");
lf[86]=C_static_string(C_heaptop,12,"invalid file");
lf[87]=C_h_intern(&lf[87],13,"\000bounds-error");
lf[88]=C_static_string(C_heaptop,30,"invalid negative port position");
lf[89]=C_h_intern(&lf[89],16,"create-directory");
lf[90]=C_static_string(C_heaptop,24,"can not create directory");
lf[91]=C_h_intern(&lf[91],16,"change-directory");
lf[92]=C_static_string(C_heaptop,32,"can not change current directory");
lf[93]=C_h_intern(&lf[93],16,"delete-directory");
lf[94]=C_static_string(C_heaptop,24,"can not delete directory");
lf[95]=C_h_intern(&lf[95],6,"string");
lf[96]=C_h_intern(&lf[96],9,"directory");
lf[97]=C_static_string(C_heaptop,22,"can not open directory");
lf[98]=C_h_intern(&lf[98],16,"\003sysmake-pointer");
lf[99]=C_h_intern(&lf[99],17,"current-directory");
lf[100]=C_h_intern(&lf[100],10,"directory\077");
lf[101]=C_h_intern(&lf[101],13,"\003sysfile-info");
lf[102]=C_static_string(C_heaptop,34,"can not retrieve current directory");
lf[103]=C_h_intern(&lf[103],5,"\000text");
lf[104]=C_h_intern(&lf[104],9,"\003syserror");
lf[105]=C_static_string(C_heaptop,35,"illegal input/output mode specifier");
lf[106]=C_static_string(C_heaptop,17,"can not open pipe");
lf[107]=C_h_intern(&lf[107],13,"\003sysmake-port");
lf[108]=C_h_intern(&lf[108],21,"\003sysstream-port-class");
lf[109]=C_static_string(C_heaptop,6,"(pipe)");
lf[110]=C_h_intern(&lf[110],15,"open-input-pipe");
lf[111]=C_h_intern(&lf[111],7,"\000binary");
lf[112]=C_h_intern(&lf[112],16,"open-output-pipe");
lf[113]=C_h_intern(&lf[113],16,"close-input-pipe");
lf[114]=C_h_intern(&lf[114],23,"close-input/output-pipe");
lf[115]=C_static_string(C_heaptop,24,"error while closing pipe");
lf[116]=C_h_intern(&lf[116],17,"close-output-pipe");
lf[117]=C_h_intern(&lf[117],20,"call-with-input-pipe");
lf[118]=C_h_intern(&lf[118],21,"call-with-output-pipe");
lf[119]=C_h_intern(&lf[119],20,"with-input-from-pipe");
lf[120]=C_h_intern(&lf[120],18,"\003sysstandard-input");
lf[121]=C_h_intern(&lf[121],19,"with-output-to-pipe");
lf[122]=C_h_intern(&lf[122],19,"\003sysstandard-output");
lf[123]=C_h_intern(&lf[123],11,"create-pipe");
lf[124]=C_static_string(C_heaptop,19,"can not create pipe");
lf[125]=C_h_intern(&lf[125],11,"signal/term");
lf[126]=C_h_intern(&lf[126],11,"signal/kill");
lf[127]=C_h_intern(&lf[127],10,"signal/int");
lf[128]=C_h_intern(&lf[128],10,"signal/hup");
lf[129]=C_h_intern(&lf[129],10,"signal/fpe");
lf[130]=C_h_intern(&lf[130],10,"signal/ill");
lf[131]=C_h_intern(&lf[131],11,"signal/segv");
lf[132]=C_h_intern(&lf[132],11,"signal/abrt");
lf[133]=C_h_intern(&lf[133],11,"signal/trap");
lf[134]=C_h_intern(&lf[134],11,"signal/quit");
lf[135]=C_h_intern(&lf[135],11,"signal/alrm");
lf[136]=C_h_intern(&lf[136],13,"signal/vtalrm");
lf[137]=C_h_intern(&lf[137],11,"signal/prof");
lf[138]=C_h_intern(&lf[138],9,"signal/io");
lf[139]=C_h_intern(&lf[139],10,"signal/urg");
lf[140]=C_h_intern(&lf[140],11,"signal/chld");
lf[141]=C_h_intern(&lf[141],11,"signal/cont");
lf[142]=C_h_intern(&lf[142],11,"signal/stop");
lf[143]=C_h_intern(&lf[143],11,"signal/tstp");
lf[144]=C_h_intern(&lf[144],11,"signal/pipe");
lf[145]=C_h_intern(&lf[145],11,"signal/xcpu");
lf[146]=C_h_intern(&lf[146],11,"signal/xfsz");
lf[147]=C_h_intern(&lf[147],11,"signal/usr1");
lf[148]=C_h_intern(&lf[148],11,"signal/usr2");
lf[149]=C_h_intern(&lf[149],12,"signal/winch");
lf[150]=C_h_intern(&lf[150],18,"\003sysinterrupt-hook");
lf[151]=C_h_intern(&lf[151],19,"set-signal-handler!");
lf[152]=C_h_intern(&lf[152],16,"set-signal-mask!");
lf[153]=C_h_intern(&lf[153],14,"\000process-error");
lf[154]=C_static_string(C_heaptop,23,"can not set signal mask");
lf[155]=C_h_intern(&lf[155],18,"system-information");
lf[156]=C_h_intern(&lf[156],25,"\003syspeek-nonnull-c-string");
lf[157]=C_static_string(C_heaptop,35,"can not retrieve system information");
lf[158]=C_h_intern(&lf[158],16,"user-information");
lf[159]=C_h_intern(&lf[159],17,"group-information");
lf[161]=C_h_intern(&lf[161],10,"get-groups");
lf[162]=C_static_string(C_heaptop,40,"can not retrieve supplementary group ids");
lf[163]=C_static_string(C_heaptop,13,"out of memory");
lf[164]=C_static_string(C_heaptop,40,"can not retrieve supplementary group ids");
lf[165]=C_h_intern(&lf[165],11,"set-groups!");
lf[166]=C_static_string(C_heaptop,35,"can not set supplementary group ids");
lf[167]=C_static_string(C_heaptop,13,"out of memory");
lf[168]=C_h_intern(&lf[168],17,"initialize-groups");
lf[169]=C_static_string(C_heaptop,42,"can not initialize supplementary group ids");
lf[170]=C_h_intern(&lf[170],10,"errno/perm");
lf[171]=C_h_intern(&lf[171],11,"errno/noent");
lf[172]=C_h_intern(&lf[172],10,"errno/srch");
lf[173]=C_h_intern(&lf[173],10,"errno/intr");
lf[174]=C_h_intern(&lf[174],8,"errno/io");
lf[175]=C_h_intern(&lf[175],12,"errno/noexec");
lf[176]=C_h_intern(&lf[176],10,"errno/badf");
lf[177]=C_h_intern(&lf[177],11,"errno/child");
lf[178]=C_h_intern(&lf[178],11,"errno/nomem");
lf[179]=C_h_intern(&lf[179],11,"errno/acces");
lf[180]=C_h_intern(&lf[180],11,"errno/fault");
lf[181]=C_h_intern(&lf[181],10,"errno/busy");
lf[182]=C_h_intern(&lf[182],12,"errno/notdir");
lf[183]=C_h_intern(&lf[183],11,"errno/isdir");
lf[184]=C_h_intern(&lf[184],11,"errno/inval");
lf[185]=C_h_intern(&lf[185],11,"errno/mfile");
lf[186]=C_h_intern(&lf[186],11,"errno/nospc");
lf[187]=C_h_intern(&lf[187],11,"errno/spipe");
lf[188]=C_h_intern(&lf[188],10,"errno/pipe");
lf[189]=C_h_intern(&lf[189],11,"errno/again");
lf[190]=C_h_intern(&lf[190],10,"errno/rofs");
lf[191]=C_h_intern(&lf[191],11,"errno/exist");
lf[192]=C_h_intern(&lf[192],16,"errno/wouldblock");
lf[193]=C_h_intern(&lf[193],16,"change-file-mode");
lf[194]=C_static_string(C_heaptop,24,"can not change file mode");
lf[195]=C_h_intern(&lf[195],17,"change-file-owner");
lf[196]=C_static_string(C_heaptop,25,"can not change file owner");
lf[197]=C_h_intern(&lf[197],15,"current-user-id");
lf[198]=C_h_intern(&lf[198],16,"current-group-id");
lf[199]=C_h_intern(&lf[199],25,"current-effective-user-id");
lf[200]=C_h_intern(&lf[200],26,"current-effective-group-id");
lf[201]=C_h_intern(&lf[201],12,"set-user-id!");
lf[202]=C_static_string(C_heaptop,19,"can not set user ID");
lf[203]=C_h_intern(&lf[203],13,"set-group-id!");
lf[204]=C_static_string(C_heaptop,20,"can not set group ID");
lf[205]=C_h_intern(&lf[205],17,"file-read-access\077");
lf[206]=C_h_intern(&lf[206],18,"file-write-access\077");
lf[207]=C_h_intern(&lf[207],20,"file-execute-access\077");
lf[208]=C_h_intern(&lf[208],14,"create-session");
lf[209]=C_static_string(C_heaptop,22,"can not create session");
lf[210]=C_h_intern(&lf[210],16,"process-group-id");
lf[211]=C_static_string(C_heaptop,33,"can not retrieve process group ID");
lf[212]=C_h_intern(&lf[212],21,"set-process-group-id!");
lf[213]=C_static_string(C_heaptop,28,"can not set process group ID");
lf[214]=C_h_intern(&lf[214],20,"create-symbolic-link");
lf[215]=C_h_intern(&lf[215],18,"create-symbol-link");
lf[216]=C_static_string(C_heaptop,28,"can not create symbolic link");
lf[217]=C_h_intern(&lf[217],9,"substring");
lf[218]=C_h_intern(&lf[218],18,"read-symbolic-link");
lf[219]=C_static_string(C_heaptop,26,"can not read symbolic link");
lf[220]=C_h_intern(&lf[220],9,"file-link");
lf[221]=C_h_intern(&lf[221],9,"hard-link");
lf[222]=C_static_string(C_heaptop,26,"could not create hard link");
lf[223]=C_h_intern(&lf[223],12,"fileno/stdin");
lf[224]=C_h_intern(&lf[224],13,"fileno/stdout");
lf[225]=C_h_intern(&lf[225],13,"fileno/stderr");
lf[226]=C_h_intern(&lf[226],7,"\000append");
lf[227]=C_static_string(C_heaptop,27,"invalid mode for input file");
lf[228]=C_static_string(C_heaptop,1,"a");
lf[229]=C_static_string(C_heaptop,21,"invalid mode argument");
lf[230]=C_static_string(C_heaptop,1,"r");
lf[231]=C_static_string(C_heaptop,1,"w");
lf[232]=C_static_string(C_heaptop,17,"can not open file");
lf[233]=C_static_string(C_heaptop,8,"(fdport)");
lf[234]=C_h_intern(&lf[234],16,"open-input-file*");
lf[235]=C_h_intern(&lf[235],17,"open-output-file*");
lf[236]=C_h_intern(&lf[236],12,"port->fileno");
lf[237]=C_h_intern(&lf[237],6,"socket");
lf[238]=C_h_intern(&lf[238],20,"\003systcp-port->fileno");
lf[239]=C_static_string(C_heaptop,25,"port has no attached file");
lf[240]=C_static_string(C_heaptop,38,"can not access file-descriptor of port");
lf[241]=C_h_intern(&lf[241],25,"\003syspeek-unsigned-integer");
lf[242]=C_h_intern(&lf[242],16,"duplicate-fileno");
lf[243]=C_static_string(C_heaptop,33,"can not duplicate file descriptor");
lf[244]=C_h_intern(&lf[244],13,"file-truncate");
lf[245]=C_static_string(C_heaptop,21,"can not truncate file");
lf[246]=C_static_string(C_heaptop,12,"invalid file");
lf[247]=C_h_intern(&lf[247],4,"lock");
lf[248]=C_h_intern(&lf[248],9,"file-lock");
lf[249]=C_static_string(C_heaptop,17,"can not lock file");
lf[250]=C_h_intern(&lf[250],18,"file-lock/blocking");
lf[251]=C_static_string(C_heaptop,17,"can not lock file");
lf[252]=C_h_intern(&lf[252],14,"file-test-lock");
lf[253]=C_static_string(C_heaptop,19,"can not unlock file");
lf[254]=C_h_intern(&lf[254],11,"file-unlock");
lf[255]=C_static_string(C_heaptop,19,"can not unlock file");
lf[256]=C_h_intern(&lf[256],11,"create-fifo");
lf[257]=C_static_string(C_heaptop,19,"can not create FIFO");
lf[258]=C_h_intern(&lf[258],5,"fifo\077");
lf[259]=C_static_string(C_heaptop,19,"file does not exist");
lf[260]=C_h_intern(&lf[260],6,"setenv");
lf[261]=C_h_intern(&lf[261],8,"unsetenv");
lf[262]=C_h_intern(&lf[262],19,"current-environment");
lf[263]=C_h_intern(&lf[263],9,"prot/read");
lf[264]=C_h_intern(&lf[264],10,"prot/write");
lf[265]=C_h_intern(&lf[265],9,"prot/exec");
lf[266]=C_h_intern(&lf[266],9,"prot/none");
lf[267]=C_h_intern(&lf[267],9,"map/fixed");
lf[268]=C_h_intern(&lf[268],10,"map/shared");
lf[269]=C_h_intern(&lf[269],11,"map/private");
lf[270]=C_h_intern(&lf[270],13,"map/anonymous");
lf[271]=C_h_intern(&lf[271],8,"map/file");
lf[272]=C_h_intern(&lf[272],18,"map-file-to-memory");
lf[273]=C_h_intern(&lf[273],4,"mmap");
lf[274]=C_static_string(C_heaptop,26,"can not map file to memory");
lf[275]=C_h_intern(&lf[275],20,"\003syspointer->address");
lf[276]=C_static_string(C_heaptop,41,"bad argument type - not a foreign pointer");
lf[277]=C_h_intern(&lf[277],16,"\003sysnull-pointer");
lf[278]=C_h_intern(&lf[278],22,"unmap-file-from-memory");
lf[279]=C_static_string(C_heaptop,30,"can not unmap file from memory");
lf[280]=C_h_intern(&lf[280],26,"memory-mapped-file-pointer");
lf[281]=C_h_intern(&lf[281],19,"memory-mapped-file\077");
lf[282]=C_h_intern(&lf[282],19,"seconds->local-time");
lf[283]=C_h_intern(&lf[283],18,"\003sysdecode-seconds");
lf[284]=C_h_intern(&lf[284],17,"seconds->utc-time");
lf[285]=C_h_intern(&lf[285],15,"seconds->string");
lf[286]=C_static_string(C_heaptop,33,"can not convert seconds to string");
lf[287]=C_h_intern(&lf[287],12,"time->string");
lf[288]=C_static_string(C_heaptop,37,"can not convert time vector to string");
lf[289]=C_static_string(C_heaptop,21,"time vector too short");
lf[290]=C_h_intern(&lf[290],19,"local-time->seconds");
lf[291]=C_h_intern(&lf[291],15,"\003syscons-flonum");
lf[292]=C_static_string(C_heaptop,38,"can not convert time vector to seconds");
lf[293]=C_static_string(C_heaptop,21,"time vector too short");
lf[294]=C_h_intern(&lf[294],17,"utc-time->seconds");
lf[295]=C_static_string(C_heaptop,38,"can not convert time vector to seconds");
lf[296]=C_static_string(C_heaptop,21,"time vector too short");
lf[297]=C_h_intern(&lf[297],27,"local-timezone-abbreviation");
lf[298]=C_h_intern(&lf[298],5,"_exit");
lf[299]=C_h_intern(&lf[299],23,"\003syscleanup-before-exit");
lf[300]=C_h_intern(&lf[300],10,"set-alarm!");
lf[301]=C_h_intern(&lf[301],19,"set-buffering-mode!");
lf[302]=C_static_string(C_heaptop,26,"can not set buffering mode");
lf[303]=C_h_intern(&lf[303],5,"\000full");
lf[304]=C_h_intern(&lf[304],5,"\000line");
lf[305]=C_h_intern(&lf[305],5,"\000none");
lf[306]=C_static_string(C_heaptop,22,"invalid buffering-mode");
lf[307]=C_h_intern(&lf[307],14,"terminal-port\077");
lf[308]=C_h_intern(&lf[308],13,"terminal-name");
lf[309]=C_static_string(C_heaptop,35,"port is not connected to a terminal");
lf[310]=C_h_intern(&lf[310],13,"get-host-name");
lf[311]=C_h_intern(&lf[311],6,"\000error");
lf[312]=C_static_string(C_heaptop,26,"can not retrieve host-name");
lf[313]=C_h_intern(&lf[313],12,"glob->regexp");
lf[314]=C_h_intern(&lf[314],13,"make-pathname");
lf[315]=C_h_intern(&lf[315],18,"decompose-pathname");
lf[316]=C_h_intern(&lf[316],4,"glob");
lf[317]=C_h_intern(&lf[317],12,"string-match");
lf[318]=C_static_string(C_heaptop,1,".");
lf[319]=C_static_string(C_heaptop,1,"*");
lf[320]=C_h_intern(&lf[320],12,"process-fork");
lf[321]=C_static_string(C_heaptop,28,"can not create child process");
lf[322]=C_h_intern(&lf[322],24,"pathname-strip-directory");
lf[323]=C_h_intern(&lf[323],15,"process-execute");
lf[324]=C_static_string(C_heaptop,23,"can not execute process");
lf[325]=C_h_intern(&lf[325],12,"process-wait");
lf[326]=C_static_string(C_heaptop,32,"waiting for child process failed");
lf[327]=C_h_intern(&lf[327],18,"current-process-id");
lf[328]=C_h_intern(&lf[328],17,"parent-process-id");
lf[329]=C_h_intern(&lf[329],5,"sleep");
lf[330]=C_h_intern(&lf[330],14,"process-signal");
lf[331]=C_static_string(C_heaptop,32,"could not send signal to process");
lf[332]=C_h_intern(&lf[332],6,"getenv");
lf[333]=C_h_intern(&lf[333],11,"process-run");
lf[334]=C_static_string(C_heaptop,7,"/bin/sh");
lf[335]=C_static_string(C_heaptop,2,"-c");
lf[336]=C_static_string(C_heaptop,5,"SHELL");
lf[337]=C_h_intern(&lf[337],15,"make-input-port");
lf[338]=C_h_intern(&lf[338],16,"make-output-port");
lf[339]=C_h_intern(&lf[339],7,"process");
lf[340]=C_static_string(C_heaptop,25,"process exited abnormally");
lf[341]=C_h_intern(&lf[341],25,"\003systhread-block-for-i/o!");
lf[342]=C_static_string(C_heaptop,22,"can not read from pipe");
lf[343]=C_static_string(C_heaptop,21,"can not write to pipe");
lf[344]=C_static_string(C_heaptop,7,"/bin/sh");
lf[345]=C_static_string(C_heaptop,2,"-c");
lf[346]=C_static_string(C_heaptop,5,"SHELL");
lf[347]=C_h_intern(&lf[347],10,"find-files");
lf[348]=C_static_string(C_heaptop,1,".");
lf[349]=C_static_string(C_heaptop,2,"..");
lf[350]=C_h_intern(&lf[350],8,"\003sysvoid");
lf[351]=C_static_string(C_heaptop,1,"*");
lf[352]=C_h_intern(&lf[352],16,"\003sysdynamic-wind");
lf[353]=C_h_intern(&lf[353],13,"pathname-file");
lf[354]=C_static_string(C_heaptop,1,"*");
lf[355]=C_h_intern(&lf[355],19,"set-root-directory!");
lf[356]=C_static_string(C_heaptop,31,"unable to change root directory");
lf[357]=C_h_intern(&lf[357],23,"\003sysuser-interrupt-hook");
lf[358]=C_h_intern(&lf[358],11,"make-vector");
lf[359]=C_h_intern(&lf[359],17,"register-feature!");
lf[360]=C_h_intern(&lf[360],5,"posix");
C_register_lf2(lf,361,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1084,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k1082 */
static void C_ccall f_1084(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1084,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1087,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1085 in k1082 */
static void C_ccall f_1087(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1087,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1090,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1088 in k1085 in k1082 */
static void C_ccall f_1090(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1090,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1093,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1093(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1093,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1096,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 400  register-feature! */
t3=*((C_word*)lf[359]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[360]);}

/* k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word ab[116],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1096,2,t0,t1);}
t2=C_mutate(&lf[2],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1098,tmp=(C_word)a,a+=2,tmp));
t3=*((C_word*)lf[3]+1);
t4=C_mutate(&lf[4],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1106,a[2]=t3,tmp=(C_word)a,a+=3,tmp));
t5=C_mutate(&lf[9],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1123,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[12]+1,C_fix((C_word)PIPE_BUF));
t7=C_mutate((C_word*)lf[13]+1,C_fix((C_word)O_RDONLY));
t8=C_mutate((C_word*)lf[14]+1,C_fix((C_word)O_WRONLY));
t9=C_mutate((C_word*)lf[15]+1,C_fix((C_word)O_RDWR));
t10=C_mutate((C_word*)lf[16]+1,C_fix((C_word)O_RDONLY));
t11=C_mutate((C_word*)lf[17]+1,C_fix((C_word)O_WRONLY));
t12=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_CREAT));
t13=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_APPEND));
t14=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_EXCL));
t15=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_NOCTTY));
t16=C_mutate((C_word*)lf[22]+1,C_fix((C_word)O_NONBLOCK));
t17=C_mutate((C_word*)lf[23]+1,C_fix((C_word)O_TRUNC));
t18=C_mutate((C_word*)lf[24]+1,C_fix((C_word)O_FSYNC));
t19=C_mutate((C_word*)lf[25]+1,C_fix((C_word)O_FSYNC));
t20=C_mutate((C_word*)lf[26]+1,C_fix((C_word)O_BINARY));
t21=C_mutate((C_word*)lf[27]+1,C_fix((C_word)O_TEXT));
t22=C_mutate((C_word*)lf[28]+1,C_fix((C_word)S_IRUSR));
t23=C_mutate((C_word*)lf[29]+1,C_fix((C_word)S_IWUSR));
t24=C_mutate((C_word*)lf[30]+1,C_fix((C_word)S_IXUSR));
t25=C_mutate((C_word*)lf[31]+1,C_fix((C_word)S_IRGRP));
t26=C_mutate((C_word*)lf[32]+1,C_fix((C_word)S_IWGRP));
t27=C_mutate((C_word*)lf[33]+1,C_fix((C_word)S_IXGRP));
t28=C_mutate((C_word*)lf[34]+1,C_fix((C_word)S_IROTH));
t29=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_IWOTH));
t30=C_mutate((C_word*)lf[36]+1,C_fix((C_word)S_IXOTH));
t31=C_mutate((C_word*)lf[37]+1,C_fix((C_word)S_IRWXU));
t32=C_mutate((C_word*)lf[38]+1,C_fix((C_word)S_IRWXG));
t33=C_mutate((C_word*)lf[39]+1,C_fix((C_word)S_IRWXO));
t34=C_mutate((C_word*)lf[40]+1,C_fix((C_word)S_ISVTX));
t35=C_mutate((C_word*)lf[41]+1,C_fix((C_word)S_ISUID));
t36=C_mutate((C_word*)lf[42]+1,C_fix((C_word)S_ISGID));
t37=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t38=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t37);
t39=C_mutate((C_word*)lf[43]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1178,a[2]=t38,tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[48]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1207,tmp=(C_word)a,a+=2,tmp));
t41=*((C_word*)lf[50]+1);
t42=C_mutate((C_word*)lf[51]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1219,a[2]=t41,tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[55]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1255,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[58]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1288,tmp=(C_word)a,a+=2,tmp));
t45=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1317,tmp=(C_word)a,a+=2,tmp);
t46=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1319,tmp=(C_word)a,a+=2,tmp);
t47=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1321,tmp=(C_word)a,a+=2,tmp);
t48=C_mutate((C_word*)lf[61]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1323,a[2]=t46,a[3]=t47,a[4]=t45,tmp=(C_word)a,a+=5,tmp));
t49=C_mutate((C_word*)lf[64]+1,C_fix((C_word)SEEK_SET));
t50=C_mutate((C_word*)lf[65]+1,C_fix((C_word)SEEK_END));
t51=C_mutate((C_word*)lf[66]+1,C_fix((C_word)SEEK_CUR));
t52=C_mutate(&lf[67],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1500,tmp=(C_word)a,a+=2,tmp));
t53=C_mutate((C_word*)lf[70]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1537,tmp=(C_word)a,a+=2,tmp));
t54=C_mutate((C_word*)lf[71]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1566,tmp=(C_word)a,a+=2,tmp));
t55=C_mutate((C_word*)lf[72]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1572,tmp=(C_word)a,a+=2,tmp));
t56=C_mutate((C_word*)lf[73]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1578,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[74]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1584,tmp=(C_word)a,a+=2,tmp));
t58=C_mutate((C_word*)lf[75]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1590,tmp=(C_word)a,a+=2,tmp));
t59=C_mutate((C_word*)lf[76]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1596,tmp=(C_word)a,a+=2,tmp));
t60=C_mutate((C_word*)lf[77]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1602,tmp=(C_word)a,a+=2,tmp));
t61=C_mutate((C_word*)lf[78]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1608,tmp=(C_word)a,a+=2,tmp));
t62=C_mutate((C_word*)lf[79]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1614,tmp=(C_word)a,a+=2,tmp));
t63=C_mutate((C_word*)lf[84]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1651,tmp=(C_word)a,a+=2,tmp));
t64=C_mutate((C_word*)lf[89]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1703,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[91]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1724,tmp=(C_word)a,a+=2,tmp));
t66=C_mutate((C_word*)lf[93]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1745,tmp=(C_word)a,a+=2,tmp));
t67=*((C_word*)lf[3]+1);
t68=*((C_word*)lf[50]+1);
t69=*((C_word*)lf[95]+1);
t70=C_mutate((C_word*)lf[96]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1766,a[2]=t68,tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[100]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1917,tmp=(C_word)a,a+=2,tmp));
t72=*((C_word*)lf[50]+1);
t73=C_mutate((C_word*)lf[99]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1937,a[2]=t72,tmp=(C_word)a,a+=3,tmp));
t74=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1977,tmp=(C_word)a,a+=2,tmp);
t75=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1989,tmp=(C_word)a,a+=2,tmp);
t76=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1995,tmp=(C_word)a,a+=2,tmp);
t77=C_mutate((C_word*)lf[110]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2010,a[2]=t75,a[3]=t76,a[4]=t74,tmp=(C_word)a,a+=5,tmp));
t78=C_mutate((C_word*)lf[112]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2043,a[2]=t75,a[3]=t76,a[4]=t74,tmp=(C_word)a,a+=5,tmp));
t79=C_mutate((C_word*)lf[113]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2076,tmp=(C_word)a,a+=2,tmp));
t80=C_mutate((C_word*)lf[116]+1,*((C_word*)lf[113]+1));
t81=*((C_word*)lf[110]+1);
t82=*((C_word*)lf[112]+1);
t83=*((C_word*)lf[113]+1);
t84=*((C_word*)lf[116]+1);
t85=C_mutate((C_word*)lf[117]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2089,a[2]=t81,a[3]=t83,tmp=(C_word)a,a+=4,tmp));
t86=C_mutate((C_word*)lf[118]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2113,a[2]=t82,a[3]=t84,tmp=(C_word)a,a+=4,tmp));
t87=C_mutate((C_word*)lf[119]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2137,a[2]=t81,a[3]=t83,tmp=(C_word)a,a+=4,tmp));
t88=C_mutate((C_word*)lf[121]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2157,a[2]=t82,a[3]=t84,tmp=(C_word)a,a+=4,tmp));
t89=C_mutate((C_word*)lf[123]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2177,tmp=(C_word)a,a+=2,tmp));
t90=C_mutate((C_word*)lf[125]+1,C_fix((C_word)SIGTERM));
t91=C_mutate((C_word*)lf[126]+1,C_fix((C_word)SIGKILL));
t92=C_mutate((C_word*)lf[127]+1,C_fix((C_word)SIGINT));
t93=C_mutate((C_word*)lf[128]+1,C_fix((C_word)SIGHUP));
t94=C_mutate((C_word*)lf[129]+1,C_fix((C_word)SIGFPE));
t95=C_mutate((C_word*)lf[130]+1,C_fix((C_word)SIGILL));
t96=C_mutate((C_word*)lf[131]+1,C_fix((C_word)SIGSEGV));
t97=C_mutate((C_word*)lf[132]+1,C_fix((C_word)SIGABRT));
t98=C_mutate((C_word*)lf[133]+1,C_fix((C_word)SIGTRAP));
t99=C_mutate((C_word*)lf[134]+1,C_fix((C_word)SIGQUIT));
t100=C_mutate((C_word*)lf[135]+1,C_fix((C_word)SIGALRM));
t101=C_mutate((C_word*)lf[136]+1,C_fix((C_word)SIGVTALRM));
t102=C_mutate((C_word*)lf[137]+1,C_fix((C_word)SIGPROF));
t103=C_mutate((C_word*)lf[138]+1,C_fix((C_word)SIGIO));
t104=C_mutate((C_word*)lf[139]+1,C_fix((C_word)SIGURG));
t105=C_mutate((C_word*)lf[140]+1,C_fix((C_word)SIGCHLD));
t106=C_mutate((C_word*)lf[141]+1,C_fix((C_word)SIGCONT));
t107=C_mutate((C_word*)lf[142]+1,C_fix((C_word)SIGSTOP));
t108=C_mutate((C_word*)lf[143]+1,C_fix((C_word)SIGTSTP));
t109=C_mutate((C_word*)lf[144]+1,C_fix((C_word)SIGPIPE));
t110=C_mutate((C_word*)lf[145]+1,C_fix((C_word)SIGXCPU));
t111=C_mutate((C_word*)lf[146]+1,C_fix((C_word)SIGXFSZ));
t112=C_mutate((C_word*)lf[147]+1,C_fix((C_word)SIGUSR1));
t113=C_mutate((C_word*)lf[148]+1,C_fix((C_word)SIGUSR2));
t114=C_mutate((C_word*)lf[149]+1,C_fix((C_word)SIGWINCH));
t115=*((C_word*)lf[150]+1);
t116=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2218,a[2]=((C_word*)t0)[2],a[3]=t115,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 917  make-vector */
t117=*((C_word*)lf[358]+1);
((C_proc4)(void*)(*((C_word*)t117+1)))(4,t117,t116,C_fix(256),C_SCHEME_FALSE);}

/* k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2218(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2218,2,t0,t1);}
t2=C_mutate((C_word*)lf[151]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2220,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[150]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2230,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[152]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2248,tmp=(C_word)a,a+=2,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2267,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4741,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 947  set-signal-handler! */
t7=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,*((C_word*)lf[127]+1),t6);}

/* a4740 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4741(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4741,3,t0,t1,t2);}
/* posixunix.scm: 949  ##sys#user-interrupt-hook */
t3=*((C_word*)lf[357]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2267(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word ab[53],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2267,2,t0,t1);}
t2=C_mutate((C_word*)lf[155]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2269,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate((C_word*)lf[158]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2307,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[159]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2352,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate(&lf[160],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2406,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[161]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2409,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[165]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2472,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[168]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2535,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[170]+1,C_fix((C_word)EPERM));
t10=C_mutate((C_word*)lf[171]+1,C_fix((C_word)ENOENT));
t11=C_mutate((C_word*)lf[172]+1,C_fix((C_word)ESRCH));
t12=C_mutate((C_word*)lf[173]+1,C_fix((C_word)EINTR));
t13=C_mutate((C_word*)lf[174]+1,C_fix((C_word)EIO));
t14=C_mutate((C_word*)lf[175]+1,C_fix((C_word)ENOEXEC));
t15=C_mutate((C_word*)lf[176]+1,C_fix((C_word)EBADF));
t16=C_mutate((C_word*)lf[177]+1,C_fix((C_word)ECHILD));
t17=C_mutate((C_word*)lf[178]+1,C_fix((C_word)ENOMEM));
t18=C_mutate((C_word*)lf[179]+1,C_fix((C_word)EACCES));
t19=C_mutate((C_word*)lf[180]+1,C_fix((C_word)EFAULT));
t20=C_mutate((C_word*)lf[181]+1,C_fix((C_word)EBUSY));
t21=C_mutate((C_word*)lf[182]+1,C_fix((C_word)ENOTDIR));
t22=C_mutate((C_word*)lf[183]+1,C_fix((C_word)EISDIR));
t23=C_mutate((C_word*)lf[184]+1,C_fix((C_word)EINVAL));
t24=C_mutate((C_word*)lf[185]+1,C_fix((C_word)EMFILE));
t25=C_mutate((C_word*)lf[186]+1,C_fix((C_word)ENOSPC));
t26=C_mutate((C_word*)lf[187]+1,C_fix((C_word)ESPIPE));
t27=C_mutate((C_word*)lf[188]+1,C_fix((C_word)EPIPE));
t28=C_mutate((C_word*)lf[189]+1,C_fix((C_word)EAGAIN));
t29=C_mutate((C_word*)lf[190]+1,C_fix((C_word)EROFS));
t30=C_mutate((C_word*)lf[191]+1,C_fix((C_word)EEXIST));
t31=C_mutate((C_word*)lf[192]+1,C_fix((C_word)EWOULDBLOCK));
t32=C_mutate((C_word*)lf[193]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2577,tmp=(C_word)a,a+=2,tmp));
t33=C_mutate((C_word*)lf[195]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2598,tmp=(C_word)a,a+=2,tmp));
t34=C_mutate((C_word*)lf[197]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2619,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[198]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2622,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[199]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2625,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[200]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2628,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[201]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2631,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[203]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2646,tmp=(C_word)a,a+=2,tmp));
t40=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2661,tmp=(C_word)a,a+=2,tmp);
t41=C_mutate((C_word*)lf[205]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2682,a[2]=t40,tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[206]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2688,a[2]=t40,tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[207]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2694,a[2]=t40,tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[208]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2700,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[210]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2715,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[212]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2730,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[214]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2745,tmp=(C_word)a,a+=2,tmp));
t48=*((C_word*)lf[217]+1);
t49=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2776,a[2]=((C_word*)t0)[2],a[3]=t48,tmp=(C_word)a,a+=4,tmp);
t50=(C_word)C_u_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posixunix.scm: 1219 make-string */
t51=*((C_word*)lf[50]+1);
((C_proc3)(void*)(*((C_word*)t51+1)))(3,t51,t49,t50);}

/* k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2776(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word ab[139],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2776,2,t0,t1);}
t2=C_mutate((C_word*)lf[218]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2777,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[220]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2816,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[223]+1,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[224]+1,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[225]+1,C_fix((C_word)STDERR_FILENO));
t7=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2835,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2872,tmp=(C_word)a,a+=2,tmp);
t9=C_mutate((C_word*)lf[234]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2887,a[2]=t7,a[3]=t8,tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[235]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2898,a[2]=t7,a[3]=t8,tmp=(C_word)a,a+=4,tmp));
t11=C_mutate((C_word*)lf[236]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2909,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate((C_word*)lf[242]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2951,tmp=(C_word)a,a+=2,tmp));
t13=C_mutate((C_word*)lf[244]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2972,tmp=(C_word)a,a+=2,tmp));
t14=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3008,tmp=(C_word)a,a+=2,tmp);
t15=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3070,tmp=(C_word)a,a+=2,tmp);
t16=C_mutate((C_word*)lf[248]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3088,a[2]=t14,a[3]=t15,tmp=(C_word)a,a+=4,tmp));
t17=C_mutate((C_word*)lf[250]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3103,a[2]=t14,a[3]=t15,tmp=(C_word)a,a+=4,tmp));
t18=C_mutate((C_word*)lf[252]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3118,a[2]=t14,a[3]=t15,tmp=(C_word)a,a+=4,tmp));
t19=C_mutate((C_word*)lf[254]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3140,tmp=(C_word)a,a+=2,tmp));
t20=C_mutate((C_word*)lf[256]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3165,tmp=(C_word)a,a+=2,tmp));
t21=C_mutate((C_word*)lf[258]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3202,tmp=(C_word)a,a+=2,tmp));
t22=C_mutate((C_word*)lf[260]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3225,tmp=(C_word)a,a+=2,tmp));
t23=C_mutate((C_word*)lf[261]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3236,tmp=(C_word)a,a+=2,tmp));
t24=C_mutate((C_word*)lf[262]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3248,tmp=(C_word)a,a+=2,tmp));
t25=C_mutate((C_word*)lf[263]+1,C_fix((C_word)PROT_READ));
t26=C_mutate((C_word*)lf[264]+1,C_fix((C_word)PROT_WRITE));
t27=C_mutate((C_word*)lf[265]+1,C_fix((C_word)PROT_EXEC));
t28=C_mutate((C_word*)lf[266]+1,C_fix((C_word)PROT_NONE));
t29=C_mutate((C_word*)lf[267]+1,C_fix((C_word)MAP_FIXED));
t30=C_mutate((C_word*)lf[268]+1,C_fix((C_word)MAP_SHARED));
t31=C_mutate((C_word*)lf[269]+1,C_fix((C_word)MAP_PRIVATE));
t32=C_mutate((C_word*)lf[270]+1,C_fix((C_word)MAP_ANON));
t33=C_mutate((C_word*)lf[271]+1,C_fix((C_word)MAP_FILE));
t34=C_mutate((C_word*)lf[272]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3331,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[278]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3389,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[280]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3421,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[281]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3427,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[282]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3433,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[284]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3439,tmp=(C_word)a,a+=2,tmp));
t40=C_mutate((C_word*)lf[285]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3450,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[287]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3467,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[290]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3495,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[294]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3523,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[297]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3551,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[298]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3559,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[300]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3578,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[301]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3581,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[307]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3634,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[308]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3655,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[310]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3682,tmp=(C_word)a,a+=2,tmp));
t51=*((C_word*)lf[313]+1);
t52=*((C_word*)lf[96]+1);
t53=*((C_word*)lf[314]+1);
t54=*((C_word*)lf[315]+1);
t55=C_mutate((C_word*)lf[316]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3694,a[2]=t51,a[3]=t52,a[4]=t53,a[5]=t54,tmp=(C_word)a,a+=6,tmp));
t56=C_mutate((C_word*)lf[320]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3800,tmp=(C_word)a,a+=2,tmp));
t57=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3838,tmp=(C_word)a,a+=2,tmp);
t58=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3846,tmp=(C_word)a,a+=2,tmp);
t59=*((C_word*)lf[322]+1);
t60=C_mutate((C_word*)lf[323]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3854,a[2]=t59,a[3]=t58,a[4]=t57,tmp=(C_word)a,a+=5,tmp));
t61=C_mutate((C_word*)lf[325]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4018,tmp=(C_word)a,a+=2,tmp));
t62=C_mutate((C_word*)lf[327]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4088,tmp=(C_word)a,a+=2,tmp));
t63=C_mutate((C_word*)lf[328]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4091,tmp=(C_word)a,a+=2,tmp));
t64=C_mutate((C_word*)lf[329]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4094,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[330]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4097,tmp=(C_word)a,a+=2,tmp));
t66=*((C_word*)lf[320]+1);
t67=*((C_word*)lf[323]+1);
t68=*((C_word*)lf[332]+1);
t69=C_mutate((C_word*)lf[333]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4118,a[2]=t66,a[3]=t68,a[4]=t67,tmp=(C_word)a,a+=5,tmp));
t70=*((C_word*)lf[123]+1);
t71=*((C_word*)lf[320]+1);
t72=*((C_word*)lf[242]+1);
t73=*((C_word*)lf[48]+1);
t74=*((C_word*)lf[333]+1);
t75=*((C_word*)lf[50]+1);
t76=*((C_word*)lf[51]+1);
t77=*((C_word*)lf[337]+1);
t78=*((C_word*)lf[338]+1);
t79=*((C_word*)lf[55]+1);
t80=*((C_word*)lf[325]+1);
t81=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4164,a[2]=t80,tmp=(C_word)a,a+=3,tmp);
t82=C_mutate((C_word*)lf[339]+1,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4184,a[2]=t71,a[3]=t72,a[4]=t75,a[5]=t77,a[6]=t78,a[7]=t73,a[8]=t81,a[9]=t70,tmp=(C_word)a,a+=10,tmp));
t83=*((C_word*)lf[316]+1);
t84=*((C_word*)lf[317]+1);
t85=*((C_word*)lf[314]+1);
t86=*((C_word*)lf[100]+1);
t87=C_mutate((C_word*)lf[347]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4492,a[2]=t86,a[3]=t85,a[4]=t83,a[5]=t84,tmp=(C_word)a,a+=6,tmp));
t88=C_mutate((C_word*)lf[355]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4721,tmp=(C_word)a,a+=2,tmp));
t89=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t89+1)))(2,t89,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4721(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4721,3,t0,t1,t2);}
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4717,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
/* ##sys#make-c-string */
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t3);}
else{
t5=t4;
f_4717(2,t5,C_SCHEME_FALSE);}}

/* k4715 in set-root-directory! in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4717(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4717,2,t0,t1);}
t2=(C_word)stub925(C_SCHEME_UNDEFINED,t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1845 posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[3],lf[44],lf[355],lf[356],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4492(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_4492r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4492r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4492r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4494,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4636,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4641,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4646,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action881914 */
t9=t8;
f_4646(t9,t1);}
else{
t9=(C_word)C_u_i_car(t4);
t10=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id882912 */
t11=t7;
f_4641(t11,t1,t9);}
else{
t11=(C_word)C_u_i_car(t10);
t12=(C_word)C_slot(t10,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit883909 */
t13=t6;
f_4636(t13,t1,t9,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
/* body879885 */
t15=t5;
f_4494(t15,t1,t9,t11,t13);}}}}

/* def-action881 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4646(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4646,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4652,tmp=(C_word)a,a+=2,tmp);
/* def-id882912 */
t3=((C_word*)t0)[2];
f_4641(t3,t1,t2);}

/* a4651 in def-action881 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4652(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4652,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id882 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4641(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4641,NULL,3,t0,t1,t2);}
/* def-limit883909 */
t3=((C_word*)t0)[2];
f_4636(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit883 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4636(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4636,NULL,4,t0,t1,t2,t3);}
/* body879885 */
t4=((C_word*)t0)[2];
f_4494(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4494(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4494,NULL,5,t0,t1,t2,t3,t4);}
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4498,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=t6,a[10]=((C_word*)t0)[6],a[11]=((C_word*)t0)[7],tmp=(C_word)a,a+=12,tmp);
t8=t4;
if(C_truep(t8)){
t9=(C_word)C_fixnump(t4);
t10=t7;
f_4498(t10,(C_truep(t9)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4631,a[2]=t4,a[3]=t6,tmp=(C_word)a,a+=4,tmp):t4));}
else{
t9=t7;
f_4498(t9,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4623,tmp=(C_word)a,a+=2,tmp));}}

/* f_4623 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4623(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4623,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_4631 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4631(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4631,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4498(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4498,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4615,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4508,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4611,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1817 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],lf[354]);}

/* k4609 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4611(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1817 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4508(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4508,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4510,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_4510(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4510(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4510,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4529,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 1823 directory? */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4529(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4529,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4591,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1824 pathname-file */
t3=*((C_word*)lf[353]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4597,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1830 pproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}}

/* k4595 in k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4597,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4604,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1830 action */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 1831 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_4510(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k4602 in k4595 in k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4604(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1830 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4510(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k4589 in k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4591(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4591,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[348]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[349]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixunix.scm: 1824 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_4510(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4544,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posixunix.scm: 1825 lproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}}

/* k4542 in k4589 in k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4544(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4544,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4554,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4556,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4564,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4578,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1827 ##sys#dynamic-wind */
t11=*((C_word*)lf[352]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posixunix.scm: 1829 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_4510(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a4577 in k4542 in k4589 in k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4578(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4578,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
/* posixunix.scm: 1827 ##sys#void */
t4=*((C_word*)lf[350]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t1);}

/* a4563 in k4542 in k4589 in k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4564(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4564,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4572,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4576,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1828 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[2],lf[351]);}

/* k4574 in a4563 in k4542 in k4589 in k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4576(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1828 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4570 in a4563 in k4542 in k4589 in k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4572(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1828 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4510(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a4555 in k4542 in k4589 in k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4556(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4556,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
/* posixunix.scm: 1827 ##sys#void */
t4=*((C_word*)lf[350]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t1);}

/* k4552 in k4542 in k4589 in k4527 in loop in k4506 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1826 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4510(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_4615 in k4496 in body879 in find-files in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4615(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4615,3,t0,t1,t2);}
/* posixunix.scm: 1815 string-match */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4184(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr3r,(void*)f_4184r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4184r(t0,t1,t2,t3);}}

static void C_ccall f_4184r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(17);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4186,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t2,a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4442,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4447,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args791856 */
t7=t6;
f_4447(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env792854 */
t9=t5;
f_4442(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body789794 */
t11=t4;
f_4186(t11,t1,t7,t9);}}}

/* def-args791 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4447(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4447,NULL,2,t0,t1);}
/* def-env792854 */
t2=((C_word*)t0)[2];
f_4442(t2,t1,C_SCHEME_FALSE);}

/* def-env792 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4442(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4442,NULL,3,t0,t1,t2);}
/* body789794 */
t3=((C_word*)t0)[2];
f_4186(t3,t1,t2,C_SCHEME_FALSE);}

/* body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4186(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4186,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4192,a[2]=((C_word*)t0)[10],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4198,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 1718 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}

/* a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4198(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4198,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4204,a[2]=((C_word*)t0)[12],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4210,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],a[13]=t3,tmp=(C_word)a,a+=14,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}

/* a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4210(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4210,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4214,a[2]=((C_word*)t0)[6],a[3]=t3,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=t1,a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[13],a[12]=t2,tmp=(C_word)a,a+=13,tmp);
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4391,a[2]=((C_word*)t0)[13],a[3]=t2,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[10],a[7]=t3,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[12],a[10]=((C_word*)t0)[5],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1721 process-fork */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t4,t5);}

/* a4390 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4391(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4391,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4395,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=t1,a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1723 file-close */
t3=((C_word*)t0)[6];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4393 in a4390 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4395(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4395,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4398,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
/* posixunix.scm: 1724 file-close */
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4396 in k4393 in a4390 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4398,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4401,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[223]+1),((C_word*)t0)[2]);
if(C_truep(t3)){
t4=t2;
f_4401(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4438,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1726 duplicate-fileno */
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[2],*((C_word*)lf[223]+1));}}

/* k4436 in k4396 in k4393 in a4390 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4438(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1727 file-close */
t2=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4399 in k4396 in k4393 in a4390 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4401(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4401,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4404,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[224]+1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=t2;
f_4404(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4429,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1729 duplicate-fileno */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[4],*((C_word*)lf[224]+1));}}

/* k4427 in k4399 in k4396 in k4393 in a4390 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4429(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1730 file-close */
t2=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4402 in k4399 in k4396 in k4393 in a4390 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4404(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4404,2,t0,t1);}
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 1732 process-execute */
t2=*((C_word*)lf[323]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[5],((C_word*)t0)[2]);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4413,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1733 getenv */
t3=*((C_word*)lf[332]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[346]);}}

/* k4411 in k4402 in k4399 in k4396 in k4393 in a4390 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4413,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[344]);
t3=(C_word)C_a_i_list(&a,2,lf[345],((C_word*)t0)[4]);
/* posixunix.scm: 1734 process-execute */
t4=*((C_word*)lf[323]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t2,t3,((C_word*)t0)[2]);}

/* k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4214(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4214,2,t0,t1);}
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4217,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t3,a[9]=t5,a[10]=t1,a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=((C_word*)t0)[11],a[14]=((C_word*)t0)[12],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 1737 file-close */
t7=((C_word*)t0)[7];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[2]);}

/* k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4217,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4220,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 1738 file-close */
t3=((C_word*)t0)[6];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4220(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4220,2,t0,t1);}
t2=f_1098(((C_word*)t0)[13]);
t3=f_1098(((C_word*)t0)[12]);
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4233,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[12],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 1742 make-string */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,C_fix(256));}

/* k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4233(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[41],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4233,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4235,a[2]=((C_word*)t0)[11],a[3]=t1,a[4]=((C_word*)t0)[12],a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4277,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4346,a[2]=t6,a[3]=t1,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4362,a[2]=((C_word*)t0)[12],a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4378,a[2]=((C_word*)t0)[12],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1761 make-input-port */
t11=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}

/* a4377 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4378(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4378,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4382,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1771 file-close */
t3=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4380 in a4377 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4382(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
/* posixunix.scm: 1773 wait */
t3=((C_word*)t0)[4];
f_4164(t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4361 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4362(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4362,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t3=((C_word*)t0)[2];
t4=(C_word)stub776(C_SCHEME_UNDEFINED,t3);
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_eqp(C_fix(1),t4));}}

/* a4345 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4346(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4346,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4350,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1763 fetch */
t3=((C_word*)t0)[2];
f_4235(t3,t2);}

/* k4348 in a4345 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4350(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_truep((C_word)C_i_greater_or_equalp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]))){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}
else{
t2=((C_word*)((C_word*)t0)[5])[1];
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[5])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[5])+1,t3);
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_subchar(((C_word*)t0)[2],t2));}}

/* k4275 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4277(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4277,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4281,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4283,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4333,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1774 make-output-port */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,t3,t4);}

/* a4332 in k4275 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4333(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4333,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4337,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1790 file-close */
t3=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4335 in a4332 in k4275 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
/* posixunix.scm: 1792 wait */
t3=((C_word*)t0)[4];
f_4164(t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4282 in k4275 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4283(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4283,3,t0,t1,t2);}
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(C_word)C_block_size(((C_word*)t3)[1]);
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4292,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=t6,a[5]=t3,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp));
t10=((C_word*)t8)[1];
f_4292(t10,t1);}

/* loop in a4282 in k4275 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4292(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4292,NULL,2,t0,t1);}
t2=(C_word)C_write(((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
t3=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4308,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1782 yield */
f_1123(t5);}
else{
/* posixunix.scm: 1784 posix-error */
t5=lf[4];
f_1106(t5,t1,lf[44],lf[343],((C_word*)t0)[2],(C_word)C_a_i_list(&a,1,((C_word*)t0)[6]));}}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[4])[1]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4324,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* substring */
t5=*((C_word*)lf[59]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)((C_word*)t0)[5])[1],t2,((C_word*)((C_word*)t0)[4])[1]);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4322 in loop in a4282 in k4275 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4324(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(C_word)C_block_size(((C_word*)((C_word*)t0)[5])[1]);
t4=C_mutate(((C_word *)((C_word*)t0)[4])+1,t3);
/* posixunix.scm: 1788 loop */
t5=((C_word*)((C_word*)t0)[3])[1];
f_4292(t5,((C_word*)t0)[2]);}

/* k4306 in loop in a4282 in k4275 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1783 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4292(t2,((C_word*)t0)[2]);}

/* k4279 in k4275 in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1741 values */
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* fetch in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4235(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4235,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4245,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4249,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_4249(t6,t2);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4249(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4249,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],C_fix(256));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4265,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1752 ##sys#thread-block-for-i/o! */
t6=*((C_word*)lf[341]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,*((C_word*)lf[10]+1),((C_word*)t0)[5],C_SCHEME_TRUE);}
else{
/* posixunix.scm: 1755 posix-error */
t5=lf[4];
f_1106(t5,t1,lf[44],lf[339],lf[342],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[5]));}}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k4263 in loop in fetch in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4265,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4268,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1753 yield */
f_1123(t2);}

/* k4266 in k4263 in loop in fetch in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4268(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1754 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4249(t2,((C_word*)t0)[2]);}

/* k4243 in fetch in k4231 in k4218 in k4215 in k4212 in a4209 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4245(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a4203 in a4197 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4204(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4204,2,t0,t1);}
/* posixunix.scm: 1719 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* a4191 in body789 in process in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4192(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4192,2,t0,t1);}
/* posixunix.scm: 1718 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* wait in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_4164(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4164,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4170,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4176,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t3,t4);}

/* a4175 in wait in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4176(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4176,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1715 ##sys#error */
t5=*((C_word*)lf[104]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t1,lf[339],lf[340],((C_word*)t0)[2],t4);}}

/* a4169 in wait in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4170(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4170,2,t0,t1);}
/* posixunix.scm: 1713 process-wait */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4118(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4118r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4118r(t0,t1,t2,t3);}}

static void C_ccall f_4118r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4125,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1680 process-fork */
t7=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k4123 in process-run in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4125(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4125,2,t0,t1);}
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[6])){
/* posixunix.scm: 1682 process-execute */
t3=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[6]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4140,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1684 getenv */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,lf[336]);}}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k4138 in k4123 in process-run in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4140(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4140,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[334]);
t3=(C_word)C_a_i_list(&a,2,lf[335],((C_word*)t0)[4]);
/* posixunix.scm: 1685 process-execute */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],t2,t3);}

/* process-signal in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4097(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4097r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4097r(t0,t1,t2,t3);}}

static void C_ccall f_4097r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_kill(t2,t5);
t7=(C_word)C_eqp(t6,C_fix(-1));
if(C_truep(t7)){
/* posixunix.scm: 1672 posix-error */
t8=lf[4];
f_1106(t8,t1,lf[153],lf[330],lf[331],(C_word)C_a_i_list(&a,2,t2,t5));}
else{
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,C_SCHEME_UNDEFINED);}}

/* sleep in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4094(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4094,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub746(C_SCHEME_UNDEFINED,t2));}

/* parent-process-id in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4091(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4091,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub743(C_SCHEME_UNDEFINED));}

/* current-process-id in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4088(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4088,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub741(C_SCHEME_UNDEFINED));}

/* process-wait in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_4018(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_4018r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4018r(t0,t1,t2);}}

static void C_ccall f_4018r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a=C_alloc(3);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_u_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t2,C_fix(1)));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_u_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t6,C_fix(1)));
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_truep(t8)?C_fix((C_word)WNOHANG):C_fix(0));
t13=(C_word)C_waitpid(t11,t12);
t14=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t15=(C_word)C_eqp(t13,C_fix(-1));
if(C_truep(t15)){
/* posixunix.scm: 1652 posix-error */
t16=lf[4];
f_1106(t16,t1,lf[153],lf[325],lf[326],(C_word)C_a_i_list(&a,1,t11));}
else{
t16=(C_truep(t14)?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
/* posixunix.scm: 1653 values */
C_values(5,0,t1,t13,t14,t16);}}

/* process-execute in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3854(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr3r,(void*)f_3854r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3854r(t0,t1,t2,t3);}}

static void C_ccall f_3854r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3856,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3968,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3973,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist691721 */
t7=t6;
f_3973(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist692719 */
t9=t5;
f_3968(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body689694 */
t11=t4;
f_3856(t11,t1,t7,t9);}}}

/* def-arglist691 in process-execute in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3973(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3973,NULL,2,t0,t1);}
/* def-envlist692719 */
t2=((C_word*)t0)[2];
f_3968(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist692 in process-execute in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3968(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3968,NULL,3,t0,t1,t2);}
/* body689694 */
t3=((C_word*)t0)[2];
f_3856(t3,t1,t2,C_SCHEME_FALSE);}

/* body689 in process-execute in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3856(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3856,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3860,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t3,a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1615 pathname-strip-directory */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}

/* k3858 in body689 in process-execute in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3860(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3860,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_3838(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3868,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_3868(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do698 in k3858 in body689 in process-execute in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3868(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3868,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_3838(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3881,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3911,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t7=t5;
f_3881(t7,f_3911(t6,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_3881(t6,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_block_size(t4);
t6=f_3838(t3,t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t13=t1;
t14=t7;
t15=t8;
t1=t13;
t2=t14;
t3=t15;
goto loop;}}

/* do702 in do698 in k3858 in body689 in process-execute in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall f_3911(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
loop:
if(C_truep((C_word)C_i_nullp(t1))){
return(f_3846(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=(C_word)C_u_i_car(t1);
t4=(C_word)C_block_size(t3);
t5=f_3846(t2,t3,t4);
t6=(C_word)C_slot(t1,C_fix(1));
t7=(C_word)C_u_fixnum_plus(t2,C_fix(1));
t9=t6;
t10=t7;
t1=t9;
t2=t10;
goto loop;}}

/* k3879 in do698 in k3858 in body689 in process-execute in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3881(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3881,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3884,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3906,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1628 ##sys#expand-home-path */
t4=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3904 in k3879 in do698 in k3858 in body689 in process-execute in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3906(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1628 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3882 in k3879 in do698 in k3858 in body689 in process-execute in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3884(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3884,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub670(C_SCHEME_UNDEFINED);
t5=(C_word)stub682(C_SCHEME_UNDEFINED);
/* posixunix.scm: 1635 posix-error */
t6=lf[4];
f_1106(t6,((C_word*)t0)[3],lf[153],lf[323],lf[324],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall f_3846(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub675(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* setarg in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall f_3838(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub663(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* process-fork in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3800(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3800r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3800r(t0,t1,t2);}}

static void C_ccall f_3800r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=(C_word)stub646(C_SCHEME_UNDEFINED);
t4=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posixunix.scm: 1600 posix-error */
t5=lf[4];
f_1106(t5,t1,lf[153],lf[320],lf[321],C_SCHEME_END_OF_LIST);}
else{
t5=(C_word)C_notvemptyp(t2);
t6=(C_truep(t5)?(C_word)C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3822,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=(C_word)C_slot(t2,C_fix(0));
t9=t8;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t7);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k3820 in process-fork in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3822(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3822,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3826,tmp=(C_word)a,a+=2,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_3826 in k3820 in process-fork in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3826(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3826,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub651(C_SCHEME_UNDEFINED,t2));}

/* glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3694(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_3694r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3694r(t0,t1,t2);}}

static void C_ccall f_3694r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3700,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_3700(t6,t1,t2);}

/* conc in glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3700(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3700,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3715,a[2]=t3,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3721,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}}

/* a3720 in conc in glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3721(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3721,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3725,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3792,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[319]);
/* posixunix.scm: 1584 make-pathname */
t8=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k3790 in a3720 in conc in glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1584 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3723 in a3720 in conc in glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3725(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3725,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3732,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[318]);
/* posixunix.scm: 1585 directory */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k3730 in k3723 in a3720 in conc in glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3732(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3732,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3734,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3734(t5,((C_word*)t0)[2],t1);}

/* loop in k3730 in k3723 in a3720 in conc in glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3734(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3734,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_slot(((C_word*)t0)[7],C_fix(1));
/* posixunix.scm: 1586 conc */
t4=((C_word*)((C_word*)t0)[6])[1];
f_3700(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3751,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_u_i_car(t2);
/* posixunix.scm: 1587 string-match */
t5=*((C_word*)lf[317]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k3749 in loop in k3730 in k3723 in a3720 in conc in glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3751(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3751,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3761,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(t1);
/* posixunix.scm: 1588 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
/* posixunix.scm: 1589 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_3734(t3,((C_word*)t0)[6],t2);}}

/* k3759 in k3749 in loop in k3730 in k3723 in a3720 in conc in glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3761(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3761,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3765,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1588 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_3734(t4,t2,t3);}

/* k3763 in k3759 in k3749 in loop in k3730 in k3723 in a3720 in conc in glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3765(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3765,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a3714 in conc in glob in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3715(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3715,2,t0,t1);}
/* posixunix.scm: 1583 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3682,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3686,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub609(t3),C_fix(0));}

/* k3684 in get-host-name in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3686(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3686,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3689,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3689(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1567 posix-error */
t3=lf[4];
f_1106(t3,t2,lf[311],lf[310],lf[312],C_SCHEME_END_OF_LIST);}}

/* k3687 in k3684 in get-host-name in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-name in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3655(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3655,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3659,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_slot(t2,C_fix(7));
t5=(C_word)C_eqp(lf[81],t4);
t6=(C_truep(t5)?(C_word)C_tty_portp(t2):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t3;
f_3659(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1556 ##sys#error */
t7=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t3,lf[308],lf[309],t2);}}

/* k3657 in terminal-name in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3659,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub602(t4,t3),C_fix(0));}

/* terminal-port? in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3634(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3634,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3638,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1547 ##sys#peek-unsigned-integer */
t4=*((C_word*)lf[241]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,C_fix(0));}

/* k3636 in terminal-port? in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3638(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(t1,C_fix(0));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3581(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3581r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3581r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3581r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(5);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)BUFSIZ));
t7=t3;
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3588,a[2]=t1,a[3]=t6,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t9=(C_word)C_eqp(t7,lf[303]);
if(C_truep(t9)){
t10=t8;
f_3588(2,t10,C_fix((C_word)_IOFBF));}
else{
t10=(C_word)C_eqp(t7,lf[304]);
if(C_truep(t10)){
t11=t8;
f_3588(2,t11,C_fix((C_word)_IOLBF));}
else{
t11=(C_word)C_eqp(t7,lf[305]);
if(C_truep(t11)){
t12=t8;
f_3588(2,t12,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm: 1534 ##sys#error */
t12=*((C_word*)lf[104]+1);
((C_proc6)(void*)(*((C_word*)t12+1)))(6,t12,t8,lf[301],lf[306],t3,t2);}}}}

/* k3586 in set-buffering-mode! in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3588(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(7));
t3=(C_word)C_eqp(lf[81],t2);
t4=(C_truep(t3)?(C_word)C_setvbuf(((C_word*)t0)[4],t1,((C_word*)t0)[3]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
/* posixunix.scm: 1540 ##sys#error */
t5=*((C_word*)lf[104]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,((C_word*)t0)[2],lf[301],lf[302],((C_word*)t0)[4],t1,((C_word*)t0)[3]);}
else{
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3578(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3578,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub588(C_SCHEME_UNDEFINED,t2));}

/* _exit in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3559(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3559r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3559r(t0,t1,t2);}}

static void C_ccall f_3559r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3563,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1516 ##sys#cleanup-before-exit */
t4=*((C_word*)lf[299]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3561 in _exit in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3563(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=t4;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub582(C_SCHEME_UNDEFINED,t3));}

/* local-timezone-abbreviation in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3551(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3551,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub577(t2),C_fix(0));}

/* utc-time->seconds in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3523(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3523,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[294]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3530,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1494 ##sys#error */
t6=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[294],lf[296],t2);}
else{
t6=t4;
f_3530(2,t6,C_SCHEME_UNDEFINED);}}

/* k3528 in utc-time->seconds in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_timegm(((C_word*)t0)[3]))){
/* posixunix.scm: 1496 ##sys#cons-flonum */
t2=*((C_word*)lf[291]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 1497 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[294],lf[295],((C_word*)t0)[3]);}}

/* local-time->seconds in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3495(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3495,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[290]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3502,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1487 ##sys#error */
t6=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[290],lf[293],t2);}
else{
t6=t4;
f_3502(2,t6,C_SCHEME_UNDEFINED);}}

/* k3500 in local-time->seconds in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3502(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixunix.scm: 1489 ##sys#cons-flonum */
t2=*((C_word*)lf[291]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 1490 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[290],lf[292],((C_word*)t0)[3]);}}

/* time->string in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3467(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3467,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[287]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3474,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1480 ##sys#error */
t6=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[287],lf[289],t2);}
else{
t6=t4;
f_3474(2,t6,C_SCHEME_UNDEFINED);}}

/* k3472 in time->string in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3474,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3477,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub562(t4,t3),C_fix(0));}

/* k3475 in k3472 in time->string in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3477,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3480,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3480(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1482 ##sys#error */
t3=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[287],lf[288],((C_word*)t0)[2]);}}

/* k3478 in k3475 in k3472 in time->string in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3480(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->string in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3450(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3450,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3454,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub553(t5,t4),C_fix(0));}

/* k3452 in seconds->string in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3454(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3454,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3457,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3457(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1473 ##sys#error */
t3=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[285],lf[286],((C_word*)t0)[2]);}}

/* k3455 in k3452 in seconds->string in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3457(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->utc-time in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3439(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3439,3,t0,t1,t2);}
/* posixunix.scm: 1467 ##sys#decode-seconds */
t3=*((C_word*)lf[283]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3433(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3433,3,t0,t1,t2);}
/* posixunix.scm: 1463 ##sys#decode-seconds */
t3=*((C_word*)lf[283]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file? in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3427(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3427,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_structurep(t2,lf[273]));}

/* memory-mapped-file-pointer in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3421(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3421,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3389(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3389r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3389r(t0,t1,t2,t3);}}

static void C_ccall f_3389r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t6=(C_word)C_slot(t2,C_fix(1));
t7=(C_truep(t6)?(C_word)C_i_foreign_pointer_argumentp(t6):C_SCHEME_FALSE);
t8=(C_word)stub526(C_SCHEME_UNDEFINED,t7,t5);
t9=(C_word)C_eqp(C_fix(0),t8);
if(C_truep(t9)){
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1450 posix-error */
t10=lf[4];
f_1106(t10,t1,lf[44],lf[278],lf[279],(C_word)C_a_i_list(&a,2,t2,t5));}}

/* map-file-to-memory in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3331(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_3331r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_3331r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_3331r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3335,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_3335(2,t10,t2);}
else{
/* posixunix.scm: 1435 ##sys#null-pointer */
t10=*((C_word*)lf[277]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

/* k3333 in map-file-to-memory in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3335(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3335,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3341,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_3341(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1438 ##sys#signal-hook */
t6=*((C_word*)lf[5]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[53],lf[272],lf[276],t1);}}

/* k3339 in k3333 in map-file-to-memory in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3341(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3341,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)stub501(t7,t8,t3,t4,t5,t6,((C_word*)t0)[3]);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3347,a[2]=((C_word*)t0)[7],a[3]=t9,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3360,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t10,tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1440 ##sys#pointer->address */
t12=*((C_word*)lf[275]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t9);}

/* k3358 in k3339 in k3333 in map-file-to-memory in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3360(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3360,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1441 posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[8],lf[44],lf[272],lf[274],(C_word)C_a_i_list(&a,6,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[8];
f_3347(2,t3,C_SCHEME_UNDEFINED);}}

/* k3345 in k3339 in k3333 in map-file-to-memory in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3347(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3347,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[273],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3248(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3248,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3254,a[2]=t3,tmp=(C_word)a,a+=3,tmp));
t5=((C_word*)t3)[1];
f_3254(t5,t1,C_fix(0));}

/* loop in current-environment in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3254(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3254,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3258,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub479(t5,t4),C_fix(0));}

/* k3256 in loop in current-environment in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3258(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3258,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3266,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp));
t5=((C_word*)t3)[1];
f_3266(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k3256 in loop in current-environment in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3266(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3266,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3292,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1399 ##sys#substring */
t5=*((C_word*)lf[59]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1402 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k3290 in scan in k3256 in loop in current-environment in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3292,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3296,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 1400 ##sys#substring */
t5=*((C_word*)lf[59]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[2],t3,t4);}

/* k3294 in k3290 in scan in k3256 in loop in current-environment in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3296(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3296,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3284,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1401 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_3254(t5,t3,t4);}

/* k3282 in k3294 in k3290 in scan in k3256 in loop in current-environment in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3284(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3284,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3236(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3236,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3241,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1388 ##sys#make-c-string */
t4=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k3239 in unsetenv in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3241(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3225(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3225,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3230,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1383 ##sys#make-c-string */
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3228 in setenv in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3230(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3230,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3234,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1383 ##sys#make-c-string */
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3232 in k3228 in setenv in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3234(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3202(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3202,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3206,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3223,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1372 ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3221 in fifo? in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3223(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1372 ##sys#file-info */
t2=*((C_word*)lf[101]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3204 in fifo? in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3206,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
/* posixunix.scm: 1375 posix-error */
t2=lf[4];
f_1106(t2,((C_word*)t0)[3],lf[44],lf[258],lf[259],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* create-fifo in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3165(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3165r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3165r(t0,t1,t2,t3);}}

static void C_ccall f_3165r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3169,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t5=t4;
f_3169(t5,(C_word)C_slot(t3,C_fix(0)));}
else{
t5=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t6=t4;
f_3169(t6,(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXU),t5));}}

/* k3167 in create-fifo in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3169(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3169,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3183,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3187,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1366 ##sys#expand-home-path */
t4=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3185 in k3167 in create-fifo in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3187(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1366 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3181 in k3167 in create-fifo in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3183(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3183,2,t0,t1);}
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1367 posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[3],lf[44],lf[256],lf[257],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-unlock in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3140(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3140,3,t0,t1,t2);}
t3=(C_word)C_slot(t2,C_fix(2));
t4=(C_word)C_slot(t2,C_fix(3));
t5=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t3,t4);
t6=(C_word)C_slot(t2,C_fix(1));
t7=(C_word)C_flock_lock(t6);
if(C_truep((C_word)C_fixnum_lessp(t7,C_fix(0)))){
/* posixunix.scm: 1352 posix-error */
t8=lf[4];
f_1106(t8,t1,lf[44],lf[254],lf[255],(C_word)C_a_i_list(&a,1,t2));}
else{
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,C_SCHEME_UNDEFINED);}}

/* file-test-lock in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3118(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3118r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3118r(t0,t1,t2,t3);}}

static void C_ccall f_3118r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3122,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1343 setup */
f_3008(t4,t2,t3);}

/* k3120 in file-test-lock in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3122(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
/* posixunix.scm: 1345 err */
f_3070(((C_word*)t0)[3],lf[253],t1,lf[252]);}}

/* file-lock/blocking in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3103(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3103r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3103r(t0,t1,t2,t3);}}

static void C_ccall f_3103r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3107,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1337 setup */
f_3008(t4,t2,t3);}

/* k3105 in file-lock/blocking in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3107(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1339 err */
f_3070(((C_word*)t0)[2],lf[251],t1,lf[250]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3088(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3088r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3088r(t0,t1,t2,t3);}}

static void C_ccall f_3088r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3092,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1331 setup */
f_3008(t4,t2,t3);}

/* k3090 in file-lock in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_3092(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1333 err */
f_3070(((C_word*)t0)[2],lf[249],t1,lf[248]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3070(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3070,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_slot(t3,C_fix(2));
t7=(C_word)C_slot(t3,C_fix(3));
/* posixunix.scm: 1328 posix-error */
t8=lf[4];
f_1106(t8,t1,lf[44],t4,t2,(C_word)C_a_i_list(&a,3,t5,t6,t7));}

/* setup in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3008(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3008,NULL,3,t1,t2,t3);}
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_fix(0):(C_word)C_u_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t3,C_fix(1)));
t8=(C_word)C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:(C_word)C_u_i_car(t7));
t10=t9;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(C_word)C_i_nullp(t7);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t7,C_fix(1)));
t14=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3027,a[2]=t1,a[3]=t11,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t15=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)t11)[1]);
if(C_truep(t15)){
t16=C_set_block_item(t11,0,C_fix(0));
t17=t14;
f_3027(t17,t16);}
else{
t16=t14;
f_3027(t16,C_SCHEME_UNDEFINED);}}

/* k3025 in setup in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_3027(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3027,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[247],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2972(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2972,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2986,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2993,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2997,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1303 ##sys#expand-home-path */
t7=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t5=t4;
f_2986(2,t5,(C_word)C_ftruncate(t2,t3));}
else{
/* posixunix.scm: 1305 ##sys#error */
t5=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,lf[244],lf[246],t2);}}}

/* k2995 in file-truncate in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2997(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1303 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2991 in file-truncate in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2993(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2986(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k2984 in file-truncate in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2986(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2986,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1307 posix-error */
t2=lf[4];
f_1106(t2,((C_word*)t0)[4],lf[44],lf[244],lf[245],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* duplicate-fileno in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2951(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_2951r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_2951r(t0,t1,t2,t3);}}

static void C_ccall f_2951r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2955,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t5=t4;
f_2955(t5,(C_word)C_dup(t2));}
else{
t5=(C_word)C_slot(t3,C_fix(0));
t6=t4;
f_2955(t6,(C_word)C_dup2(t2,t5));}}

/* k2953 in duplicate-fileno in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_2955(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2955,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2958,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1291 posix-error */
t3=lf[4];
f_1106(t3,t2,lf[44],lf[242],lf[243],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=t2;
f_2958(2,t3,C_SCHEME_UNDEFINED);}}

/* k2956 in k2953 in duplicate-fileno in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2958(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2909(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2909,3,t0,t1,t2);}
t3=(C_word)C_slot(t2,C_fix(7));
t4=(C_word)C_eqp(lf[237],t3);
if(C_truep(t4)){
/* posixunix.scm: 1274 ##sys#tcp-port->fileno */
t5=*((C_word*)lf[238]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t2);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2945,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1275 ##sys#peek-unsigned-integer */
t6=*((C_word*)lf[241]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,C_fix(0));}}

/* k2943 in port->fileno in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2945(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2945,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixunix.scm: 1280 posix-error */
t2=lf[4];
f_1106(t2,((C_word*)t0)[3],lf[53],lf[236],lf[239],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2928,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1278 posix-error */
t4=lf[4];
f_1106(t4,t3,lf[44],lf[236],lf[240],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=t3;
f_2928(2,t4,C_SCHEME_UNDEFINED);}}}

/* k2926 in k2943 in port->fileno in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2928(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2898(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2898r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2898r(t0,t1,t2,t3);}}

static void C_ccall f_2898r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2907,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1269 mode */
f_2835(t4,C_SCHEME_FALSE,t3);}

/* k2905 in open-output-file* in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2907,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1269 check */
f_2872(((C_word*)t0)[2],lf[235],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2887(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2887r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2887r(t0,t1,t2,t3);}}

static void C_ccall f_2887r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2896,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1265 mode */
f_2835(t4,C_SCHEME_TRUE,t3);}

/* k2894 in open-input-file* in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2896(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2896,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1265 check */
f_2872(((C_word*)t0)[2],lf[234],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_2872(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2872,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1258 posix-error */
t6=lf[4];
f_1106(t6,t1,lf[44],t2,lf[232],(C_word)C_a_i_list(&a,1,t3));}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2885,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1259 ##sys#make-port */
t7=*((C_word*)lf[107]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[108]+1),lf[233],lf[81]);}}

/* k2883 in check in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_2835(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2835,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2843,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_u_i_car(t3);
t6=(C_word)C_eqp(t5,lf[226]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixunix.scm: 1252 ##sys#error */
t8=*((C_word*)lf[104]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[227],t5);}
else{
t8=t4;
f_2843(2,t8,lf[228]);}}
else{
/* posixunix.scm: 1253 ##sys#error */
t7=*((C_word*)lf[104]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[229],t5);}}
else{
t5=t4;
f_2843(2,t5,(C_truep(t2)?lf[230]:lf[231]));}}

/* k2841 in mode in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2843(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1248 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-link in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2816(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2816,4,t0,t1,t2,t3);}
t4=t2;
t5=t3;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2805,a[2]=t5,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t4)){
/* ##sys#make-c-string */
t7=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}
else{
t7=t6;
f_2805(2,t7,C_SCHEME_FALSE);}}

/* k2803 in file-link in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2805(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2805,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2809,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[2])){
/* ##sys#make-c-string */
t3=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t3=t2;
f_2809(2,t3,C_SCHEME_FALSE);}}

/* k2807 in k2803 in file-link in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2809(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2809,2,t0,t1);}
t2=(C_word)stub377(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1233 posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[4],lf[44],lf[221],lf[222],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* read-symbolic-link in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2777(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2777,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2782,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2798,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1222 ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2796 in read-symbolic-link in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2798(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1222 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2780 in read-symbolic-link in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2782(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2782,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2785,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1224 posix-error */
t4=lf[4];
f_1106(t4,t3,lf[44],lf[218],lf[219],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t4=t3;
f_2785(2,t4,C_SCHEME_UNDEFINED);}}

/* k2783 in k2780 in read-symbolic-link in k2774 in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2785(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1225 substring */
t2=((C_word*)t0)[5];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2745(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2745,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2760,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2772,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1210 ##sys#expand-home-path */
t6=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2770 in create-symbolic-link in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2772(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1210 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2758 in create-symbolic-link in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2760(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2760,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2764,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2768,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1211 ##sys#expand-home-path */
t4=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2766 in k2758 in create-symbolic-link in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2768(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1211 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2762 in k2758 in create-symbolic-link in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2764,2,t0,t1);}
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1213 posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[4],lf[44],lf[215],lf[216],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* set-process-group-id! in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2730(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2730,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setpgid(t2,t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2740,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1198 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2738 in set-process-group-id! in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2740(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1199 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[212],lf[213],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* process-group-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2715(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2715,3,t0,t1,t2);}
t3=(C_word)C_getpgid(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2719,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2725,a[2]=t2,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1190 ##sys#update-errno */
t6=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t4;
f_2719(2,t5,C_SCHEME_UNDEFINED);}}

/* k2723 in process-group-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2725(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1191 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[210],lf[211],((C_word*)t0)[2]);}

/* k2717 in process-group-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2719(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* create-session in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2700,2,t0,t1);}
t2=(C_word)C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2704,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2710,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1182 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2704(2,t4,C_SCHEME_UNDEFINED);}}

/* k2708 in create-session in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2710(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1183 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[208],lf[209]);}

/* k2702 in create-session in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2694(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2694,3,t0,t1,t2);}
/* posixunix.scm: 1177 check */
f_2661(t1,t2,C_fix((C_word)X_OK));}

/* file-write-access? in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2688(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2688,3,t0,t1,t2);}
/* posixunix.scm: 1176 check */
f_2661(t1,t2,C_fix((C_word)W_OK));}

/* file-read-access? in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2682(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2682,3,t0,t1,t2);}
/* posixunix.scm: 1175 check */
f_2661(t1,t2,C_fix((C_word)R_OK));}

/* check in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_2661(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2661,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2676,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2680,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1172 ##sys#expand-home-path */
t6=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2678 in check in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2680(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1172 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2674 in check in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2676(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2676,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2668,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_2668(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1173 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2666 in k2674 in check in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* set-group-id! in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2646(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2646,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2656,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1162 ##sys#update-errno */
t4=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2654 in set-group-id! in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1163 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[201],lf[204],((C_word*)t0)[2]);}

/* set-user-id! in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2631(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2631,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2641,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1156 ##sys#update-errno */
t4=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2639 in set-user-id! in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1157 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[201],lf[202],((C_word*)t0)[2]);}

/* current-effective-group-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2628(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2628,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub339(C_SCHEME_UNDEFINED));}

/* current-effective-user-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2625(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2625,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub337(C_SCHEME_UNDEFINED));}

/* current-group-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2622,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub335(C_SCHEME_UNDEFINED));}

/* current-user-id in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2619,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub333(C_SCHEME_UNDEFINED));}

/* change-file-owner in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2598(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2598,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2613,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2617,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1145 ##sys#expand-home-path */
t7=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k2615 in change-file-owner in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2617(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1145 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2611 in change-file-owner in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2613(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2613,2,t0,t1);}
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1146 posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[3],lf[44],lf[195],lf[196],(C_word)C_a_i_list(&a,3,((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2577(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2577,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2592,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2596,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1137 ##sys#expand-home-path */
t6=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2594 in change-file-mode in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2596(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1137 ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2590 in change-file-mode in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2592(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2592,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1138 posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[3],lf[44],lf[193],lf[194],(C_word)C_a_i_list(&a,2,((C_word*)t0)[2],((C_word*)t0)[4]));}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* initialize-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2535(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2535,4,t0,t1,t2,t3);}
t4=t2;
t5=t3;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2531,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t4)){
/* ##sys#make-c-string */
t7=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}
else{
t7=t6;
f_2531(2,t7,C_SCHEME_FALSE);}}

/* k2529 in initialize-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2531(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2531,2,t0,t1);}
t2=(C_word)stub311(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[5]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2545,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1068 ##sys#update-errno */
t4=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2543 in k2529 in initialize-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2545(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1069 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[168],lf[169],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2472(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2472,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2476,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_2406(t4);
if(C_truep(t5)){
t6=t3;
f_2476(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1051 ##sys#error */
t6=*((C_word*)lf[104]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[165],lf[167]);}}

/* k2474 in set-groups! in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2476,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2481,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_2481(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* do299 in k2474 in set-groups! in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_2481(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2481,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2497,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1056 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_set_gid(t3,t4);
t6=(C_word)C_slot(t2,C_fix(1));
t7=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t10=t1;
t11=t6;
t12=t7;
t1=t10;
t2=t11;
t3=t12;
goto loop;}}

/* k2495 in do299 in k2474 in set-groups! in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2497(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1057 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[165],lf[166],((C_word*)t0)[2]);}

/* get-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2409(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2409,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2413,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2467,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1037 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2413(2,t4,C_SCHEME_UNDEFINED);}}

/* k2465 in get-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1038 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[161],lf[164]);}

/* k2411 in get-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2413,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2416,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_2406(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_2416(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1040 ##sys#error */
t4=*((C_word*)lf[104]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[161],lf[163]);}}

/* k2414 in k2411 in get-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2416(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2416,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2419,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)stub281(C_SCHEME_UNDEFINED,((C_word*)t0)[3]);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2448,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1042 ##sys#update-errno */
t5=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_2419(2,t4,C_SCHEME_UNDEFINED);}}

/* k2446 in k2414 in k2411 in get-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2448(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1043 ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[161],lf[162]);}

/* k2417 in k2414 in k2411 in get-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2419(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2419,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2424,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_2424(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k2417 in k2414 in k2411 in get-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_2424(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2424,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2438,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1047 loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k2436 in loop in k2417 in k2414 in k2411 in get-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2438(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2438,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall f_2406(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub285(C_SCHEME_UNDEFINED,t1));}

/* group-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2352(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2352,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2356,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2356(t4,(C_word)C_getgrgid(t2));}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2401,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1012 ##sys#make-c-string */
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}}

/* k2399 in group-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2401(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2356(t2,(C_word)C_getgrnam(t1));}

/* k2354 in group-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_2356(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2356,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2366,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2364 in k2354 in group-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2366(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2366,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2370,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k2368 in k2364 in k2354 in group-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2370(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2370,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2374,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2376,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t6=((C_word*)t4)[1];
f_2376(t6,t2,C_fix(0));}

/* rec in k2368 in k2364 in k2354 in group-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_2376(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2376,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2380,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub270(t5,t4),C_fix(0));}

/* k2378 in rec in k2368 in k2364 in k2354 in group-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2380(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2380,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2390,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1020 rec */
t4=((C_word*)((C_word*)t0)[2])[1];
f_2376(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k2388 in k2378 in rec in k2368 in k2364 in k2354 in group-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2390(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2390,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k2372 in k2368 in k2364 in k2354 in group-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2374(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2374,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,4,((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1));}

/* user-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2307(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2307,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2311,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2311(t4,(C_word)C_getpwuid(t2));}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2344,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 989  ##sys#make-c-string */
t5=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}}

/* k2342 in user-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2344(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2311(t2,(C_word)C_getpwnam(t1));}

/* k2309 in user-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_2311(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2311,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2321,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2319 in k2309 in user-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2321(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2321,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2325,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k2323 in k2319 in k2309 in user-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2325(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2325,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2329,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k2327 in k2323 in k2319 in k2309 in user-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2329(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2329,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2333,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k2331 in k2327 in k2323 in k2319 in k2309 in user-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2333(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2333,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2337,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k2335 in k2331 in k2327 in k2323 in k2319 in k2309 in user-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2337,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,7,((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* system-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2269(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2269,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2273,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2302,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 968  ##sys#update-errno */
t4=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_2273(2,t3,C_SCHEME_UNDEFINED);}}

/* k2300 in system-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2302(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 969  ##sys#error */
t2=*((C_word*)lf[104]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[155],lf[157]);}

/* k2271 in system-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2273(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2273,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2280,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k2278 in k2271 in system-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2280(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2280,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2284,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k2282 in k2278 in k2271 in system-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2284(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2284,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2288,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k2286 in k2282 in k2278 in k2271 in system-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2288(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2288,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2292,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k2290 in k2286 in k2282 in k2278 in k2271 in system-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2292,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2296,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k2294 in k2290 in k2286 in k2282 in k2278 in k2271 in system-information in k2265 in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2296(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2296,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* set-signal-mask! in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2248(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2248,3,t0,t1,t2);}
t3=(C_word)C_sigemptyset(C_fix(0));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2252,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2263,tmp=(C_word)a,a+=2,tmp);
/* for-each */
t6=*((C_word*)lf[63]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,t5,t2);}

/* a2262 in set-signal-mask! in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2263(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2263,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_sigaddset(t2));}

/* k2250 in set-signal-mask! in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2252(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 942  posix-error */
t2=lf[4];
f_1106(t2,((C_word*)t0)[2],lf[153],lf[152],lf[154],C_SCHEME_END_OF_LIST);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#interrupt-hook in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2230(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2230,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2240,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 928  h */
t6=t4;
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
/* posixunix.scm: 930  oldhook */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t2,t3);}}

/* k2238 in ##sys#interrupt-hook in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2240(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 929  ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k2216 in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2220(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2220,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?t2:C_SCHEME_FALSE);
t5=(C_word)C_establish_signal_handler(t2,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)C_i_setslot(((C_word*)t0)[2],t2,t3));}

/* create-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2177(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2177,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2181,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posixunix.scm: 854  posix-error */
t3=lf[4];
f_1106(t3,t2,lf[44],lf[123],lf[124],C_SCHEME_END_OF_LIST);}
else{
t3=t2;
f_2181(2,t3,C_SCHEME_UNDEFINED);}}

/* k2179 in create-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2181(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 855  values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2157(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2157r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2157r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2157r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[122]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2161,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2159 in with-output-to-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2161,2,t0,t1);}
t2=C_mutate((C_word*)lf[122]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2167,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 842  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2166 in k2159 in with-output-to-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2167(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2167r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2167r(t0,t1,t2);}}

static void C_ccall f_2167r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2171,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 844  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2169 in a2166 in k2159 in with-output-to-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[122]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2137(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2137r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2137r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2137r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[120]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2141,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2139 in with-input-from-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2141(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2141,2,t0,t1);}
t2=C_mutate((C_word*)lf[120]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2147,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 832  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2146 in k2139 in with-input-from-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2147(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2147r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2147r(t0,t1,t2);}}

static void C_ccall f_2147r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2151,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 834  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2149 in a2146 in k2139 in with-input-from-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2151(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[120]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2113(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2113r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2113r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2113r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2117,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2115 in call-with-output-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2117(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2117,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2122,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2128,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 822  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2127 in k2115 in call-with-output-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2128(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2128r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2128r(t0,t1,t2);}}

static void C_ccall f_2128r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2132,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 825  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2130 in a2127 in k2115 in call-with-output-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2132(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2121 in k2115 in call-with-output-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2122(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2122,2,t0,t1);}
/* posixunix.scm: 823  proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2089(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2089r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2089r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2089r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2093,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2091 in call-with-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2093(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2093,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2098,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2104,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 814  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2103 in k2091 in call-with-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2104(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2104r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2104r(t0,t1,t2);}}

static void C_ccall f_2104r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2108,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 817  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2106 in a2103 in k2091 in call-with-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2097 in k2091 in call-with-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2098(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2098,2,t0,t1);}
/* posixunix.scm: 815  proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2076(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2076,3,t0,t1,t2);}
t3=(C_word)close_pipe(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2080,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t5)){
/* posixunix.scm: 803  posix-error */
t6=lf[4];
f_1106(t6,t4,lf[44],lf[114],lf[115],(C_word)C_a_i_list(&a,1,t2));}
else{
t6=t4;
f_2080(2,t6,C_SCHEME_UNDEFINED);}}

/* k2078 in close-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2043(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2043r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2043r(t0,t1,t2,t3);}}

static void C_ccall f_2043r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(11);
t4=f_1977(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2054,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[103]);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2061,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 796  ##sys#make-c-string */
t8=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(C_word)C_eqp(t4,lf[111]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2071,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 797  ##sys#make-c-string */
t9=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
/* posixunix.scm: 798  badmode */
f_1989(t5,t4);}}}

/* k2069 in open-output-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2071(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2071,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2054(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k2059 in open-output-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2061,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2054(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k2052 in open-output-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2054(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 792  check */
f_1995(((C_word*)t0)[3],lf[112],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2010(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2010r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2010r(t0,t1,t2,t3);}}

static void C_ccall f_2010r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(11);
t4=f_1977(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2021,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[103]);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2028,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 785  ##sys#make-c-string */
t8=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(C_word)C_eqp(t4,lf[111]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2038,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 786  ##sys#make-c-string */
t9=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
/* posixunix.scm: 787  badmode */
f_1989(t5,t4);}}}

/* k2036 in open-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2038,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2021(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k2026 in open-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2028,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2021(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k2019 in open-input-pipe in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 781  check */
f_1995(((C_word*)t0)[3],lf[110],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1995(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1995,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 773  posix-error */
t6=lf[4];
f_1106(t6,t1,lf[44],t2,lf[106],(C_word)C_a_i_list(&a,1,t3));}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2008,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 774  ##sys#make-port */
t7=*((C_word*)lf[107]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[108]+1),lf[109],lf[81]);}}

/* k2006 in check in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_2008(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1989(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1989,NULL,2,t1,t2);}
/* posixunix.scm: 770  ##sys#error */
t3=*((C_word*)lf[104]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[105],t2);}

/* mode in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall f_1977(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[103]));}

/* current-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1937(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_1937r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1937r(t0,t1,t2);}}

static void C_ccall f_1937r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1941,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_1941(t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_slot(t2,C_fix(1));
t5=(C_word)C_i_nullp(t4);
t6=t3;
f_1941(t6,(C_truep(t5)?(C_word)C_u_i_car(t2):C_SCHEME_TRUE));}}

/* k1939 in current-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1941(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1941,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 753  change-directory */
t2=*((C_word*)lf[91]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1950,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 754  make-string */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix(256));}}

/* k1948 in k1939 in current-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1950(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_curdir(t1);
if(C_truep(t2)){
/* posixunix.scm: 757  ##sys#substring */
t3=*((C_word*)lf[59]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[2],t1,C_fix(0),t2);}
else{
/* posixunix.scm: 758  posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[2],lf[44],lf[99],lf[102],C_SCHEME_END_OF_LIST);}}

/* directory? in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1917(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1917,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1921,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1935,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 746  ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1933 in directory? in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1935(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 746  ##sys#file-info */
t2=*((C_word*)lf[101]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1919 in directory? in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1766(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_1766r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1766r(t0,t1,t2);}}

static void C_ccall f_1766r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1768,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1863,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1868,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec140164 */
t6=t5;
f_1868(t6,t1);}
else{
t6=(C_word)C_u_i_car(t2);
t7=(C_word)C_slot(t2,C_fix(1));
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?141162 */
t8=t4;
f_1863(t8,t1,t6);}
else{
t8=(C_word)C_u_i_car(t7);
t9=(C_word)C_slot(t7,C_fix(1));
/* body138143 */
t10=t3;
f_1768(t10,t1,t6,t8);}}}

/* def-spec140 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1868(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1868,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1876,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 719  current-directory */
t3=*((C_word*)lf[99]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1874 in def-spec140 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1876(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?141162 */
t2=((C_word*)t0)[3];
f_1863(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?141 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1863(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1863,NULL,3,t0,t1,t2);}
/* body138143 */
t3=((C_word*)t0)[2];
f_1768(t3,t1,t2,C_SCHEME_FALSE);}

/* body138 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1768(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1768,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1772,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 721  make-string */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,C_fix(256));}

/* k1770 in body138 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1772(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1772,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1775,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 722  ##sys#make-pointer */
t3=*((C_word*)lf[98]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1773 in k1770 in body138 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1775(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1775,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1778,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 723  ##sys#make-pointer */
t3=*((C_word*)lf[98]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1776 in k1773 in k1770 in body138 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1778,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1782,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1862,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 724  ##sys#expand-home-path */
t4=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k1860 in k1776 in k1773 in k1770 in body138 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1862(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 724  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1780 in k1776 in k1773 in k1770 in body138 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1782(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1782,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
/* posixunix.scm: 726  posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[6],lf[44],lf[96],lf[97],(C_word)C_a_i_list(&a,1,((C_word*)t0)[5]));}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1796,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_1796(t6,((C_word*)t0)[6]);}}

/* loop in k1780 in k1776 in k1773 in k1770 in body138 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1796(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1796,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1806,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 734  ##sys#substring */
t5=*((C_word*)lf[59]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k1804 in loop in k1780 in k1776 in k1773 in k1770 in body138 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1806(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1806,2,t0,t1);}
t2=(C_word)C_subchar(t1,C_fix(0));
t3=(C_word)C_fixnum_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_subchar(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1818,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_1818(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_1818(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_1818(t7,C_SCHEME_FALSE);}}

/* k1816 in k1804 in loop in k1780 in k1776 in k1773 in k1770 in body138 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1818(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1818,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 741  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_1796(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1828,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 742  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_1796(t3,t2);}}

/* k1826 in k1816 in k1804 in loop in k1780 in k1776 in k1773 in k1770 in body138 in directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1828,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1745(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1745,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1760,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1764,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 712  ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1762 in delete-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 712  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1758 in delete-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1760(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1760,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 713  posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[3],lf[44],lf[93],lf[94],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* change-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1724(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1724,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1739,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1743,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 706  ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1741 in change-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1743(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 706  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1737 in change-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1739(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1739,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 707  posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[3],lf[44],lf[91],lf[92],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* create-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1703(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1703,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1718,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1722,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 700  ##sys#expand-home-path */
t5=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1720 in create-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1722(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 700  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1716 in create-directory in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1718(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1718,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 701  posix-error */
t3=lf[4];
f_1106(t3,((C_word*)t0)[3],lf[44],lf[89],lf[90],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}}

/* set-file-position! in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1651(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1651r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1651r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1651r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1658,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm: 686  ##sys#signal-hook */
t8=*((C_word*)lf[5]+1);
((C_proc7)(void*)(*((C_word*)t8+1)))(7,t8,t7,lf[87],lf[84],lf[88],t3,t2);}
else{
t8=t7;
f_1658(2,t8,C_SCHEME_UNDEFINED);}}

/* k1656 in set-file-position! in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1658(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1658,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1664,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1670,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 687  port? */
t4=*((C_word*)lf[83]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k1668 in k1656 in set-file-position! in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[81]);
t4=((C_word*)t0)[4];
f_1664(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_1664(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixunix.scm: 691  ##sys#signal-hook */
t2=*((C_word*)lf[5]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[53],lf[84],lf[86],((C_word*)t0)[5]);}}}

/* k1662 in k1656 in set-file-position! in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1664(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1664,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 692  posix-error */
t2=lf[4];
f_1106(t2,((C_word*)t0)[4],lf[44],lf[84],lf[85],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}}

/* file-position in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1614(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1614,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1618,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1630,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 671  port? */
t5=*((C_word*)lf[83]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1628 in file-position in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1630(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[81]);
t4=((C_word*)t0)[2];
f_1618(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_1618(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixunix.scm: 676  ##sys#signal-hook */
t2=*((C_word*)lf[5]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[53],lf[79],lf[82],((C_word*)t0)[3]);}}}

/* k1616 in file-position in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1618(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1618,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1621,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 678  posix-error */
t3=lf[4];
f_1106(t3,t2,lf[44],lf[79],lf[80],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t3=t2;
f_1621(2,t3,C_SCHEME_UNDEFINED);}}

/* k1619 in k1616 in file-position in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1621(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* symbolic-link? in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1608(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1608,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1612,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 666  ##sys#stat */
f_1500(t3,t2,C_SCHEME_TRUE,lf[78]);}

/* k1610 in symbolic-link? in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1612(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* regular-file? in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1602(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1602,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1606,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 661  ##sys#stat */
f_1500(t3,t2,C_SCHEME_TRUE,lf[77]);}

/* k1604 in regular-file? in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* file-permissions in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1596(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1596,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1600,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 657  ##sys#stat */
f_1500(t3,t2,C_SCHEME_FALSE,lf[76]);}

/* k1598 in file-permissions in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1600(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1590(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1590,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1594,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 656  ##sys#stat */
f_1500(t3,t2,C_SCHEME_FALSE,lf[75]);}

/* k1592 in file-owner in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1594(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1584(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1584,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1588,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 655  ##sys#stat */
f_1500(t3,t2,C_SCHEME_FALSE,lf[74]);}

/* k1586 in file-change-time in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1588(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1588,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1578(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1578,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1582,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 654  ##sys#stat */
f_1500(t3,t2,C_SCHEME_FALSE,lf[73]);}

/* k1580 in file-access-time in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1582(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1582,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1572(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1572,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1576,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 653  ##sys#stat */
f_1500(t3,t2,C_SCHEME_FALSE,lf[72]);}

/* k1574 in file-modification-time in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1576(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1576,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1566(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1566,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1570,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 652  ##sys#stat */
f_1500(t3,t2,C_SCHEME_FALSE,lf[71]);}

/* k1568 in file-size in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1537(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_1537r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1537r(t0,t1,t2,t3);}}

static void C_ccall f_1537r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(7);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1541,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1548,a[2]=t2,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t6=t5;
f_1548(t6,C_SCHEME_FALSE);}
else{
t6=(C_word)C_slot(t3,C_fix(1));
t7=(C_word)C_i_nullp(t6);
t8=t5;
f_1548(t8,(C_truep(t7)?(C_word)C_u_i_car(t3):C_SCHEME_TRUE));}}

/* k1546 in file-stat in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1548(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 647  ##sys#stat */
f_1500(((C_word*)t0)[3],((C_word*)t0)[2],t1,lf[70]);}

/* k1539 in file-stat in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1541(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1541,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,9,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime)));}

/* ##sys#stat in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1500(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1500,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1504,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_1504(2,t6,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1525,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1532,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 634  ##sys#expand-home-path */
t8=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
/* posixunix.scm: 642  ##sys#signal-hook */
t6=*((C_word*)lf[5]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[53],lf[69],t2);}}}

/* k1530 in ##sys#stat in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1532(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 634  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1523 in ##sys#stat in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1525(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1504(2,t2,(C_truep(((C_word*)t0)[2])?(C_word)C_lstat(t1):(C_word)C_stat(t1)));}

/* k1502 in ##sys#stat in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1504(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1504,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 644  posix-error */
t2=lf[4];
f_1106(t2,((C_word*)t0)[4],lf[44],((C_word*)t0)[3],lf[68],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1323(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1323r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1323r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1323r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(15);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_slot(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_1317(C_fix(0));
t10=f_1317(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1339,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_1339(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
/* posixunix.scm: 567  fd_set */
t14=t12;
f_1339(2,t14,f_1319(C_fix(0),t2));}
else{
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1484,a[2]=((C_word*)t0)[2],a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* for-each */
t14=*((C_word*)lf[63]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t12,t13,t2);}}}

/* a1483 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1484(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1484,3,t0,t1,t2);}
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 574  fd_set */
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,f_1319(C_fix(0),t2));}

/* k1337 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1339(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1339,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1345,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_1345(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
/* posixunix.scm: 579  fd_set */
t5=t3;
f_1345(2,t5,f_1319(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1464,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t5=*((C_word*)lf[63]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,t4,((C_word*)t0)[8]);}}}

/* a1463 in k1337 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1464(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1464,3,t0,t1,t2);}
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 586  fd_set */
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,f_1319(C_fix(1),t2));}

/* k1343 in k1337 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1345,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1348,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_1348(t4,(C_word)C_C_select_t(t3,((C_word*)t0)[3]));}
else{
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_1348(t4,(C_word)C_C_select(t3));}}

/* k1346 in k1343 in k1337 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1348(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1348,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 593  posix-error */
t2=lf[4];
f_1106(t2,((C_word*)t0)[5],lf[44],lf[61],lf[62],(C_word)C_a_i_list(&a,2,((C_word*)t0)[4],((C_word*)t0)[3]));}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
/* posixunix.scm: 594  values */
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1387,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
/* posixunix.scm: 599  fd_test */
t4=t3;
f_1387(t4,f_1321(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1428,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1430,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t8=*((C_word*)lf[63]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_1387(t4,C_SCHEME_FALSE);}}}}

/* a1429 in k1346 in k1343 in k1337 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1430(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1430,3,t0,t1,t2);}
t3=f_1321(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1426 in k1346 in k1343 in k1337 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1428(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1387(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1385 in k1346 in k1343 in k1337 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1387(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1387,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1391,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
/* posixunix.scm: 605  fd_test */
t3=t2;
f_1391(t3,f_1321(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1403,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1405,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t7=*((C_word*)lf[63]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_1391(t3,C_SCHEME_FALSE);}}

/* a1404 in k1385 in k1346 in k1343 in k1337 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1405(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1405,3,t0,t1,t2);}
t3=f_1321(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1401 in k1385 in k1346 in k1343 in k1337 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1391(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1389 in k1385 in k1346 in k1343 in k1337 in file-select in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1391(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 596  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* fd_test in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall f_1321(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub62(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_set in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall f_1319(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub56(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_zero in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall f_1317(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub51(C_SCHEME_UNDEFINED,t1));}

/* file-mkstemp in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1288(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1288,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1292,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 545  ##sys#make-c-string */
t4=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k1290 in file-mkstemp in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1292,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(C_word)C_block_size(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1298,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm: 549  posix-error */
t6=lf[4];
f_1106(t6,t4,lf[44],lf[58],lf[60],(C_word)C_a_i_list(&a,1,((C_word*)t0)[2]));}
else{
t6=t4;
f_1298(2,t6,C_SCHEME_UNDEFINED);}}

/* k1296 in k1290 in file-mkstemp in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1298,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1305,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 550  ##sys#substring */
t4=*((C_word*)lf[59]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1303 in k1296 in k1290 in file-mkstemp in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 550  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1255(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1255r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1255r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1255r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1259,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t5;
f_1259(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 531  ##sys#signal-hook */
t7=*((C_word*)lf[5]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t5,lf[53],lf[55],lf[57],t3);}}

/* k1257 in file-write in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1259(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1259,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1265,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t6)){
/* posixunix.scm: 536  posix-error */
t7=lf[4];
f_1106(t7,t5,lf[44],lf[55],lf[56],(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],t3));}
else{
t7=t5;
f_1265(2,t7,C_SCHEME_UNDEFINED);}}

/* k1263 in k1257 in file-write in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1219(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1219r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1219r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1219r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1223,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t6=t5;
f_1223(2,t6,(C_word)C_slot(t4,C_fix(0)));}
else{
/* posixunix.scm: 519  make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}}

/* k1221 in file-read in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1223(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1223,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1226,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1226(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 521  ##sys#signal-hook */
t4=*((C_word*)lf[5]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[53],lf[51],lf[54],t1);}}

/* k1224 in k1221 in file-read in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1226(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1226,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1229,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 524  posix-error */
t5=lf[4];
f_1106(t5,t3,lf[44],lf[51],lf[52],(C_word)C_a_i_list(&a,2,((C_word*)t0)[5],((C_word*)t0)[3]));}
else{
t5=t3;
f_1229(2,t5,C_SCHEME_UNDEFINED);}}

/* k1227 in k1224 in k1221 in file-read in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1229(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1229,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1207(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1207,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
/* posixunix.scm: 512  posix-error */
t3=lf[4];
f_1106(t3,t1,lf[44],lf[48],lf[49],(C_word)C_a_i_list(&a,1,t2));}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-open in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1178(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1178r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1178r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1178r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1186,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1199,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 503  ##sys#expand-home-path */
t9=*((C_word*)lf[47]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}

/* k1197 in file-open in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1199(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 503  ##sys#make-c-string */
t2=*((C_word*)lf[46]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1184 in file-open in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1186(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1186,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1189,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 505  posix-error */
t5=lf[4];
f_1106(t5,t3,lf[44],lf[43],lf[45],(C_word)C_a_i_list(&a,3,((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]));}
else{
t5=t3;
f_1189(2,t5,C_SCHEME_UNDEFINED);}}

/* k1187 in k1184 in file-open in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1189(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* yield in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1123(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1123,NULL,1,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1129,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 419  ##sys#call-with-current-continuation */
C_call_cc(3,0,t1,t2);}

/* a1128 in yield in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1129(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1129,3,t0,t1,t2);}
t3=*((C_word*)lf[10]+1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1138,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t5=(C_word)C_i_setslot(t3,C_fix(1),t4);
/* posixunix.scm: 423  ##sys#schedule */
t6=*((C_word*)lf[11]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t1);}

/* a1137 in a1128 in yield in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1138(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1138,2,t0,t1);}
/* posixunix.scm: 422  return */
t2=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,C_SCHEME_UNDEFINED);}

/* posix-error in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_fcall f_1106(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1106,NULL,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1110,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 412  ##sys#update-errno */
t7=*((C_word*)lf[8]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1108 in posix-error in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1110(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1110,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1117,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1121,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[7]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,(C_word)stub7(t4,t1),C_fix(0));}

/* k1119 in k1108 in posix-error in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1121(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 413  string-append */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[6],t1);}

/* k1115 in k1108 in posix-error in k1094 in k1091 in k1088 in k1085 in k1082 */
static void C_ccall f_1117(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[5]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* make-nonblocking in k1094 in k1091 in k1088 in k1085 in k1082 */
static C_word C_fcall f_1098(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub1(C_SCHEME_UNDEFINED,t1));}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[414] = {
{"toplevelposixunix.scm",(void*)C_posix_toplevel},
{"f_1084posixunix.scm",(void*)f_1084},
{"f_1087posixunix.scm",(void*)f_1087},
{"f_1090posixunix.scm",(void*)f_1090},
{"f_1093posixunix.scm",(void*)f_1093},
{"f_1096posixunix.scm",(void*)f_1096},
{"f_2218posixunix.scm",(void*)f_2218},
{"f_4741posixunix.scm",(void*)f_4741},
{"f_2267posixunix.scm",(void*)f_2267},
{"f_2776posixunix.scm",(void*)f_2776},
{"f_4721posixunix.scm",(void*)f_4721},
{"f_4717posixunix.scm",(void*)f_4717},
{"f_4492posixunix.scm",(void*)f_4492},
{"f_4646posixunix.scm",(void*)f_4646},
{"f_4652posixunix.scm",(void*)f_4652},
{"f_4641posixunix.scm",(void*)f_4641},
{"f_4636posixunix.scm",(void*)f_4636},
{"f_4494posixunix.scm",(void*)f_4494},
{"f_4623posixunix.scm",(void*)f_4623},
{"f_4631posixunix.scm",(void*)f_4631},
{"f_4498posixunix.scm",(void*)f_4498},
{"f_4611posixunix.scm",(void*)f_4611},
{"f_4508posixunix.scm",(void*)f_4508},
{"f_4510posixunix.scm",(void*)f_4510},
{"f_4529posixunix.scm",(void*)f_4529},
{"f_4597posixunix.scm",(void*)f_4597},
{"f_4604posixunix.scm",(void*)f_4604},
{"f_4591posixunix.scm",(void*)f_4591},
{"f_4544posixunix.scm",(void*)f_4544},
{"f_4578posixunix.scm",(void*)f_4578},
{"f_4564posixunix.scm",(void*)f_4564},
{"f_4576posixunix.scm",(void*)f_4576},
{"f_4572posixunix.scm",(void*)f_4572},
{"f_4556posixunix.scm",(void*)f_4556},
{"f_4554posixunix.scm",(void*)f_4554},
{"f_4615posixunix.scm",(void*)f_4615},
{"f_4184posixunix.scm",(void*)f_4184},
{"f_4447posixunix.scm",(void*)f_4447},
{"f_4442posixunix.scm",(void*)f_4442},
{"f_4186posixunix.scm",(void*)f_4186},
{"f_4198posixunix.scm",(void*)f_4198},
{"f_4210posixunix.scm",(void*)f_4210},
{"f_4391posixunix.scm",(void*)f_4391},
{"f_4395posixunix.scm",(void*)f_4395},
{"f_4398posixunix.scm",(void*)f_4398},
{"f_4438posixunix.scm",(void*)f_4438},
{"f_4401posixunix.scm",(void*)f_4401},
{"f_4429posixunix.scm",(void*)f_4429},
{"f_4404posixunix.scm",(void*)f_4404},
{"f_4413posixunix.scm",(void*)f_4413},
{"f_4214posixunix.scm",(void*)f_4214},
{"f_4217posixunix.scm",(void*)f_4217},
{"f_4220posixunix.scm",(void*)f_4220},
{"f_4233posixunix.scm",(void*)f_4233},
{"f_4378posixunix.scm",(void*)f_4378},
{"f_4382posixunix.scm",(void*)f_4382},
{"f_4362posixunix.scm",(void*)f_4362},
{"f_4346posixunix.scm",(void*)f_4346},
{"f_4350posixunix.scm",(void*)f_4350},
{"f_4277posixunix.scm",(void*)f_4277},
{"f_4333posixunix.scm",(void*)f_4333},
{"f_4337posixunix.scm",(void*)f_4337},
{"f_4283posixunix.scm",(void*)f_4283},
{"f_4292posixunix.scm",(void*)f_4292},
{"f_4324posixunix.scm",(void*)f_4324},
{"f_4308posixunix.scm",(void*)f_4308},
{"f_4281posixunix.scm",(void*)f_4281},
{"f_4235posixunix.scm",(void*)f_4235},
{"f_4249posixunix.scm",(void*)f_4249},
{"f_4265posixunix.scm",(void*)f_4265},
{"f_4268posixunix.scm",(void*)f_4268},
{"f_4245posixunix.scm",(void*)f_4245},
{"f_4204posixunix.scm",(void*)f_4204},
{"f_4192posixunix.scm",(void*)f_4192},
{"f_4164posixunix.scm",(void*)f_4164},
{"f_4176posixunix.scm",(void*)f_4176},
{"f_4170posixunix.scm",(void*)f_4170},
{"f_4118posixunix.scm",(void*)f_4118},
{"f_4125posixunix.scm",(void*)f_4125},
{"f_4140posixunix.scm",(void*)f_4140},
{"f_4097posixunix.scm",(void*)f_4097},
{"f_4094posixunix.scm",(void*)f_4094},
{"f_4091posixunix.scm",(void*)f_4091},
{"f_4088posixunix.scm",(void*)f_4088},
{"f_4018posixunix.scm",(void*)f_4018},
{"f_3854posixunix.scm",(void*)f_3854},
{"f_3973posixunix.scm",(void*)f_3973},
{"f_3968posixunix.scm",(void*)f_3968},
{"f_3856posixunix.scm",(void*)f_3856},
{"f_3860posixunix.scm",(void*)f_3860},
{"f_3868posixunix.scm",(void*)f_3868},
{"f_3911posixunix.scm",(void*)f_3911},
{"f_3881posixunix.scm",(void*)f_3881},
{"f_3906posixunix.scm",(void*)f_3906},
{"f_3884posixunix.scm",(void*)f_3884},
{"f_3846posixunix.scm",(void*)f_3846},
{"f_3838posixunix.scm",(void*)f_3838},
{"f_3800posixunix.scm",(void*)f_3800},
{"f_3822posixunix.scm",(void*)f_3822},
{"f_3826posixunix.scm",(void*)f_3826},
{"f_3694posixunix.scm",(void*)f_3694},
{"f_3700posixunix.scm",(void*)f_3700},
{"f_3721posixunix.scm",(void*)f_3721},
{"f_3792posixunix.scm",(void*)f_3792},
{"f_3725posixunix.scm",(void*)f_3725},
{"f_3732posixunix.scm",(void*)f_3732},
{"f_3734posixunix.scm",(void*)f_3734},
{"f_3751posixunix.scm",(void*)f_3751},
{"f_3761posixunix.scm",(void*)f_3761},
{"f_3765posixunix.scm",(void*)f_3765},
{"f_3715posixunix.scm",(void*)f_3715},
{"f_3682posixunix.scm",(void*)f_3682},
{"f_3686posixunix.scm",(void*)f_3686},
{"f_3689posixunix.scm",(void*)f_3689},
{"f_3655posixunix.scm",(void*)f_3655},
{"f_3659posixunix.scm",(void*)f_3659},
{"f_3634posixunix.scm",(void*)f_3634},
{"f_3638posixunix.scm",(void*)f_3638},
{"f_3581posixunix.scm",(void*)f_3581},
{"f_3588posixunix.scm",(void*)f_3588},
{"f_3578posixunix.scm",(void*)f_3578},
{"f_3559posixunix.scm",(void*)f_3559},
{"f_3563posixunix.scm",(void*)f_3563},
{"f_3551posixunix.scm",(void*)f_3551},
{"f_3523posixunix.scm",(void*)f_3523},
{"f_3530posixunix.scm",(void*)f_3530},
{"f_3495posixunix.scm",(void*)f_3495},
{"f_3502posixunix.scm",(void*)f_3502},
{"f_3467posixunix.scm",(void*)f_3467},
{"f_3474posixunix.scm",(void*)f_3474},
{"f_3477posixunix.scm",(void*)f_3477},
{"f_3480posixunix.scm",(void*)f_3480},
{"f_3450posixunix.scm",(void*)f_3450},
{"f_3454posixunix.scm",(void*)f_3454},
{"f_3457posixunix.scm",(void*)f_3457},
{"f_3439posixunix.scm",(void*)f_3439},
{"f_3433posixunix.scm",(void*)f_3433},
{"f_3427posixunix.scm",(void*)f_3427},
{"f_3421posixunix.scm",(void*)f_3421},
{"f_3389posixunix.scm",(void*)f_3389},
{"f_3331posixunix.scm",(void*)f_3331},
{"f_3335posixunix.scm",(void*)f_3335},
{"f_3341posixunix.scm",(void*)f_3341},
{"f_3360posixunix.scm",(void*)f_3360},
{"f_3347posixunix.scm",(void*)f_3347},
{"f_3248posixunix.scm",(void*)f_3248},
{"f_3254posixunix.scm",(void*)f_3254},
{"f_3258posixunix.scm",(void*)f_3258},
{"f_3266posixunix.scm",(void*)f_3266},
{"f_3292posixunix.scm",(void*)f_3292},
{"f_3296posixunix.scm",(void*)f_3296},
{"f_3284posixunix.scm",(void*)f_3284},
{"f_3236posixunix.scm",(void*)f_3236},
{"f_3241posixunix.scm",(void*)f_3241},
{"f_3225posixunix.scm",(void*)f_3225},
{"f_3230posixunix.scm",(void*)f_3230},
{"f_3234posixunix.scm",(void*)f_3234},
{"f_3202posixunix.scm",(void*)f_3202},
{"f_3223posixunix.scm",(void*)f_3223},
{"f_3206posixunix.scm",(void*)f_3206},
{"f_3165posixunix.scm",(void*)f_3165},
{"f_3169posixunix.scm",(void*)f_3169},
{"f_3187posixunix.scm",(void*)f_3187},
{"f_3183posixunix.scm",(void*)f_3183},
{"f_3140posixunix.scm",(void*)f_3140},
{"f_3118posixunix.scm",(void*)f_3118},
{"f_3122posixunix.scm",(void*)f_3122},
{"f_3103posixunix.scm",(void*)f_3103},
{"f_3107posixunix.scm",(void*)f_3107},
{"f_3088posixunix.scm",(void*)f_3088},
{"f_3092posixunix.scm",(void*)f_3092},
{"f_3070posixunix.scm",(void*)f_3070},
{"f_3008posixunix.scm",(void*)f_3008},
{"f_3027posixunix.scm",(void*)f_3027},
{"f_2972posixunix.scm",(void*)f_2972},
{"f_2997posixunix.scm",(void*)f_2997},
{"f_2993posixunix.scm",(void*)f_2993},
{"f_2986posixunix.scm",(void*)f_2986},
{"f_2951posixunix.scm",(void*)f_2951},
{"f_2955posixunix.scm",(void*)f_2955},
{"f_2958posixunix.scm",(void*)f_2958},
{"f_2909posixunix.scm",(void*)f_2909},
{"f_2945posixunix.scm",(void*)f_2945},
{"f_2928posixunix.scm",(void*)f_2928},
{"f_2898posixunix.scm",(void*)f_2898},
{"f_2907posixunix.scm",(void*)f_2907},
{"f_2887posixunix.scm",(void*)f_2887},
{"f_2896posixunix.scm",(void*)f_2896},
{"f_2872posixunix.scm",(void*)f_2872},
{"f_2885posixunix.scm",(void*)f_2885},
{"f_2835posixunix.scm",(void*)f_2835},
{"f_2843posixunix.scm",(void*)f_2843},
{"f_2816posixunix.scm",(void*)f_2816},
{"f_2805posixunix.scm",(void*)f_2805},
{"f_2809posixunix.scm",(void*)f_2809},
{"f_2777posixunix.scm",(void*)f_2777},
{"f_2798posixunix.scm",(void*)f_2798},
{"f_2782posixunix.scm",(void*)f_2782},
{"f_2785posixunix.scm",(void*)f_2785},
{"f_2745posixunix.scm",(void*)f_2745},
{"f_2772posixunix.scm",(void*)f_2772},
{"f_2760posixunix.scm",(void*)f_2760},
{"f_2768posixunix.scm",(void*)f_2768},
{"f_2764posixunix.scm",(void*)f_2764},
{"f_2730posixunix.scm",(void*)f_2730},
{"f_2740posixunix.scm",(void*)f_2740},
{"f_2715posixunix.scm",(void*)f_2715},
{"f_2725posixunix.scm",(void*)f_2725},
{"f_2719posixunix.scm",(void*)f_2719},
{"f_2700posixunix.scm",(void*)f_2700},
{"f_2710posixunix.scm",(void*)f_2710},
{"f_2704posixunix.scm",(void*)f_2704},
{"f_2694posixunix.scm",(void*)f_2694},
{"f_2688posixunix.scm",(void*)f_2688},
{"f_2682posixunix.scm",(void*)f_2682},
{"f_2661posixunix.scm",(void*)f_2661},
{"f_2680posixunix.scm",(void*)f_2680},
{"f_2676posixunix.scm",(void*)f_2676},
{"f_2668posixunix.scm",(void*)f_2668},
{"f_2646posixunix.scm",(void*)f_2646},
{"f_2656posixunix.scm",(void*)f_2656},
{"f_2631posixunix.scm",(void*)f_2631},
{"f_2641posixunix.scm",(void*)f_2641},
{"f_2628posixunix.scm",(void*)f_2628},
{"f_2625posixunix.scm",(void*)f_2625},
{"f_2622posixunix.scm",(void*)f_2622},
{"f_2619posixunix.scm",(void*)f_2619},
{"f_2598posixunix.scm",(void*)f_2598},
{"f_2617posixunix.scm",(void*)f_2617},
{"f_2613posixunix.scm",(void*)f_2613},
{"f_2577posixunix.scm",(void*)f_2577},
{"f_2596posixunix.scm",(void*)f_2596},
{"f_2592posixunix.scm",(void*)f_2592},
{"f_2535posixunix.scm",(void*)f_2535},
{"f_2531posixunix.scm",(void*)f_2531},
{"f_2545posixunix.scm",(void*)f_2545},
{"f_2472posixunix.scm",(void*)f_2472},
{"f_2476posixunix.scm",(void*)f_2476},
{"f_2481posixunix.scm",(void*)f_2481},
{"f_2497posixunix.scm",(void*)f_2497},
{"f_2409posixunix.scm",(void*)f_2409},
{"f_2467posixunix.scm",(void*)f_2467},
{"f_2413posixunix.scm",(void*)f_2413},
{"f_2416posixunix.scm",(void*)f_2416},
{"f_2448posixunix.scm",(void*)f_2448},
{"f_2419posixunix.scm",(void*)f_2419},
{"f_2424posixunix.scm",(void*)f_2424},
{"f_2438posixunix.scm",(void*)f_2438},
{"f_2406posixunix.scm",(void*)f_2406},
{"f_2352posixunix.scm",(void*)f_2352},
{"f_2401posixunix.scm",(void*)f_2401},
{"f_2356posixunix.scm",(void*)f_2356},
{"f_2366posixunix.scm",(void*)f_2366},
{"f_2370posixunix.scm",(void*)f_2370},
{"f_2376posixunix.scm",(void*)f_2376},
{"f_2380posixunix.scm",(void*)f_2380},
{"f_2390posixunix.scm",(void*)f_2390},
{"f_2374posixunix.scm",(void*)f_2374},
{"f_2307posixunix.scm",(void*)f_2307},
{"f_2344posixunix.scm",(void*)f_2344},
{"f_2311posixunix.scm",(void*)f_2311},
{"f_2321posixunix.scm",(void*)f_2321},
{"f_2325posixunix.scm",(void*)f_2325},
{"f_2329posixunix.scm",(void*)f_2329},
{"f_2333posixunix.scm",(void*)f_2333},
{"f_2337posixunix.scm",(void*)f_2337},
{"f_2269posixunix.scm",(void*)f_2269},
{"f_2302posixunix.scm",(void*)f_2302},
{"f_2273posixunix.scm",(void*)f_2273},
{"f_2280posixunix.scm",(void*)f_2280},
{"f_2284posixunix.scm",(void*)f_2284},
{"f_2288posixunix.scm",(void*)f_2288},
{"f_2292posixunix.scm",(void*)f_2292},
{"f_2296posixunix.scm",(void*)f_2296},
{"f_2248posixunix.scm",(void*)f_2248},
{"f_2263posixunix.scm",(void*)f_2263},
{"f_2252posixunix.scm",(void*)f_2252},
{"f_2230posixunix.scm",(void*)f_2230},
{"f_2240posixunix.scm",(void*)f_2240},
{"f_2220posixunix.scm",(void*)f_2220},
{"f_2177posixunix.scm",(void*)f_2177},
{"f_2181posixunix.scm",(void*)f_2181},
{"f_2157posixunix.scm",(void*)f_2157},
{"f_2161posixunix.scm",(void*)f_2161},
{"f_2167posixunix.scm",(void*)f_2167},
{"f_2171posixunix.scm",(void*)f_2171},
{"f_2137posixunix.scm",(void*)f_2137},
{"f_2141posixunix.scm",(void*)f_2141},
{"f_2147posixunix.scm",(void*)f_2147},
{"f_2151posixunix.scm",(void*)f_2151},
{"f_2113posixunix.scm",(void*)f_2113},
{"f_2117posixunix.scm",(void*)f_2117},
{"f_2128posixunix.scm",(void*)f_2128},
{"f_2132posixunix.scm",(void*)f_2132},
{"f_2122posixunix.scm",(void*)f_2122},
{"f_2089posixunix.scm",(void*)f_2089},
{"f_2093posixunix.scm",(void*)f_2093},
{"f_2104posixunix.scm",(void*)f_2104},
{"f_2108posixunix.scm",(void*)f_2108},
{"f_2098posixunix.scm",(void*)f_2098},
{"f_2076posixunix.scm",(void*)f_2076},
{"f_2080posixunix.scm",(void*)f_2080},
{"f_2043posixunix.scm",(void*)f_2043},
{"f_2071posixunix.scm",(void*)f_2071},
{"f_2061posixunix.scm",(void*)f_2061},
{"f_2054posixunix.scm",(void*)f_2054},
{"f_2010posixunix.scm",(void*)f_2010},
{"f_2038posixunix.scm",(void*)f_2038},
{"f_2028posixunix.scm",(void*)f_2028},
{"f_2021posixunix.scm",(void*)f_2021},
{"f_1995posixunix.scm",(void*)f_1995},
{"f_2008posixunix.scm",(void*)f_2008},
{"f_1989posixunix.scm",(void*)f_1989},
{"f_1977posixunix.scm",(void*)f_1977},
{"f_1937posixunix.scm",(void*)f_1937},
{"f_1941posixunix.scm",(void*)f_1941},
{"f_1950posixunix.scm",(void*)f_1950},
{"f_1917posixunix.scm",(void*)f_1917},
{"f_1935posixunix.scm",(void*)f_1935},
{"f_1921posixunix.scm",(void*)f_1921},
{"f_1766posixunix.scm",(void*)f_1766},
{"f_1868posixunix.scm",(void*)f_1868},
{"f_1876posixunix.scm",(void*)f_1876},
{"f_1863posixunix.scm",(void*)f_1863},
{"f_1768posixunix.scm",(void*)f_1768},
{"f_1772posixunix.scm",(void*)f_1772},
{"f_1775posixunix.scm",(void*)f_1775},
{"f_1778posixunix.scm",(void*)f_1778},
{"f_1862posixunix.scm",(void*)f_1862},
{"f_1782posixunix.scm",(void*)f_1782},
{"f_1796posixunix.scm",(void*)f_1796},
{"f_1806posixunix.scm",(void*)f_1806},
{"f_1818posixunix.scm",(void*)f_1818},
{"f_1828posixunix.scm",(void*)f_1828},
{"f_1745posixunix.scm",(void*)f_1745},
{"f_1764posixunix.scm",(void*)f_1764},
{"f_1760posixunix.scm",(void*)f_1760},
{"f_1724posixunix.scm",(void*)f_1724},
{"f_1743posixunix.scm",(void*)f_1743},
{"f_1739posixunix.scm",(void*)f_1739},
{"f_1703posixunix.scm",(void*)f_1703},
{"f_1722posixunix.scm",(void*)f_1722},
{"f_1718posixunix.scm",(void*)f_1718},
{"f_1651posixunix.scm",(void*)f_1651},
{"f_1658posixunix.scm",(void*)f_1658},
{"f_1670posixunix.scm",(void*)f_1670},
{"f_1664posixunix.scm",(void*)f_1664},
{"f_1614posixunix.scm",(void*)f_1614},
{"f_1630posixunix.scm",(void*)f_1630},
{"f_1618posixunix.scm",(void*)f_1618},
{"f_1621posixunix.scm",(void*)f_1621},
{"f_1608posixunix.scm",(void*)f_1608},
{"f_1612posixunix.scm",(void*)f_1612},
{"f_1602posixunix.scm",(void*)f_1602},
{"f_1606posixunix.scm",(void*)f_1606},
{"f_1596posixunix.scm",(void*)f_1596},
{"f_1600posixunix.scm",(void*)f_1600},
{"f_1590posixunix.scm",(void*)f_1590},
{"f_1594posixunix.scm",(void*)f_1594},
{"f_1584posixunix.scm",(void*)f_1584},
{"f_1588posixunix.scm",(void*)f_1588},
{"f_1578posixunix.scm",(void*)f_1578},
{"f_1582posixunix.scm",(void*)f_1582},
{"f_1572posixunix.scm",(void*)f_1572},
{"f_1576posixunix.scm",(void*)f_1576},
{"f_1566posixunix.scm",(void*)f_1566},
{"f_1570posixunix.scm",(void*)f_1570},
{"f_1537posixunix.scm",(void*)f_1537},
{"f_1548posixunix.scm",(void*)f_1548},
{"f_1541posixunix.scm",(void*)f_1541},
{"f_1500posixunix.scm",(void*)f_1500},
{"f_1532posixunix.scm",(void*)f_1532},
{"f_1525posixunix.scm",(void*)f_1525},
{"f_1504posixunix.scm",(void*)f_1504},
{"f_1323posixunix.scm",(void*)f_1323},
{"f_1484posixunix.scm",(void*)f_1484},
{"f_1339posixunix.scm",(void*)f_1339},
{"f_1464posixunix.scm",(void*)f_1464},
{"f_1345posixunix.scm",(void*)f_1345},
{"f_1348posixunix.scm",(void*)f_1348},
{"f_1430posixunix.scm",(void*)f_1430},
{"f_1428posixunix.scm",(void*)f_1428},
{"f_1387posixunix.scm",(void*)f_1387},
{"f_1405posixunix.scm",(void*)f_1405},
{"f_1403posixunix.scm",(void*)f_1403},
{"f_1391posixunix.scm",(void*)f_1391},
{"f_1321posixunix.scm",(void*)f_1321},
{"f_1319posixunix.scm",(void*)f_1319},
{"f_1317posixunix.scm",(void*)f_1317},
{"f_1288posixunix.scm",(void*)f_1288},
{"f_1292posixunix.scm",(void*)f_1292},
{"f_1298posixunix.scm",(void*)f_1298},
{"f_1305posixunix.scm",(void*)f_1305},
{"f_1255posixunix.scm",(void*)f_1255},
{"f_1259posixunix.scm",(void*)f_1259},
{"f_1265posixunix.scm",(void*)f_1265},
{"f_1219posixunix.scm",(void*)f_1219},
{"f_1223posixunix.scm",(void*)f_1223},
{"f_1226posixunix.scm",(void*)f_1226},
{"f_1229posixunix.scm",(void*)f_1229},
{"f_1207posixunix.scm",(void*)f_1207},
{"f_1178posixunix.scm",(void*)f_1178},
{"f_1199posixunix.scm",(void*)f_1199},
{"f_1186posixunix.scm",(void*)f_1186},
{"f_1189posixunix.scm",(void*)f_1189},
{"f_1123posixunix.scm",(void*)f_1123},
{"f_1129posixunix.scm",(void*)f_1129},
{"f_1138posixunix.scm",(void*)f_1138},
{"f_1106posixunix.scm",(void*)f_1106},
{"f_1110posixunix.scm",(void*)f_1110},
{"f_1121posixunix.scm",(void*)f_1121},
{"f_1117posixunix.scm",(void*)f_1117},
{"f_1098posixunix.scm",(void*)f_1098},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
