#
# "$Id: cupsddk.spec.in 343 2007-07-13 19:52:48Z mike $"
#
#   RPM "spec" file for the CUPS Driver Development Kit.
#
#   Copyright 2007 by Apple Inc.
#   Copyright 1997-2007 by Easy Software Products, all rights reserved.
#
#   These coded instructions, statements, and computer programs are the
#   property of Apple Inc. and are protected by Federal copyright
#   law.  Distribution and use rights are outlined in the file "LICENSE.txt"
#   which should have been included with this file.  If this file is
#   file is missing or damaged, see the license at "http://www.cups.org/".
#

Summary: CUPS Driver Development Kit
Name: cupsddk
Version: 1.2.0
Release: 1
License: GPL
Group: System Environment/Daemons
Source: http://ftp.easysw.com/pub/cupsddk/1.2.0/cupsddk-1.2.0-source.tar.gz
Url: http://www.cups.org/ddk/
Packager: Anonymous <anonymous@foo.com>
Vendor: Easy Software Products

# Use buildroot so as not to disturb the version already installed
BuildRoot: /var/tmp/%{name}-root
BuildRequires: cups-devel >= 1:1.2

%package drivers
Summary: CUPS DDK - printer drivers
Group: System Environment/Drivers

%description
The CUPS Driver Development Kit (DDK) provides a suite of
standard drivers, a PPD file compiler, and other utilities that
can be used to develop printer drivers for CUPS and other
printing environments.  CUPS provides a portable printing layer
for UNIX(r)-based operating systems.  The CUPS DDK provides the
means for mass-producing PPD files and drivers/filters for
CUPS-based printer drivers.

The CUPS DDK is licensed under the GNU General Public License. 
Please contact Easy Software Products for commercial support and
"binary distribution" rights.

%description drivers
The CUPS DDK drivers provide support for all HP PCL/RTL and Epson
ESC/P2 devices.

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" LDFLAGS="$RPM_OPT_FLAGS" ./configure

# If we got this far, all prerequisite libraries must be here.
make

%install
# Make sure the RPM_BUILD_ROOT directory exists.
rm -rf $RPM_BUILD_ROOT

make BUILDROOT=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/bin/*
/usr/include/cups/*
/usr/share/doc/cups/*

%dir /usr/share/man/man1
/usr/share/man/man1/cupsprofile.1.gz
/usr/share/man/man1/ppdc.1.gz
/usr/share/man/man1/ppdhtml.1.gz
/usr/share/man/man1/ppdi.1.gz
/usr/share/man/man1/ppdmerge.1.gz
/usr/share/man/man1/ppdpo.1.gz
%dir /usr/share/man/man5
/usr/share/man/man5/ppdcfile.5.gz

%files drivers
%dir /usr/lib/cups/filter
/usr/lib/cups/filter/*
/usr/lib/cups/driver/*
%dir /usr/share/cups/drv
%dir /usr/share/cupsddk
/usr/share/cupsddk/*

%dir /usr/share/man/man1
/usr/share/man/man1/commandtoescpx.1.gz
/usr/share/man/man1/commandtopclx.1.gz
/usr/share/man/man1/rastertoescpx.1.gz
/usr/share/man/man1/rastertopclx.1.gz

#
# End of "$Id: cupsddk.spec.in 343 2007-07-13 19:52:48Z mike $".
#
