/*
 * debtags - Implement package tags support for Debian
 *
 * Copyright (C) 2003--2007  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DEBTAGS_ENVIRONMENT_TCC
#define DEBTAGS_ENVIRONMENT_TCC

#include "Environment.h"

#include <pkg/debtags/maint/serializer.h>

#include <tagcoll/input/stdio.h>
#include <tagcoll/TextFormat.h>


template<typename OUT>
void Environment::readCollection(const string& file, const OUT& out)
{
	if (file == "-")
	{
		input::Stdio input(stdin, "<stdin>");
		textformat::parse(input,
				pkg::debtags::stringToInt(pkgid, voc(),
					pkg::debtags::intToPkg(pkgid, voc(), out)));
	}
	else
	{
		input::Stdio input(file);
		textformat::parse(input,
				pkg::debtags::stringToInt(pkgid, voc(),
					pkg::debtags::intToPkg(pkgid, voc(), out)));
	}
}

template<typename OUT>
void Environment::readCollectionRaw(const string& file, const OUT& out)
{
	if (file == "-")
	{
		input::Stdio input(stdin, "<stdin>");
		textformat::parse(input, out);
	}
	else
	{
		input::Stdio input(file);
		textformat::parse(input, out);
	}
}

#endif
// vim:set ts=4 sw=4:
