/* objops.cpp
 * functions that do operations to mudela objects
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999-2005 Matthew Hiller
 */

#include <denemo/denemo.h>
#include "chordops.h"
#include "utils.h"
#include "commandfuncs.h"
#include "objops.h"
#include "staffops.h"
#include <string.h>

/**
 * Free the given object
 * @param mudobj the mudelaobject to free
 */
void
freeobject (mudelaobject * mudobj)
{
  if (mudobj)
    switch (mudobj->type)
    {
    	case CHORD:
				freechord (mudobj);	/* Which also frees mudobj itself */
				break;
      default:
				g_free (mudobj);
				break;
    }
}

/**
 * Create a new timesignature object
 * @param time1 nominator of time signature
 * @param time2 denominator of the time signature
 * @return the timesignature
 */
mudelaobject *
newtimesigobj (gint time1, gint time2)
{
  mudelaobject *ret;
  timesig *newtimesig = (timesig *) g_malloc (sizeof (timesig));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = TIMESIG;
  newtimesig->time1 = time1;
  newtimesig->time2 = time2;
  ret->object = newtimesig;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}



/**
 * Create a new clef object
 * @param type clef type to create 
 *
 * @return the clef 
 */
mudelaobject *
newclefobj (enum clefs type)
{
  mudelaobject *ret;
  clef *newclef = (clef *) g_malloc (sizeof (clef));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = CLEF;
  ret->isinvisible = FALSE;
  newclef->type = type;
  ret->object = newclef;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}


void set_modeaccs(gint *accs, gint number, gint mode)
{ 
	
	g_print("Mode %d : %d \n", number, mode);
	if(mode == 0)
	{
	  switch (number) 
	  {
	  case 11:
	  	number -= 7;
	  	break;
	  }
	  initkeyaccs(accs,number);
	  
	}
	else if(mode == 2)
	  initkeyaccs(accs,0);
	else if(number == 1 && mode == 1)
	  initkeyaccs(accs,0);
	else if(number == 1 && mode == 1)
	  initkeyaccs(accs,0);
	else if(number == 1 && mode == 1)	
	  initkeyaccs(accs,0);
	else if(number == 1 && mode == 1)
	  initkeyaccs(accs,0);
	else if(number == 1 && mode == 1)
	  initkeyaccs(accs,0);
	else if(number == 1 && mode == 1)
	  initkeyaccs(accs,0);
}
/** 
 * This function initializes the accidental-context array associated with
 * a key signature or a staff to that appropriate for _number_ 
 */
void
initkeyaccs (gint * accs, gint number)
{
  int index;
  guint i;
  memset (accs, 0, SEVENGINTS);
  if (number > 0)
    for (index = 3; number; number--, index = (index + 4) % 7)
      accs[index] = 1;
  else if (number < 0)
    for (index = 6; number; number++, index = (index + 3) % 7)
      accs[index] = -1;
#ifdef DEBUG
  for(i=0; i < 7; i++)
 	g_print("[%d]", accs[i]);
  g_print("\n");
#endif
}

/**
 * Create a new keysignature object
 * 
 * @param number number of keysignature
 * @param isminor signifies if the key sig should be minor
 * @return the key signature
 */
mudelaobject *
newkeyobj (gint number, gint isminor, gint mode)
{
  mudelaobject *ret;
  keysig *newkeysig = (keysig *) g_malloc (sizeof (keysig));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = KEYSIG;
  ret->isinvisible = FALSE;
  
  g_print("Number %d \t IsMinor %d \t Mode %d\n", number, isminor, mode);
  newkeysig->mode = mode;
  newkeysig->number = number;
  newkeysig->isminor = isminor;
  
  
  
  if(isminor == 2)
    set_modeaccs(newkeysig->accs, number, mode);
  else
    initkeyaccs (newkeysig->accs, number);

  ret->object = newkeysig;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

/**
 * Create a new measure break object
 * @return the measurebreak
 */ 
mudelaobject *
newmeasurebreakobject ()
{
  mudelaobject *ret;

  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = MEASUREBREAK;
  return ret;
}

/**
 * Create a clone of the given object
 * @param orig the object to clone
 * @return the cloned object
 */
mudelaobject *
clone_object (mudelaobject * orig)
{
  mudelaobject *ret;

  switch (orig->type)
    {
    case CHORD:
      ret = clone_chord (orig);
      break;
    default:
      ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
      memcpy (ret, orig, sizeof (mudelaobject));
      break;
    }
  return ret;
}

/**
 *  Create a new stem directive 
 *  @param type the stem directive type
 *  @return the stem directive
 */
mudelaobject *
stem_directive_new (enum stemdirections type)
{
  mudelaobject *ret;
  stemdirective *newstemdir =
    (stemdirective *) g_malloc (sizeof (stemdirective));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = STEMDIRECTIVE;
  ret->isinvisible = FALSE;
  newstemdir->type = type;
  ret->object = newstemdir;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

/**
 * Create a new lilypond directive 
 *
 * @param type the lilypond directive body
 * @return the lilypond directive
 *
mudelaobject *
lily_directive_new (gchar * type)
{
  mudelaobject *ret;
  lilydirective *newlily =
    (lilydirective *) g_malloc (sizeof (lilydirective));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = LILYDIRECTIVE;
  newlily->directive = g_string_new (type);
  ret->object = newlily;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}
*/
/**
 * Create a new dynamic object
 * @param type the dynamic to create
 * @return the dynamic
  */
mudelaobject *
dynamic_new (gchar * type)
{
  mudelaobject *ret;
  dynamic *newdyn = (dynamic *) g_malloc (sizeof (dynamic));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = DYNAMIC;
  ret->isinvisible = FALSE;
  newdyn->type = g_string_new (type);
  ret->object = newdyn;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

/**
 * Create a new lyric object
 * @param type the lyric to create
 * @param position whether it shoul be centered or not
 * @param syllable whether it is a syllable
 * @return the dynamic
  */
mudelaobject *
lyric_new (gchar * type, gint position, gboolean syllable)
{
  mudelaobject *ret;
  lyric *newlyric = (lyric *) g_malloc (sizeof (lyric));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = LYRIC;
  ret->isinvisible = FALSE;


  newlyric->lyrics = g_string_new (type);
  newlyric->position = position;
  newlyric->is_syllable = syllable;
  ret->object = newlyric;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

/**
 *  Create a mudelaobject
 * @param type mudelaobject type 
 * @return the mudelaobject
 */

mudelaobject *
newobj (enum objtype type)
{
  mudelaobject *ret = (mudelaobject *) g_malloc0 (sizeof (mudelaobject));;
  ret->type = type;
  set_basic_numticks (ret);
  setpixelmin (ret);		/* these do nothing at present - but if we introduce
				   a show markers option then we will want to allot some space
				 */
  return ret;
}









/**
 * Set the key signature into the score
 * @param si the score
 * @param tokey the key sig to insert
 * @param type  major/minor/mode
 */
void setinitialkeysig(staff *curstaff, gint tokey, gint type)
{
	
	curstaff->skey = tokey;
	curstaff->skey_isminor = type;
	initkeyaccs(curstaff->skeyaccs, tokey);
   showwhichaccidentalswholestaff (curstaff);
	
}
