# -------------------------------------------------------------------------------
# dc-debconf-select.pl:
#  This file will be added to end of dictionaries-common.config-base
#  to make dictionaries-common.config, as well as installed under
#  /usr/share/dictionaries-common for single ispell dicts/wordlists use
# -------------------------------------------------------------------------------

sub dc_debconf_select (){
  my $class      = shift;
  my $priority   = shift;
  my $question   = "shared/packages-$class";
  my $debug      = "yes" if exists $ENV{'DICT_COMMON_DEBUG'};
  my @oldchoices = ();
  my %newchoices = ();
  my %title      = ('ispell'   => "Dictionaries-common: Ispell dictionary",
		    'wordlist' => "Dictionaries-common: Wordlist dictionary"
		    );
  
  # Get list of packages sharing the question 
  
  my ($errorcode,$pkgowners) = metaget ($question, "owners");
  return if $errorcode;
  
  # Get new list of provided languages

  foreach (split (/\s*,\s*/, $pkgowners)){
    my $entry = metaget ("$_/languages", "default");
    for ( $entry ){ # trim leading/trailing whitespaces
      s/^\s+//;
      s/\s+$//;
    }
    $newchoices{$_}++ foreach ( split(/\s*,\s*/, $entry) );
  }
  my $choices = join (', ', sort {lc $a cmp lc $b} keys %newchoices);

  # Read current value of default ispell dict / wordlist. No need to have
  # critical priority if is in the new list or set to manual. Otherwise
  # ask with critical priority, name for current value is changed or
  # something wrong happened. 

  $question = "dictionaries-common/default-$class";
  my $curval  = get ($question) || "undefined";
  unless ( $priority ){
    if ( $curval =~ /^Manual.*/ or exists $newchoices{$curval} ){
      $priority = "medium";   # 
    } else {
      $priority = "medium"; # No good value, ask. Do not change!
    }
  }
  
  # Get old list of provided languages
  
  @oldchoices = split(/\s*,\s*/,metaget ($question, "choices"));
  pop @oldchoices;
  my $oldchoices = join (', ', @oldchoices);
  print STDERR "** dictionaries-common: $class, $priority, $question\n" .
      "   new:[$choices]\n   old:[$oldchoices]\n" if $debug;

  # May ask question if there is no match

  if ( scalar %newchoices ) { 
    if ( $choices ne $oldchoices ) {
      subst ($question, "choices", $choices);
      fset ($question, "seen", "false");
    }   
    input ($priority, $question);
    title ($title{$class});
    go ();
  }
  
  # If called from dictionaries-common.config, check actual values in debug mode
  
  if ( $debug && $fromdcconfig ){
    print STDERR "** dictionaries-common.config: Checking some real values for $question\n";
    print STDERR "   Real new choices: " . metaget ($question, "choices") . "\n";
    print STDERR "   Real new value: "  . get ($question) . "\n";
    print STDERR "---\n";
  }
}

# Local Variables:
# perl-indent-level: 2
# End:

1;

