
from elisa.core.tests.test_media_provider import TestMediaProvider
from elisa.core.media_uri import MediaUri
import os
from twisted.internet import defer
from twisted.trial.unittest import SkipTest

class TestIpodMedia(TestMediaProvider):
    tests_dir = os.path.dirname(__file__)

    component_class = 'elisa.plugins.ipod_plugin.ipod_media:IpodMedia'

    def setUp(self):
        try:
            import gpod
        except ImportError:
            raise SkipTest("gpod missing")


        itunesdb = os.path.join(self.tests_dir, "data", "iTunesDB")
        self._ipod = MediaUri("ipod://%s" % itunesdb)

        TestMediaProvider.setUp(self)

    def get_valid_uris(self):
        return [self._ipod]
        
    def test_directory(self):
        uri = self._ipod
        dfr = self.component.is_directory(uri)
        dfr.addCallback(lambda validated: self.assertEquals(validated, True))

        uri = MediaUri(u'%s?artist=Rammstein' % self._ipod)
        dfr1 = self.component.is_directory(uri)
        dfr1.addCallback(lambda validated: self.assertEquals(validated, True))

        uri = MediaUri(u'%s?id=1234' % self._ipod)
        dfr2 = self.component.is_directory(uri)
        dfr2.addCallback(lambda validated: self.assertEquals(validated, False))
        return defer.DeferredList([dfr, dfr1, dfr2])
