# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from pgm.graph.group import Group
from pgm.graph.image import Image
from pgm.timing import implicit
import pgm
from twisted.internet import reactor

class Dock(Group):

    def __init__(self):
        super(Dock, self).__init__()

        # build the background
        self.background = Image()
        self.add(self.background)
        self.background.layout = pgm.IMAGE_FILLED
        self.background.alignment = pgm.IMAGE_LEFT
        self.background.opacity = 255
        self.background.bg_color = (0, 0, 0, 0)
        self.background.position = (0.0, 0.0, 0.0)

        self.background.visible = True
        
        self._show = None

        self._animated_group = implicit.AnimatedObject(self)
        self._animated_group.mode = implicit.REPLACE
        self._animated_group.setup_next_animations(duration = 500,
                                                   transformation = implicit.DECELERATE)

    def show(self, time_to_show=-1):
        """
        Show the player dock for the next seconds
        @time_to_show: duration before the dock disappears (in seconds)
                       if set to -1 the dock will not disappear
        """
        if self._animated_group.opacity != 255:
            self._animated_group.opacity = 255

        if time_to_show > 0:
            if self._show != None and self._show.active():
                self._show.reset(time_to_show)
            else:
                self._show = reactor.callLater(time_to_show, self.hide)

    def _cancel_timer(self):
        if self._show != None and self._show.active():
            self._show.cancel()

    def hide(self):
        """
        Hide the dock
        """
        self._cancel_timer()
        if self._animated_group.opacity != 0:
            self._animated_group.opacity = 0

    def is_visible(self):
        # FIXME: we should override visible__get() here, but it doesn't work...
        #        the progress bar is not visible anymore if we do so.
        return self._animated_group.opacity == 255

    def connect(self, signal, *args):
        self.background.connect(signal, *args)

