from elisa.core.tests.component_test_case import ComponentTestCase
from elisa.core import player
from elisa.plugins.xmlmenu.actions.play_action import PlayAction

from weakref import ref

class SimpleModel(object):
    pass

class TestPlayAction(ComponentTestCase):

    component_class = PlayAction
    playlist = []
    state = None

    def test_simple_adding(self):
        self.playlist = []
        self.state = None

        model = SimpleModel()
        model.uri = 'a'

        self.component.player_model = self
        self.component.model = ref(model)
        self.component(self, None)
        self.assertEquals(len(self.playlist), 1)
        self.assertEquals(self.playlist[0].uri, 'a')
        self.failIf(self.state == None)

    def test_adding_of_existing(self):
        self.state = player.STATES.PLAYING
        self.media_type = 'audio'

        model = SimpleModel()
        model.uri = 'a'
        self.playlist = [model]

        self.component.player_model = self
        self.component.model = ref(model)
        self.component(self, None)
        self.assertEquals(len(self.playlist), 1)
        self.assertEquals(self.playlist[0].uri, 'a')
        self.failIf(self.state == None)

        model2 = SimpleModel()
        model2.uri = 'b'

        self.component.model = ref(model2)
        self.component(self, None)
        self.assertEquals(len(self.playlist), 2)
        self.assertEquals(self.playlist[1].uri, 'b')
        self.failIf(self.state == None)

