
from elisa.core.tests import elisa_test_case

from elisa.plugins.xmlmenu.xmltreemenu_activity import XmltreemenuActivity
from elisa.core.tests.elisa_test_case import BoilerPlateApp, DEFAULT_CONFIG
from elisa.extern.coherence.et import parse_xml

from elisa.core import common

import os

class TestXmlActvity(elisa_test_case.ElisaTestCase):

    component_class = XmltreemenuActivity

    def setUp(self):
        common.set_application(BoilerPlateApp(DEFAULT_CONFIG,
                                        load_all_plugins=True))
        plugin_registry = common.application.plugin_registry
        self.component =  plugin_registry.create_component('xmlmenu:xmltreemenu_activity')
        # This is BAD!
        self.component.player_model = None

        # what if the user HAS an other xml-file?

    def test_get_model_loadmore_unload(self):
        plugin_registry = common.application.plugin_registry

        MenuModel = plugin_registry.get_component_class('base:menu_model')
        ListModel = plugin_registry.get_component_class('base:list_model')

        model = self.component.get_model()

        # check, if we get the correct model
        self.assertEquals(type(model), MenuModel)

        # check, if the model has the the xml_tag, that is necessary
        menu_config = self.component._model_configs[model]
        self.failUnless(menu_config.get('xml_tag'))

        # no known children
        self.assertEquals(len(model.children), 0)

        # This is a f****** hack, that I don't want to have!
        def got_first_children(children):
            self.assertEquals(type(children), ListModel)
            length = len(children)

            if length <= 0 :
                self.fail()
            # Test, if the unload is working
            self.component.unload(children)
            self.assertEquals(len(children), 0)

        # get the children
        children_dfr = self.component.loadmore(model)
        children_dfr.addCallback(got_first_children)
        return children_dfr

    def test_default_xml_translations(self):
        
        xml_file = os.path.join(self.directory,
                                '..',
                                'data',
                                'default_menu.xml')
        reader = open(xml_file,'r')

        data = '<Root>'

        for line in reader:
            line = line.strip()
            if line.startswith('<Label'):
                data += '\n%s\t' % line

        data += '\n</Root>'

        xml = parse_xml(data)
        root = xml.getroot()

        translator = common.application.translator

        strings_by_domain = {}

        for label in root.findall('Label'):
            string = label.text
            domain = label.get('translate-domain', None)
            if domain:
                if not strings_by_domain.has_key(domain):
                    strings_by_domain[domain] = []
                already_found = strings_by_domain[domain]
                if string not in already_found:
                    already_found.append(string)
            else:
                self.fail("'%s' is given without domain!" % string)

        locales = translator._localedirs

        pot_data = {}

        for domain, strings in strings_by_domain.iteritems():
            if domain not in locales.keys():
                self.fail("Missing domain '%s'" % domain)

        for string in strings:
            value = False
            for localedir in locales[domain]:

                if localedir not in pot_data.keys():

                    messages = os.path.join(localedir, 'messages.pot')
                    if not os.path.isfile(messages):
                        #print messages, 'missing. BAD!'
                        continue
                    mes_read = open(messages, 'r')
                    pot_data[localedir] = mes_read.read()
                    mes_read.close()

                data = pot_data[localedir]

                if '\nmsgid "%s"\n' % string in data:
                    value = True
                    break

            if not value:
                self.fail("'%s' not found in the translation template for" \
                          " '%s': '%r'" % (string, domain, locales[domain]))
        
