/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Jul  2 16:31:02 EDT 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 7 -dif -name hb_7 -include hb.h */

/*
 * This function contains 72 FP additions, 66 FP multiplications,
 * (or, 18 additions, 12 multiplications, 54 fused multiply/add),
 * 66 stack variables, and 28 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hb.h"

static const R *hb_7(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP974927912, +0.974927912181823607018131682993931217232785801);
     DK(KP900968867, +0.900968867902419126236102319507445051165919162);
     DK(KP801937735, +0.801937735804838252472204639014890102331838324);
     DK(KP692021471, +0.692021471630095869627814897002069140197260599);
     DK(KP356895867, +0.356895867892209443894399510021300583399127187);
     DK(KP554958132, +0.554958132087371191422194871006410481067288862);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 12, MAKE_VOLATILE_STRIDE(ios)) {
	  E T14, T13, T17, T15, T16, T18;
	  {
	       E T1, Tt, TB, T4, TC, Ta, TD, TA, T7, Tl, T1l, TZ, T1b, Th, Tw;
	       E Td, TP, Tm, Ti, Tj, T5, T6;
	       T1 = rio[0];
	       Tt = iio[0];
	       {
		    E T2, T3, T8, T9;
		    T2 = rio[WS(ios, 1)];
		    T3 = iio[-WS(ios, 6)];
		    T8 = rio[WS(ios, 3)];
		    T9 = iio[-WS(ios, 4)];
		    T5 = rio[WS(ios, 2)];
		    TB = T2 - T3;
		    T4 = T2 + T3;
		    TC = T8 - T9;
		    Ta = T8 + T9;
		    T6 = iio[-WS(ios, 5)];
	       }
	       {
		    E Tf, T1a, Tg, Tc, TO;
		    Tf = iio[-WS(ios, 2)];
		    TD = FMA(KP554958132, TC, TB);
		    T1a = FNMS(KP356895867, T4, Ta);
		    TA = T5 - T6;
		    T7 = T5 + T6;
		    Tg = rio[WS(ios, 5)];
		    Tl = iio[-WS(ios, 3)];
		    T1l = FMA(KP554958132, TA, TC);
		    TZ = FNMS(KP554958132, TB, TA);
		    Tc = FNMS(KP356895867, T7, T4);
		    TO = FNMS(KP356895867, Ta, T7);
		    T1b = FNMS(KP692021471, T1a, T7);
		    Th = Tf + Tg;
		    Tw = Tf - Tg;
		    Td = FNMS(KP692021471, Tc, Ta);
		    TP = FNMS(KP692021471, TO, T4);
		    Tm = rio[WS(ios, 4)];
		    Ti = iio[-WS(ios, 1)];
		    Tj = rio[WS(ios, 6)];
	       }
	       {
		    E Tu, Tv, TX, T1e, T1j, TS, TL, TH, TK, TJ, TM, Tn;
		    rio[0] = T1 + T4 + T7 + Ta;
		    Tn = Tl + Tm;
		    Tu = Tl - Tm;
		    {
			 E Tk, TW, T1d, T1i;
			 Tk = Ti + Tj;
			 Tv = Ti - Tj;
			 TW = FNMS(KP356895867, Tu, Tw);
			 T1d = FMA(KP554958132, Th, Tn);
			 T1i = FNMS(KP356895867, Tv, Tu);
			 {
			      E Tx, TR, To, Ty;
			      Tx = FNMS(KP356895867, Tw, Tv);
			      TR = FNMS(KP554958132, Tk, Th);
			      To = FMA(KP554958132, Tn, Tk);
			      TX = FNMS(KP692021471, TW, Tv);
			      T1e = FNMS(KP801937735, T1d, Tk);
			      T1j = FNMS(KP692021471, T1i, Tw);
			      Ty = FNMS(KP692021471, Tx, Tu);
			      TS = FNMS(KP801937735, TR, Tn);
			      {
				   E Tp, Te, Tz, TE;
				   Tp = FMA(KP801937735, To, Th);
				   Te = FNMS(KP900968867, Td, T1);
				   Tz = FNMS(KP900968867, Ty, Tt);
				   TE = FMA(KP801937735, TD, TA);
				   {
					E Tb, Tq, TI, TF, Ts, Tr, TG;
					Tb = W[0];
					Tq = FNMS(KP974927912, Tp, Te);
					TI = FMA(KP974927912, Tp, Te);
					TF = FMA(KP974927912, TE, Tz);
					TL = FNMS(KP974927912, TE, Tz);
					Ts = W[1];
					Tr = Tb * Tq;
					TH = W[10];
					TK = W[11];
					TG = Ts * Tq;
					rio[WS(ios, 1)] = FNMS(Ts, TF, Tr);
					TJ = TH * TI;
					TM = TK * TI;
					iio[-WS(ios, 5)] = FMA(Tb, TF, TG);
				   }
			      }
			 }
		    }
		    iio[-WS(ios, 6)] = Tt + Tu + Tv + Tw;
		    rio[WS(ios, 6)] = FNMS(TK, TL, TJ);
		    iio[0] = FMA(TH, TL, TM);
		    {
			 E T1t, T1p, T1s, T1r, T1u, T1c, T1k, T1m;
			 T1c = FNMS(KP900968867, T1b, T1);
			 T1k = FNMS(KP900968867, T1j, Tt);
			 T1m = FNMS(KP801937735, T1l, TB);
			 {
			      E T19, T1f, T1q, T1n, T1h, T1g, T1o;
			      T19 = W[2];
			      T1f = FNMS(KP974927912, T1e, T1c);
			      T1q = FMA(KP974927912, T1e, T1c);
			      T1n = FMA(KP974927912, T1m, T1k);
			      T1t = FNMS(KP974927912, T1m, T1k);
			      T1h = W[3];
			      T1g = T19 * T1f;
			      T1p = W[8];
			      T1s = W[9];
			      T1o = T1h * T1f;
			      rio[WS(ios, 2)] = FNMS(T1h, T1n, T1g);
			      T1r = T1p * T1q;
			      T1u = T1s * T1q;
			      iio[-WS(ios, 4)] = FMA(T19, T1n, T1o);
			 }
			 {
			      E TY, TT, T10, TQ;
			      TQ = FNMS(KP900968867, TP, T1);
			      rio[WS(ios, 5)] = FNMS(T1s, T1t, T1r);
			      iio[-WS(ios, 1)] = FMA(T1p, T1t, T1u);
			      TY = FNMS(KP900968867, TX, Tt);
			      T14 = FMA(KP974927912, TS, TQ);
			      TT = FNMS(KP974927912, TS, TQ);
			      T10 = FNMS(KP801937735, TZ, TC);
			      {
				   E TN, TV, T11, TU, T12;
				   TN = W[4];
				   TV = W[5];
				   T13 = W[6];
				   T17 = FNMS(KP974927912, T10, TY);
				   T11 = FMA(KP974927912, T10, TY);
				   TU = TN * TT;
				   T12 = TV * TT;
				   T15 = T13 * T14;
				   T16 = W[7];
				   rio[WS(ios, 3)] = FNMS(TV, T11, TU);
				   iio[-WS(ios, 3)] = FMA(TN, T11, T12);
			      }
			 }
		    }
	       }
	  }
	  rio[WS(ios, 4)] = FNMS(T16, T17, T15);
	  T18 = T16 * T14;
	  iio[-WS(ios, 2)] = FMA(T13, T17, T18);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 7},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 7, "hb_7", twinstr, &GENUS, {18, 12, 54, 0}, 0, 0, 0 };

void X(codelet_hb_7) (planner *p) {
     X(khc2hc_register) (p, hb_7, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -sign 1 -n 7 -dif -name hb_7 -include hb.h */

/*
 * This function contains 72 FP additions, 60 FP multiplications,
 * (or, 36 additions, 24 multiplications, 36 fused multiply/add),
 * 36 stack variables, and 28 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hb.h"

static const R *hb_7(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP222520933, +0.222520933956314404288902564496794759466355569);
     DK(KP900968867, +0.900968867902419126236102319507445051165919162);
     DK(KP623489801, +0.623489801858733530525004884004239810632274731);
     DK(KP781831482, +0.781831482468029808708444526674057750232334519);
     DK(KP974927912, +0.974927912181823607018131682993931217232785801);
     DK(KP433883739, +0.433883739117558120475768332848358754609990728);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 12, MAKE_VOLATILE_STRIDE(ios)) {
	  E T1, Ta, T4, T7, Tq, TI, TR, TU, TE, Tt, Tb, Tk, Te, Th, Tx;
	  E TF, TV, TQ, TJ, Tm;
	  {
	       E To, Tn, Tp, T8, T9;
	       T1 = rio[0];
	       T8 = rio[WS(ios, 3)];
	       T9 = iio[-WS(ios, 4)];
	       Ta = T8 + T9;
	       To = T8 - T9;
	       {
		    E T2, T3, T5, T6;
		    T2 = rio[WS(ios, 1)];
		    T3 = iio[-WS(ios, 6)];
		    T4 = T2 + T3;
		    Tn = T2 - T3;
		    T5 = rio[WS(ios, 2)];
		    T6 = iio[-WS(ios, 5)];
		    T7 = T5 + T6;
		    Tp = T5 - T6;
	       }
	       Tq = FMA(KP433883739, Tn, KP974927912 * To) - (KP781831482 * Tp);
	       TI = FMA(KP781831482, Tn, KP974927912 * Tp) + (KP433883739 * To);
	       TR = FNMS(KP781831482, To, KP974927912 * Tn) - (KP433883739 * Tp);
	       TU = FMA(KP623489801, Ta, T1) + FNMA(KP900968867, T7, KP222520933 * T4);
	       TE = FMA(KP623489801, T4, T1) + FNMA(KP900968867, Ta, KP222520933 * T7);
	       Tt = FMA(KP623489801, T7, T1) + FNMA(KP222520933, Ta, KP900968867 * T4);
	  }
	  {
	       E Tv, Tw, Tu, Ti, Tj;
	       Tb = iio[0];
	       Ti = rio[WS(ios, 4)];
	       Tj = iio[-WS(ios, 3)];
	       Tk = Ti - Tj;
	       Tv = Ti + Tj;
	       {
		    E Tc, Td, Tf, Tg;
		    Tc = iio[-WS(ios, 1)];
		    Td = rio[WS(ios, 6)];
		    Te = Tc - Td;
		    Tw = Tc + Td;
		    Tf = rio[WS(ios, 5)];
		    Tg = iio[-WS(ios, 2)];
		    Th = Tf - Tg;
		    Tu = Tf + Tg;
	       }
	       Tx = FNMS(KP974927912, Tv, KP781831482 * Tu) - (KP433883739 * Tw);
	       TF = FMA(KP781831482, Tw, KP974927912 * Tu) + (KP433883739 * Tv);
	       TV = FMA(KP433883739, Tu, KP781831482 * Tv) - (KP974927912 * Tw);
	       TQ = FMA(KP900968867, Th, Tb) + FNMA(KP623489801, Tk, KP222520933 * Te);
	       TJ = FMA(KP623489801, Te, Tb) + FMA(KP222520933, Th, KP900968867 * Tk);
	       Tm = FMA(KP222520933, Tk, Tb) + FNMA(KP623489801, Th, KP900968867 * Te);
	  }
	  rio[0] = T1 + T4 + T7 + Ta;
	  iio[-WS(ios, 6)] = Tb + Te - (Th + Tk);
	  {
	       E TM, TO, TL, TN;
	       TM = TJ - TI;
	       TO = TE + TF;
	       TL = W[10];
	       TN = W[11];
	       iio[0] = FMA(TL, TM, TN * TO);
	       rio[WS(ios, 6)] = FNMS(TN, TM, TL * TO);
	  }
	  {
	       E TY, T10, TX, TZ;
	       TY = TU + TV;
	       T10 = TR + TQ;
	       TX = W[2];
	       TZ = W[3];
	       rio[WS(ios, 2)] = FNMS(TZ, T10, TX * TY);
	       iio[-WS(ios, 4)] = FMA(TX, T10, TZ * TY);
	  }
	  {
	       E Tr, Ty, Tl, Ts;
	       Tr = Tm - Tq;
	       Ty = Tt - Tx;
	       Tl = W[6];
	       Ts = W[7];
	       iio[-WS(ios, 2)] = FMA(Tl, Tr, Ts * Ty);
	       rio[WS(ios, 4)] = FNMS(Ts, Tr, Tl * Ty);
	  }
	  {
	       E TA, TC, Tz, TB;
	       TA = Tt + Tx;
	       TC = Tq + Tm;
	       Tz = W[4];
	       TB = W[5];
	       rio[WS(ios, 3)] = FNMS(TB, TC, Tz * TA);
	       iio[-WS(ios, 3)] = FMA(Tz, TC, TB * TA);
	  }
	  {
	       E TS, TW, TP, TT;
	       TS = TQ - TR;
	       TW = TU - TV;
	       TP = W[8];
	       TT = W[9];
	       iio[-WS(ios, 1)] = FMA(TP, TS, TT * TW);
	       rio[WS(ios, 5)] = FNMS(TT, TS, TP * TW);
	  }
	  {
	       E TG, TK, TD, TH;
	       TG = TE - TF;
	       TK = TI + TJ;
	       TD = W[0];
	       TH = W[1];
	       rio[WS(ios, 1)] = FNMS(TH, TK, TD * TG);
	       iio[-WS(ios, 5)] = FMA(TD, TK, TH * TG);
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 7},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 7, "hb_7", twinstr, &GENUS, {36, 24, 36, 0}, 0, 0, 0 };

void X(codelet_hb_7) (planner *p) {
     X(khc2hc_register) (p, hb_7, &desc);
}
#endif				/* HAVE_FMA */
