#
# Copyright (c) 2008 Canonical
#
# Written by Marc Tardif <marc@interunion.ca>
#
# This file is part of HWTest.
#
# HWTest is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# HWTest is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with HWTest.  If not, see <http://www.gnu.org/licenses/>.
#
import md5
import logging

from datetime import datetime

from hwtest.plugin import Plugin


class SubmissionInfo(Plugin):

    optional_attributes = ["submission_id"]

    def register(self, manager):
        super(SubmissionInfo, self).register(manager)
        self._system_id = None

        for (rt, rh) in [
             ("report", self.report),
             ("report-system_id", self.report_system_id)]:
            self._manager.reactor.call_on(rt, rh)

    def report_system_id(self, system_id):
        self._system_id = system_id

    def report(self):
        submission_id = self.config.submission_id
        if not submission_id:
            if not self._system_id:
                return

            fingerprint = md5.new()
            fingerprint.update(self._system_id)
            fingerprint.update(str(datetime.utcnow()))
            submission_id = fingerprint.hexdigest()

        message = submission_id
        logging.info("Submission ID: %s", message)
        self._manager.reactor.fire("report-submission_id", message)


factory = SubmissionInfo
