/***************************************************************************
 *
 * knetworkmanager-connectioninfodialog.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTIONINFODIALOG_H
#define KNETWORKMANAGER_CONNECTIONINFODIALOG_H

#include <kdialogbase.h>
#include <qobject.h>
#include <qguardedptr.h>

#include "connectioninfowidget.h"
#include "knetworkmanager.h"

class ConnectionInfoWidgetImpl : public ConnectionInfoWidget
{
	Q_OBJECT
	public:
	  ConnectionInfoWidgetImpl(QWidget* parent = 0, const char* name = 0, WFlags f = 0);
	  QSize sizeHint() const;
	  QSize minimumSizeHint() const;
};

class ConnectionInfoDialog : public KDialogBase
{
	Q_OBJECT
	public:
	  ConnectionInfoDialog(KNetworkManager* ctx, QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
	  ~ConnectionInfoDialog();

	public slots:
	  void deviceStoreChanged(DeviceStore* store);

	private:
	  void updateConnectionInfo();

	  KNetworkManager* _ctx;
	  ConnectionInfoWidgetImpl* _infoWidget;
	  QGuardedPtr<Device> _curDev;
	  QGuardedPtr<Network> _curNet;
};

#endif /* KNETWORKMANAGER_CONNECTIONINFODIALOG_H */
