/***************************************************************************
 *
 * knetworkmanager-vpnc.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_VPNC_H
#define KNETWORKMANAGER_VPNC_H

#include <qmap.h>
#include <qstring.h>
#include <qwidget.h>
#include <qlayout.h>

#include "knetworkmanager-vpnplugin.h"
#include "vpncprop.h"
#include "vpncauth.h"

class VPNCPlugin : public VPNPlugin
{
	Q_OBJECT
	public:
		VPNCPlugin(QObject*, const char*, const QStringList&);
		~VPNCPlugin();

		VPNConfigWidget* CreateConfigWidget(QWidget* parent=0);
		VPNAuthenticationWidget* CreateAuthenticationWidget(QWidget* parent=0);
};

class VPNCConfig : public VPNConfigWidget
{
	Q_OBJECT
	public:
		void setVPNData(const QStringList& routes, const QStringList& properties);
		QStringList getVPNProperties();
		QStringList getVPNRoutes();
		bool hasChanged();
		bool isValid(QStringList& );

		VPNCConfig(QWidget* parent);
		~VPNCConfig();

	private:
		VPNCConfigWidget*   _vpncWidget;

	protected slots:
		void languageChange();
};

class VPNCAuthentication : public VPNAuthenticationWidget
{
	Q_OBJECT
	public:
		VPNCAuthentication(QWidget* parent = NULL, char* name = NULL);
		~VPNCAuthentication();
		QStringList getPasswords();

	private:
		VPNCAuthenticationWidget* _vpncAuth;
};

#endif /* KNETWORKMANAGER_VPNC_H */
