/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kdebug.h>

#include <qtooltip.h>

#include <klistview.h>

#include "logListItem.h"

#include "viewToolTip.h"
#include "view.h"


ViewToolTip::ViewToolTip(QWidget *parent, View *view) :
	QToolTip(parent),
	view(view) {
	
}

ViewToolTip::~ViewToolTip() {
	clear();
}


void ViewToolTip::maybeTip(const QPoint& p) {
	//ViewToolTip::setWakeUpDelay(1000);
	
	if (!view->isTooltipEnabled() )
		return;
	
	QListViewItem *qtItem = view->getLogList()->itemAt(p);
	if (qtItem && qtItem->childCount() == 0) {
		LogListItem* item = static_cast<LogListItem*> (qtItem);
				
		QString s=item->getToolTipText();
		
		QRect r= view->getLogList()->itemRect(item);
		//kdDebug() << "Left=" << r.left() << " Right=" << r.right() << " Top=" << r.top() << " Bottom=" << r.bottom() << endl;
		
		tip(r, s);
	}
}
