#include <ept/core/apt.h>
#include <ept/core/list.h>

using namespace ept::core;

int summary = 0;

template< typename List >
void printList( List l )
{
    while ( !l.empty() ) {
        if ( summary ){
            record::Parser p( l.property() );
            std::cout << p.get< record::Name >() << "_"
                      << p.get< record::Version >() << " - "
                      << p.get< record::ShortDescription >() << std::endl;
        } else
            std::cout << l.property() << std::endl;
        l = l.tail();
    }
}

int main( int argc, char **argv ) {
    AptDatabase db;
    record::Source recs( db );
    if ( argc == 2 && std::string( argv[ 1 ] ) == "-s" )
        summary = 1;
    printList( recs.list< record::Record >() );
}
