/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: EncodingUtility.java 3523 2007-10-16 11:03:09Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */

package org.jfree.fonts.encoding;

import org.jfree.fonts.encoding.manual.Utf16LE;

/**
 * Creation-Date: 21.07.2007, 19:44:31
 *
 * @author Thomas Morgner
 */
public class EncodingUtility
{
  private EncodingUtility()
  {
  }

  public static String encode (final byte[] data, final String encoding) throws EncodingException
  {
    final Encoding enc;
    if ("UTF-16".equals(encoding))
    {
      enc = EncodingRegistry.getInstance().getEncoding("UTF-16LE");
    }
    else
    {
      enc = EncodingRegistry.getInstance().getEncoding(encoding);
    }

    final ByteBuffer byteBuffer = new ByteBuffer(data);
    final CodePointBuffer cp = enc.decode(byteBuffer, null);
    return Utf16LE.getInstance().encodeString(cp);
  }
}
