/**
 * =========================================
 * LibXML : a free Java layouting library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libxml/
 *
 * (C) Copyright 2006, by Object Refinery Ltd, Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * $Id: XmlFactoryModule.java,v 1.6 2007/06/03 17:07:08 taqua Exp $
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */
package org.jfree.xmlns.parser;

/**
 * The XmlFactoryModule is the base of a plugin-structure to allow
 * parser-multiplexing. In that case, the actual implementation of the
 * parser will be selected according to the DTD, Namespace or root-tag
 * of the document.
 *
 * @author Thomas Morgner
 */
public interface XmlFactoryModule
{
  /**
   * A constant declaring that the content has been recognized by the
   * declared namespace.
   */
  public static final int RECOGNIZED_BY_NAMESPACE = 4000;
  /**
   * A constant declaring that the content has been recognized by the
   * declared Document Type Declaration (DTD).
   */
  public static final int RECOGNIZED_BY_DTD = 2000;
  /**
   * A constant declaring that the content has been recognized by the
   * tagname of the root-element of the XML-document.
   */
  public static final int RECOGNIZED_BY_TAGNAME = 1000;
  /**
   * A constant declaring that the content has NOT been recognized by any mean.
   */
  public static final int NOT_RECOGNIZED = -1;

  /**
   * Checks the given document data to compute the propability of whether this
   * factory module would be able to handle the given data.
   *
   * @param documentInfo the document information collection.
   * @return an integer value indicating how good the document matches the
   * factories requirements.
   */
  public int getDocumentSupport (XmlDocumentInfo documentInfo);

  /**
   * Creates an XmlReadHandler for the root-tag based on the given document
   * information.
   *
   * @param documentInfo the document information that has been extracted from
   * the parser.
   * @return the root handler or null.
   */
  public XmlReadHandler createReadHandler (XmlDocumentInfo documentInfo);

  /**
   * Returns the default namespace for a document with the characteristics
   * given in the XmlDocumentInfo.
   *
   * @param documentInfo the document information.
   * @return the default namespace uri for the document.
   */
  public String getDefaultNamespace (XmlDocumentInfo documentInfo);
}
