/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2007 Tadas Dailyda <tadas@dailyda.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __ODS_COMMON_H_
#define __ODS_COMMON_H_

#include <dbus/dbus-glib.h>
#include <time.h>

/* Reference to the type of BUS we are using */
extern DBusBusType ODS_DBUS_BUS;
#define	ODS_DBUS_SERVICE		"org.openobex"

enum {
  ODS_SERVICE_OPP = 1,
  ODS_SERVICE_FTP,
  ODS_SERVICE_PBAP
};

#define ODS_OPP_RFCOMM_CHANNEL	9
#define ODS_FTP_RFCOMM_CHANNEL	10
#define ODS_PBAP_RFCOMM_CHANNEL 15

gboolean	ods_check_bluetooth_address (const gchar *str);
gboolean	ods_check_caller (DBusGMethodInvocation *context, const gchar *owner);
glong		ods_get_uname (gunichar2 **uname, const gchar *name);
gchar *		ods_utf16_to_utf8 (const guchar *utf16, size_t len);
gint		ods_make_iso8601 (time_t time, gchar *str, gint len);
time_t		ods_parse_iso8601 (const gchar *str, gint len);

#endif /*__ODS_COMMON_H_*/
