/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Iterator.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2006/11/01 09:14:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/*  Copyright 2005 Sun Microsystems, Inc. */

#ifndef INCLUDED_ITERATOR_HXX
#define INCLUDED_ITERATOR_HXX

#include <boost/shared_ptr.hpp>

namespace odiapi { namespace props {

/** An abstract iterator interface.
 */
template<typename T>
class Iterator
{
public:
  typedef boost::shared_ptr< Iterator<T> > Pointer_t;

  /** Reset the iterator
   */
  virtual void first() = 0;
	
  /** Go to the next item.

      @precond !isDone()
  */
  virtual void next() = 0;
	
  /** Get the current item

      @precond !isDone()
        
      @return The current property
  */
  virtual T getCurrent() const = 0;

  /** Iteration done?
        
      @return true if iteration is done false otherwise
  */
  virtual bool isDone() const = 0;
      
  /** Destructor
   */
  virtual ~Iterator() {};
};

} } // namespace odiapi { namespace props {
 
#endif 
