/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wizardheader.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 14:16:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SVTOOLS_WIZARDHEADER_HXX
#define SVTOOLS_WIZARDHEADER_HXX

#ifndef _SV_CTRL_HXX
#include <vcl/ctrl.hxx>
#endif

class Bitmap;
//.........................................................................
namespace svt
{
//.........................................................................

	class WizardHeaderImpl;
	//=====================================================================
	//= WizardHeader
	//=====================================================================
	class WizardHeader : public Control
	{
	protected:
		WizardHeaderImpl*		m_pImpl;

	public:
		WizardHeader( Window* _pParent, const ResId& _rId );
		WizardHeader( Window* _pParent, WinBits _nWinStyle = 0 );
		~WizardHeader( );

	public:
		/**	sets the bitmap to be used
			@param	_rBmp
				the new bitmap
			@param	_bInvalidate
				if <TRUE/>, the control will be invalidated and thus repainted
		*/
		void			setHeaderBitmap( const Bitmap& _rBmp, sal_Bool _bInvalidate = sal_True );

		/** returns the bitmap currently used
		*/
		const Bitmap&	getHeaderBitmap( ) const;

		/** sets the text to be displayed
			<p>In a wizard, you usually change the text with ever page change.</p>
			@param	_rText
				the new text
			@param	_bInvalidate
				if <TRUE/>, the control will be invalidated and thus repainted
		*/
		void			setHeaderText( const String& _rText, sal_Bool _bInvalidate = sal_True );

		/** returns the text currently used
		*/
		const String&	getHeaderText( ) const;

	protected:
		// Window overridables
		void			Paint( const Rectangle& _rRect );

	private:
		void implInit();
	};

//.........................................................................
}	// namespace svt
//.........................................................................

#endif // SVTOOLS_WIZARDHEADER_HXX

