import copy

import utils
from lphelper import sort

from bughelper_error import LPUrlError as LPURLERROR


class LPBugPage(frozenset):
    """
    grab content of a single bug-table    
    """
    @staticmethod
    def find_parse_function(connection, url, all_tasks):
        raise NotImplementedError, 'this method must be implemented by a concrete subclass'
    
    def __new__(cls, url, connection=None, all_tasks=False, class_helper=None):
        assert connection, "Connection object needed"
        tested_url = utils.valid_lp_url(url,utils.BUGPAGE)
        assert tested_url, "Invalid launchpad url %s" %url
        
        if class_helper:
            assert issubclass(class_helper, LPBugPage), "class_helper needs to be subclass of LPBugPage"
        else:
            class_helper = LPBugPage
        
        x, following_page = class_helper.find_parse_function(connection, tested_url, all_tasks)
        obj = super(LPBugPage, cls).__new__(LPBugPage, x)
        obj.following_page = following_page
        return obj
            
    def get_bugs(self):
        # should be removed in the future, as self is now a set itself
        return self
    bugs = property(fget=get_bugs,doc="get bugs")

class _TempBugList(set):
    def __init__(self, bugs):
        set.__init__(self, bugs)
        
    def __re_init__(self, bugs):
        set.__init__(self, bugs)
        

class LPBugList(set):
    """
    returns a SET of BugInfo objects
    searches baseurl and its following pages
    
    TODO:
        * on-demand parsing
        * documentation
        * 'length' not working
    
    """
    def __new__(cls, *args, **kwargs):
        obj = set.__new__(cls)
        return obj
    
    def __init__(self, baseurl, connection=None, filter=None, length=True,
                    all_tasks=False, start_bugs=[], helper_bugpage=None):
                        
        self.__args = locals().copy()
        del self.__args["self"]
        assert connection, "Connection object needed"
        self.__connection = connection
        self.__all_tasks = all_tasks
        
        self.__filter = filter
        self.__length = length
        
        try:
            url = baseurl.baseurl
            assert not filter, "unable to handle filtered baseurl AND filter-argument"
            self.__filter = baseurl    
        except AttributeError:
            url = baseurl
        self.baseurl = utils.valid_lp_url(url,utils.BUGLIST)
        assert self.baseurl, "Invalid launchpad url %s" %baseurl
        
        self.class_helper_bugpage = helper_bugpage
            
        self.__re_init__(start_bugs)
        #FIXME: only parse if neccessary?
        self._add(self.baseurl)
        
    def __repr__(self):
        return "<BugList %s>" %self.baseurl.split("?")[0]
        
    def __str__(self):
        return "BugList([%s])" %",".join(repr(i) for i in self)
        
    def __re_init__(self, bugs):
        set.__init__(self, bugs)
        
    def __copy__(self):
        return self.__class__(**self.__args)    
        
    def copy(self):
        return copy.copy(self)
        
    # EXPERIMENTAL on-demand parsing
    #def __getattribute__(self, name):
        #print "GETATTRIBUTE", name
        #if not set.__getattribute__(self, "parsed"):
            #self.parsed = True
            #set.__getattribute__(self, "_add")(self.baseurl)
        #return set.__getattribute__(self, name)
    
    def __iadd__(self, other):
        """ let l be an instance of BugList,
        l += BugList(<LP-URL>) will add bugs to l
        l.add(<LP-URL>) is still possible
        """
        self.__re_init__(self.union(other))
        return self
    
    def filter(self,func=None):
        """
        filters bugs-set by given func and returns a new BugList object
        """
        if func is None:
            func = set()
        if not isinstance(func, set):
            func = set(func)
        func = func | self.__filter.functions
        bugs = self.copy()
        for f in set(func):
            bugs = f(bugs)
        
        self.__re_init__(bugs)
        return self
    
    def sort(self, optsort):
        """ returns a LIST of bugs sorted by optsort """
        return sorted(self, cmp=lambda x,y: sort(x,y,optsort.strip("-")), reverse=optsort.startswith("-"))
    
    
    def _fetch(self, url):
        """
        searches given bugpage for bugs and 'next'-page and returns both values
        
        if calling <url> returns an LPURLERROR, this error will be ignored
        if there are still bugs in the buglist, otherwise raised again
        """
        if self.class_helper_bugpage is None:
            raise NotImplementedError, 'this method must be implemented by a concrete subclass'
        follow = None
        bp = frozenset()
        try:
            bp = self.class_helper_bugpage(url, connection=self.__connection, all_tasks=self.__all_tasks,
                                                class_helper=self.class_helper_bugpage)
            follow = bp.following_page
        except LPURLERROR, e:
            if len(self) == 0:
                raise LPURLERROR(text = str(e))
        return bp, follow
    

    def _add(self, url, follow=True):
        """ adds bugs to the buglist """
        myfollow = True
        allbugs = set()
        x = True
        
        while(url and myfollow and x):
            (bugs,url) = self._fetch(url)
            myfollow = follow
            b = _TempBugList(bugs)
            if getattr(self.__filter, "filter", False):
                self.__filter.filter(b)
            x = getattr(b, "stopped", True)
            self += b
            
    def _get_class_helper_bugpage(self):
        if not self.__class_helper_bugpage:
            raise NotImplementedError, 'this method must be implemented by a concrete subclass'
        return self.__class_helper_bugpage
        
    def _set_class_helper_bugpage(self, value):
        #if not (issubclass(value, LPBugPage) or value is None):
        if not (value is None or issubclass(value, LPBugPage)):
            raise TypeError, "BugList.class_helper_bugpage needs to be instance of LPBugPage"
        self.__class_helper_bugpage = value
    class_helper_bugpage = property(_get_class_helper_bugpage, _set_class_helper_bugpage)
            
    def get_bugs(self):
        # should be removed in the future, as self is now a set itself
        return self
    bugs = property(fget=get_bugs,doc="get list of bugs")
