#!/usr/bin/env python
######################################################################
# automatically generate a html page which lists kernel bugs the
# kernel team might want to look at:
#
# http://people.ubuntu.com/~ogasawara/hardy-buglist.html
#
# this script requires that you pass in a separate file containing
# the list of bugs.  The list must be in the following format:
#
# <bug number>,<comment>,[carry-fwd],
#
# for example:
# 112233,kernel config change,,
# 445566,patch upstream,,
# 0,end of the current week's bug list,,
# 778899,bitesize patch,carry-fwd,
#
# The resulting display will be sorted by Importance.
######################################################################

import os
import sys
import launchpadbugs.connector as Connector
import commands
import re

class Importance(object):
    def __init__(self):
        self.critical = []
        self.high = []
        self.medium = []
        self.low = []
        self.wishlist = []
        self.undecided = []
        self.unknown = []

def SortImportance(html, importance, list):
        if importance == 'Critical':
            list.critical.append(html)
        if importance == 'High':
            list.high.append(html)
        if importance == 'Medium':
            list.medium.append(html)
        if importance == 'Low':
            list.low.append(html)
        if importance == 'Wishlist':
            list.wishlist.append(html)
        if importance == 'Undecided':
            list.undecided.append(html)
        if importance == 'Unknown':
            list.unknown.append(html)

def BuildBuglist(list):
    html = ""
    for line in list.critical:
        html += line
    for line in list.high:
        html += line
    for line in list.medium:
        html += line
    for line in list.low:
        html += line
    for line in list.wishlist:
        html += line
    for line in list.undecided:
        html += line
    for line in list.unknown:
        html += line

    return html

release=["hardy","Hardy Heron"]

if len(sys.argv) != 2:
    print 'Usage: %s <%s-buglist.txt>' % (sys.argv[0], release[0])
    sys.exit(1)

red = "#ffa2a2"
green = "#c4ffc4"
yellow = "#fffec4"
grey = "#e0e0e0"

longnames = ["linux (Ubuntu)",
            "linux-ubuntu-modules-2.6.24 (Ubuntu)",
            "linux-restricted-modules-2.6.24 (Ubuntu)",
            "initramfs-tools (Ubuntu)",
            "module-init-tools (Ubuntu)"]

current = Importance()
carry_fwd = Importance()
fixed = Importance()

Bug = Connector.ConnectBug("TEXT")
htmlfile = "./%s-buglist-temp.html" % (release[0])
buglist = sys.argv[1]

html = "<html>\n"
html += "<head>\n"
html += "\t<title>%s Kernel Buglist</title>\n" % (release[1])
html += "\t<link defanghtml_rel=\"made\" defanghtml_href=\"mailto:webmaster@ubuntu.com\">\n"
html += "\t<link rel=\"stylesheet\" type=\"text/css\" charset=\"utf-8\" media=\"all\" href=\"http://www.ubuntu.com/htdocs/ubuntuweb/css/common.css\">\n"
html += "\t<link rel=\"stylesheet\" type=\"text/css\" charset=\"utf-8\" media=\"screen\" href=\"http://www.ubuntu.com/htdocs/ubuntuweb/css/screen.css\">\n"
html += "\t<link rel=\"stylesheet\" type=\"text/css\" charset=\"utf-8\" href=\"buglist.css\">\n"
html += "</head>"
html += "<body>\n"
html += "<h3>%s Kernel Buglist</h3>\n" % (release[1])

html_table = "<p>\n<table border=1>\n"
html_table += "<tbody><tr>\n"
html_table += "\t<th align=center>Bug</defanghtml_hd>\n"
html_table += "\t<th align=center>Importance</th>\n"
html_table += "\t<th align=center>Status</th>\n"
html_table += "\t<th align=center>Summary</th>\n"
html_table += "\t<th align=center>Assignee</th>\n"
html_table += "\t<th align=center>Comments</th>\n"
html_table += "</tr>\n"

html += html_table
html_fixed = html_table
html_fixed += "<p></p><h3>Fixed Bugs</h3>"
html_carryfwd = ''

current_list = 1
LIST = open(buglist, "r")
for line in LIST:
    print line

    if re.match('#', line):
        continue

    arg = line.split(',')
    num = arg[0]
    comment = arg[1]

    if num == "0":
        print "End of current week's list"
        current_list = 0
        continue

    URL = "https://bugs.launchpad.net/ubuntu/+bug/" + num
    bug = Bug(url=URL)
    info = ""
    for i in bug.infotable:
        if i.affects.longname in longnames and i.status != "Invalid":
            info = i
            break

    if not info:
        print "**** NOT A KERNEL BUG ****"
        continue

    html_row = "<tr>\n"
    html_row += "\t<td class=\"first\"><a href=\"%s\">%s</a></td>\n" % (URL, num)

    if info.importance == "Critical" or info.importance == "High":
        info_color = red
    elif info.importance == "Medium":
        info_color = yellow
    else:
        info_color = ""

    html_row += "\t<td bgcolor =\"%s\">%s</td>\n" % (info_color, info.importance)

    if info.status == 'Fix Released' or info.status == 'Fix Committed':
        status_color = green
    elif info.status == 'In Progress':
        status_color = yellow
    elif info.status == 'Invalid' or info.status == 'Won\'t Fix':
        status_color = grey
    else:
        status_color=""

    html_row += "\t<td bgcolor=\"%s\">%s</td>\n" % (status_color, info.status)
    html_row += "\t<td>%s</td>\n" % bug.summary
    html_row += "\t<td>%s</td>\n" % info.assignee
    html_row += "\t<td>%s</td>\n" % comment
    html_row += "</tr>\n"

    if current_list == 1:
        SortImportance(html_row, info.importance, current)

    if info.status == 'Fix Released' or info.status == 'Fix Committed':
        SortImportance(html_row, info.importance, fixed)
    elif arg[2]:
        SortImportance(html_row, info.importance, carry_fwd)

LIST.close()

html += BuildBuglist(current)
html += "<tr><th colspan=\"6\">Carried Forward from Previous Week(s)</th></tr>"
html += BuildBuglist(carry_fwd)
html += "</tbody></table>\n</p>"
html += html_fixed
html += BuildBuglist(fixed)
html += "</table>\n</p>"
html += "</tbody></table></p></body></html>\n"
HTML = open(htmlfile, 'w')
HTML.write(html)
HTML.close()
