import urllib
import urlparse

from lpconstants import BUGLIST
    
def minbug(bug, minbug):
    return int(bug) >= minbug and bug
        
def filterbug(bug, buglist):
    return int(bug) not in buglist and bug
    
def hasbranch(bug, cls=None):
    try:
        br = bug.branches
        if not br:
            return False
        else:
            return True and bug
    except AttributeError:
        if cls:
            try:
                bug = cls(bug)
                br = bug.branches
                if not br:
                    return False
                else:
                    return True and bug
            except:
                raise RuntimeError, "Something went wrong"

def reporter(bug, reporter, cls=None):
    try:
        return bug.reporter == reporter and bug
    except AttributeError:
        if cls:
            try:
                bug = cls(bug)
                return x.reporter == reporter and bug
            except:
                raise RuntimeError, "Something went wrong"
        else:
            raise NotImplementedError, "Please define your own reporter-filterfunction"
            
            
#this is a HACK-filter to get current task-row
def get_current_task(bug, listurl, cls=None):
    try:
        t = bug.infotable
    except AttributeError:
        if cls:
            try:
                bug = cls(bug)
                t = bug.infotable
            except:
                raise RuntimeError, "Something went wrong"
        else:
            raise NotImplementedError, "Please define your own get_current_task-filterfunction"
    
    if t._current is None:
        idx_fallback = None
        y = t.current_from_listurl(listurl)
        for idx, a in enumerate(t):
            if a.is_current(y):
                t._current = idx
                break
            if a.target == y[2]:
                idx_fallback = idx
        else:
            # there is no way to find the currrent task if we are searching
            # an package-unspecific list like https://bugs.edge.launchpad.net/ubuntu/+bugs
            # as a fallback take the last one with the right target, in this case,
            # take the last one where .target == 'ubuntu'
            
            # if idx_fallback is still None, this is worse an error message, because in this case
            # parsing went wrong
            assert not idx_fallback is None, "parsing of '%s' went wrong" %bug.url
            t._current = idx_fallback
    return bug
            
def lastcomment(bug, cls=None, **comment_def):
    """
    comment_def["user"], type: str or lphelper.user or "reporter"
    comment_def["before"], type: datetime
    comment_def["after"], type: datetime
    comment_def["operation"], in ["|","&"]
    """
    if not comment_def:
        raise TypeError, "lastcomment-function needs at least one definitional argument"
    if not set(comment_def.keys()) <= set(["user","before","after","operation", "at"]):
        raise TypeError, "unknown definitional argument for lastcomment"
    if "at" in comment_def.keys():
        if "before" in comment_def.keys() or "after" in comment_def.keys():
            raise TypeError, "'at' and 'after' or 'before' is not allowed"
    conditions = []
    operation = comment_def.get("operation","|")
    if operation not in ("|","&"):
        raise ValueError, "unknown operation"
    try:
        c = bug.comments
        if not c:
            return False
        lastcomment = c[-1]
    except AttributeError:
        if cls:
            try:
                bug = cls(bug)
                c = bug.comments
                if not c:
                    return False
                lastcomment = c[-1]
            except:
                raise RuntimeError, "Something went wrong"
        else:
            raise NotImplementedError, "Please define your own reporter-filterfunction"
    if "user" in comment_def:
        if comment_def["user"] == "reporter":
            comment_def["user"] = bug.reporter
        conditions.append(lastcomment.user == comment_def["user"])
    if "at" in comment_def:
        conditions.append(lastcomment.date.timetuple()[:3] == comment_def["at"].timetuple()[:3])
    if "before" in comment_def:
        conditions.append(lastcomment.date <= comment_def["before"])
    if "after" in comment_def:
        conditions.append(lastcomment.date >= comment_def["after"])
    #print conditions
    if operation == "&":
        return not (False in conditions) and bug
    else:
        return True in conditions and bug


class StopFiltering(StopIteration):
    pass
    
class LPBugListFilter(object):
    
    def __init__(self, func=[]):
        self._functions = func
        self._func_cache = self._functions[:]
        
    @property
    def functions(self):
        return self._functions
        
    def reset(self):
        self._functions = self._func_cache
        
    def filter(self, bugs, INLINE=True):
        self.__stop_by_filter = True
        if not self.functions:
            return bugs
        if isinstance(bugs, str):
            bugs = (bugs,)
        try:
            x = iter(bugs)
        except TypeError:
            x = (bugs,)
        for f in self.functions:
            def _iter_bugs():
                for b in x:
                    try:
                        yield f(b)
                    except StopFiltering:
                        self.__stop_by_filter = False
                        raise StopIteration
            r = set(_iter_bugs())
            r.discard(False)
            x = r
        r.discard(False)
        try:
            if not INLINE:
                bugs = bugs.copy()
            bugs.__re_init__(r)
            bugs.stopped = self.__stop_by_filter
            return bugs
        except AttributeError:
            return r

def parse_options(url_opt):
    result = {}
    if url_opt:
        for i in urllib.unquote_plus(url_opt).split("&"):
            k = i.split("=")
            try:
                result[k[0]].add(k[1])
            except:
                result[k[0]] = set([k[1]])
    return result
    

class URLBugListFilter(LPBugListFilter):
    
    ADD = 1
    OVERWRITE = 2
    CONFLICTS_ERROR = 3
    
    OPTION_DICT = { "status": "field.status:list",
                    "importance": "field.importance:list",
                    "tag": "field.tag",
                    "assignee": "field.assignee",
                    "reporter": "field.bug_reporter",
                    "contact": "field.bug_contact",
                    "commenter": "field.bug_commenter",
                    "subscriber": "field.subscriber",
                    "duplicates": "field.omit_dupes",
                    "component": "field.component",
                    "cve": "field.has_cve",
                    "has-patch": "field.has_patch",
                    "upstream-status": "field.status_upstream" }
                    
        
    def __init__(self, url_opt="", func=[], opt_type=CONFLICTS_ERROR):
        
        self._conflicts_error = opt_type
        self.__url_opt = parse_options(url_opt)
        self.__baseurl = ()
        self.__url_cache = self.__url_opt.copy()
        LPBugListFilter.__init__(self, func)
        
    def __call__(self, baseurl):
        self.baseurl = baseurl
        return self
        
    def reset(self):
        self._functions = self._func_cache
        self.__url_opt = self.__url_cache
        
    def get_baseurl(self):
        assert self.__baseurl, "needs baseurl"
        x = list(self.__baseurl[:3])
        x.append(self.urlopt)
        x.append("")
        return urlparse.urlunsplit(x)
        
    def set_baseurl(self, baseurl):
        self.__baseurl = urlparse.urlsplit(baseurl)
        self._add_default_urlopt(baseurl)
    baseurl = property(get_baseurl, set_baseurl)
        
    @property
    def urlopt(self):
        return urllib.urlencode(self.__url_opt,True)
        
    def add_option(self, option, value):
        if not option in URLBugListFilter.OPTION_DICT:
            raise ValueError
        if option == "component":
            value = set([BUGLIST.COMPONENT_DICT[i] for i in value])
        self._add_option({URLBugListFilter.OPTION_DICT[option]: value})
        
        
    def _add_default_urlopt(self, url):
        u = urlparse.urlsplit(url)
        r = parse_options(u[3])
        self._add_option(r)
        
    def _add_option(self, r):
        if self._conflicts_error == URLBugListFilter.ADD:
            for i,k in r.iteritems():
                try:
                    self.__url_opt[i] = self.__url_opt[i].union(k)
                except KeyError:
                    self.__url_opt[i] = k
        elif self._conflicts_error == URLBugListFilter.OVERWRITE:
            self.__url_opt = r
        elif self._conflicts_error == URLBugListFilter.CONFLICTS_ERROR:
            for i,k in r.iteritems():
                if i in self.__url_opt:
                    if not self.__url_opt[i] == k:
                        raise ValueError, "ValueError: conflict filter options (%s)" %i
                else:
                    self.__url_opt[i] = k
        else:
            raise ValueError, "unknown type=%s" %type
        
        


        
#some test-cases
if __name__ == '__main__':
    import connector as Connector
    tBug = Connector.ConnectBug(method="text")
    tBuglist = Connector.ConnectBugList(method="text")
    from datetime import datetime
    
    f = LPBugListFilter([lambda x: minbug(x, 175000)])#, lambda x: lastcomment(x, tBug, user="thekorn", before=datetime(2007,10,16))])
    bugs = [172802,
 137574,
 177608,
 146377,
 175946,
 162814,
 173005,
 177202,
 116243,
 138837,
 174103,
 172882,
 172637,
 172670]
    print f.filter(bugs)
     
    f = URLBugListFilter(func=(lambda x: lastcomment(x, tBug, user="reporter"),))
    bugs = tBuglist(f("https://bugs.edge.launchpad.net/python-launchpad-bugs/+bugs?field.searchtext=&orderby=-importance&search=Search&field.status%3Alist=NEW&field.status%3Alist=INCOMPLETE_WITH_RESPONSE&field.status%3Alist=CONFIRMED&field.status%3Alist=TRIAGED&field.status%3Alist=INPROGRESS&field.status%3Alist=FIXCOMMITTED&field.assignee=&field.bug_reporter=&field.omit_dupes=on&field.has_patch=&field.has_no_package="))
    print bugs, len(bugs)
        
