#!/usr/bin/env python

"""**************************************************************************
** $Id: listboxcombo.py,v 1.1 2003/05/30 17:47:57 phil Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from qt import *

FALSE = 0
TRUE  = 1

class ListBoxCombo( QVBox ):
    # Constructor
    # Creates child widgets of the ListBoxCombo widget
    def __init__( self, parent=None, name=None ):
        QVBox.__init__( self, parent, name )
                
        self.setMargin( 5 )
        self.setSpacing( 5 )

        i = 0
        row1 = QHBox( self )
        row1.setSpacing( 5 )
 
        # Create a multi-selection ListBox...
        self.lb1 = QListBox( row1 )
        self.lb1.setSelectionMode( QListBox.Multi )
            
        # ...insert a pixmap item...
        xpm = QPixmap( "qtlogo.png" )
        txt = QString()
        QListBoxPixmap( self.lb1, xpm, txt ) 
        
        # ...and 100 text items
        for i in range(0, 100, 1) :
            xpm = QPixmap()
            txt = QString( "Listbox Item %1" ).arg( i )
            if not i % 4 :
                xpm = QPixmap( "fileopen.xpm" )
            QListBoxPixmap( self.lb1, xpm, txt ) 
                     
        # Create a pushbutton...
        arrow1 = QPushButton( " -> ", row1 )
        # ...and connect the clicked SIGNAL with the SLOT slotLeft2Right
        self.connect( arrow1, SIGNAL("clicked()"), self.slotLeft2Right )

        # create an empty single-selection ListBox
        self.lb2 = QListBox( row1 )

        row2 = QHBox( self )
        row2.setSpacing( 5 )

        box1 = QVBox( row2 )
        box1.setSpacing( 5 )
        
        # Create a non-editable Combobox and a label below...
        cb1 = QComboBox( FALSE, box1 )
        self.label1 = QLabel( "Current Item: Combobox Item 0", box1 )
        self.label1.setMaximumHeight( self.label1.sizeHint().height() * 2 )
        self.label1.setFrameStyle( QFrame.Panel | QFrame.Sunken )

        #...and insert 50 items into the Combobox
        for i in range( 0, 50, 1 ) :
            txt = str( QString( "Combobox Item %1" ).arg( i ) )
            if i % 9 :
                cb1.insertItem( txt )
            else :
                cb1.listBox().insertItem( MyListBoxItem() )
            
        box2 = QVBox( row2 )
        box2.setSpacing( 5 )

        # Create an editable Combobox and a label below...
        cb2 = QComboBox( TRUE, box2 )
        self.label2 = QLabel( "Current Item: Combobox Item 0", box2 )
        self.label2.setMaximumHeight( self.label2.sizeHint().height() * 2 )
        self.label2.setFrameStyle( QFrame.Panel | QFrame.Sunken )

        # ... and insert 50 items into the Combobox
        for i in range(0, 50, 1 ) :
            txt = str(QString( "Combobox Item %1" ).arg( i ))
            if not i % 4 :
                cb2.insertItem( QPixmap( "fileopen.xpm" ), txt )
            else :
                cb2.insertItem( txt )
        
        # Connect the activated SIGNALs of the Comboboxes with SLOTs
        self.connect( cb1, SIGNAL("activated( const QString & )"), self.slotCombo1Activated )
        self.connect( cb2, SIGNAL("activated( const QString & )"), self.slotCombo2Activated )
    
    """ SLOT slotLeft2Right
    * Copies all selected items of the first ListBox into the second ListBox
    """
    def slotLeft2Right( self ):
        # Go through all items of the first ListBox
        for i in range( 0, self.lb1.count(), 1 ) :
            item = self.lb1.item( i )
            # if the item is selected...
            if self.lb1.isSelected( i ): #item.isSelected() :
                # ...and it is a text item...
                if item.pixmap() and not(item.text().isEmpty()):
                    self.lb2.insertItem( item.pixmap(), item.text() )
                elif not( item.pixmap() ):
                    self.lb2.insertItem( item.text() )
                elif item.text().isEmpty() :
                    self.lb2.insertItem( item.pixmap() )

    """ SLOT slotCombo1Activated( const QString &s )
    * Sets the text of the item which the user just selected in the
    * first Combobox (and is now the value of s) to the first Label.
    """
    def slotCombo1Activated( self, s ) :
        self.label1.setText( str(QString( "Current Item: %1" ).arg( s ) ) )
    
    """ SLOT slotCombo2Activated( const QString &s )
    * Sets the text of the item which the user just selected in the
    * second Combobox (and is now the value of s) to the second Label.
    """
    def slotCombo2Activated( self, s ) :
        self.label2.setText( str(QString( "Current Item: %1" ).arg( s ) ) )
    

class MyListBoxItem( QListBoxItem ):
    def __init__( self, parent=None, name=None ):
        QListBoxItem.__init__( self, parent, name )
        self.setCustomHighlighting( TRUE )
    
    def paint( self, painter ):
        # evil trick: find out whether we are painted onto our listbox
        in_list_box = 0
        if self.listBox() and self.listBox().viewport() == painter.device():
            in_list_box = 1
        r = QRect( 0, 0, self.width( self.listBox() ), self.height( self.listBox() ) )
        brush = QBrush( Qt.red, Qt.SolidPattern )
        if in_list_box and isSelected():
            painter.eraseRect( r )
        painter.fillRect( 5, 5, self.width( self.listBox() ) - 10, self.height( self.listBox() ) - 10, brush )
        if in_list_box and isCurrent():
            self.listBox().style().drawPrimitive( QStyle.PE_FocusRect, painter, r, self.listBox().colorGroup() )
            
    def width( self, QListBox ):
        return 100
    
    def height( self, QListBox ):
        return 16

    
def main( args ):
    a = QApplication( args )
    
    listboxcombo = ListBoxCombo()
    listboxcombo.resize( 400, 270 )
    listboxcombo.setCaption( "Qt Example - Listboxes and Comboboxes" )
    a.setMainWidget( listboxcombo )
    listboxcombo.show();
    
    a.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
