#ifndef FILEOPS_H
#define FILEOPS_H

#include <libgnomevfs/gnome-vfs.h>

#include <gtk/gtk.h>

typedef void (*ScreemFileOp)( GnomeVFSMonitorEventType type,
			const gchar *uri, gpointer data );

gboolean copy_file( const gchar *source, const gchar *dest,
		GnomeVFSXferOverwriteMode ovr_mode,
		ScreemFileOp cb, gpointer data );
gboolean copy_dir( const char *source, const gchar *dest, gboolean move,
		ScreemFileOp cb, gpointer data );
gboolean move_file( const gchar *source, const gchar *dest,
		ScreemFileOp cb, gpointer data );
gboolean delete_file( const gchar *file, ScreemFileOp cb, gpointer data );
gboolean delete_dir( const gchar *path, ScreemFileOp cb, gpointer data );
gboolean mkdir_recursive( const gchar *path, GnomeVFSFilePermissions perms,
		ScreemFileOp cb, gpointer data );

gchar *relative_path( const gchar *text, const gchar *root );
gchar *relative_to_full( const gchar *relPath, const gchar *base_uri );

gboolean overwrite( const gchar *filename );
gboolean uri_exists( const gchar *filename, GnomeVFSResult *result );
gboolean uri_accessible( const gchar *filename, 
		GnomeVFSFilePermissions perms );

gchar* paths_match( const gchar *base_uri,
		    const gchar *path1, const gchar *path2 );

gchar *load_file( const gchar *path, 
		gboolean *compressed, gchar **charset, GError **error );
gboolean save_file( const gchar *path, const gchar *data,
		    GnomeVFSFilePermissions perms,
		    gboolean compress, gboolean create_backup,
		    GError **error );

gboolean screem_uri_is_dir( const gchar *uri );

gchar *screem_create_tmp_file( const gchar *base, const gchar *ext, 
		const gchar *tmpdir );
gchar *screem_get_dot_dir( void );

GSList *screem_vfs_scandir( const gchar *dir, 
		     gint (*filter)( const GnomeVFSFileInfo *info ),
		     GCompareFunc compare,
		     gboolean recurse );

GtkWidget *screem_file_dialog_create( const gchar *title,
		GtkWindow *parent, GtkFileChooserAction action,
		gboolean multi, const gchar *dir,
		const GSList *filters, gboolean preview );
gchar * screem_fileselect( const gchar *title, GtkWindow *parent,
			GtkFileChooserAction action,
			const gchar *dir, 
			const GSList *filters, gboolean preview );

GSList * screem_fileselect_multi( const gchar *title, GtkWindow *parent,
				GtkFileChooserAction action,
				const gchar *dir, 
				const GSList *filters, gboolean preview );

gint screem_compare_file_age( const gchar *a, const gchar *b );

/* hack functions for file selector dialog positioning / sizing */
void screem_gtk_file_chooser_button_show( GtkWidget *widget );
void screem_gtk_file_chooser_button_response( GtkWidget *widget,
		gint response );


#endif
