#ifndef SCREEM_APPLICATION_H
#define SCREEM_APPLICATION_H

#include <config.h>

#include <glib-object.h>

#include <gconf/gconf-client.h>

#include <gtksourceview/gtksourcelanguagesmanager.h>
#include <gtk/gtktreemodel.h>

#include <libgnomevfs/gnome-vfs-monitor.h>

#include "screem-site.h"
#include "screem-helper.h"
#include "screem-editor.h"

#include "screem-dtd-db.h"

#include "screem-plugin-manager.h"
#include "screem-macro-manager.h"
#include "screem-helper-manager.h"
#include "screem-icon-cache.h"
#include "screem-session.h"

#define SCREEM_TYPE_APPLICATION            (screem_application_get_type ())
#define SCREEM_APPLICATION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_APPLICATION, ScreemApplication))
#define SCREEM_APPLICATION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_APPLICATION, ScreemApplicationClass))
#define SCREEM_IS_APPLICATION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_APPLICATION))

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif

typedef struct ScreemApplication ScreemApplication;
typedef struct ScreemApplicationPrivate ScreemApplicationPrivate;

struct ScreemApplication {
	GObject parent;
	
	ScreemApplicationPrivate *priv;
	
	gboolean offline;
	gint offline_notify;

	/* UI stuff */
	GtkWidget *hint;

	GConfClient *client;
};

typedef struct {
	GObjectClass parent_class;

} ScreemApplicationClass;

GType screem_application_get_type( void );
ScreemApplication *screem_application_new( void );
void screem_application_startup( ScreemApplication *app,
				 const gchar *session,
				 const gchar **files );
void screem_application_add_files( ScreemApplication *app,
		GSList *files );
void screem_application_close( ScreemApplication *app );

GList *screem_application_get_window_list( ScreemApplication *app );
void screem_application_close_all_windows( ScreemApplication *app );

ScreemWindow *screem_application_create_window( ScreemApplication *app );

GList *screem_application_get_loaded_sites( ScreemApplication *app );
void screem_application_add_site( ScreemApplication *app, ScreemSite *site );
ScreemSite *screem_application_get_site( ScreemApplication *app,
					 const gchar *uri );
ScreemSite *screem_application_get_site_by_name( ScreemApplication *app,
						 const gchar *name );
ScreemSite *screem_application_get_default_site( ScreemApplication *app );
void screem_application_close_site( ScreemApplication *app, ScreemSite *site );
void screem_application_close_all_sites( ScreemApplication *app );
gboolean screem_application_save_sites( ScreemApplication *app );

void screem_application_init_tag_styles( GtkSourceLanguage *lang );
GtkSourceLanguagesManager* screem_application_load_syntax_tables( void );
GHashTable *screem_application_get_features( ScreemApplication *application, const gchar *type );

ScreemDTDDB *screem_application_get_dtd_db( ScreemApplication *application );

void screem_application_set_cursor( ScreemApplication *app,
		GdkCursorType type );
void screem_application_file_op( GnomeVFSMonitorEventType type,
				const gchar *uri, gpointer data );

ScreemSession *screem_application_get_session( ScreemApplication *app );

GtkTreeModel *screem_application_get_encodings( ScreemApplication *app );

void screem_application_exec_helpers( ScreemApplication *app,
		ScreemPage *page );

ScreemPluginManager *screem_application_get_plugin_manager( ScreemApplication *app );
ScreemMacroManager *screem_application_get_macro_manager( ScreemApplication *app );
ScreemHelperManager *screem_application_get_helper_manager( ScreemApplication *app );

ScreemIconCache *screem_application_get_icon_cache( ScreemApplication *app );

#endif
