#ifndef SCREEM_COMBO_BOX_H
#define SCREEM_COMBO_BOX_H

#include <gtk/gtkbin.h>
#include <gtk/gtktreemodel.h>

#define SCREEM_TYPE_COMBO_BOX  (screem_combo_box_get_type())
#define SCREEM_COMBO_BOX(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ),   \
                                                SCREEM_TYPE_COMBO_BOX, \
                                                ScreemComboBox ) )
#define SCREEM_IS_COMBO_BOX(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                               SCREEM_TYPE_COMBO_BOX ) )

typedef struct ScreemComboBoxPrivate ScreemComboBoxPrivate;

typedef struct ScreemComboBox ScreemComboBox;

struct ScreemComboBox {
	GtkBin parent;

	ScreemComboBoxPrivate *priv;
};

typedef struct {
	GtkBinClass parent_class;
	
	void (*changed)( ScreemComboBox *combo );

} ScreemComboBoxClass;


GType screem_combo_box_get_type( void );
ScreemComboBox *screem_combo_box_new( void );

GtkTreeModel *screem_combo_box_get_model( ScreemComboBox *combo );
void screem_combo_box_set_model( ScreemComboBox *combo,
		GtkTreeModel *model );

gint screem_combo_box_get_active( ScreemComboBox *combo );
void screem_combo_box_set_active( ScreemComboBox *combo, gint active );

gboolean screem_combo_box_get_active_iter( ScreemComboBox *combo,
		GtkTreeIter *iter );
void screem_combo_box_set_active_iter( ScreemComboBox *combo,
		GtkTreeIter *iter );


#endif
