#ifndef SCREEM_MACRO_MANAGER_H
#define SCREEM_MACRO_MANAGER_H

#include <glib-object.h>

#include <gdk/gdk.h>
#include <gtk/gtkaccelgroup.h>
#include <gtk/gtktreemodel.h>

#define SCREEM_TYPE_MACRO_MANAGER            (screem_macro_manager_get_type ())
#define SCREEM_MACRO_MANAGER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_MACRO_MANAGER, ScreemMacroManager))
#define SCREEM_MACRO_MANAGER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_MACRO_MANAGER, ScreemMacroManagerClass))
#define SCREEM_IS_MACRO_MANAGER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_MACRO_MANAGER))

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif

typedef struct ScreemMacroManagerPrivate ScreemMacroManagerPrivate;

typedef struct ScreemMacroManager ScreemMacroManager;

struct ScreemMacroManager {
	GObject parent;

	ScreemMacroManagerPrivate *priv;
};

typedef struct {
	GObjectClass parent_class;

} ScreemMacroManagerClass;

enum {
	SCREEM_MACRO_MODEL_COMBO,
	SCREEM_MACRO_MODEL_TEXT,
	SCREEM_MACRO_MODEL_MACRO,
	SCREEM_MACRO_MODEL_NUM_COLS
};

typedef enum {
	SCREEM_MACRO_INSERT_TEXT,
	SCREEM_MACRO_NUM_TYPES
} ScreemMacroType;

typedef struct {
	guint key;
	GdkModifierType mod;
	ScreemMacroType type;
	gpointer data;
} ScreemMacro;

GType screem_macro_manager_get_type( void );
ScreemMacroManager* screem_macro_manager_new( void );

GtkAccelGroup *screem_macro_manager_get_accel_group( ScreemMacroManager *manager );

GtkTreeModel *screem_macro_manager_get_model( ScreemMacroManager *manager );

void screem_macro_manager_edit_macros( ScreemMacroManager *manager );

#endif

