#ifndef SCREEM_TAG_INSPECTOR_H
#define SCREEM_TAG_INSPECTOR_H

#include <gtk/gtkbin.h>

#include "screem-page.h"
#include "screem-window.h"

#define SCREEM_TYPE_TAG_INSPECTOR  (screem_tag_inspector_get_type())
#define SCREEM_TAG_INSPECTOR(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ),   \
                                                SCREEM_TYPE_TAG_INSPECTOR, \
                                                ScreemTagInspector ) )
#define SCREEM_IS_TAG_INSPECTOR(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                               SCREEM_TYPE_TAG_INSPECTOR ) )

typedef struct ScreemTagInspectorPrivate ScreemTagInspectorPrivate;

typedef struct ScreemTagInspector ScreemTagInspector;

struct ScreemTagInspector {
	GtkBin parent;

	ScreemTagInspectorPrivate *priv;
};

typedef struct {
	GtkBinClass parent_class;

	void (* replace_attribute)( ScreemTagInspector *inspector,
								const gchar *attribute );

} ScreemTagInspectorClass;


GType screem_tag_inspector_get_type( void );
ScreemTagInspector *screem_tag_inspector_new( ScreemWindow *window );

gboolean screem_tag_inspector_inspect( ScreemTagInspector *inspector,
									ScreemPage *page, guint pos, guint ppos );


#endif
