/* This file is part of the SpeedCrunch project
   Copyright (C) 2004 Ariya Hidayat <ariya@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 */


#ifndef RESULT
#define RESULT

#include <math/hmath.hxx>

#include <QListWidget>
#include <QResizeEvent>

class QListWidgetItem;

class ResultPrivate;

class Result : public QListWidget
{
  Q_OBJECT

  public:
    Result( QWidget* parent = 0, const char* name = 0 );
    ~Result();

    void append( const QString& expr, const HNumber& value );
    void appendError( const QString& expr, const QString& msg );
    QString asText() const;

    void setFormat( char format );
    char format() const;
    void setDecimalDigits( int digits );
    int decimalDigits() const;
    QString formatNumber( const HNumber& value ) const;
    QString decimalPoint() const;
    void setDecimalPoint( const QString& dp );

    void setCustomAppearance( bool custom );
    bool customAppearance() const;
    void setCustomTextColor( const QColor& textColor );
    QColor customTextColor() const;
    void setCustomBackgroundColor( const QColor& bg1, const QColor& bg2 );
    QColor customBackgroundColor1() const;
    QColor customBackgroundColor2() const;
    void setCustomErrorColor( const QColor& e );
    QColor customErrorColor() const;

  signals:
    void textCopied( const QString& text );

  public slots:
    void clear();

  protected:
    virtual void resizeEvent( QResizeEvent* );

  private slots:
    void copyToClipboard( QListWidgetItem* );
    void triggerUpdate();
    void scrollEnd();

  private:
    ResultPrivate* d;
    Result( const Result& );
    Result& operator=( const Result& );
};

#endif // RESULT
