/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include "qt3strigiclient.h"
#include <qdir.h>
#include "qt3strigirunner.h"
//#include <qdebug.h>

Qt3StrigiClient::Qt3StrigiClient(QObject* parent) :QObject(parent) {
    QString socketpath = QDir::homeDirPath()+"/.strigi/socket";
    socket.setSocketPath((const char*)socketpath.utf8());
    mode = Idle;
    connect(&poller, SIGNAL(timeout()), this, SLOT(poll()));

    Qt3StrigiRunner* runner = new Qt3StrigiRunner(this);
    runner->startStrigi();
}
void
Qt3StrigiClient::poll() {
    if (socket.statusChanged()) {
        poller.stop();
        if (mode == Query) {
            hits = socket.getHits();
            QString query = queryQueue.front();
            queryQueue.pop_front();
            emit gotHits(query, hits);
        } else if (mode == CountHits) {
            int count = socket.getHitCount();
            QString query = countQueue.front();
            countQueue.pop_front();
            emit gotHitsCount(query, count);
        }
        mode = Idle;
        if (countQueue.size()) {
            startCountHits();
        } else if (queryQueue.size()) {
            startQuery();
        }
    }
}
void
Qt3StrigiClient::countHits(const QString& query) {
    countQueue.append(query);
    if (mode == Idle) {
        startCountHits();
    }
}
void
Qt3StrigiClient::query(const QString& query) {
    if (query.length()) {
        queryQueue.append(query);
        if (mode == Idle) {
            startQuery();
        }
    }
}
void
Qt3StrigiClient::startCountHits() {
    bool ok = socket.countHits((const char*)countQueue.front().utf8());
    if (ok) {
        mode = CountHits;
        poller.start(1);
    } else {
        // fail in silence
        countQueue.pop_front();
    }
}
void
Qt3StrigiClient::startQuery() {
    bool ok = socket.query((const char*)queryQueue.front().utf8(), 10, 0);
    if (ok) {
        mode = Query;
        poller.start(1);
    } else {
        // fail in silence
        queryQueue.pop_front();
    }
}
