/* amd64-linux.kernel.vmlinux.h
   created from amd64-linux.kernel.vmlinux.bin, 25804 (0x64cc) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_AMD64_LINUX_KERNEL_VMLINUX_SIZE    25804
#define STUB_AMD64_LINUX_KERNEL_VMLINUX_ADLER32 0x7ddb957f
#define STUB_AMD64_LINUX_KERNEL_VMLINUX_CRC32   0x7948f85f

unsigned char stub_amd64_linux_kernel_vmlinux[25804] = {
127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
 52, 30,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
150,  0,147,  0, 90, 14,104,  0,  0,  0,  0,184,  0,  0,  0,  0,   /* 0x  30 */
 87, 86, 80, 80,106,  0,104,  0,  0,  0,  0,232,  1,  0,  0,  0,   /* 0x  40 */
235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,  7,139,   /* 0x  50 */
 30,131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,255,184,   /* 0x  60 */
  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x  70 */
192,  1,219,117,  7,139, 30,131,238,252, 17,219,115,255,  1,219,   /* 0x  80 */
115,255,117,  9,139, 30,131,238,252, 17,219,115,255, 49,201,131,   /* 0x  90 */
232,  3,114, 13,193,224,  8,138,  6, 70,131,240,255,116,255,137,   /* 0x  a0 */
197,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,   /* 0x  b0 */
117,  7,139, 30,131,238,252, 17,219, 17,201,117,255, 65,  1,219,   /* 0x  c0 */
117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139,   /* 0x  d0 */
 30,131,238,252, 17,219,115, 48,  1,219,115, 48,117,  9,139, 30,   /* 0x  e0 */
131,238,252, 17,219,115, 48, 65, 65,131,193,  2,129,253,  0,243,   /* 0x  f0 */
255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,252,255,255,   /* 0x 100 */
255,141, 20, 47,131,253,252,138,  4, 15,118,255,138,  2, 66,136,   /* 0x 110 */
  7, 71, 73,117,247,233,252,255,255,255,139,  2,131,194,  4,137,   /* 0x 120 */
  7,131,199,  4,131,233,  4,119,241,  1,207,233,252,255,255,255,   /* 0x 130 */
235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,  7,139,   /* 0x 140 */
 30,131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,255,184,   /* 0x 150 */
  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 160 */
192,  1,219,117,  7,139, 30,131,238,252, 17,219,114, 15,  1,219,   /* 0x 170 */
115, 11,117, 15,139, 30,131,238,252, 17,219,114, 15, 72,  1,219,   /* 0x 180 */
117,  7,139, 30,131,238,252, 17,219, 17,192,235,255, 49,201,131,   /* 0x 190 */
232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,255,209,   /* 0x 1a0 */
248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 1b0 */
 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,   /* 0x 1c0 */
255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,   /* 0x 1d0 */
219,117,  7,139, 30,131,238,252, 17,219,115, 68,  1,219,115, 68,   /* 0x 1e0 */
117,  9,139, 30,131,238,252, 17,219,115, 68, 65, 65,131,193,  2,   /* 0x 1f0 */
129,253,  0,251,255,255,131,209,  1, 86,141, 52, 47,243,164, 94,   /* 0x 200 */
233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,118,255,   /* 0x 210 */
138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,   /* 0x 220 */
131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,   /* 0x 230 */
252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,   /* 0x 240 */
219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,138,   /* 0x 250 */
  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,   /* 0x 260 */
252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 270 */
114, 30,  1,219,115, 11,117, 30,139, 30,131,238,252, 17,219,114,   /* 0x 280 */
 30, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,   /* 0x 290 */
255,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,235,255,   /* 0x 2a0 */
 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,   /* 0x 2b0 */
116,255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,   /* 0x 2c0 */
252, 17,219,114,204, 65,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 2d0 */
219,114,190,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,   /* 0x 2e0 */
  1,219,117,  7,139, 30,131,238,252, 17,219,115, 81,  1,219,115,   /* 0x 2f0 */
 81,117,  9,139, 30,131,238,252, 17,219,115, 81, 65, 65,131,193,   /* 0x 300 */
  2,129,253,  0,251,255,255,131,209,  2, 86,141, 52, 47,243,164,   /* 0x 310 */
 94,233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,118,   /* 0x 320 */
255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,   /* 0x 330 */
  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,   /* 0x 340 */
233,252,255,255,255,137,229,141,156, 36,  0,  0,  0,  0, 49,192,   /* 0x 350 */
 80, 57,220,117,251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,195,   /* 0x 360 */
  4, 83,104,  0,  0,  0,  0, 86,131,195,  4, 83, 80,199,  3,  0,   /* 0x 370 */
  0,  0,  0,137,229,139, 85,  0,172, 74,136,193, 36,  7,192,233,   /* 0x 380 */
  3,187,  0,253,255,255,211,227,141,164, 92,144,241,255,255,131,   /* 0x 390 */
228,224,106,  0,106,  0,137,227, 83,131,195,  4,139, 77,  0,255,   /* 0x 3a0 */
 49, 87, 83,131,195,  4,136, 67,  2,172, 74,136,193, 36, 15,136,   /* 0x 3b0 */
  3,192,233,  4,136, 75,  1, 82, 86, 83, 80, 85, 87, 86, 83,131,   /* 0x 3c0 */
236,124,139,148, 36,144,  0,  0,  0,199, 68, 36,116,  0,  0,  0,   /* 0x 3d0 */
  0,198, 68, 36,115,  0,139,172, 36,156,  0,  0,  0,141, 66,  4,   /* 0x 3e0 */
137, 68, 36,120,184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,   /* 0x 3f0 */
227,137,217, 73,137, 76, 36,108, 15,182, 74,  1,211,224, 72,137,   /* 0x 400 */
 68, 36,104,139,132, 36,168,  0,  0,  0, 15,182, 50,199, 69,  0,   /* 0x 410 */
  0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,  0,   /* 0x 420 */
  0,  0,184,  0,  3,  0,  0,137,116, 36,100,199, 68, 36, 92,  1,   /* 0x 430 */
  0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,  1,   /* 0x 440 */
  0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,  1,   /* 0x 450 */
241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,139,   /* 0x 460 */
 68, 36,120,102,199,  0,  0,  4,131,192,  2,226,246,139,156, 36,   /* 0x 470 */
148,  0,  0,  0, 49,255,199, 68, 36, 72,255,255,255,255,137,218,   /* 0x 480 */
  3,148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,210, 59, 92, 36,   /* 0x 490 */
 76, 15,132,124,  9,  0,  0, 15,182,  3,193,231,  8, 66, 67,  9,   /* 0x 4a0 */
199,131,250,  4,126,231,139,140, 36,164,  0,  0,  0, 57, 76, 36,   /* 0x 4b0 */
116, 15,131,100,  9,  0,  0,139,116, 36,116, 35,116, 36,108,139,   /* 0x 4c0 */
 68, 36, 96,139, 84, 36,120,193,224,  4,137,116, 36, 68,  1,240,   /* 0x 4d0 */
129,124, 36, 72,255,255,255,  0,141, 44, 66,119, 24, 59, 92, 36,   /* 0x 4e0 */
 76, 15,132, 44,  9,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,   /* 0x 4f0 */
231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11,   /* 0x 500 */
 15,183,202, 15,175,193, 57,199, 15,131,221,  1,  0,  0,137, 68,   /* 0x 510 */
 36, 72,184,  0,  8,  0,  0, 41,200,138, 76, 36,100,193,248,  5,   /* 0x 520 */
190,  1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,115,102,137, 69,   /* 0x 530 */
  0,139, 68, 36,116, 35, 68, 36,104,139,108, 36,120,211,224,185,   /* 0x 540 */
  8,  0,  0,  0, 43, 76, 36,100,211,250,  1,208,105,192,  0,  6,   /* 0x 550 */
  0,  0,131,124, 36, 96,  6,141,132,  5,108, 14,  0,  0,137, 68,   /* 0x 560 */
 36, 20, 15,142,202,  0,  0,  0,139, 68, 36,116, 43, 68, 36, 92,   /* 0x 570 */
139,148, 36,160,  0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,209,   /* 0x 580 */
100, 36, 64,139, 76, 36, 64,141, 20, 54,139,108, 36, 20,129,225,   /* 0x 590 */
  0,  1,  0,  0,129,124, 36, 72,255,255,255,  0,141, 68, 77,  0,   /* 0x 5a0 */
137, 76, 36, 60,141, 44, 16,119, 24, 59, 92, 36, 76, 15,132, 96,   /* 0x 5b0 */
  8,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,   /* 0x 5c0 */
199,139, 68, 36, 72,102,139,141,  0,  2,  0,  0,193,232, 11, 15,   /* 0x 5d0 */
183,241, 15,175,198, 57,199,115, 35,137, 68, 36, 72,184,  0,  8,   /* 0x 5e0 */
  0,  0, 41,240,137,214,193,248,  5,131,124, 36, 60,  0,141,  4,   /* 0x 5f0 */
  1,102,137,133,  0,  2,  0,  0,116, 34,235, 46, 41, 68, 36, 72,   /* 0x 600 */
 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,131,124,   /* 0x 610 */
 36, 60,  0,102,137,141,  0,  2,  0,  0,116, 14,129,254,255,  0,   /* 0x 620 */
  0,  0, 15,142, 87,255,255,255,235,121,129,254,255,  0,  0,  0,   /* 0x 630 */
127,113,141, 20, 54,139,108, 36, 20,  1,213,129,124, 36, 72,255,   /* 0x 640 */
255,255,  0,119, 24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,193,   /* 0x 650 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x 660 */
 72,102,139, 77,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,   /* 0x 670 */
115, 25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,   /* 0x 680 */
248,  5,141,  4,  1,102,137, 69,  0,235,159, 41, 68, 36, 72, 41,   /* 0x 690 */
199,137,200,141,114,  1,102,193,232,  5,102, 41,193,102,137, 77,   /* 0x 6a0 */
  0,235,135,139, 84, 36,116,137,240,139,140, 36,160,  0,  0,  0,   /* 0x 6b0 */
136, 68, 36,115,136,  4, 10, 66,131,124, 36, 96,  3,137, 84, 36,   /* 0x 6c0 */
116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,  0,   /* 0x 6d0 */
131,124, 36, 96,  9,127, 10,131,108, 36, 96,  3,233, 10,  7,  0,   /* 0x 6e0 */
  0,131,108, 36, 96,  6,233,  0,  7,  0,  0,139, 76, 36, 72, 41,   /* 0x 6f0 */
199,139,116, 36, 96, 41,193,137,208,102,193,232,  5,102, 41,194,   /* 0x 700 */
129,249,255,255,255,  0,102,137, 85,  0,139,108, 36,120,141,116,   /* 0x 710 */
117,  0,137,116, 36, 56,119, 22, 59, 92, 36, 76, 15,132,241,  6,   /* 0x 720 */
  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,139,108,   /* 0x 730 */
 36, 56,137,200,193,232, 11,102,139,149,128,  1,  0,  0, 15,183,   /* 0x 740 */
234, 15,175,197, 57,199,115, 82,137,198,184,  0,  8,  0,  0, 41,   /* 0x 750 */
232,139,108, 36, 88,193,248,  5,139, 76, 36, 84,141,  4,  2,139,   /* 0x 760 */
 84, 36, 56,137, 76, 36, 80,139, 76, 36,120,102,137,130,128,  1,   /* 0x 770 */
  0,  0,139, 68, 36, 92,137,108, 36, 84,137, 68, 36, 88, 49,192,   /* 0x 780 */
131,124, 36, 96,  6, 15,159,192,129,193,100,  6,  0,  0,141,  4,   /* 0x 790 */
 64,137, 68, 36, 96,233,116,  2,  0,  0,137,206, 41,199, 41,198,   /* 0x 7a0 */
137,208,102,193,232,  5,139, 76, 36, 56,102, 41,194,129,254,255,   /* 0x 7b0 */
255,255,  0,102,137,145,128,  1,  0,  0,119, 22, 59, 92, 36, 76,   /* 0x 7c0 */
 15,132, 77,  6,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,   /* 0x 7d0 */
  9,199,139,108, 36, 56,137,242,193,234, 11,102,139,141,152,  1,   /* 0x 7e0 */
  0,  0, 15,183,193, 15,175,208, 57,215, 15,131,227,  0,  0,  0,   /* 0x 7f0 */
189,  0,  8,  0,  0,137,214, 41,197,199, 68, 36, 52,  0,  8,  0,   /* 0x 800 */
  0,137,232,193,248,  5,141,  4,  1,139, 76, 36, 56,102,137,129,   /* 0x 810 */
152,  1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,193,224,  5,  3,   /* 0x 820 */
 68, 36,120,129,250,255,255,255,  0,141, 44, 72,119, 22, 59, 92,   /* 0x 830 */
 36, 76, 15,132,219,  5,  0,  0, 15,182,  3,193,231,  8,193,230,   /* 0x 840 */
  8, 67,  9,199,102,139,149,224,  1,  0,  0,137,240,193,232, 11,   /* 0x 850 */
 15,183,202, 15,175,193, 57,199,115, 96, 41, 76, 36, 52,193,124,   /* 0x 860 */
 36, 52,  5,139,116, 36, 52,137, 68, 36, 72,131,124, 36,116,  0,   /* 0x 870 */
141,  4, 50,102,137,133,224,  1,  0,  0, 15,132,147,  5,  0,  0,   /* 0x 880 */
 49,192,131,124, 36, 96,  6,139,172, 36,160,  0,  0,  0,139, 84,   /* 0x 890 */
 36,116, 15,159,192,141, 68,  0,  9,137, 68, 36, 96,139, 68, 36,   /* 0x 8a0 */
116, 43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,115,136,  4, 42,   /* 0x 8b0 */
 66,137, 84, 36,116,233, 49,  5,  0,  0, 41,198, 41,199,137,208,   /* 0x 8c0 */
102,193,232,  5,102, 41,194,102,137,149,224,  1,  0,  0,233, 31,   /* 0x 8d0 */
  1,  0,  0,137,200, 41,214,102,193,232,  5,139,108, 36, 56,102,   /* 0x 8e0 */
 41,193, 41,215,129,254,255,255,255,  0,102,137,141,152,  1,  0,   /* 0x 8f0 */
  0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,  3,   /* 0x 900 */
193,231,  8,193,230,  8, 67,  9,199,139, 76, 36, 56,137,240,193,   /* 0x 910 */
232, 11,102,139,145,176,  1,  0,  0, 15,183,202, 15,175,193, 57,   /* 0x 920 */
199,115, 35,137,198,184,  0,  8,  0,  0, 41,200,139,108, 36, 56,   /* 0x 930 */
193,248,  5,141,  4,  2,102,137,133,176,  1,  0,  0,139, 68, 36,   /* 0x 940 */
 88,233,160,  0,  0,  0,137,241, 41,199, 41,193,137,208,102,193,   /* 0x 950 */
232,  5,102, 41,194,139, 68, 36, 56,129,249,255,255,255,  0,102,   /* 0x 960 */
137,144,176,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,161,  4,   /* 0x 970 */
  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,199,139,116,   /* 0x 980 */
 36, 56,137,200,193,232, 11,102,139,150,200,  1,  0,  0, 15,183,   /* 0x 990 */
234, 15,175,197, 57,199,115, 32,137,198,184,  0,  8,  0,  0, 41,   /* 0x 9a0 */
232,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,200,  1,   /* 0x 9b0 */
  0,  0,139, 68, 36, 84,235, 38,137,206, 41,199, 41,198,137,208,   /* 0x 9c0 */
102,193,232,  5,102, 41,194,139, 68, 36, 56,102,137,144,200,  1,   /* 0x 9d0 */
  0,  0,139, 84, 36, 84,139, 68, 36, 80,137, 84, 36, 80,139, 76,   /* 0x 9e0 */
 36, 88,137, 76, 36, 84,139,108, 36, 92,137, 68, 36, 92,137,108,   /* 0x 9f0 */
 36, 88, 49,192,131,124, 36, 96,  6,139, 76, 36,120, 15,159,192,   /* 0x a00 */
129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 96,129,254,   /* 0x a10 */
255,255,255,  0,119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,  0,   /* 0x a20 */
 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 17,137,   /* 0x a30 */
240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 47,137, 68,   /* 0x a40 */
 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,   /* 0x a50 */
  5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,102,137,  1,139,   /* 0x a60 */
 68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,235,114, 41,198, 41,   /* 0x a70 */
199,137,208,102,193,232,  5,102, 41,194,129,254,255,255,255,  0,   /* 0x a80 */
102,137, 17,119, 22, 59, 92, 36, 76, 15,132,132,  3,  0,  0, 15,   /* 0x a90 */
182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139, 81,  2,137,   /* 0x aa0 */
240,193,232, 11, 15,183,234, 15,175,197, 57,199,115, 59,137, 68,   /* 0x ab0 */
 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,   /* 0x ac0 */
  5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,139, 84, 36, 68,   /* 0x ad0 */
102,137, 65,  2,141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,199,   /* 0x ae0 */
 68, 36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,199,137,208,137,   /* 0x af0 */
116, 36, 72,102,193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,102,   /* 0x b00 */
 41,194,199, 68, 36, 48,  8,  0,  0,  0,102,137, 81,  2,129,193,   /* 0x b10 */
  4,  2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,  0,   /* 0x b20 */
  0,137, 76, 36, 40,141, 44, 18,139,116, 36, 16,  1,238,129,124,   /* 0x b30 */
 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,209,  2,   /* 0x b40 */
  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,   /* 0x b50 */
139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193,   /* 0x b60 */
 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,   /* 0x b70 */
248,  5,141,  4,  2,137,234,102,137,  6,235, 21, 41, 68, 36, 72,   /* 0x b80 */
 41,199,137,208,102,193,232,  5,102, 41,194,102,137, 22,141, 85,   /* 0x b90 */
  1,139,116, 36, 40, 78,137,116, 36, 40,117,137,138, 76, 36, 48,   /* 0x ba0 */
184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 44,131,124, 36,   /* 0x bb0 */
 96,  3,137, 84, 36, 12, 15,143,231,  1,  0,  0,131, 68, 36, 96,   /* 0x bc0 */
  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139,116, 36,   /* 0x bd0 */
120,193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,141,132,  6, 96,   /* 0x be0 */
  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,139,   /* 0x bf0 */
116, 36,  8,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59,   /* 0x c00 */
 92, 36, 76, 15,132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,182,   /* 0x c10 */
  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232,   /* 0x c20 */
 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,   /* 0x c30 */
  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,  6,137,   /* 0x c40 */
232,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102,   /* 0x c50 */
 41,194,141, 69,  1,102,137, 22,139,108, 36, 36, 77,137,108, 36,   /* 0x c60 */
 36,117,137,141, 80,192,131,250,  3,137, 20, 36, 15,142, 39,  1,   /* 0x c70 */
  0,  0,137,208,137,214,209,248,131,230,  1,141, 72,255,131,206,   /* 0x c80 */
  2,131,250, 13,137, 76, 36, 32,127, 28,139,108, 36,120,211,230,   /* 0x c90 */
  1,210,137, 52, 36,141, 68,117,  0, 41,208,  5, 94,  5,  0,  0,   /* 0x ca0 */
137, 68, 36,  4,235, 86,141, 80,251,129,124, 36, 72,255,255,255,   /* 0x cb0 */
  0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,  0,193,100, 36,   /* 0x cc0 */
 72,  8, 15,182,  3,193,231,  8, 67,  9,199,209,108, 36, 72,  1,   /* 0x cd0 */
246, 59,124, 36, 72,114,  7, 43,124, 36, 72,131,206,  1, 74,117,   /* 0x ce0 */
200,139, 68, 36,120,193,230,  4,137, 52, 36,  5, 68,  6,  0,  0,   /* 0x cf0 */
199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,199, 68, 36, 28,   /* 0x d00 */
  1,  0,  0,  0,184,  1,  0,  0,  0,139,108, 36,  4,  1,192,137,   /* 0x d10 */
 68, 36, 24,  1,197,129,124, 36, 72,255,255,255,  0,119, 24, 59,   /* 0x d20 */
 92, 36, 76, 15,132,234,  0,  0,  0,193,100, 36, 72,  8, 15,182,   /* 0x d30 */
  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,   /* 0x d40 */
232, 11, 15,183,242, 15,175,198, 57,199,115, 27,137, 68, 36, 72,   /* 0x d50 */
184,  0,  8,  0,  0, 41,240,193,248,  5,141,  4,  2,102,137, 69,   /* 0x d60 */
  0,139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,199,137,208,102,   /* 0x d70 */
193,232,  5,102, 41,194,139, 68, 36, 24,102,137, 85,  0,139, 84,   /* 0x d80 */
 36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,100, 36, 28, 73,137,   /* 0x d90 */
 76, 36, 32, 15,133,112,255,255,255,139, 52, 36, 70,137,116, 36,   /* 0x da0 */
 92,116, 89,139, 76, 36, 12,139,108, 36,116,131,193,  2, 57,108,   /* 0x db0 */
 36, 92,119, 95,139,132, 36,160,  0,  0,  0,137,234, 43, 68, 36,   /* 0x dc0 */
 92,  3,148, 36,160,  0,  0,  0,141, 52, 40,138,  6, 70,136, 68,   /* 0x dd0 */
 36,115,136,  2, 66,255, 68, 36,116, 73,116, 15,139,172, 36,164,   /* 0x de0 */
  0,  0,  0, 57,108, 36,116,114,226,235, 17,139,132, 36,164,  0,   /* 0x df0 */
  0,  0, 57, 68, 36,116, 15,130,187,246,255,255,129,124, 36, 72,   /* 0x e00 */
255,255,255,  0,119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,116,   /* 0x e10 */
 41,235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,156, 36,148,  0,   /* 0x e20 */
  0,  0, 49,192,139,148, 36,156,  0,  0,  0,139, 76, 36,116,137,   /* 0x e30 */
 26,139,156, 36,168,  0,  0,  0,137, 11,131,196,124, 91, 94, 95,   /* 0x e40 */
 93, 85, 87, 86, 83,131,236,124,139,148, 36,144,  0,  0,  0,199,   /* 0x e50 */
 68, 36,116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,   /* 0x e60 */
  0,  0,  0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,   /* 0x e70 */
182, 74,  2,137,195,211,227,137,217, 73,137, 76, 36,108, 15,182,   /* 0x e80 */
 74,  1,211,224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,  0,   /* 0x e90 */
 15,182, 50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,   /* 0x ea0 */
  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,   /* 0x eb0 */
100,199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,   /* 0x ec0 */
  0,199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,   /* 0x ed0 */
  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57,   /* 0x ee0 */
 76, 36,116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,192,   /* 0x ef0 */
  2,226,246,139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,   /* 0x f00 */
255,255,255,255,137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36,   /* 0x f10 */
 76, 49,210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,   /* 0x f20 */
193,231,  8, 66, 67,  9,199,131,250,  4,126,231,139,140, 36,164,   /* 0x f30 */
  0,  0,  0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,   /* 0x f40 */
116, 35,116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,   /* 0x f50 */
137,116, 36, 68,  1,240,129,124, 36, 72,255,255,255,  0,141, 44,   /* 0x f60 */
 66,119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36,   /* 0x f70 */
 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,   /* 0x f80 */
139, 85,  0,193,232, 11, 15,183,202, 15,175,193, 57,199, 15,131,   /* 0x f90 */
221,  1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138,   /* 0x fa0 */
 76, 36,100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182,   /* 0x fb0 */
 84, 36,115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,   /* 0x fc0 */
108, 36,120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,   /* 0x fd0 */
  1,208,105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,   /* 0x fe0 */
108, 14,  0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68,   /* 0x ff0 */
 36,116, 43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,   /* 0x1000 */
  2,137, 68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,   /* 0x1010 */
139,108, 36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,   /* 0x1020 */
255,  0,141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59,   /* 0x1030 */
 92, 36, 76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,   /* 0x1040 */
  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,   /* 0x1050 */
  0,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 35,137,   /* 0x1060 */
 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,131,   /* 0x1070 */
124, 36, 60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,   /* 0x1080 */
235, 46, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,   /* 0x1090 */
  5,102, 41,193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,   /* 0x10a0 */
116, 14,129,254,255,  0,  0,  0, 15,142, 87,255,255,255,235,121,   /* 0x10b0 */
129,254,255,  0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,   /* 0x10c0 */
213,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,   /* 0x10d0 */
132,196,  7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,   /* 0x10e0 */
 67,  9,199,139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,   /* 0x10f0 */
241, 15,175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,   /* 0x1100 */
  0, 41,240,137,214,193,248,  5,141,  4,  1,102,137, 69,  0,235,   /* 0x1110 */
159, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,   /* 0x1120 */
102, 41,193,102,137, 77,  0,235,135,139, 84, 36,116,137,240,139,   /* 0x1130 */
140, 36,160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,124,   /* 0x1140 */
 36, 96,  3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,   /* 0x1150 */
  0,233, 27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,108, 36,   /* 0x1160 */
 96,  3,233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,   /* 0x1170 */
  0,139, 76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,208,102,   /* 0x1180 */
193,232,  5,102, 41,194,129,249,255,255,255,  0,102,137, 85,  0,   /* 0x1190 */
139,108, 36,120,141,116,117,  0,137,116, 36, 56,119, 22, 59, 92,   /* 0x11a0 */
 36, 76, 15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,   /* 0x11b0 */
  8, 67,  9,199,139,108, 36, 56,137,200,193,232, 11,102,139,149,   /* 0x11c0 */
128,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 82,137,198,   /* 0x11d0 */
184,  0,  8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,139, 76,   /* 0x11e0 */
 36, 84,141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,   /* 0x11f0 */
120,102,137,130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,   /* 0x1200 */
137, 68, 36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,129,193,   /* 0x1210 */
100,  6,  0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,   /* 0x1220 */
137,206, 41,199, 41,198,137,208,102,193,232,  5,139, 76, 36, 56,   /* 0x1230 */
102, 41,194,129,254,255,255,255,  0,102,137,145,128,  1,  0,  0,   /* 0x1240 */
119, 22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,   /* 0x1250 */
231,  8,193,230,  8, 67,  9,199,139,108, 36, 56,137,242,193,234,   /* 0x1260 */
 11,102,139,141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,215,   /* 0x1270 */
 15,131,227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,199,   /* 0x1280 */
 68, 36, 52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,139,   /* 0x1290 */
 76, 36, 56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76,   /* 0x12a0 */
 36, 68,193,224,  5,  3, 68, 36,120,129,250,255,255,255,  0,141,   /* 0x12b0 */
 44, 72,119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,   /* 0x12c0 */
  3,193,231,  8,193,230,  8, 67,  9,199,102,139,149,224,  1,  0,   /* 0x12d0 */
  0,137,240,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 96,   /* 0x12e0 */
 41, 76, 36, 52,193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36,   /* 0x12f0 */
 72,131,124, 36,116,  0,141,  4, 50,102,137,133,224,  1,  0,  0,   /* 0x1300 */
 15,132,147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,   /* 0x1310 */
160,  0,  0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,137,   /* 0x1320 */
 68, 36, 96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136,   /* 0x1330 */
 68, 36,115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0,   /* 0x1340 */
 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,102,137,149,   /* 0x1350 */
224,  1,  0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,193,232,   /* 0x1360 */
  5,139,108, 36, 56,102, 41,193, 41,215,129,254,255,255,255,  0,   /* 0x1370 */
102,137,141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,   /* 0x1380 */
  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,   /* 0x1390 */
 76, 36, 56,137,240,193,232, 11,102,139,145,176,  1,  0,  0, 15,   /* 0x13a0 */
183,202, 15,175,193, 57,199,115, 35,137,198,184,  0,  8,  0,  0,   /* 0x13b0 */
 41,200,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,176,   /* 0x13c0 */
  1,  0,  0,139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,199,   /* 0x13d0 */
 41,193,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,129,   /* 0x13e0 */
249,255,255,255,  0,102,137,144,176,  1,  0,  0,119, 22, 59, 92,   /* 0x13f0 */
 36, 76, 15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,   /* 0x1400 */
  8, 67,  9,199,139,116, 36, 56,137,200,193,232, 11,102,139,150,   /* 0x1410 */
200,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 32,137,198,   /* 0x1420 */
184,  0,  8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,141,  4,   /* 0x1430 */
  2,102,137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206,   /* 0x1440 */
 41,199, 41,198,137,208,102,193,232,  5,102, 41,194,139, 68, 36,   /* 0x1450 */
 56,102,137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,   /* 0x1460 */
137, 84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,   /* 0x1470 */
137, 68, 36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,139,   /* 0x1480 */
 76, 36,120, 15,159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,   /* 0x1490 */
137, 68, 36, 96,129,254,255,255,255,  0,119, 22, 59, 92, 36, 76,   /* 0x14a0 */
 15,132,243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,   /* 0x14b0 */
  9,199,102,139, 17,137,240,193,232, 11, 15,183,234, 15,175,197,   /* 0x14c0 */
 57,199,115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,   /* 0x14d0 */
100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,   /* 0x14e0 */
  4,  2,102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36,   /* 0x14f0 */
 16,235,114, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,   /* 0x1500 */
129,254,255,255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,   /* 0x1510 */
132,132,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,   /* 0x1520 */
199,102,139, 81,  2,137,240,193,232, 11, 15,183,234, 15,175,197,   /* 0x1530 */
 57,199,115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,   /* 0x1540 */
100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,   /* 0x1550 */
  4,  2,139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,   /* 0x1560 */
  0,137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,   /* 0x1570 */
198, 41,199,137,208,137,116, 36, 72,102,193,232,  5,199, 68, 36,   /* 0x1580 */
 44, 16,  0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,   /* 0x1590 */
102,137, 81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76,   /* 0x15a0 */
 36, 48,186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116,   /* 0x15b0 */
 36, 16,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92,   /* 0x15c0 */
 36, 76, 15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,   /* 0x15d0 */
193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11,   /* 0x15e0 */
 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,   /* 0x15f0 */
  8,  0,  0, 41,200,193,248,  5,141,  4,  2,137,234,102,137,  6,   /* 0x1600 */
235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,   /* 0x1610 */
194,102,137, 22,141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,   /* 0x1620 */
117,137,138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3,   /* 0x1630 */
 84, 36, 44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,   /* 0x1640 */
  0,  0,131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,184,  3,   /* 0x1650 */
  0,  0,  0,139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,   /* 0x1660 */
  0,  0,141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,   /* 0x1670 */
  0,  0,141, 44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,255,   /* 0x1680 */
255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,   /* 0x1690 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x16a0 */
 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115,   /* 0x16b0 */
 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,   /* 0x16c0 */
  4,  2,102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,   /* 0x16d0 */
208,102,193,232,  5,102, 41,194,141, 69,  1,102,137, 22,139,108,   /* 0x16e0 */
 36, 36, 77,137,108, 36, 36,117,137,141, 80,192,131,250,  3,137,   /* 0x16f0 */
 20, 36, 15,142, 39,  1,  0,  0,137,208,137,214,209,248,131,230,   /* 0x1700 */
  1,141, 72,255,131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,   /* 0x1710 */
139,108, 36,120,211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,   /* 0x1720 */
208,  5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,   /* 0x1730 */
124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,   /* 0x1740 */
  1,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,   /* 0x1750 */
199,209,108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36,   /* 0x1760 */
 72,131,206,  1, 74,117,200,139, 68, 36,120,193,230,  4,137, 52,   /* 0x1770 */
 36,  5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68,   /* 0x1780 */
 36,  4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,   /* 0x1790 */
108, 36,  4,  1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,   /* 0x17a0 */
255,255,  0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,   /* 0x17b0 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x17c0 */
 72,102,139, 85,  0,193,232, 11, 15,183,242, 15,175,198, 57,199,   /* 0x17d0 */
115, 27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,   /* 0x17e0 */
141,  4,  2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36,   /* 0x17f0 */
 72, 41,199,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 24,   /* 0x1800 */
102,137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,   /* 0x1810 */
209,100, 36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,255,139,   /* 0x1820 */
 52, 36, 70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,   /* 0x1830 */
116,131,193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,   /* 0x1840 */
  0,137,234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52,   /* 0x1850 */
 40,138,  6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,   /* 0x1860 */
116, 15,139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,235,   /* 0x1870 */
 17,139,132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,   /* 0x1880 */
255,255,129,124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,   /* 0x1890 */
184,  1,  0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32,   /* 0x18a0 */
 67, 43,156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,   /* 0x18b0 */
  0,139, 76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,   /* 0x18c0 */
131,196,124, 91, 94, 95, 93,  3,115,252,  3,123,248, 49,192,141,   /* 0x18d0 */
140, 36,  0,255,255,255,137,236, 80, 57,204,117,251,137,236, 49,   /* 0x18e0 */
201, 89, 90, 95,137,254,235, 29,138,  7,131,199,  1, 60,128,114,   /* 0x18f0 */
 10, 60,143,119,  6,128,127,254, 15,116,  5, 44,232, 60,  1,119,   /* 0x1900 */
255, 56, 23,117,255,139,  7,102,193,232,  8,193,192, 16,134,196,   /* 0x1910 */
 41,248,  1,240,137,  7,131,199,  4,131,233,  4,138,  7,131,199,   /* 0x1920 */
  1,226, 13,131,233,  1,127,  3, 89, 95,185,  0,  0,  0,  0,138,   /* 0x1930 */
  7, 71, 44,232, 60,  1,119,247,128, 63,  0,117,  4,139,  7,138,   /* 0x1940 */
 95,  4,102,193,232,  8,134,196,193,192, 16,134,196, 41,248,128,   /* 0x1950 */
235,232,137,  7,131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,   /* 0x1960 */
176,232,176,233,242,174,117,  4,128, 63,  0,117,255,139,  7,102,   /* 0x1970 */
193,232,  8,134,196,193,192, 16,134,196, 41,248,171,235,  4, 94,   /* 0x1980 */
 95, 49,219,203, 94,139, 78,252,137,197,  3,  4, 36,131,192, 31,   /* 0x1990 */
131,224,240,253,141,116, 49,255,141,124,  1,255,243,164,139, 74,   /* 0x19a0 */
252,131,193,  3,193,233,  2,141,116,138,252,141,120,252,243,165,   /* 0x19b0 */
252,141,119,  4,137,239,131,205,255,255,224, 85, 80, 88, 33,161,   /* 0x19c0 */
216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x19d0 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,116,109,112, 47, 97,   /* 0x19e0 */
109,100, 54, 52, 45,108,105,110,117,120, 46,107,101,114,110,101,   /* 0x19f0 */
108, 46,118,109,108,105,110,117,120, 46, 98,105,110, 58, 32, 32,   /* 0x1a00 */
 32, 32, 32,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,   /* 0x1a10 */
108,102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,   /* 0x1a20 */
111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32,   /* 0x1a30 */
 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32,   /* 0x1a40 */
 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32,   /* 0x1a50 */
 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,   /* 0x1a60 */
108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 76,   /* 0x1a70 */
 73, 78, 85, 88, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x1a80 */
 48, 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1a90 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1aa0 */
 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1ab0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x1ac0 */
 79, 78, 76, 89, 10, 32, 32, 49, 32, 76, 88, 67, 65, 76, 76, 84,   /* 0x1ad0 */
 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0x1ae0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1af0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 50, 32, 32, 50,   /* 0x1b00 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x1b10 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 76, 88, 67, 75,   /* 0x1b20 */
 76, 76, 84, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1b30 */
 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1b40 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 51,   /* 0x1b50 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1b60 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1b70 */
 89, 10, 32, 32, 51, 32, 76, 88, 77, 79, 86, 69, 85, 80, 32, 32,   /* 0x1b80 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48,   /* 0x1b90 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1ba0 */
 32, 32, 48, 48, 48, 48, 48, 48, 52, 54, 32, 32, 50, 42, 42, 48,   /* 0x1bb0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x1bc0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32,   /* 0x1bd0 */
 78, 50, 66, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x1be0 */
 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1bf0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1c00 */
 48, 48, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x1c10 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x1c20 */
 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 78, 50, 66, 70, 65, 83,   /* 0x1c30 */
 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0x1c40 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1c50 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53, 51, 32, 32,   /* 0x1c60 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x1c70 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x1c80 */
 32, 32, 54, 32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 32, 32, 32,   /* 0x1c90 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48,   /* 0x1ca0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1cb0 */
 48, 48, 48, 48, 48, 48, 53, 53, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1cc0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x1cd0 */
 76, 89, 10, 32, 32, 55, 32, 78, 50, 66, 68, 69, 67, 49, 48, 32,   /* 0x1ce0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48,   /* 0x1cf0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1d00 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 53, 98, 32, 32, 50, 42, 42,   /* 0x1d10 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x1d20 */
 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 78, 50, 66, 83, 77, 65,   /* 0x1d30 */
 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53,   /* 0x1d40 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1d50 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 54, 32, 32,   /* 0x1d60 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x1d70 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x1d80 */
 32, 32, 57, 32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 32, 32, 32,   /* 0x1d90 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48,   /* 0x1da0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1db0 */
 48, 48, 48, 48, 48, 48, 54, 98, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1dc0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x1dd0 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 78, 50,   /* 0x1de0 */
 66, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1df0 */
 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1e00 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1e10 */
 55, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x1e20 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49,   /* 0x1e30 */
 32, 78, 50, 66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x1e40 */
 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e50 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1e60 */
 48, 48, 48, 56, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x1e70 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x1e80 */
 65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 78, 50, 66, 70, 65,   /* 0x1e90 */
 83, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1ea0 */
102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1eb0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56,101, 32,   /* 0x1ec0 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x1ed0 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x1ee0 */
 10, 32, 49, 51, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 32, 32,   /* 0x1ef0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 51,101, 32, 32, 48, 48, 48,   /* 0x1f00 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1f10 */
 32, 48, 48, 48, 48, 48, 48, 57,100, 32, 32, 50, 42, 42, 48, 32,   /* 0x1f20 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x1f30 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 78,   /* 0x1f40 */
 50, 66, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x1f50 */
 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1f60 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1f70 */
 48,100, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1f80 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x1f90 */
 79, 78, 76, 89, 10, 32, 49, 53, 32, 78, 50, 66, 70, 65, 83, 52,   /* 0x1fa0 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32,   /* 0x1fb0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1fc0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 56, 32, 32, 50,   /* 0x1fd0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x1fe0 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x1ff0 */
 49, 54, 32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32,   /* 0x2000 */
 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,   /* 0x2010 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2020 */
 48, 48, 48, 48, 48,102, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2030 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2040 */
 89, 10, 32, 49, 55, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 32,   /* 0x2050 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48,   /* 0x2060 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2070 */
 32, 32, 48, 48, 48, 48, 48, 48,102, 57, 32, 32, 50, 42, 42, 48,   /* 0x2080 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x2090 */
 79, 78, 76, 89, 10, 32, 49, 56, 32, 78, 50, 66, 68, 69, 67, 53,   /* 0x20a0 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32,   /* 0x20b0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x20c0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,102, 99, 32, 32, 50,   /* 0x20d0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x20e0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 57, 32, 78, 50, 66, 83,   /* 0x20f0 */
 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2100 */
 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2110 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 48, 53,   /* 0x2120 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x2130 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2140 */
 89, 10, 32, 50, 48, 32, 78, 50, 66, 70, 65, 83, 54, 48, 32, 32,   /* 0x2150 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 57, 32, 32, 48, 48,   /* 0x2160 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2170 */
 32, 32, 48, 48, 48, 48, 48, 49, 49, 49, 32, 32, 50, 42, 42, 48,   /* 0x2180 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x2190 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 49, 32,   /* 0x21a0 */
 78, 50, 66, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x21b0 */
 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x21c0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x21d0 */
 48, 49, 50, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x21e0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x21f0 */
 68, 79, 78, 76, 89, 10, 32, 50, 50, 32, 78, 50, 66, 68, 69, 67,   /* 0x2200 */
 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2210 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2220 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 52, 48, 32, 32,   /* 0x2230 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x2240 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 78, 50, 68,   /* 0x2250 */
 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2260 */
 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2270 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 52,   /* 0x2280 */
 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2290 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x22a0 */
 76, 89, 10, 32, 50, 52, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32,   /* 0x22b0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,   /* 0x22c0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x22d0 */
 48, 32, 32, 48, 48, 48, 48, 48, 49, 52, 51, 32, 32, 50, 42, 42,   /* 0x22e0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x22f0 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 53,   /* 0x2300 */
 32, 78, 50, 68, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48,   /* 0x2310 */
 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2320 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2330 */
 48, 48, 49, 52, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2340 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2350 */
 32, 50, 54, 32, 78, 50, 68, 68, 69, 67, 49, 48, 32, 32, 32, 32,   /* 0x2360 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48,   /* 0x2370 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2380 */
 48, 48, 48, 48, 48, 49, 52, 98, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2390 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x23a0 */
 76, 89, 10, 32, 50, 55, 32, 78, 50, 68, 83, 77, 65, 50, 48, 32,   /* 0x23b0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48,   /* 0x23c0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x23d0 */
 48, 32, 32, 48, 48, 48, 48, 48, 49, 53, 54, 32, 32, 50, 42, 42,   /* 0x23e0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x23f0 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 56,   /* 0x2400 */
 32, 78, 50, 68, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x2410 */
 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2420 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2430 */
 48, 48, 49, 53, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2440 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x2450 */
 65, 68, 79, 78, 76, 89, 10, 32, 50, 57, 32, 78, 50, 68, 68, 69,   /* 0x2460 */
 67, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2470 */
100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2480 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 54, 52, 32,   /* 0x2490 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x24a0 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32, 78, 50,   /* 0x24b0 */
 68, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x24c0 */
 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x24d0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,   /* 0x24e0 */
 55, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x24f0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x2500 */
 78, 76, 89, 10, 32, 51, 49, 32, 78, 50, 68, 70, 65, 83, 51, 48,   /* 0x2510 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32,   /* 0x2520 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2530 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55,101, 32, 32, 50, 42,   /* 0x2540 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2550 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,   /* 0x2560 */
 50, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32,   /* 0x2570 */
 48, 48, 48, 48, 48, 48, 53, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2580 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2590 */
 48, 48, 48, 49, 56,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x25a0 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x25b0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 51, 32, 78, 50, 68, 83,   /* 0x25c0 */
 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x25d0 */
 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x25e0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,100,102,   /* 0x25f0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x2600 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2610 */
 89, 10, 32, 51, 52, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 32,   /* 0x2620 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48,   /* 0x2630 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2640 */
 32, 32, 48, 48, 48, 48, 48, 49,101, 99, 32, 32, 50, 42, 42, 48,   /* 0x2650 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x2660 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 53, 32,   /* 0x2670 */
 78, 50, 68, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2680 */
 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2690 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x26a0 */
 48, 49,102, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x26b0 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x26c0 */
 51, 54, 32, 78, 50, 68, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32,   /* 0x26d0 */
 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48,   /* 0x26e0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x26f0 */
 48, 48, 48, 48, 49,102,100, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2700 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2710 */
 89, 10, 32, 51, 55, 32, 78, 50, 68, 68, 69, 67, 53, 48, 32, 32,   /* 0x2720 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48,   /* 0x2730 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2740 */
 32, 32, 48, 48, 48, 48, 48, 50, 48, 48, 32, 32, 50, 42, 42, 48,   /* 0x2750 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x2760 */
 79, 78, 76, 89, 10, 32, 51, 56, 32, 78, 50, 68, 83, 77, 65, 54,   /* 0x2770 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32,   /* 0x2780 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2790 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 48, 57, 32, 32, 50,   /* 0x27a0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x27b0 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x27c0 */
 51, 57, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32,   /* 0x27d0 */
 32, 48, 48, 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48, 48, 48,   /* 0x27e0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x27f0 */
 48, 48, 48, 48, 50, 49, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2800 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x2810 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 48, 32, 78, 50, 68,   /* 0x2820 */
 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2830 */
 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2840 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 50,   /* 0x2850 */
101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2860 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x2870 */
 76, 89, 10, 32, 52, 49, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32,   /* 0x2880 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2890 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x28a0 */
 48, 32, 32, 48, 48, 48, 48, 48, 50, 52, 52, 32, 32, 50, 42, 42,   /* 0x28b0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x28c0 */
 68, 79, 78, 76, 89, 10, 32, 52, 50, 32, 78, 50, 69, 83, 77, 65,   /* 0x28d0 */
 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51,   /* 0x28e0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x28f0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 52, 52, 32, 32,   /* 0x2900 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x2910 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2920 */
 32, 52, 51, 32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 32, 32, 32,   /* 0x2930 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x2940 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2950 */
 48, 48, 48, 48, 48, 50, 52, 55, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2960 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x2970 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 52, 32, 78, 50,   /* 0x2980 */
 69, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2990 */
 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x29a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,   /* 0x29b0 */
 52, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x29c0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 53,   /* 0x29d0 */
 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x29e0 */
 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x29f0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2a00 */
 48, 48, 50, 52,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2a10 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2a20 */
 32, 52, 54, 32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 32, 32, 32,   /* 0x2a30 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,   /* 0x2a40 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2a50 */
 48, 48, 48, 48, 48, 50, 53, 97, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2a60 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x2a70 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 55, 32, 78, 50,   /* 0x2a80 */
 69, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2a90 */
 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2aa0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,   /* 0x2ab0 */
 53,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2ac0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x2ad0 */
 78, 76, 89, 10, 32, 52, 56, 32, 78, 50, 69, 68, 69, 67, 50, 48,   /* 0x2ae0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32,   /* 0x2af0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2b00 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 54, 56, 32, 32, 50, 42,   /* 0x2b10 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2b20 */
 65, 68, 79, 78, 76, 89, 10, 32, 52, 57, 32, 78, 50, 69, 83, 77,   /* 0x2b30 */
 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2b40 */
100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2b50 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 55, 53, 32,   /* 0x2b60 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2b70 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2b80 */
 10, 32, 53, 48, 32, 78, 50, 69, 70, 65, 83, 51, 48, 32, 32, 32,   /* 0x2b90 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48,   /* 0x2ba0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2bb0 */
 32, 48, 48, 48, 48, 48, 50, 56, 50, 32, 32, 50, 42, 42, 48, 32,   /* 0x2bc0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x2bd0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 49, 32, 78,   /* 0x2be0 */
 50, 69, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x2bf0 */
 48, 48, 48, 53,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2c00 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2c10 */
 50, 57, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2c20 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x2c30 */
 79, 78, 76, 89, 10, 32, 53, 50, 32, 78, 50, 69, 83, 77, 65, 52,   /* 0x2c40 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32,   /* 0x2c50 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2c60 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,102, 48, 32, 32, 50,   /* 0x2c70 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2c80 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2c90 */
 53, 51, 32, 78, 50, 69, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32,   /* 0x2ca0 */
 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48,   /* 0x2cb0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2cc0 */
 48, 48, 48, 48, 50,102,100, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2cd0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x2ce0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 52, 32, 78, 50, 69,   /* 0x2cf0 */
 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2d00 */
 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2d10 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 48,   /* 0x2d20 */
 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2d30 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 53, 32,   /* 0x2d40 */
 78, 50, 69, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2d50 */
 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2d60 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2d70 */
 48, 51, 48,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2d80 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2d90 */
 53, 54, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32,   /* 0x2da0 */
 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48,   /* 0x2db0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2dc0 */
 48, 48, 48, 48, 51, 49, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2dd0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2de0 */
 89, 10, 32, 53, 55, 32, 78, 50, 69, 83, 77, 65, 54, 48, 32, 32,   /* 0x2df0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32, 48, 48,   /* 0x2e00 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2e10 */
 32, 32, 48, 48, 48, 48, 48, 51, 49, 97, 32, 32, 50, 42, 42, 48,   /* 0x2e20 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x2e30 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 56, 32,   /* 0x2e40 */
 78, 50, 69, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2e50 */
 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2e60 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2e70 */
 48, 51, 50, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2e80 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x2e90 */
 68, 79, 78, 76, 89, 10, 32, 53, 57, 32, 78, 50, 69, 70, 65, 83,   /* 0x2ea0 */
 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54,   /* 0x2eb0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2ec0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 51,102, 32, 32,   /* 0x2ed0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x2ee0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2ef0 */
 32, 54, 48, 32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 32, 32, 32,   /* 0x2f00 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2f10 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2f20 */
 48, 48, 48, 48, 48, 51, 53, 53, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2f30 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x2f40 */
 76, 89, 10, 32, 54, 49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48,   /* 0x2f50 */
 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,101, 32, 32, 48,   /* 0x2f60 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2f70 */
 48, 32, 32, 48, 48, 48, 48, 48, 51, 53, 53, 32, 32, 50, 42, 42,   /* 0x2f80 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x2f90 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 50,   /* 0x2fa0 */
 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48,   /* 0x2fb0 */
 48, 48, 48, 48, 48, 52, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2fc0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2fd0 */
 48, 48, 51, 56, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2fe0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2ff0 */
 32, 54, 51, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32,   /* 0x3000 */
 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32, 48, 48, 48, 48,   /* 0x3010 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3020 */
 48, 48, 48, 48, 48, 51, 99, 98, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3030 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x3040 */
 76, 89, 10, 32, 54, 52, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3050 */
 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32, 48,   /* 0x3060 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3070 */
 48, 32, 32, 48, 48, 48, 48, 48,101, 53, 49, 32, 32, 50, 42, 42,   /* 0x3080 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x3090 */
 68, 79, 78, 76, 89, 10, 32, 54, 53, 32, 76, 90, 77, 65, 95, 68,   /* 0x30a0 */
 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 97,   /* 0x30b0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x30c0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,100, 55, 32, 32,   /* 0x30d0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x30e0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 54, 32, 76, 88, 67,   /* 0x30f0 */
 75, 76, 76, 84, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x3100 */
 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3110 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,102,   /* 0x3120 */
 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x3130 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 55, 32,   /* 0x3140 */
 99,116,111,107, 51, 50, 46, 48, 48, 32, 32, 32, 32, 32, 48, 48,   /* 0x3150 */
 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3160 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3170 */
 49, 56,102, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3180 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x3190 */
 68, 79, 78, 76, 89, 10, 32, 54, 56, 32, 99,116,111,107, 51, 50,   /* 0x31a0 */
 46, 49, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101,   /* 0x31b0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x31c0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,102,100, 32, 32,   /* 0x31d0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x31e0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x31f0 */
 32, 54, 57, 32, 99,116,111,107, 51, 50, 46, 50, 48, 32, 32, 32,   /* 0x3200 */
 32, 32, 48, 48, 48, 48, 48, 48, 50, 49, 32, 32, 48, 48, 48, 48,   /* 0x3210 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3220 */
 48, 48, 48, 48, 49, 57, 48, 98, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3230 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3240 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 48, 32, 99,116,   /* 0x3250 */
111,107, 51, 50, 46, 51, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3260 */
 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3270 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,   /* 0x3280 */
 50, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3290 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x32a0 */
 78, 76, 89, 10, 32, 55, 49, 32, 99,116,111,107, 51, 50, 46, 52,   /* 0x32b0 */
 48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32,   /* 0x32c0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x32d0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 51, 51, 32, 32, 50, 42,   /* 0x32e0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x32f0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55,   /* 0x3300 */
 50, 32, 76, 88, 67, 65, 76, 76, 84, 57, 32, 32, 32, 32, 32, 32,   /* 0x3310 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3320 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3330 */
 48, 48, 49, 57, 51, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3340 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3350 */
 10, 32, 55, 51, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 32, 32,   /* 0x3360 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48, 48,   /* 0x3370 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3380 */
 32, 48, 48, 48, 48, 49, 57, 51, 97, 32, 32, 50, 42, 42, 48, 32,   /* 0x3390 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x33a0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 52, 32, 67,   /* 0x33b0 */
 84, 67, 76, 69, 86, 69, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x33c0 */
 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x33d0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x33e0 */
 57, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x33f0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x3400 */
 79, 78, 76, 89, 10, 32, 55, 53, 32, 67, 65, 76, 76, 84, 82, 48,   /* 0x3410 */
 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32,   /* 0x3420 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3430 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 52,100, 32, 32, 50,   /* 0x3440 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3450 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 54, 32, 67, 84, 66, 83,   /* 0x3460 */
 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3470 */
 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3480 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 53, 50,   /* 0x3490 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x34a0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 55, 32, 67,   /* 0x34b0 */
 84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x34c0 */
 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x34d0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x34e0 */
 57, 53, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x34f0 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55,   /* 0x3500 */
 56, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32, 32, 32,   /* 0x3510 */
 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3520 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3530 */
 48, 48, 49, 57, 53, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3540 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3550 */
 10, 32, 55, 57, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32, 32,   /* 0x3560 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48, 48,   /* 0x3570 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3580 */
 32, 48, 48, 48, 48, 49, 57, 53,100, 32, 32, 50, 42, 42, 48, 32,   /* 0x3590 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x35a0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 48, 32, 67,   /* 0x35b0 */
 65, 76, 76, 84, 82, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x35c0 */
 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x35d0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x35e0 */
 57, 54, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x35f0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x3600 */
 79, 78, 76, 89, 10, 32, 56, 49, 32, 67, 65, 76, 76, 84, 82, 69,   /* 0x3610 */
 56, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,   /* 0x3620 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3630 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55, 48, 32, 32, 50,   /* 0x3640 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3650 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 50, 32, 67, 65, 76, 76,   /* 0x3660 */
 84, 82, 69, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3670 */
 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3680 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55, 50,   /* 0x3690 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x36a0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 51, 32, 67,   /* 0x36b0 */
 65, 76, 76, 84, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x36c0 */
 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x36d0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x36e0 */
 57, 55, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x36f0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x3700 */
 79, 78, 76, 89, 10, 32, 56, 52, 32, 67, 84, 67, 76, 69, 86, 69,   /* 0x3710 */
 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32,   /* 0x3720 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3730 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 55, 56, 32, 32, 50,   /* 0x3740 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3750 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x3760 */
 56, 53, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32, 32,   /* 0x3770 */
 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,   /* 0x3780 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x3790 */
 48, 48, 48, 49, 57, 55,100, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x37a0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x37b0 */
 89, 10, 32, 56, 54, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 32,   /* 0x37c0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48,   /* 0x37d0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x37e0 */
 32, 32, 48, 48, 48, 48, 49, 57, 55,102, 32, 32, 50, 42, 42, 48,   /* 0x37f0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x3800 */
 79, 78, 76, 89, 10, 32, 56, 55, 32, 67, 84, 66, 82, 79, 82, 49,   /* 0x3810 */
 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,   /* 0x3820 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3830 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 56, 51, 32, 32, 50,   /* 0x3840 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3850 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 56, 32, 67, 84, 66, 83,   /* 0x3860 */
 87, 65, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3870 */
 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3880 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 56, 53,   /* 0x3890 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x38a0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 57, 32, 67,   /* 0x38b0 */
 65, 76, 76, 84, 82, 49, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x38c0 */
 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x38d0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x38e0 */
 57, 56, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x38f0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x3900 */
 79, 78, 76, 89, 10, 32, 57, 48, 32, 76, 73, 78, 85, 88, 57, 57,   /* 0x3910 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51, 55, 32,   /* 0x3920 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x3930 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 56,102, 32, 32, 50,   /* 0x3940 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x3950 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 49, 32, 76, 73, 78, 85,   /* 0x3960 */
 88, 57, 57, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3970 */
 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3980 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 99, 54,   /* 0x3990 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x39a0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 50, 32, 76,   /* 0x39b0 */
 73, 78, 85, 88, 57, 57, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x39c0 */
 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x39d0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x39e0 */
 57, 99, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x39f0 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57,   /* 0x3a00 */
 51, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32,   /* 0x3a10 */
 48, 48, 48, 48, 48, 48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3a20 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3a30 */
 48, 48, 49, 57, 99, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3a40 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3a50 */
 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48,   /* 0x3a60 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3a70 */
 78, 50, 66, 83, 77, 65, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3a80 */
 48, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x3a90 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,   /* 0x3aa0 */
 65, 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3ab0 */
 66, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3ac0 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,   /* 0x3ad0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67,   /* 0x3ae0 */
 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3af0 */
 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48,  9, 48, 48, 48,   /* 0x3b00 */
 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48,   /* 0x3b10 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3b20 */
 78, 50, 66, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3b30 */
 48, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,   /* 0x3b40 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68,   /* 0x3b50 */
 69, 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3b60 */
 66, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3b70 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49,   /* 0x3b80 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83,   /* 0x3b90 */
 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3ba0 */
 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 54, 48,  9, 48, 48, 48,   /* 0x3bb0 */
 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48,   /* 0x3bc0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3bd0 */
 78, 50, 68, 83, 77, 65, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3be0 */
 48, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x3bf0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70,   /* 0x3c00 */
 65, 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3c10 */
 68, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3c20 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48,   /* 0x3c30 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67,   /* 0x3c40 */
 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3c50 */
 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48,  9, 48, 48, 48,   /* 0x3c60 */
 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 50, 48, 10, 48,   /* 0x3c70 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3c80 */
 78, 50, 68, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3c90 */
 48, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,   /* 0x3ca0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68,   /* 0x3cb0 */
 69, 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3cc0 */
 68, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3cd0 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49,   /* 0x3ce0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83,   /* 0x3cf0 */
 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3d00 */
 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48,  9, 48, 48, 48,   /* 0x3d10 */
 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48,   /* 0x3d20 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3d30 */
 78, 50, 69, 83, 77, 65, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3d40 */
 48, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x3d50 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,   /* 0x3d60 */
 65, 83, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3d70 */
 69, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3d80 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48,   /* 0x3d90 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67,   /* 0x3da0 */
 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3db0 */
 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48,  9, 48, 48, 48,   /* 0x3dc0 */
 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48,   /* 0x3dd0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3de0 */
 78, 50, 69, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3df0 */
 48, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,   /* 0x3e00 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68,   /* 0x3e10 */
 69, 67, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x3e20 */
 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3e30 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49,   /* 0x3e40 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83,   /* 0x3e50 */
 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3e60 */
 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48,  9, 48, 48, 48,   /* 0x3e70 */
 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 48,   /* 0x3e80 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3e90 */
 99,116,111,107, 51, 50, 46, 48, 48,  9, 48, 48, 48, 48, 48, 48,   /* 0x3ea0 */
 48, 48, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 48, 48, 48,   /* 0x3eb0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,   /* 0x3ec0 */
111,107, 51, 50, 46, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3ed0 */
 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x3ee0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107,   /* 0x3ef0 */
 51, 50, 46, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,   /* 0x3f00 */
116,111,107, 51, 50, 46, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x3f10 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50,   /* 0x3f20 */
 46, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,   /* 0x3f30 */
107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3f40 */
108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48,   /* 0x3f50 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82,   /* 0x3f60 */
 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x3f70 */
 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48,  9, 48, 48, 48,   /* 0x3f80 */
 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48,   /* 0x3f90 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x3fa0 */
 67, 65, 76, 76, 84, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x3fb0 */
 48, 32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 48, 48, 48, 48, 48,   /* 0x3fc0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76,   /* 0x3fd0 */
 84, 82, 49, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65,   /* 0x3fe0 */
 76, 76, 84, 82, 49, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3ff0 */
108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 57, 57, 48,   /* 0x4000 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 57,   /* 0x4010 */
 57, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4020 */
 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 48, 48,  9, 48, 48, 48,   /* 0x4030 */
 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 48, 48, 48, 10, 48,   /* 0x4040 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4050 */
 76, 88, 67, 65, 76, 76, 84, 49,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4060 */
 48, 32, 76, 88, 67, 65, 76, 76, 84, 49, 10, 48, 48, 48, 48, 48,   /* 0x4070 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 75,   /* 0x4080 */
 76, 76, 84, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88,   /* 0x4090 */
 67, 75, 76, 76, 84, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x40a0 */
108, 32, 32, 32, 32,100, 32, 32, 76, 88, 77, 79, 86, 69, 85, 80,   /* 0x40b0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 77, 79, 86, 69,   /* 0x40c0 */
 85, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x40d0 */
 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 48,  9, 48, 48, 48,   /* 0x40e0 */
 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 49, 48, 10, 48,   /* 0x40f0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4100 */
 78, 50, 66, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4110 */
 48, 32, 78, 50, 66, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x4120 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,   /* 0x4130 */
 65, 83, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4140 */
 66, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4150 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 51, 48,   /* 0x4160 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65,   /* 0x4170 */
 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4180 */
 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 51, 48,  9, 48, 48, 48,   /* 0x4190 */
 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 51, 48, 10, 48,   /* 0x41a0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x41b0 */
 78, 50, 66, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x41c0 */
 48, 32, 78, 50, 66, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48,   /* 0x41d0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,   /* 0x41e0 */
 65, 83, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x41f0 */
 66, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4200 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 53, 48,   /* 0x4210 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65,   /* 0x4220 */
 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4230 */
 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 53, 48,  9, 48, 48, 48,   /* 0x4240 */
 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 53, 48, 10, 48,   /* 0x4250 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4260 */
 78, 50, 66, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4270 */
 48, 32, 78, 50, 66, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48,   /* 0x4280 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,   /* 0x4290 */
 65, 83, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x42a0 */
 66, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x42b0 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 48,   /* 0x42c0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83,   /* 0x42d0 */
 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x42e0 */
 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 50, 48,  9, 48, 48, 48,   /* 0x42f0 */
 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 50, 48, 10, 48,   /* 0x4300 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4310 */
 78, 50, 68, 70, 65, 83, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4320 */
 48, 32, 78, 50, 68, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x4330 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83,   /* 0x4340 */
 77, 65, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4350 */
 68, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4360 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 51, 48,   /* 0x4370 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83,   /* 0x4380 */
 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4390 */
 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 52, 48,  9, 48, 48, 48,   /* 0x43a0 */
 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 52, 48, 10, 48,   /* 0x43b0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x43c0 */
 78, 50, 68, 70, 65, 83, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x43d0 */
 48, 32, 78, 50, 68, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48,   /* 0x43e0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83,   /* 0x43f0 */
 77, 65, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4400 */
 68, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4410 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 53, 48,   /* 0x4420 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70, 65, 83,   /* 0x4430 */
 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4440 */
 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 54, 48,  9, 48, 48, 48,   /* 0x4450 */
 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 54, 48, 10, 48,   /* 0x4460 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4470 */
 78, 50, 68, 70, 65, 83, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4480 */
 48, 32, 78, 50, 68, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48,   /* 0x4490 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,   /* 0x44a0 */
 65, 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x44b0 */
 69, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x44c0 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 50, 48,   /* 0x44d0 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65,   /* 0x44e0 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x44f0 */
 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 50, 48,  9, 48, 48, 48,   /* 0x4500 */
 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 50, 48, 10, 48,   /* 0x4510 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4520 */
 78, 50, 69, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4530 */
 48, 32, 78, 50, 69, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48,   /* 0x4540 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,   /* 0x4550 */
 65, 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4560 */
 69, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4570 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 52, 48,   /* 0x4580 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65,   /* 0x4590 */
 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x45a0 */
 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 52, 48,  9, 48, 48, 48,   /* 0x45b0 */
 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 52, 48, 10, 48,   /* 0x45c0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x45d0 */
 78, 50, 69, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x45e0 */
 48, 32, 78, 50, 69, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48,   /* 0x45f0 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,   /* 0x4600 */
 65, 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50,   /* 0x4610 */
 69, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4620 */
108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 54, 48,   /* 0x4630 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65,   /* 0x4640 */
 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x4650 */
 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 48,  9, 48, 48, 48,   /* 0x4660 */
 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 54, 48, 10, 48,   /* 0x4670 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4680 */
 76, 90, 77, 65, 95, 68, 69, 67, 48, 48,  9, 48, 48, 48, 48, 48,   /* 0x4690 */
 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 10, 48,   /* 0x46a0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x46b0 */
 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48, 48,   /* 0x46c0 */
 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48,   /* 0x46d0 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x46e0 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48,   /* 0x46f0 */
 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x4700 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4710 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48,   /* 0x4720 */
 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x4730 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4740 */
 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48,   /* 0x4750 */
 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48,   /* 0x4760 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x4770 */
 76, 88, 67, 75, 76, 76, 84, 57,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x4780 */
 48, 32, 76, 88, 67, 75, 76, 76, 84, 57, 10, 48, 48, 48, 48, 48,   /* 0x4790 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107,   /* 0x47a0 */
 51, 50, 46, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,   /* 0x47b0 */
116,111,107, 51, 50, 46, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x47c0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 88, 67, 65, 76, 76,   /* 0x47d0 */
 84, 57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 88, 67, 65,   /* 0x47e0 */
 76, 76, 84, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x47f0 */
 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 49,  9, 48,   /* 0x4800 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76, 69, 86, 69, 49,   /* 0x4810 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4820 */
 32, 32, 67, 65, 76, 76, 84, 82, 48, 49,  9, 48, 48, 48, 48, 48,   /* 0x4830 */
 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 49, 10, 48, 48, 48,   /* 0x4840 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,   /* 0x4850 */
 66, 83, 72, 82, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4860 */
 67, 84, 66, 83, 72, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4870 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79, 82,   /* 0x4880 */
 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 82,   /* 0x4890 */
 79, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x48a0 */
 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 48, 49,  9, 48,   /* 0x48b0 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 87, 65, 48, 49,   /* 0x48c0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x48d0 */
 32, 32, 67, 65, 76, 76, 84, 82, 48, 50,  9, 48, 48, 48, 48, 48,   /* 0x48e0 */
 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 50, 10, 48, 48, 48,   /* 0x48f0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,   /* 0x4900 */
 76, 76, 84, 82, 69, 56,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4910 */
 67, 65, 76, 76, 84, 82, 69, 56, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4920 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,   /* 0x4930 */
 69, 57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76,   /* 0x4940 */
 84, 82, 69, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4950 */
 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 50,  9, 48,   /* 0x4960 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76, 69, 86, 69, 50,   /* 0x4970 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4980 */
 32, 32, 67, 65, 76, 76, 84, 82, 49, 50,  9, 48, 48, 48, 48, 48,   /* 0x4990 */
 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 50, 10, 48, 48, 48,   /* 0x49a0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,   /* 0x49b0 */
 66, 83, 72, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x49c0 */
 67, 84, 66, 83, 72, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x49d0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79, 82,   /* 0x49e0 */
 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 82,   /* 0x49f0 */
 79, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4a00 */
 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 49, 49,  9, 48,   /* 0x4a10 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83, 87, 65, 49, 49,   /* 0x4a20 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4a30 */
 32, 32, 76, 73, 78, 85, 88, 57, 57, 49,  9, 48, 48, 48, 48, 48,   /* 0x4a40 */
 48, 48, 48, 32, 76, 73, 78, 85, 88, 57, 57, 49, 10, 48, 48, 48,   /* 0x4a50 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73,   /* 0x4a60 */
 78, 85, 88, 57, 57, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4a70 */
 76, 73, 78, 85, 88, 57, 57, 50, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4a80 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69,   /* 0x4a90 */
 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49,   /* 0x4aa0 */
 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,   /* 0x4ab0 */
 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,   /* 0x4ac0 */
 48, 48, 48, 48, 32, 69, 78, 84, 82, 89, 95, 80, 79, 73, 78, 84,   /* 0x4ad0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x4ae0 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4af0 */
 32, 80, 72, 89, 83, 73, 67, 65, 76, 95, 83, 84, 65, 82, 84, 10,   /* 0x4b00 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4b10 */
 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4b20 */
102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48,   /* 0x4b30 */
 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,   /* 0x4b40 */
 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,101,   /* 0x4b50 */
114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4b60 */
 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,   /* 0x4b70 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,115,116,   /* 0x4b80 */
 97, 99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48,   /* 0x4b90 */
 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,   /* 0x4ba0 */
 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,   /* 0x4bb0 */
117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x4bc0 */
 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,   /* 0x4bd0 */
 48, 48, 48, 48, 48, 32,108,122,109, 97, 95, 99, 95,108,101,110,   /* 0x4be0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x4bf0 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x4c00 */
 32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,101,115,   /* 0x4c10 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x4c20 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 88, 48,   /* 0x4c30 */
 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x4c40 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4c50 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,   /* 0x4c60 */
 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4c70 */
 32, 69, 78, 84, 82, 89, 95, 80, 79, 73, 78, 84, 10, 48, 48, 48,   /* 0x4c80 */
 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,   /* 0x4c90 */
 32, 32, 32, 32, 32, 32, 32, 32, 80, 72, 89, 83, 73, 67, 65, 76,   /* 0x4ca0 */
 95, 83, 84, 65, 82, 84, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x4cb0 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x4cc0 */
 76, 88, 67, 75, 76, 76, 84, 49, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x4cd0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4ce0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x4cf0 */
 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32,   /* 0x4d00 */
 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,   /* 0x4d10 */
111, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x4d20 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 88, 77, 79, 86,   /* 0x4d30 */
 69, 85, 80, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x4d40 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4d50 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0x4d60 */
 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4d70 */
 32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104, 10,   /* 0x4d80 */
 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x4d90 */
 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 76, 73, 78, 85, 88,   /* 0x4da0 */
 57, 57, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x4db0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,   /* 0x4dc0 */
 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x4dd0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4de0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4df0 */
 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x4e00 */
 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69,   /* 0x4e10 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x4e20 */
 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 49, 48, 93, 58,   /* 0x4e30 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x4e40 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x4e50 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,   /* 0x4e60 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,   /* 0x4e70 */
 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x4e80 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x4e90 */
 50, 66, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x4ea0 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4eb0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x4ec0 */
 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x4ed0 */
 32, 32, 32, 32, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 10,   /* 0x4ee0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x4ef0 */
 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 50, 48,   /* 0x4f00 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x4f10 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x4f20 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,   /* 0x4f30 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x4f40 */
 50, 66, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x4f50 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x4f60 */
 91, 78, 50, 66, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x4f70 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x4f80 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x4f90 */
 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x4fa0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48,   /* 0x4fb0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x4fc0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83,   /* 0x4fd0 */
 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x4fe0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x4ff0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,   /* 0x5000 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5010 */
 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x5020 */
 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x5030 */
 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82,   /* 0x5040 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x5050 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 68, 69, 67, 51, 48, 93,   /* 0x5060 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x5070 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x5080 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 51, 56,   /* 0x5090 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x50a0 */
 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 50,102, 32,   /* 0x50b0 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x50c0 */
 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79,   /* 0x50d0 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x50e0 */
 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 52, 48, 93, 58, 10, 79,   /* 0x50f0 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x5100 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x5110 */
 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5120 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,   /* 0x5130 */
 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x5140 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,   /* 0x5150 */
 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x5160 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5170 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5180 */
 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x5190 */
 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48,   /* 0x51a0 */
 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x51b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,   /* 0x51c0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x51d0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65,   /* 0x51e0 */
 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x51f0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5200 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82,   /* 0x5210 */
 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,   /* 0x5220 */
 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x5230 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x5240 */
 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70,   /* 0x5250 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x5260 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5270 */
 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5280 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83,   /* 0x5290 */
 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56,   /* 0x52a0 */
 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x52b0 */
 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x52c0 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x52d0 */
 78, 50, 66, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x52e0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x52f0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x5300 */
 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,   /* 0x5310 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10,   /* 0x5320 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x5330 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 49,   /* 0x5340 */
 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x5350 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x5360 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,   /* 0x5370 */
 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5380 */
 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x5390 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x53a0 */
 32, 91, 78, 50, 68, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70,   /* 0x53b0 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x53c0 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x53d0 */
 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x53e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49,   /* 0x53f0 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x5400 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77,   /* 0x5410 */
 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x5420 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5430 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0x5440 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x5450 */
 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79,   /* 0x5460 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5470 */
 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 50, 48, 93, 58, 10, 79,   /* 0x5480 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x5490 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x54a0 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x54b0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65,   /* 0x54c0 */
 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x54d0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,   /* 0x54e0 */
 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x54f0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5500 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5510 */
 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x5520 */
 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69,   /* 0x5530 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x5540 */
 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 51, 48, 93, 58,   /* 0x5550 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x5560 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x5570 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54,   /* 0x5580 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,   /* 0x5590 */
 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82,   /* 0x55a0 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x55b0 */
 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x55c0 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x55d0 */
 82, 32, 91, 78, 50, 68, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70,   /* 0x55e0 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x55f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5600 */
 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5610 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,   /* 0x5620 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95, 51, 56,   /* 0x5630 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x5640 */
 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 52, 51, 32,   /* 0x5650 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x5660 */
 32, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79,   /* 0x5670 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5680 */
 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 52, 48, 93, 58, 10, 79,   /* 0x5690 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x56a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x56b0 */
 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x56c0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,   /* 0x56d0 */
 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x56e0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,   /* 0x56f0 */
 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x5700 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5710 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5720 */
 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x5730 */
 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48,   /* 0x5740 */
 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x5750 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,   /* 0x5760 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x5770 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65,   /* 0x5780 */
 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x5790 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x57a0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82,   /* 0x57b0 */
 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,   /* 0x57c0 */
 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x57d0 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x57e0 */
 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70,   /* 0x57f0 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x5800 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5810 */
 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5820 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83,   /* 0x5830 */
 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56,   /* 0x5840 */
 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x5850 */
 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x5860 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x5870 */
 78, 50, 68, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x5880 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5890 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x58a0 */
 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,   /* 0x58b0 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10,   /* 0x58c0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x58d0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 49,   /* 0x58e0 */
 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x58f0 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x5900 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,   /* 0x5910 */
 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5920 */
 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x5930 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x5940 */
 32, 91, 78, 50, 69, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70,   /* 0x5950 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x5960 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x5970 */
 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x5980 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49,   /* 0x5990 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x59a0 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77,   /* 0x59b0 */
 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x59c0 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x59d0 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0x59e0 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x59f0 */
 32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79,   /* 0x5a00 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5a10 */
 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 50, 48, 93, 58, 10, 79,   /* 0x5a20 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x5a30 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x5a40 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5a50 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65,   /* 0x5a60 */
 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x5a70 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,   /* 0x5a80 */
 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x5a90 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5aa0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5ab0 */
 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x5ac0 */
 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69,   /* 0x5ad0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x5ae0 */
 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 51, 48, 93, 58,   /* 0x5af0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x5b00 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x5b10 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54,   /* 0x5b20 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,   /* 0x5b30 */
 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82,   /* 0x5b40 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5b50 */
 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x5b60 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x5b70 */
 82, 32, 91, 78, 50, 69, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70,   /* 0x5b80 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x5b90 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5ba0 */
 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5bb0 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,   /* 0x5bc0 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56,   /* 0x5bd0 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x5be0 */
 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32,   /* 0x5bf0 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x5c00 */
 32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 10, 82, 69, 76, 79,   /* 0x5c10 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5c20 */
 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 52, 48, 93, 58, 10, 79,   /* 0x5c30 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x5c40 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x5c50 */
 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5c60 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,   /* 0x5c70 */
 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x5c80 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,   /* 0x5c90 */
 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x5ca0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5cb0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5cc0 */
 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x5cd0 */
 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48,   /* 0x5ce0 */
 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x5cf0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,   /* 0x5d00 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x5d10 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65,   /* 0x5d20 */
 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x5d30 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5d40 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82,   /* 0x5d50 */
 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,   /* 0x5d60 */
 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x5d70 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x5d80 */
 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70,   /* 0x5d90 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x5da0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5db0 */
 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x5dc0 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83,   /* 0x5dd0 */
 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56,   /* 0x5de0 */
 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x5df0 */
 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x5e00 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x5e10 */
 78, 50, 69, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x5e20 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5e30 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x5e40 */
 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,   /* 0x5e50 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10,   /* 0x5e60 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x5e70 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69,   /* 0x5e80 */
 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x5e90 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5ea0 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32,   /* 0x5eb0 */
 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5ec0 */
 32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,   /* 0x5ed0 */
117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 51,   /* 0x5ee0 */
 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,   /* 0x5ef0 */
122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48,   /* 0x5f00 */
 49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,   /* 0x5f10 */
 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10,   /* 0x5f20 */
 48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95, 51,   /* 0x5f30 */
 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,   /* 0x5f40 */
112,114,111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76, 79,   /* 0x5f50 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5f60 */
 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 48, 48, 93, 58, 10,   /* 0x5f70 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x5f80 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x5f90 */
 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,   /* 0x5fa0 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107,   /* 0x5fb0 */
 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x5fc0 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,   /* 0x5fd0 */
116,111,107, 51, 50, 46, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x5fe0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5ff0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x6000 */
 48, 48, 48,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x6010 */
 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48,   /* 0x6020 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x6030 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,   /* 0x6040 */
 46, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x6050 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6060 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32,   /* 0x6070 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x6080 */
 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48,   /* 0x6090 */
 48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x60a0 */
 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48,   /* 0x60b0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x60c0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50,   /* 0x60d0 */
 46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x60e0 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x60f0 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32,   /* 0x6100 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x6110 */
 32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 10, 82, 69, 76,   /* 0x6120 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x6130 */
 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 52, 48, 93, 58,   /* 0x6140 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x6150 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x6160 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54,   /* 0x6170 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,   /* 0x6180 */
107, 51, 50, 46, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x6190 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x61a0 */
 67, 65, 76, 76, 84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x61b0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x61c0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x61d0 */
 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,   /* 0x61e0 */
 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,   /* 0x61f0 */
110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x6200 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84,   /* 0x6210 */
 67, 76, 69, 86, 69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x6220 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6230 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x6240 */
 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32,   /* 0x6250 */
 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10,   /* 0x6260 */
 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x6270 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,   /* 0x6280 */
 82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x6290 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76,   /* 0x62a0 */
 76, 84, 82, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x62b0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x62c0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x62d0 */
100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x62e0 */
 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69,   /* 0x62f0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x6300 */
 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93, 58,   /* 0x6310 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x6320 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x6330 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,   /* 0x6340 */
 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,   /* 0x6350 */
116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79,   /* 0x6360 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x6370 */
 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10, 79,   /* 0x6380 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x6390 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x63a0 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x63b0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,   /* 0x63c0 */
 82, 49, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x63d0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67,   /* 0x63e0 */
 76, 69, 86, 69, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x63f0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6400 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x6410 */
 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x6420 */
 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48,   /* 0x6430 */
 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x6440 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82,   /* 0x6450 */
 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x6460 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,   /* 0x6470 */
 84, 82, 49, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x6480 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6490 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,   /* 0x64a0 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x64b0 */
 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10                    /* 0x64c0 */
};
