/* ARB.xs is generated from the following files:

    ARB.xs.default
    ../ARBDB/ad_prot.h
    ../ARBDB/ad_t_prot.h
    ../ARBDB/adGene.h

*/


#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "debug.h"
#include "arbdb.h"
#include "arbdbt.h"
#include "adGene.h"
#include "ARB_ext.c"
#ifdef __cplusplus
}
#endif


MODULE = ARB		PACKAGE = ARB	 PREFIX = P2A_

PROTOTYPES: ENABLE

GBDATA *
P2A_search(gbd,str,type_of_entry)
	GBDATA *gbd
	char *str
	char *type_of_entry

	CODE:
	if (str[0] == 0) str = 0;
	RETVAL = GB_search(gbd,str,GBP_gb_types(type_of_entry));
	OUTPUT:
	RETVAL


GBDATA*
P2A_find(gbd,key,str,gbs)
        GBDATA *gbd
        char *key
        char *str
        char *gbs

        CODE:
        RETVAL = GB_find(gbd,key,str,GBP_search_mode(gbs));
        OUTPUT:
        RETVAL


GBDATA *
P2A_create(father,key,type)
	GBDATA *father
	char *key
	char *type

	CODE:
	RETVAL = GB_create(father,key,GBP_gb_types(type));
	OUTPUT:
	RETVAL

char *
P2A_request_undo_type(gb_main,type)
	GBDATA *gb_main
	char *type

	CODE:
	RETVAL = (char *)GB_request_undo_type(gb_main,GBP_undo_types(type));
	OUTPUT:
	RETVAL

char *
P2A_undo(gb_main,type)
	GBDATA *gb_main
	char *type

	CODE:
	RETVAL = (char *)GB_undo(gb_main,GBP_undo_types(type));
	OUTPUT:
	RETVAL

char *
P2A_undo_info(gb_main,type)
	GBDATA *gb_main
	char *type

	CODE:
	if (static_pntr) free(static_pntr);
	static_pntr = GB_undo_info(gb_main,GBP_undo_types(type));
	RETVAL = static_pntr;
	OUTPUT:
	RETVAL

GBDATA *
P2AT_open_table_field(gb_table,key,type)
	GBDATA *gb_table
	char *key
	char *type

	CODE:
	RETVAL = GBT_open_table_field(gb_table,key,GBP_gb_types(type));
	OUTPUT:
	RETVAL


char
P2AT_complementNucleotide(c,T_or_U)
	char c
	char T_or_U

	CODE:
	RETVAL = GBT_complementNucleotide(c,T_or_U);
	OUTPUT:
	RETVAL

char*
P2A_find_all_files(dir,mask,filename_only)
 char *dir
 char *mask
 int filename_only

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_find_all_files(dir,mask,filename_only);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_find_latest_file(dir,mask)
 char *dir
 char *mask

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_find_latest_file(dir,mask);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

void
P2A_raise_critical_error(msg)
 char *msg

    PPCODE:
   GB_raise_critical_error(msg);

char*
P2A_export_IO_error(action,filename)
 char *action
 char *filename

    CODE:
   RETVAL = (char *)GB_export_IO_error(action,filename);
   OUTPUT:
   RETVAL

char*
P2A_print_error()

    CODE:
   RETVAL = (char *)GB_print_error();
   OUTPUT:
   RETVAL

char*
P2A_get_error()

    CODE:
   RETVAL = (char *)GB_get_error();
   OUTPUT:
   RETVAL

void
P2A_clear_error()

    PPCODE:
   GB_clear_error();

char*
P2A_check_key(key)
 char *key

    CODE:
   RETVAL = (char *)GB_check_key(key);
   OUTPUT:
   RETVAL

char*
P2A_check_link_name(key)
 char *key

    CODE:
   RETVAL = (char *)GB_check_link_name(key);
   OUTPUT:
   RETVAL

char*
P2A_check_hkey(key)
 char *key

    CODE:
   RETVAL = (char *)GB_check_hkey(key);
   OUTPUT:
   RETVAL

long
P2A_checksum(seq,length,ignore_case,exclude)
 char *seq
 long length
 int ignore_case
 char *exclude

    CODE:
   RETVAL = GB_checksum(seq,length,ignore_case,exclude);
   OUTPUT:
   RETVAL

long
P2A_merge_sort_strcmp(v0,v1,not_used)
 void *v0
 void *v1
 char *not_used

    CODE:
   RETVAL = GB_merge_sort_strcmp(v0,v1,not_used);
   OUTPUT:
   RETVAL

int
P2A_status(val)
 double val

    CODE:
   RETVAL = GB_status(val);
   OUTPUT:
   RETVAL

char*
P2A_read_as_tagged_string(gbd,tagi)
 GBDATA *gbd
 char *tagi

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_read_as_tagged_string(gbd,tagi);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

double
P2A_atof(str)
 char *str

    CODE:
   RETVAL = GB_atof(str);
   OUTPUT:
   RETVAL

char*
P2A_give_buffer(size)
 long size

    CODE:
   RETVAL = (char *)GB_give_buffer(size);
   OUTPUT:
   RETVAL

int
P2A_give_buffer_size()

    CODE:
   RETVAL = GB_give_buffer_size();
   OUTPUT:
   RETVAL

char*
P2A_give_buffer2(size)
 long size

    CODE:
   RETVAL = (char *)GB_give_buffer2(size);
   OUTPUT:
   RETVAL

char*
P2A_give_other_buffer(buffer,size)
 char *buffer
 long size

    CODE:
   RETVAL = (char *)GB_give_other_buffer(buffer,size);
   OUTPUT:
   RETVAL

char*
P2A_close(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_close(gbd);
   OUTPUT:
   RETVAL

char*
P2A_exit(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_exit(gbd);
   OUTPUT:
   RETVAL

long
P2A_read_int(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_int(gbd);
   OUTPUT:
   RETVAL

int
P2A_read_byte(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_byte(gbd);
   OUTPUT:
   RETVAL

double
P2A_read_float(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_float(gbd);
   OUTPUT:
   RETVAL

long
P2A_read_count(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_count(gbd);
   OUTPUT:
   RETVAL

long
P2A_read_memuse(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_memuse(gbd);
   OUTPUT:
   RETVAL

char*
P2A_read_pntr(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_read_pntr(gbd);
   OUTPUT:
   RETVAL

char*
P2A_read_char_pntr(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_read_char_pntr(gbd);
   OUTPUT:
   RETVAL

char*
P2A_read_string(gbd)
 GBDATA *gbd

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_read_string(gbd);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

long
P2A_read_string_count(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_string_count(gbd);
   OUTPUT:
   RETVAL

char*
P2A_read_link_pntr(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_read_link_pntr(gbd);
   OUTPUT:
   RETVAL

char*
P2A_read_link(gbd)
 GBDATA *gbd

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_read_link(gbd);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

long
P2A_read_link_count(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_link_count(gbd);
   OUTPUT:
   RETVAL

long
P2A_read_bits_count(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_bits_count(gbd);
   OUTPUT:
   RETVAL

char*
P2A_read_bits_pntr(gbd,c_0,c_1)
 GBDATA *gbd
 char c_0
 char c_1

    CODE:
   RETVAL = (char *)GB_read_bits_pntr(gbd,c_0,c_1);
   OUTPUT:
   RETVAL

char*
P2A_read_bits(gbd,c_0,c_1)
 GBDATA *gbd
 char c_0
 char c_1

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_read_bits(gbd,c_0,c_1);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_read_bytes_pntr(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_read_bytes_pntr(gbd);
   OUTPUT:
   RETVAL

long
P2A_read_bytes_count(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_bytes_count(gbd);
   OUTPUT:
   RETVAL

char*
P2A_read_bytes(gbd)
 GBDATA *gbd

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_read_bytes(gbd);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

long
P2A_read_ints_count(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_ints_count(gbd);
   OUTPUT:
   RETVAL

long
P2A_read_floats_count(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_floats_count(gbd);
   OUTPUT:
   RETVAL

char*
P2A_read_as_string(gbd)
 GBDATA *gbd

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_read_as_string(gbd);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_write_byte(gbd,i)
 GBDATA *gbd
 int i

    CODE:
   RETVAL = (char *)GB_write_byte(gbd,i);
   OUTPUT:
   RETVAL

char*
P2A_write_int(gbd,i)
 GBDATA *gbd
 long i

    CODE:
   RETVAL = (char *)GB_write_int(gbd,i);
   OUTPUT:
   RETVAL

char*
P2A_write_float(gbd,f)
 GBDATA *gbd
 double f

    CODE:
   RETVAL = (char *)GB_write_float(gbd,f);
   OUTPUT:
   RETVAL

char*
P2A_write_pntr(gbd,s,bytes_size,stored_size)
 GBDATA *gbd
 char *s
 long bytes_size
 long stored_size

    CODE:
   RETVAL = (char *)GB_write_pntr(gbd,s,bytes_size,stored_size);
   OUTPUT:
   RETVAL

char*
P2A_write_string(gbd,s)
 GBDATA *gbd
 char *s

    CODE:
   RETVAL = (char *)GB_write_string(gbd,s);
   OUTPUT:
   RETVAL

char*
P2A_write_link(gbd,s)
 GBDATA *gbd
 char *s

    CODE:
   RETVAL = (char *)GB_write_link(gbd,s);
   OUTPUT:
   RETVAL

char*
P2A_write_bits(gbd,bits,size,c_0)
 GBDATA *gbd
 char *bits
 long size
 char *c_0

    CODE:
   RETVAL = (char *)GB_write_bits(gbd,bits,size,c_0);
   OUTPUT:
   RETVAL

char*
P2A_write_bytes(gbd,s,size)
 GBDATA *gbd
 char *s
 long size

    CODE:
   RETVAL = (char *)GB_write_bytes(gbd,s,size);
   OUTPUT:
   RETVAL

char*
P2A_write_as_string(gbd,val)
 GBDATA *gbd
 char *val

    CODE:
   RETVAL = (char *)GB_write_as_string(gbd,val);
   OUTPUT:
   RETVAL

int
P2A_read_security_write(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_security_write(gbd);
   OUTPUT:
   RETVAL

int
P2A_read_security_read(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_security_read(gbd);
   OUTPUT:
   RETVAL

int
P2A_read_security_delete(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_security_delete(gbd);
   OUTPUT:
   RETVAL

int
P2A_get_my_security(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_get_my_security(gbd);
   OUTPUT:
   RETVAL

char*
P2A_write_security_write(gbd,level)
 GBDATA *gbd
 unsigned long level

    CODE:
   RETVAL = (char *)GB_write_security_write(gbd,level);
   OUTPUT:
   RETVAL

char*
P2A_write_security_read(gbd,level)
 GBDATA *gbd
 unsigned long level

    CODE:
   RETVAL = (char *)GB_write_security_read(gbd,level);
   OUTPUT:
   RETVAL

char*
P2A_write_security_delete(gbd,level)
 GBDATA *gbd
 unsigned long level

    CODE:
   RETVAL = (char *)GB_write_security_delete(gbd,level);
   OUTPUT:
   RETVAL

char*
P2A_write_security_levels(gbd,readlevel,writelevel,deletelevel)
 GBDATA *gbd
 unsigned long readlevel
 unsigned long writelevel
 unsigned long deletelevel

    CODE:
   RETVAL = (char *)GB_write_security_levels(gbd,readlevel,writelevel,deletelevel);
   OUTPUT:
   RETVAL

char*
P2A_change_my_security(gbd,level,passwd)
 GBDATA *gbd
 int level
 char *passwd

    CODE:
   RETVAL = (char *)GB_change_my_security(gbd,level,passwd);
   OUTPUT:
   RETVAL

char*
P2A_push_my_security(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_push_my_security(gbd);
   OUTPUT:
   RETVAL

char*
P2A_pop_my_security(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_pop_my_security(gbd);
   OUTPUT:
   RETVAL

char*
P2A_read_type(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_read_type(gbd);
   OUTPUT:
   RETVAL

char*
P2A_read_key(gbd)
 GBDATA *gbd

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_read_key(gbd);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_read_key_pntr(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_read_key_pntr(gbd);
   OUTPUT:
   RETVAL

long
P2A_read_clock(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_clock(gbd);
   OUTPUT:
   RETVAL

long
P2A_read_transaction(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_transaction(gbd);
   OUTPUT:
   RETVAL

GBDATA*
P2A_get_father(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_get_father(gbd);
   OUTPUT:
   RETVAL

GBDATA*
P2A_get_root(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_get_root(gbd);
   OUTPUT:
   RETVAL

int
P2A_check_father(gbd,gb_maybefather)
 GBDATA *gbd
 GBDATA *gb_maybefather

    CODE:
   RETVAL = GB_check_father(gbd,gb_maybefather);
   OUTPUT:
   RETVAL

int
P2A_rename(gbc,new_key)
 GBDATA *gbc
 char *new_key

    CODE:
   RETVAL = GB_rename(gbc,new_key);
   OUTPUT:
   RETVAL

GBDATA*
P2A_create_container(father,key)
 GBDATA *father
 char *key

    CODE:
   RETVAL = GB_create_container(father,key);
   OUTPUT:
   RETVAL

char*
P2A_delete(source)
 GBDATA *source

    CODE:
   RETVAL = (char *)GB_delete(source);
   OUTPUT:
   RETVAL

char*
P2A_copy(dest,source)
 GBDATA *dest
 GBDATA *source

    CODE:
   RETVAL = (char *)GB_copy(dest,source);
   OUTPUT:
   RETVAL

char*
P2A_get_subfields(gbd)
 GBDATA *gbd

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_get_subfields(gbd);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_set_temporary(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_set_temporary(gbd);
   OUTPUT:
   RETVAL

char*
P2A_clear_temporary(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_clear_temporary(gbd);
   OUTPUT:
   RETVAL

long
P2A_read_temporary(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_temporary(gbd);
   OUTPUT:
   RETVAL

char*
P2A_push_local_transaction(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_push_local_transaction(gbd);
   OUTPUT:
   RETVAL

char*
P2A_pop_local_transaction(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_pop_local_transaction(gbd);
   OUTPUT:
   RETVAL

char*
P2A_push_transaction(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_push_transaction(gbd);
   OUTPUT:
   RETVAL

char*
P2A_pop_transaction(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_pop_transaction(gbd);
   OUTPUT:
   RETVAL

char*
P2A_begin_transaction(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_begin_transaction(gbd);
   OUTPUT:
   RETVAL

char*
P2A_no_transaction(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_no_transaction(gbd);
   OUTPUT:
   RETVAL

char*
P2A_abort_transaction(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_abort_transaction(gbd);
   OUTPUT:
   RETVAL

char*
P2A_commit_transaction(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_commit_transaction(gbd);
   OUTPUT:
   RETVAL

char*
P2A_update_server(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_update_server(gbd);
   OUTPUT:
   RETVAL

void*
P2A_read_old_value()

    PPCODE:
   GB_read_old_value();

long
P2A_read_old_size()

    CODE:
   RETVAL = GB_read_old_size();
   OUTPUT:
   RETVAL

char*
P2A_get_callback_info(gbd)
 GBDATA *gbd

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_get_callback_info(gbd);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_release(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_release(gbd);
   OUTPUT:
   RETVAL

int
P2A_testlocal(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_testlocal(gbd);
   OUTPUT:
   RETVAL

int
P2A_nsons(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_nsons(gbd);
   OUTPUT:
   RETVAL

char*
P2A_disable_quicksave(gbd,reason)
 GBDATA *gbd
 char *reason

    CODE:
   RETVAL = (char *)GB_disable_quicksave(gbd,reason);
   OUTPUT:
   RETVAL

char*
P2A_resort_system_folder_to_top(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = (char *)GB_resort_system_folder_to_top(gb_main);
   OUTPUT:
   RETVAL

char*
P2A_write_usr_public(gbd,flags)
 GBDATA *gbd
 long flags

    CODE:
   RETVAL = (char *)GB_write_usr_public(gbd,flags);
   OUTPUT:
   RETVAL

long
P2A_read_usr_public(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_usr_public(gbd);
   OUTPUT:
   RETVAL

long
P2A_read_usr_private(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_usr_private(gbd);
   OUTPUT:
   RETVAL

char*
P2A_write_usr_private(gbd,ref)
 GBDATA *gbd
 long ref

    CODE:
   RETVAL = (char *)GB_write_usr_private(gbd,ref);
   OUTPUT:
   RETVAL

char*
P2A_write_flag(gbd,flag)
 GBDATA *gbd
 long flag

    CODE:
   RETVAL = (char *)GB_write_flag(gbd,flag);
   OUTPUT:
   RETVAL

int
P2A_read_flag(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_flag(gbd);
   OUTPUT:
   RETVAL

char*
P2A_touch(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_touch(gbd);
   OUTPUT:
   RETVAL

char*
P2A_print_debug_information(dummy,gb_main)
 void *dummy
 GBDATA *gb_main

    CODE:
   RETVAL = (char *)GB_print_debug_information(dummy,gb_main);
   OUTPUT:
   RETVAL

int
P2A_info(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_info(gbd);
   OUTPUT:
   RETVAL

long
P2A_number_of_subentries(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_number_of_subentries(gbd);
   OUTPUT:
   RETVAL

double
P2A_log_fak(n)
 int n

    CODE:
   RETVAL = GB_log_fak(n);
   OUTPUT:
   RETVAL

char*
P2A_optimize(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = (char *)GB_optimize(gb_main);
   OUTPUT:
   RETVAL

char*
P2A_create_index(gbd,key,estimated_size)
 GBDATA *gbd
 char *key
 long estimated_size

    CODE:
   RETVAL = (char *)GB_create_index(gbd,key,estimated_size);
   OUTPUT:
   RETVAL

char*
P2A_get_requested_undo_type(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = (char *)GB_get_requested_undo_type(gb_main);
   OUTPUT:
   RETVAL

char*
P2A_set_undo_mem(gbd,memsize)
 GBDATA *gbd
 long memsize

    CODE:
   RETVAL = (char *)GB_set_undo_mem(gbd,memsize);
   OUTPUT:
   RETVAL

GBDATA*
P2A_follow_link(gb_link)
 GBDATA *gb_link

    CODE:
   RETVAL = GB_follow_link(gb_link);
   OUTPUT:
   RETVAL

void
P2A_usleep(usec)
 long usec

    PPCODE:
   GB_usleep(usec);

long
P2A_time_of_file(path)
 char *path

    CODE:
   RETVAL = GB_time_of_file(path);
   OUTPUT:
   RETVAL

long
P2A_size_of_file(path)
 char *path

    CODE:
   RETVAL = GB_size_of_file(path);
   OUTPUT:
   RETVAL

long
P2A_mode_of_file(path)
 char *path

    CODE:
   RETVAL = GB_mode_of_file(path);
   OUTPUT:
   RETVAL

long
P2A_mode_of_link(path)
 char *path

    CODE:
   RETVAL = GB_mode_of_link(path);
   OUTPUT:
   RETVAL

int
P2A_is_regularfile(path)
 char *path

    CODE:
   RETVAL = GB_is_regularfile(path);
   OUTPUT:
   RETVAL

int
P2A_is_executablefile(path)
 char *path

    CODE:
   RETVAL = GB_is_executablefile(path);
   OUTPUT:
   RETVAL

int
P2A_is_directory(path)
 char *path

    CODE:
   RETVAL = GB_is_directory(path);
   OUTPUT:
   RETVAL

long
P2A_getuid()

    CODE:
   RETVAL = GB_getuid();
   OUTPUT:
   RETVAL

long
P2A_getpid()

    CODE:
   RETVAL = GB_getpid();
   OUTPUT:
   RETVAL

long
P2A_getuid_of_file(path)
 char *path

    CODE:
   RETVAL = GB_getuid_of_file(path);
   OUTPUT:
   RETVAL

int
P2A_unlink(path)
 char *path

    CODE:
   RETVAL = GB_unlink(path);
   OUTPUT:
   RETVAL

char*
P2A_follow_unix_link(path)
 char *path

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_follow_unix_link(path);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_symlink(name1,name2)
 char *name1
 char *name2

    CODE:
   RETVAL = (char *)GB_symlink(name1,name2);
   OUTPUT:
   RETVAL

char*
P2A_set_mode_of_file(path,mode)
 char *path
 long mode

    CODE:
   RETVAL = (char *)GB_set_mode_of_file(path,mode);
   OUTPUT:
   RETVAL

char*
P2A_rename_file(oldpath,newpath)
 char *oldpath
 char *newpath

    CODE:
   RETVAL = (char *)GB_rename_file(oldpath,newpath);
   OUTPUT:
   RETVAL

char*
P2A_read_file(path)
 char *path

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_read_file(path);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_map_FILE(in,writeable)
 FILE *in
 int writeable

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_map_FILE(in,writeable);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_map_file(path,writeable)
 char *path
 int writeable

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_map_file(path,writeable);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

long
P2A_size_of_FILE(in)
 FILE *in

    CODE:
   RETVAL = GB_size_of_FILE(in);
   OUTPUT:
   RETVAL

long
P2A_time_of_day()

    CODE:
   RETVAL = GB_time_of_day();
   OUTPUT:
   RETVAL

long
P2A_last_saved_clock(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GB_last_saved_clock(gb_main);
   OUTPUT:
   RETVAL

long
P2A_last_saved_time(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GB_last_saved_time(gb_main);
   OUTPUT:
   RETVAL

void
P2A_edit(path)
 char *path

    PPCODE:
   GB_edit(path);

void
P2A_textprint(path)
 char *path

    PPCODE:
   GB_textprint(path);

char*
P2A_getcwd()

    CODE:
   RETVAL = (char *)GB_getcwd();
   OUTPUT:
   RETVAL

void
P2A_xterm()

    PPCODE:
   GB_xterm();

void
P2A_xcmd(cmd,background,wait_only_if_error)
 char *cmd
 int background
 int wait_only_if_error

    PPCODE:
   GB_xcmd(cmd,background,wait_only_if_error);

char*
P2A_getenvUSER()

    CODE:
   RETVAL = (char *)GB_getenvUSER();
   OUTPUT:
   RETVAL

char*
P2A_getenvHOME()

    CODE:
   RETVAL = (char *)GB_getenvHOME();
   OUTPUT:
   RETVAL

char*
P2A_getenvARBHOME()

    CODE:
   RETVAL = (char *)GB_getenvARBHOME();
   OUTPUT:
   RETVAL

char*
P2A_getenvARBMACRO()

    CODE:
   RETVAL = (char *)GB_getenvARBMACRO();
   OUTPUT:
   RETVAL

char*
P2A_getenvARBMACROHOME()

    CODE:
   RETVAL = (char *)GB_getenvARBMACROHOME();
   OUTPUT:
   RETVAL

char*
P2A_getenvPATH()

    CODE:
   RETVAL = (char *)GB_getenvPATH();
   OUTPUT:
   RETVAL

char*
P2A_getenvARB_GS()

    CODE:
   RETVAL = (char *)GB_getenvARB_GS();
   OUTPUT:
   RETVAL

char*
P2A_getenvARB_TEXTEDIT()

    CODE:
   RETVAL = (char *)GB_getenvARB_TEXTEDIT();
   OUTPUT:
   RETVAL

char*
P2A_getenvDOCPATH()

    CODE:
   RETVAL = (char *)GB_getenvDOCPATH();
   OUTPUT:
   RETVAL

char*
P2A_getenvHTMLDOCPATH()

    CODE:
   RETVAL = (char *)GB_getenvHTMLDOCPATH();
   OUTPUT:
   RETVAL

char*
P2A_getenv(env)
 char *env

    CODE:
   RETVAL = (char *)GB_getenv(env);
   OUTPUT:
   RETVAL

int
P2A_host_is_local(hostname)
 char *hostname

    CODE:
   RETVAL = GB_host_is_local(hostname);
   OUTPUT:
   RETVAL

long
P2A_get_physical_memory()

    CODE:
   RETVAL = GB_get_physical_memory();
   OUTPUT:
   RETVAL

long
P2A_read_clients(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_read_clients(gbd);
   OUTPUT:
   RETVAL

int
P2A_is_server(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_is_server(gbd);
   OUTPUT:
   RETVAL

int
P2A_is_client(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_is_client(gbd);
   OUTPUT:
   RETVAL

char*
P2A_tell_server_dont_wait(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_tell_server_dont_wait(gbd);
   OUTPUT:
   RETVAL

char*
P2A_install_pid(mode)
 int mode

    CODE:
   RETVAL = (char *)GB_install_pid(mode);
   OUTPUT:
   RETVAL

char*
P2A_set_cache_size(gbd,size)
 GBDATA *gbd
 long size

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_set_cache_size(gbd,size);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_get_GBDATA_path(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_get_GBDATA_path(gbd);
   OUTPUT:
   RETVAL

GBDATA*
P2A_find_sub_by_quark(father,key_quark,val,after)
 GBDATA *father
 int key_quark
 char *val
 GBDATA *after

    CODE:
   RETVAL = GB_find_sub_by_quark(father,key_quark,val,after);
   OUTPUT:
   RETVAL

GBDATA*
P2A_find_sub_sub_by_quark(father,key,sub_key_quark,val,after)
 GBDATA *father
 char *key
 int sub_key_quark
 char *val
 GBDATA *after

    CODE:
   RETVAL = GB_find_sub_sub_by_quark(father,key,sub_key_quark,val,after);
   OUTPUT:
   RETVAL

char*
P2A_first_non_key_char(str)
 char *str

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_first_non_key_char(str);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

GBDATA*
P2A_search_last_son(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_search_last_son(gbd);
   OUTPUT:
   RETVAL

long
P2A_number_of_marked_subentries(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = GB_number_of_marked_subentries(gbd);
   OUTPUT:
   RETVAL

GBDATA*
P2A_first_marked(gbd,keystring)
 GBDATA *gbd
 char *keystring

    CODE:
   RETVAL = GB_first_marked(gbd,keystring);
   OUTPUT:
   RETVAL

GBDATA*
P2A_next_marked(gbd,keystring)
 GBDATA *gbd
 char *keystring

    CODE:
   RETVAL = GB_next_marked(gbd,keystring);
   OUTPUT:
   RETVAL

char*
P2A_command_interpreter(gb_main,str,commands,gbd,default_tree_name)
 GBDATA *gb_main
 char *str
 char *commands
 GBDATA *gbd
 char *default_tree_name

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_command_interpreter(gb_main,str,commands,gbd,default_tree_name);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_save(gb,path,savetype)
 GBDATA *gb
 char *path
 char *savetype

    CODE:
   RETVAL = (char *)GB_save(gb,path,savetype);
   OUTPUT:
   RETVAL

char*
P2A_create_directory(path)
 char *path

    CODE:
   RETVAL = (char *)GB_create_directory(path);
   OUTPUT:
   RETVAL

char*
P2A_save_in_home(gb,path,savetype)
 GBDATA *gb
 char *path
 char *savetype

    CODE:
   RETVAL = (char *)GB_save_in_home(gb,path,savetype);
   OUTPUT:
   RETVAL

char*
P2A_save_as(gb,path,savetype)
 GBDATA *gb
 char *path
 char *savetype

    CODE:
   RETVAL = (char *)GB_save_as(gb,path,savetype);
   OUTPUT:
   RETVAL

char*
P2A_delete_database(filename)
 char *filename

    CODE:
   RETVAL = (char *)GB_delete_database(filename);
   OUTPUT:
   RETVAL

char*
P2A_save_quick_as(gb_main,path)
 GBDATA *gb_main
 char *path

    CODE:
   RETVAL = (char *)GB_save_quick_as(gb_main,path);
   OUTPUT:
   RETVAL

char*
P2A_save_quick(gb,refpath)
 GBDATA *gb
 char *refpath

    CODE:
   RETVAL = (char *)GB_save_quick(gb,refpath);
   OUTPUT:
   RETVAL

char*
P2A_disable_path(gbd,path)
 GBDATA *gbd
 char *path

    CODE:
   RETVAL = (char *)GB_disable_path(gbd,path);
   OUTPUT:
   RETVAL

void*
P2A_calloc(nelem,elsize)
 unsigned int nelem
 unsigned int elsize

    PPCODE:
   GB_calloc(nelem,elsize);

char*
P2A_strdup(p)
 char *p

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_strdup(p);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_strduplen(p,len)
 char *p
 unsigned len

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_strduplen(p,len);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

void*
P2A_recalloc(ptr,oelem,nelem,elsize)
 void *ptr
 unsigned int oelem
 unsigned int nelem
 unsigned int elsize

    PPCODE:
   GB_recalloc(ptr,oelem,nelem,elsize);

void
P2A_memerr()

    PPCODE:
   GB_memerr();

void
P2A_set_next_main_idx(idx)
 long idx

    PPCODE:
   GB_set_next_main_idx(idx);

GBDATA*
P2A_login(path,opent,user)
 char *path
 char *opent
 char *user

    CODE:
   RETVAL = GB_login(path,opent,user);
   OUTPUT:
   RETVAL

GBDATA*
P2A_open(path,opent)
 char *path
 char *opent

    CODE:
   RETVAL = GB_open(path,opent);
   OUTPUT:
   RETVAL

void
P2A_set_verbose()

    PPCODE:
   GB_set_verbose();

char*
P2A_get_type_name(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_get_type_name(gbd);
   OUTPUT:
   RETVAL

char*
P2A_get_db_path(gbd)
 GBDATA *gbd

    CODE:
   RETVAL = (char *)GB_get_db_path(gbd);
   OUTPUT:
   RETVAL

void
P2A_dump_db_path(gbd)
 GBDATA *gbd

    PPCODE:
   GB_dump_db_path(gbd);

void
P2A_dump(gbd)
 GBDATA *gbd

    PPCODE:
   GB_dump(gbd);

char*
P2A_ralfs_test(gb_main)
 GBDATA *gb_main

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_ralfs_test(gb_main);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_ralfs_menupoint(main_data)
 GBDATA *main_data

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GB_ralfs_menupoint(main_data);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2A_fix_database(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = (char *)GB_fix_database(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2A_test_link_follower(gb_main,gb_link,link)
 GBDATA *gb_main
 GBDATA *gb_link
 char *link

    CODE:
   RETVAL = GB_test_link_follower(gb_main,gb_link,link);
   OUTPUT:
   RETVAL

MODULE = ARB   PACKAGE = BIO  PREFIX = P2AT_

char*
P2AT_check_alignment_name(alignment_name)
 char *alignment_name

    CODE:
   RETVAL = (char *)GBT_check_alignment_name(alignment_name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_create_alignment(gbd,name,len,aligned,security,type)
 GBDATA *gbd
 char *name
 long len
 long aligned
 long security
 char *type

    CODE:
   RETVAL = GBT_create_alignment(gbd,name,len,aligned,security,type);
   OUTPUT:
   RETVAL

char*
P2AT_rename_alignment(gbMain,source,dest,copy,dele)
 GBDATA *gbMain
 char *source
 char *dest
 int copy
 int dele

    CODE:
   RETVAL = (char *)GBT_rename_alignment(gbMain,source,dest,copy,dele);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_or_create(Main,key,delete_level)
 GBDATA *Main
 char *key
 long delete_level

    CODE:
   RETVAL = GBT_find_or_create(Main,key,delete_level);
   OUTPUT:
   RETVAL

char*
P2AT_check_data(Main,alignment_name)
 GBDATA *Main
 char *alignment_name

    CODE:
   RETVAL = (char *)GBT_check_data(Main,alignment_name);
   OUTPUT:
   RETVAL

char*
P2AT_check_lengths(Main,alignment_name)
 GBDATA *Main
 char *alignment_name

    CODE:
   RETVAL = (char *)GBT_check_lengths(Main,alignment_name);
   OUTPUT:
   RETVAL

char*
P2AT_format_alignment(Main,alignment_name)
 GBDATA *Main
 char *alignment_name

    CODE:
   RETVAL = (char *)GBT_format_alignment(Main,alignment_name);
   OUTPUT:
   RETVAL

char*
P2AT_insert_character(Main,alignment_name,pos,count,char_delete)
 GBDATA *Main
 char *alignment_name
 long pos
 long count
 char *char_delete

    CODE:
   RETVAL = (char *)GBT_insert_character(Main,alignment_name,pos,count,char_delete);
   OUTPUT:
   RETVAL

char*
P2AT_write_group_name(gb_group_name,new_group_name)
 GBDATA *gb_group_name
 char *new_group_name

    CODE:
   RETVAL = (char *)GBT_write_group_name(gb_group_name,new_group_name);
   OUTPUT:
   RETVAL

char*
P2AT_write_tree_rem(gb_main,tree_name,remark)
 GBDATA *gb_main
 char *tree_name
 char *remark

    CODE:
   RETVAL = (char *)GBT_write_tree_rem(gb_main,tree_name,remark);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_get_tree(gb_main,tree_name)
 GBDATA *gb_main
 char *tree_name

    CODE:
   RETVAL = GBT_get_tree(gb_main,tree_name);
   OUTPUT:
   RETVAL

long
P2AT_size_of_tree(gb_main,tree_name)
 GBDATA *gb_main
 char *tree_name

    CODE:
   RETVAL = GBT_size_of_tree(gb_main,tree_name);
   OUTPUT:
   RETVAL

char*
P2AT_find_largest_tree(gb_main)
 GBDATA *gb_main

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_find_largest_tree(gb_main);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_find_latest_tree(gb_main)
 GBDATA *gb_main

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_find_latest_tree(gb_main);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_tree_info_string(gb_main,tree_name)
 GBDATA *gb_main
 char *tree_name

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_tree_info_string(gb_main,tree_name);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_check_tree_name(tree_name)
 char *tree_name

    CODE:
   RETVAL = (char *)GBT_check_tree_name(tree_name);
   OUTPUT:
   RETVAL

char*
P2AT_get_next_tree_name(gb_main,tree)
 GBDATA *gb_main
 char *tree

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_get_next_tree_name(gb_main,tree);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_existing_tree(Main,tree)
 GBDATA *Main
 char *tree

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_existing_tree(Main,tree);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

GBDATA*
P2AT_create_species(gb_main,name)
 GBDATA *gb_main
 char *name

    CODE:
   RETVAL = GBT_create_species(gb_main,name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_create_species_rel_species_data(gb_species_data,name)
 GBDATA *gb_species_data
 char *name

    CODE:
   RETVAL = GBT_create_species_rel_species_data(gb_species_data,name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_create_SAI(gb_main,name)
 GBDATA *gb_main
 char *name

    CODE:
   RETVAL = GBT_create_SAI(gb_main,name);
   OUTPUT:
   RETVAL

char*
P2AT_write_sequence(gb_data,ali_name,ali_len,sequence)
 GBDATA *gb_data
 char *ali_name
 long ali_len
 char *sequence

    CODE:
   RETVAL = (char *)GBT_write_sequence(gb_data,ali_name,ali_len,sequence);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_gen_accession_number(gb_species,ali_name)
 GBDATA *gb_species
 char *ali_name

    CODE:
   RETVAL = GBT_gen_accession_number(gb_species,ali_name);
   OUTPUT:
   RETVAL

int
P2AT_is_partial(gb_species,default_value,define_if_undef)
 GBDATA *gb_species
 int default_value
 int define_if_undef

    CODE:
   RETVAL = GBT_is_partial(gb_species,default_value,define_if_undef);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_get_species_data(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GBT_get_species_data(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_marked_species_rel_species_data(gb_species_data)
 GBDATA *gb_species_data

    CODE:
   RETVAL = GBT_first_marked_species_rel_species_data(gb_species_data);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_marked_species(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GBT_first_marked_species(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_marked_species(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GBT_next_marked_species(gb_species);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_species_rel_species_data(gb_species_data)
 GBDATA *gb_species_data

    CODE:
   RETVAL = GBT_first_species_rel_species_data(gb_species_data);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_species(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GBT_first_species(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_species(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GBT_next_species(gb_species);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_species_rel_species_data(gb_species_data,name)
 GBDATA *gb_species_data
 char *name

    CODE:
   RETVAL = GBT_find_species_rel_species_data(gb_species_data,name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_species(gb_main,name)
 GBDATA *gb_main
 char *name

    CODE:
   RETVAL = GBT_find_species(gb_main,name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_marked_extended(gb_extended_data)
 GBDATA *gb_extended_data

    CODE:
   RETVAL = GBT_first_marked_extended(gb_extended_data);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_marked_extended(gb_extended)
 GBDATA *gb_extended

    CODE:
   RETVAL = GBT_next_marked_extended(gb_extended);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_SAI(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GBT_first_SAI(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_SAI(gb_extended)
 GBDATA *gb_extended

    CODE:
   RETVAL = GBT_next_SAI(gb_extended);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_SAI(gb_main,name)
 GBDATA *gb_main
 char *name

    CODE:
   RETVAL = GBT_find_SAI(gb_main,name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_SAI_rel_exdata(gb_extended_data)
 GBDATA *gb_extended_data

    CODE:
   RETVAL = GBT_first_SAI_rel_exdata(gb_extended_data);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_SAI_rel_exdata(gb_extended_data,name)
 GBDATA *gb_extended_data
 char *name

    CODE:
   RETVAL = GBT_find_SAI_rel_exdata(gb_extended_data,name);
   OUTPUT:
   RETVAL

char*
P2AT_create_unique_species_name(gb_main,default_name)
 GBDATA *gb_main
 char *default_name

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_create_unique_species_name(gb_main,default_name);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

void
P2AT_mark_all(gb_main,flag)
 GBDATA *gb_main
 int flag

    PPCODE:
   GBT_mark_all(gb_main,flag);

long
P2AT_count_marked_species(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GBT_count_marked_species(gb_main);
   OUTPUT:
   RETVAL

long
P2AT_count_species(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GBT_count_species(gb_main);
   OUTPUT:
   RETVAL

char*
P2AT_store_marked_species(gb_main,unmark_all)
 GBDATA *gb_main
 int unmark_all

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_store_marked_species(gb_main,unmark_all);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_restore_marked_species(gb_main,stored_marked)
 GBDATA *gb_main
 char *stored_marked

    CODE:
   RETVAL = (char *)GBT_restore_marked_species(gb_main,stored_marked);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_read_sequence(gb_species,use)
 GBDATA *gb_species
 char *use

    CODE:
   RETVAL = GBT_read_sequence(gb_species,use);
   OUTPUT:
   RETVAL

char*
P2AT_read_name(gb_species)
 GBDATA *gb_species

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_read_name(gb_species);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_get_default_alignment(gb_main)
 GBDATA *gb_main

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_get_default_alignment(gb_main);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_set_default_alignment(gb_main,alignment_name)
 GBDATA *gb_main
 char *alignment_name

    CODE:
   RETVAL = (char *)GBT_set_default_alignment(gb_main,alignment_name);
   OUTPUT:
   RETVAL

char*
P2AT_get_default_helix(gb_main)
 GBDATA *gb_main

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_get_default_helix(gb_main);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_get_default_helix_nr(gb_main)
 GBDATA *gb_main

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_get_default_helix_nr(gb_main);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_get_default_ref(gb_main)
 GBDATA *gb_main

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_get_default_ref(gb_main);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

GBDATA*
P2AT_get_alignment(gb_main,use)
 GBDATA *gb_main
 char *use

    CODE:
   RETVAL = GBT_get_alignment(gb_main,use);
   OUTPUT:
   RETVAL

long
P2AT_get_alignment_len(gb_main,use)
 GBDATA *gb_main
 char *use

    CODE:
   RETVAL = GBT_get_alignment_len(gb_main,use);
   OUTPUT:
   RETVAL

char*
P2AT_set_alignment_len(gb_main,use,new_len)
 GBDATA *gb_main
 char *use
 long new_len

    CODE:
   RETVAL = (char *)GBT_set_alignment_len(gb_main,use,new_len);
   OUTPUT:
   RETVAL

int
P2AT_get_alignment_aligned(gb_main,use)
 GBDATA *gb_main
 char *use

    CODE:
   RETVAL = GBT_get_alignment_aligned(gb_main,use);
   OUTPUT:
   RETVAL

char*
P2AT_get_alignment_type_string(gb_main,use)
 GBDATA *gb_main
 char *use

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_get_alignment_type_string(gb_main,use);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

int
P2AT_is_alignment_protein(gb_main,alignment_name)
 GBDATA *gb_main
 char *alignment_name

    CODE:
   RETVAL = GBT_is_alignment_protein(gb_main,alignment_name);
   OUTPUT:
   RETVAL

char*
P2AT_check_arb_file(name)
 char *name

    CODE:
   RETVAL = (char *)GBT_check_arb_file(name);
   OUTPUT:
   RETVAL

void
P2AT_install_message_handler(gb_main)
 GBDATA *gb_main

    PPCODE:
   GBT_install_message_handler(gb_main);

void
P2AT_message(gb_main,msg)
 GBDATA *gb_main
 char *msg

    PPCODE:
   GBT_message(gb_main,msg);

long
P2AT_get_species_hash_size(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GBT_get_species_hash_size(gb_main);
   OUTPUT:
   RETVAL

char*
P2AT_begin_rename_session(gb_main,all_flag)
 GBDATA *gb_main
 int all_flag

    CODE:
   RETVAL = (char *)GBT_begin_rename_session(gb_main,all_flag);
   OUTPUT:
   RETVAL

char*
P2AT_rename_species(oldname,newname)
 char *oldname
 char *newname

    CODE:
   RETVAL = (char *)GBT_rename_species(oldname,newname);
   OUTPUT:
   RETVAL

char*
P2AT_abort_rename_session()

    CODE:
   RETVAL = (char *)GBT_abort_rename_session();
   OUTPUT:
   RETVAL

char*
P2AT_read_string(gb_main,awar_name)
 GBDATA *gb_main
 char *awar_name

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_read_string(gb_main,awar_name);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

long
P2AT_read_int(gb_main,awar_name)
 GBDATA *gb_main
 char *awar_name

    CODE:
   RETVAL = GBT_read_int(gb_main,awar_name);
   OUTPUT:
   RETVAL

double
P2AT_read_float(gb_main,awar_name)
 GBDATA *gb_main
 char *awar_name

    CODE:
   RETVAL = GBT_read_float(gb_main,awar_name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_search_string(gb_main,awar_name,def)
 GBDATA *gb_main
 char *awar_name
 char *def

    CODE:
   RETVAL = GBT_search_string(gb_main,awar_name,def);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_search_int(gb_main,awar_name,def)
 GBDATA *gb_main
 char *awar_name
 int def

    CODE:
   RETVAL = GBT_search_int(gb_main,awar_name,def);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_search_float(gb_main,awar_name,def)
 GBDATA *gb_main
 char *awar_name
 double def

    CODE:
   RETVAL = GBT_search_float(gb_main,awar_name,def);
   OUTPUT:
   RETVAL

char*
P2AT_read_string2(gb_main,awar_name,def)
 GBDATA *gb_main
 char *awar_name
 char *def

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_read_string2(gb_main,awar_name,def);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

long
P2AT_read_int2(gb_main,awar_name,def)
 GBDATA *gb_main
 char *awar_name
 long def

    CODE:
   RETVAL = GBT_read_int2(gb_main,awar_name,def);
   OUTPUT:
   RETVAL

double
P2AT_read_float2(gb_main,awar_name,def)
 GBDATA *gb_main
 char *awar_name
 double def

    CODE:
   RETVAL = GBT_read_float2(gb_main,awar_name,def);
   OUTPUT:
   RETVAL

char*
P2AT_write_string(gb_main,awar_name,def)
 GBDATA *gb_main
 char *awar_name
 char *def

    CODE:
   RETVAL = (char *)GBT_write_string(gb_main,awar_name,def);
   OUTPUT:
   RETVAL

char*
P2AT_write_int(gb_main,awar_name,def)
 GBDATA *gb_main
 char *awar_name
 long def

    CODE:
   RETVAL = (char *)GBT_write_int(gb_main,awar_name,def);
   OUTPUT:
   RETVAL

char*
P2AT_write_float(gb_main,awar_name,def)
 GBDATA *gb_main
 char *awar_name
 double def

    CODE:
   RETVAL = (char *)GBT_write_float(gb_main,awar_name,def);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_open(path,opent,disabled_path)
 char *path
 char *opent
 char *disabled_path

    CODE:
   RETVAL = GBT_open(path,opent,disabled_path);
   OUTPUT:
   RETVAL

char*
P2AT_remote_action(gb_main,application,action_name)
 GBDATA *gb_main
 char *application
 char *action_name

    CODE:
   RETVAL = (char *)GBT_remote_action(gb_main,application,action_name);
   OUTPUT:
   RETVAL

char*
P2AT_remote_awar(gb_main,application,awar_name,value)
 GBDATA *gb_main
 char *application
 char *awar_name
 char *value

    CODE:
   RETVAL = (char *)GBT_remote_awar(gb_main,application,awar_name,value);
   OUTPUT:
   RETVAL

char*
P2AT_remote_read_awar(gb_main,application,awar_name)
 GBDATA *gb_main
 char *application
 char *awar_name

    CODE:
   RETVAL = (char *)GBT_remote_read_awar(gb_main,application,awar_name);
   OUTPUT:
   RETVAL

char*
P2AT_remote_touch_awar(gb_main,application,awar_name)
 GBDATA *gb_main
 char *application
 char *awar_name

    CODE:
   RETVAL = (char *)GBT_remote_touch_awar(gb_main,application,awar_name);
   OUTPUT:
   RETVAL

char*
P2AT_read_gene_sequence(gb_gene,use_revComplement)
 GBDATA *gb_gene
 int use_revComplement

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_read_gene_sequence(gb_gene,use_revComplement);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_compress_sequence_tree2(gb_main,tree_name,ali_name)
 GBDATA *gb_main
 char *tree_name
 char *ali_name

    CODE:
   RETVAL = (char *)GBT_compress_sequence_tree2(gb_main,tree_name,ali_name);
   OUTPUT:
   RETVAL

void
P2AT_compression_test(dummy,gb_main)
 void *dummy
 GBDATA *gb_main

    PPCODE:
   GBT_compression_test(dummy,gb_main);

char*
P2AT_install_table_link_follower(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = (char *)GBT_install_table_link_follower(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_open_table(gb_table_root,table_name,read_only)
 GBDATA *gb_table_root
 char *table_name
 int read_only

    CODE:
   RETVAL = GBT_open_table(gb_table_root,table_name,read_only);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_table(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GBT_first_table(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_table(gb_table)
 GBDATA *gb_table

    CODE:
   RETVAL = GBT_next_table(gb_table);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_table_entry(gb_table)
 GBDATA *gb_table

    CODE:
   RETVAL = GBT_first_table_entry(gb_table);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_marked_table_entry(gb_table)
 GBDATA *gb_table

    CODE:
   RETVAL = GBT_first_marked_table_entry(gb_table);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_table_entry(gb_table_entry)
 GBDATA *gb_table_entry

    CODE:
   RETVAL = GBT_next_table_entry(gb_table_entry);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_marked_table_entry(gb_table_entry)
 GBDATA *gb_table_entry

    CODE:
   RETVAL = GBT_next_marked_table_entry(gb_table_entry);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_table_entry(gb_table,id)
 GBDATA *gb_table
 char *id

    CODE:
   RETVAL = GBT_find_table_entry(gb_table,id);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_open_table_entry(gb_table,id)
 GBDATA *gb_table
 char *id

    CODE:
   RETVAL = GBT_open_table_entry(gb_table,id);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_table_field(gb_table)
 GBDATA *gb_table

    CODE:
   RETVAL = GBT_first_table_field(gb_table);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_marked_table_field(gb_table)
 GBDATA *gb_table

    CODE:
   RETVAL = GBT_first_marked_table_field(gb_table);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_table_field(gb_table_field)
 GBDATA *gb_table_field

    CODE:
   RETVAL = GBT_next_table_field(gb_table_field);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_marked_table_field(gb_table_field)
 GBDATA *gb_table_field

    CODE:
   RETVAL = GBT_next_marked_table_field(gb_table_field);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_table_field(gb_table,id)
 GBDATA *gb_table
 char *id

    CODE:
   RETVAL = GBT_find_table_field(gb_table,id);
   OUTPUT:
   RETVAL

char*
P2AT_get_type_of_table_entry_field(gb_table,fieldname)
 GBDATA *gb_table
 char *fieldname

    CODE:
   RETVAL = (char *)GBT_get_type_of_table_entry_field(gb_table,fieldname);
   OUTPUT:
   RETVAL

char*
P2AT_savely_write_table_entry_field(gb_table,gb_entry,fieldname,value_in_ascii_format)
 GBDATA *gb_table
 GBDATA *gb_entry
 char *fieldname
 char *value_in_ascii_format

    CODE:
   RETVAL = (char *)GBT_savely_write_table_entry_field(gb_table,gb_entry,fieldname,value_in_ascii_format);
   OUTPUT:
   RETVAL

char*
P2AT_reverseNucSequence(s,len)
 char *s
 int len

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_reverseNucSequence(s,len);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

char*
P2AT_complementNucSequence(s,len,T_or_U)
 char *s
 int len
 char T_or_U

    CODE:
   if (static_pntr) free(static_pntr);
   static_pntr = GBT_complementNucSequence(s,len,T_or_U);
   RETVAL = static_pntr;
   OUTPUT:
   RETVAL

void
P2AT_reverseComplementNucSequence(seq,length,T_or_U)
 char *seq
 long length
 char T_or_U

    PPCODE:
   GBT_reverseComplementNucSequence(seq,length,T_or_U);

int
P2AT_is_genome_db(gb_main,default_value)
 GBDATA *gb_main
 int default_value

    CODE:
   RETVAL = GEN_is_genome_db(gb_main,default_value);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_findOrCreate_gene_data(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GEN_findOrCreate_gene_data(gb_species);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_gene_data(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GEN_find_gene_data(gb_species);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_expect_gene_data(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GEN_expect_gene_data(gb_species);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_gene(gb_species,name)
 GBDATA *gb_species
 char *name

    CODE:
   RETVAL = GEN_find_gene(gb_species,name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_create_gene(gb_species,name)
 GBDATA *gb_species
 char *name

    CODE:
   RETVAL = GEN_create_gene(gb_species,name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_gene_rel_gene_data(gb_gene_data,name)
 GBDATA *gb_gene_data
 char *name

    CODE:
   RETVAL = GEN_find_gene_rel_gene_data(gb_gene_data,name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_create_gene_rel_gene_data(gb_gene_data,name)
 GBDATA *gb_gene_data
 char *name

    CODE:
   RETVAL = GEN_create_gene_rel_gene_data(gb_gene_data,name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_gene(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GEN_first_gene(gb_species);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_gene_rel_gene_data(gb_gene_data)
 GBDATA *gb_gene_data

    CODE:
   RETVAL = GEN_first_gene_rel_gene_data(gb_gene_data);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_gene(gb_gene)
 GBDATA *gb_gene

    CODE:
   RETVAL = GEN_next_gene(gb_gene);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_marked_gene(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GEN_first_marked_gene(gb_species);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_marked_gene(gb_gene)
 GBDATA *gb_gene

    CODE:
   RETVAL = GEN_next_marked_gene(gb_gene);
   OUTPUT:
   RETVAL

int
P2AT_is_pseudo_gene_species(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GEN_is_pseudo_gene_species(gb_species);
   OUTPUT:
   RETVAL

int
P2AT_is_organism(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GEN_is_organism(gb_species);
   OUTPUT:
   RETVAL

char*
P2AT_origin_organism(gb_pseudo)
 GBDATA *gb_pseudo

    CODE:
   RETVAL = (char *)GEN_origin_organism(gb_pseudo);
   OUTPUT:
   RETVAL

char*
P2AT_origin_gene(gb_pseudo)
 GBDATA *gb_pseudo

    CODE:
   RETVAL = (char *)GEN_origin_gene(gb_pseudo);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_origin_organism(gb_pseudo)
 GBDATA *gb_pseudo

    CODE:
   RETVAL = GEN_find_origin_organism(gb_pseudo);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_origin_gene(gb_pseudo)
 GBDATA *gb_pseudo

    CODE:
   RETVAL = GEN_find_origin_gene(gb_pseudo);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_pseudo_species(gb_main,organism_name,gene_name)
 GBDATA *gb_main
 char *organism_name
 char *gene_name

    CODE:
   RETVAL = GEN_find_pseudo_species(gb_main,organism_name,gene_name);
   OUTPUT:
   RETVAL

char*
P2AT_organism_not_found(gb_pseudo)
 GBDATA *gb_pseudo

    CODE:
   RETVAL = (char *)GEN_organism_not_found(gb_pseudo);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_pseudo(gb_organism,gb_gene)
 GBDATA *gb_organism
 GBDATA *gb_gene

    CODE:
   RETVAL = GEN_find_pseudo(gb_organism,gb_gene);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_pseudo_species(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GEN_first_pseudo_species(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_pseudo_species_rel_species_data(gb_species_data)
 GBDATA *gb_species_data

    CODE:
   RETVAL = GEN_first_pseudo_species_rel_species_data(gb_species_data);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_pseudo_species(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GEN_next_pseudo_species(gb_species);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_marked_pseudo_species(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GEN_first_marked_pseudo_species(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_marked_pseudo_species(gb_species)
 GBDATA *gb_species

    CODE:
   RETVAL = GEN_next_marked_pseudo_species(gb_species);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_find_organism(gb_main,name)
 GBDATA *gb_main
 char *name

    CODE:
   RETVAL = GEN_find_organism(gb_main,name);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_organism(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GEN_first_organism(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_organism(gb_organism)
 GBDATA *gb_organism

    CODE:
   RETVAL = GEN_next_organism(gb_organism);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_first_marked_organism(gb_main)
 GBDATA *gb_main

    CODE:
   RETVAL = GEN_first_marked_organism(gb_main);
   OUTPUT:
   RETVAL

GBDATA*
P2AT_next_marked_organism(gb_organism)
 GBDATA *gb_organism

    CODE:
   RETVAL = GEN_next_marked_organism(gb_organism);
   OUTPUT:
   RETVAL

